/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshiftdata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.redshiftdata.model.RedshiftDataRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExecuteStatementRequest
extends RedshiftDataRequest
implements ToCopyableBuilder<Builder, ExecuteStatementRequest> {
    private static final SdkField<String> CLUSTER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ExecuteStatementRequest.getter(ExecuteStatementRequest::clusterIdentifier)).setter(ExecuteStatementRequest.setter(Builder::clusterIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterIdentifier").build()}).build();
    private static final SdkField<String> DATABASE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ExecuteStatementRequest.getter(ExecuteStatementRequest::database)).setter(ExecuteStatementRequest.setter(Builder::database)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Database").build()}).build();
    private static final SdkField<String> DB_USER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ExecuteStatementRequest.getter(ExecuteStatementRequest::dbUser)).setter(ExecuteStatementRequest.setter(Builder::dbUser)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DbUser").build()}).build();
    private static final SdkField<String> SECRET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ExecuteStatementRequest.getter(ExecuteStatementRequest::secretArn)).setter(ExecuteStatementRequest.setter(Builder::secretArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretArn").build()}).build();
    private static final SdkField<String> SQL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ExecuteStatementRequest.getter(ExecuteStatementRequest::sql)).setter(ExecuteStatementRequest.setter(Builder::sql)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sql").build()}).build();
    private static final SdkField<String> STATEMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ExecuteStatementRequest.getter(ExecuteStatementRequest::statementName)).setter(ExecuteStatementRequest.setter(Builder::statementName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatementName").build()}).build();
    private static final SdkField<Boolean> WITH_EVENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(ExecuteStatementRequest.getter(ExecuteStatementRequest::withEvent)).setter(ExecuteStatementRequest.setter(Builder::withEvent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WithEvent").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_IDENTIFIER_FIELD, DATABASE_FIELD, DB_USER_FIELD, SECRET_ARN_FIELD, SQL_FIELD, STATEMENT_NAME_FIELD, WITH_EVENT_FIELD));
    private final String clusterIdentifier;
    private final String database;
    private final String dbUser;
    private final String secretArn;
    private final String sql;
    private final String statementName;
    private final Boolean withEvent;

    private ExecuteStatementRequest(BuilderImpl builder) {
        super(builder);
        this.clusterIdentifier = builder.clusterIdentifier;
        this.database = builder.database;
        this.dbUser = builder.dbUser;
        this.secretArn = builder.secretArn;
        this.sql = builder.sql;
        this.statementName = builder.statementName;
        this.withEvent = builder.withEvent;
    }

    public String clusterIdentifier() {
        return this.clusterIdentifier;
    }

    public String database() {
        return this.database;
    }

    public String dbUser() {
        return this.dbUser;
    }

    public String secretArn() {
        return this.secretArn;
    }

    public String sql() {
        return this.sql;
    }

    public String statementName() {
        return this.statementName;
    }

    public Boolean withEvent() {
        return this.withEvent;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.database());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbUser());
        hashCode = 31 * hashCode + Objects.hashCode(this.secretArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.sql());
        hashCode = 31 * hashCode + Objects.hashCode(this.statementName());
        hashCode = 31 * hashCode + Objects.hashCode(this.withEvent());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecuteStatementRequest)) {
            return false;
        }
        ExecuteStatementRequest other = (ExecuteStatementRequest)((Object)obj);
        return Objects.equals(this.clusterIdentifier(), other.clusterIdentifier()) && Objects.equals(this.database(), other.database()) && Objects.equals(this.dbUser(), other.dbUser()) && Objects.equals(this.secretArn(), other.secretArn()) && Objects.equals(this.sql(), other.sql()) && Objects.equals(this.statementName(), other.statementName()) && Objects.equals(this.withEvent(), other.withEvent());
    }

    public String toString() {
        return ToString.builder((String)"ExecuteStatementRequest").add("ClusterIdentifier", (Object)this.clusterIdentifier()).add("Database", (Object)this.database()).add("DbUser", (Object)this.dbUser()).add("SecretArn", (Object)this.secretArn()).add("Sql", (Object)this.sql()).add("StatementName", (Object)this.statementName()).add("WithEvent", (Object)this.withEvent()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterIdentifier": {
                return Optional.ofNullable(clazz.cast(this.clusterIdentifier()));
            }
            case "Database": {
                return Optional.ofNullable(clazz.cast(this.database()));
            }
            case "DbUser": {
                return Optional.ofNullable(clazz.cast(this.dbUser()));
            }
            case "SecretArn": {
                return Optional.ofNullable(clazz.cast(this.secretArn()));
            }
            case "Sql": {
                return Optional.ofNullable(clazz.cast(this.sql()));
            }
            case "StatementName": {
                return Optional.ofNullable(clazz.cast(this.statementName()));
            }
            case "WithEvent": {
                return Optional.ofNullable(clazz.cast(this.withEvent()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExecuteStatementRequest, T> g) {
        return obj -> g.apply((ExecuteStatementRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RedshiftDataRequest.BuilderImpl
    implements Builder {
        private String clusterIdentifier;
        private String database;
        private String dbUser;
        private String secretArn;
        private String sql;
        private String statementName;
        private Boolean withEvent;

        private BuilderImpl() {
        }

        private BuilderImpl(ExecuteStatementRequest model) {
            super(model);
            this.clusterIdentifier(model.clusterIdentifier);
            this.database(model.database);
            this.dbUser(model.dbUser);
            this.secretArn(model.secretArn);
            this.sql(model.sql);
            this.statementName(model.statementName);
            this.withEvent(model.withEvent);
        }

        public final String getClusterIdentifier() {
            return this.clusterIdentifier;
        }

        @Override
        public final Builder clusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        public final void setClusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
        }

        public final String getDatabase() {
            return this.database;
        }

        @Override
        public final Builder database(String database) {
            this.database = database;
            return this;
        }

        public final void setDatabase(String database) {
            this.database = database;
        }

        public final String getDbUser() {
            return this.dbUser;
        }

        @Override
        public final Builder dbUser(String dbUser) {
            this.dbUser = dbUser;
            return this;
        }

        public final void setDbUser(String dbUser) {
            this.dbUser = dbUser;
        }

        public final String getSecretArn() {
            return this.secretArn;
        }

        @Override
        public final Builder secretArn(String secretArn) {
            this.secretArn = secretArn;
            return this;
        }

        public final void setSecretArn(String secretArn) {
            this.secretArn = secretArn;
        }

        public final String getSql() {
            return this.sql;
        }

        @Override
        public final Builder sql(String sql) {
            this.sql = sql;
            return this;
        }

        public final void setSql(String sql) {
            this.sql = sql;
        }

        public final String getStatementName() {
            return this.statementName;
        }

        @Override
        public final Builder statementName(String statementName) {
            this.statementName = statementName;
            return this;
        }

        public final void setStatementName(String statementName) {
            this.statementName = statementName;
        }

        public final Boolean getWithEvent() {
            return this.withEvent;
        }

        @Override
        public final Builder withEvent(Boolean withEvent) {
            this.withEvent = withEvent;
            return this;
        }

        public final void setWithEvent(Boolean withEvent) {
            this.withEvent = withEvent;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ExecuteStatementRequest build() {
            return new ExecuteStatementRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RedshiftDataRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ExecuteStatementRequest> {
        public Builder clusterIdentifier(String var1);

        public Builder database(String var1);

        public Builder dbUser(String var1);

        public Builder secretArn(String var1);

        public Builder sql(String var1);

        public Builder statementName(String var1);

        public Builder withEvent(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

