/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshiftdata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTablesRequest extends RedshiftDataRequest implements
        ToCopyableBuilder<ListTablesRequest.Builder, ListTablesRequest> {
    private static final SdkField<String> CLUSTER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterIdentifier").getter(getter(ListTablesRequest::clusterIdentifier))
            .setter(setter(Builder::clusterIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterIdentifier").build()).build();

    private static final SdkField<String> DATABASE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Database").getter(getter(ListTablesRequest::database)).setter(setter(Builder::database))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Database").build()).build();

    private static final SdkField<String> DB_USER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("DbUser")
            .getter(getter(ListTablesRequest::dbUser)).setter(setter(Builder::dbUser))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DbUser").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListTablesRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListTablesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<String> SCHEMA_PATTERN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SchemaPattern").getter(getter(ListTablesRequest::schemaPattern)).setter(setter(Builder::schemaPattern))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaPattern").build()).build();

    private static final SdkField<String> SECRET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SecretArn").getter(getter(ListTablesRequest::secretArn)).setter(setter(Builder::secretArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretArn").build()).build();

    private static final SdkField<String> TABLE_PATTERN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TablePattern").getter(getter(ListTablesRequest::tablePattern)).setter(setter(Builder::tablePattern))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TablePattern").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_IDENTIFIER_FIELD,
            DATABASE_FIELD, DB_USER_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, SCHEMA_PATTERN_FIELD, SECRET_ARN_FIELD,
            TABLE_PATTERN_FIELD));

    private final String clusterIdentifier;

    private final String database;

    private final String dbUser;

    private final Integer maxResults;

    private final String nextToken;

    private final String schemaPattern;

    private final String secretArn;

    private final String tablePattern;

    private ListTablesRequest(BuilderImpl builder) {
        super(builder);
        this.clusterIdentifier = builder.clusterIdentifier;
        this.database = builder.database;
        this.dbUser = builder.dbUser;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.schemaPattern = builder.schemaPattern;
        this.secretArn = builder.secretArn;
        this.tablePattern = builder.tablePattern;
    }

    /**
     * <p>
     * The cluster identifier. This parameter is required when authenticating using either AWS Secrets Manager or
     * temporary credentials.
     * </p>
     * 
     * @return The cluster identifier. This parameter is required when authenticating using either AWS Secrets Manager
     *         or temporary credentials.
     */
    public String clusterIdentifier() {
        return clusterIdentifier;
    }

    /**
     * <p>
     * The name of the database. This parameter is required when authenticating using temporary credentials.
     * </p>
     * 
     * @return The name of the database. This parameter is required when authenticating using temporary credentials.
     */
    public String database() {
        return database;
    }

    /**
     * <p>
     * The database user name. This parameter is required when authenticating using temporary credentials.
     * </p>
     * 
     * @return The database user name. This parameter is required when authenticating using temporary credentials.
     */
    public String dbUser() {
        return dbUser;
    }

    /**
     * <p>
     * The maximum number of tables to return in the response. If more tables exist than fit in one response, then
     * <code>NextToken</code> is returned to page through the results.
     * </p>
     * 
     * @return The maximum number of tables to return in the response. If more tables exist than fit in one response,
     *         then <code>NextToken</code> is returned to page through the results.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * A value that indicates the starting point for the next set of response records in a subsequent request. If a
     * value is returned in a response, you can retrieve the next set of records by providing this returned NextToken
     * value in the next NextToken parameter and retrying the command. If the NextToken field is empty, all response
     * records have been retrieved for the request.
     * </p>
     * 
     * @return A value that indicates the starting point for the next set of response records in a subsequent request.
     *         If a value is returned in a response, you can retrieve the next set of records by providing this returned
     *         NextToken value in the next NextToken parameter and retrying the command. If the NextToken field is
     *         empty, all response records have been retrieved for the request.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * A pattern to filter results by schema name. Within a schema pattern, "%" means match any substring of 0 or more
     * characters and "_" means match any one character. Only schema name entries matching the search pattern are
     * returned. If <code>SchemaPattern</code> is not specified, then all tables that match <code>TablePattern</code>
     * are returned. If neither <code>SchemaPattern</code> or <code>TablePattern</code> are specified, then all tables
     * are returned.
     * </p>
     * 
     * @return A pattern to filter results by schema name. Within a schema pattern, "%" means match any substring of 0
     *         or more characters and "_" means match any one character. Only schema name entries matching the search
     *         pattern are returned. If <code>SchemaPattern</code> is not specified, then all tables that match
     *         <code>TablePattern</code> are returned. If neither <code>SchemaPattern</code> or
     *         <code>TablePattern</code> are specified, then all tables are returned.
     */
    public String schemaPattern() {
        return schemaPattern;
    }

    /**
     * <p>
     * The name or ARN of the secret that enables access to the database. This parameter is required when authenticating
     * using AWS Secrets Manager.
     * </p>
     * 
     * @return The name or ARN of the secret that enables access to the database. This parameter is required when
     *         authenticating using AWS Secrets Manager.
     */
    public String secretArn() {
        return secretArn;
    }

    /**
     * <p>
     * A pattern to filter results by table name. Within a table pattern, "%" means match any substring of 0 or more
     * characters and "_" means match any one character. Only table name entries matching the search pattern are
     * returned. If <code>TablePattern</code> is not specified, then all tables that match <code>SchemaPattern</code>are
     * returned. If neither <code>SchemaPattern</code> or <code>TablePattern</code> are specified, then all tables are
     * returned.
     * </p>
     * 
     * @return A pattern to filter results by table name. Within a table pattern, "%" means match any substring of 0 or
     *         more characters and "_" means match any one character. Only table name entries matching the search
     *         pattern are returned. If <code>TablePattern</code> is not specified, then all tables that match
     *         <code>SchemaPattern</code>are returned. If neither <code>SchemaPattern</code> or
     *         <code>TablePattern</code> are specified, then all tables are returned.
     */
    public String tablePattern() {
        return tablePattern;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(database());
        hashCode = 31 * hashCode + Objects.hashCode(dbUser());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(schemaPattern());
        hashCode = 31 * hashCode + Objects.hashCode(secretArn());
        hashCode = 31 * hashCode + Objects.hashCode(tablePattern());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTablesRequest)) {
            return false;
        }
        ListTablesRequest other = (ListTablesRequest) obj;
        return Objects.equals(clusterIdentifier(), other.clusterIdentifier()) && Objects.equals(database(), other.database())
                && Objects.equals(dbUser(), other.dbUser()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(schemaPattern(), other.schemaPattern())
                && Objects.equals(secretArn(), other.secretArn()) && Objects.equals(tablePattern(), other.tablePattern());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListTablesRequest").add("ClusterIdentifier", clusterIdentifier()).add("Database", database())
                .add("DbUser", dbUser()).add("MaxResults", maxResults()).add("NextToken", nextToken())
                .add("SchemaPattern", schemaPattern()).add("SecretArn", secretArn()).add("TablePattern", tablePattern()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClusterIdentifier":
            return Optional.ofNullable(clazz.cast(clusterIdentifier()));
        case "Database":
            return Optional.ofNullable(clazz.cast(database()));
        case "DbUser":
            return Optional.ofNullable(clazz.cast(dbUser()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "SchemaPattern":
            return Optional.ofNullable(clazz.cast(schemaPattern()));
        case "SecretArn":
            return Optional.ofNullable(clazz.cast(secretArn()));
        case "TablePattern":
            return Optional.ofNullable(clazz.cast(tablePattern()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTablesRequest, T> g) {
        return obj -> g.apply((ListTablesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftDataRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListTablesRequest> {
        /**
         * <p>
         * The cluster identifier. This parameter is required when authenticating using either AWS Secrets Manager or
         * temporary credentials.
         * </p>
         * 
         * @param clusterIdentifier
         *        The cluster identifier. This parameter is required when authenticating using either AWS Secrets
         *        Manager or temporary credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterIdentifier(String clusterIdentifier);

        /**
         * <p>
         * The name of the database. This parameter is required when authenticating using temporary credentials.
         * </p>
         * 
         * @param database
         *        The name of the database. This parameter is required when authenticating using temporary credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder database(String database);

        /**
         * <p>
         * The database user name. This parameter is required when authenticating using temporary credentials.
         * </p>
         * 
         * @param dbUser
         *        The database user name. This parameter is required when authenticating using temporary credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbUser(String dbUser);

        /**
         * <p>
         * The maximum number of tables to return in the response. If more tables exist than fit in one response, then
         * <code>NextToken</code> is returned to page through the results.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of tables to return in the response. If more tables exist than fit in one response,
         *        then <code>NextToken</code> is returned to page through the results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * A value that indicates the starting point for the next set of response records in a subsequent request. If a
         * value is returned in a response, you can retrieve the next set of records by providing this returned
         * NextToken value in the next NextToken parameter and retrying the command. If the NextToken field is empty,
         * all response records have been retrieved for the request.
         * </p>
         * 
         * @param nextToken
         *        A value that indicates the starting point for the next set of response records in a subsequent
         *        request. If a value is returned in a response, you can retrieve the next set of records by providing
         *        this returned NextToken value in the next NextToken parameter and retrying the command. If the
         *        NextToken field is empty, all response records have been retrieved for the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * A pattern to filter results by schema name. Within a schema pattern, "%" means match any substring of 0 or
         * more characters and "_" means match any one character. Only schema name entries matching the search pattern
         * are returned. If <code>SchemaPattern</code> is not specified, then all tables that match
         * <code>TablePattern</code> are returned. If neither <code>SchemaPattern</code> or <code>TablePattern</code>
         * are specified, then all tables are returned.
         * </p>
         * 
         * @param schemaPattern
         *        A pattern to filter results by schema name. Within a schema pattern, "%" means match any substring of
         *        0 or more characters and "_" means match any one character. Only schema name entries matching the
         *        search pattern are returned. If <code>SchemaPattern</code> is not specified, then all tables that
         *        match <code>TablePattern</code> are returned. If neither <code>SchemaPattern</code> or
         *        <code>TablePattern</code> are specified, then all tables are returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaPattern(String schemaPattern);

        /**
         * <p>
         * The name or ARN of the secret that enables access to the database. This parameter is required when
         * authenticating using AWS Secrets Manager.
         * </p>
         * 
         * @param secretArn
         *        The name or ARN of the secret that enables access to the database. This parameter is required when
         *        authenticating using AWS Secrets Manager.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretArn(String secretArn);

        /**
         * <p>
         * A pattern to filter results by table name. Within a table pattern, "%" means match any substring of 0 or more
         * characters and "_" means match any one character. Only table name entries matching the search pattern are
         * returned. If <code>TablePattern</code> is not specified, then all tables that match
         * <code>SchemaPattern</code>are returned. If neither <code>SchemaPattern</code> or <code>TablePattern</code>
         * are specified, then all tables are returned.
         * </p>
         * 
         * @param tablePattern
         *        A pattern to filter results by table name. Within a table pattern, "%" means match any substring of 0
         *        or more characters and "_" means match any one character. Only table name entries matching the search
         *        pattern are returned. If <code>TablePattern</code> is not specified, then all tables that match
         *        <code>SchemaPattern</code>are returned. If neither <code>SchemaPattern</code> or
         *        <code>TablePattern</code> are specified, then all tables are returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tablePattern(String tablePattern);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RedshiftDataRequest.BuilderImpl implements Builder {
        private String clusterIdentifier;

        private String database;

        private String dbUser;

        private Integer maxResults;

        private String nextToken;

        private String schemaPattern;

        private String secretArn;

        private String tablePattern;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTablesRequest model) {
            super(model);
            clusterIdentifier(model.clusterIdentifier);
            database(model.database);
            dbUser(model.dbUser);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            schemaPattern(model.schemaPattern);
            secretArn(model.secretArn);
            tablePattern(model.tablePattern);
        }

        public final String getClusterIdentifier() {
            return clusterIdentifier;
        }

        @Override
        public final Builder clusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        public final void setClusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
        }

        public final String getDatabase() {
            return database;
        }

        @Override
        public final Builder database(String database) {
            this.database = database;
            return this;
        }

        public final void setDatabase(String database) {
            this.database = database;
        }

        public final String getDbUser() {
            return dbUser;
        }

        @Override
        public final Builder dbUser(String dbUser) {
            this.dbUser = dbUser;
            return this;
        }

        public final void setDbUser(String dbUser) {
            this.dbUser = dbUser;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final String getSchemaPattern() {
            return schemaPattern;
        }

        @Override
        public final Builder schemaPattern(String schemaPattern) {
            this.schemaPattern = schemaPattern;
            return this;
        }

        public final void setSchemaPattern(String schemaPattern) {
            this.schemaPattern = schemaPattern;
        }

        public final String getSecretArn() {
            return secretArn;
        }

        @Override
        public final Builder secretArn(String secretArn) {
            this.secretArn = secretArn;
            return this;
        }

        public final void setSecretArn(String secretArn) {
            this.secretArn = secretArn;
        }

        public final String getTablePattern() {
            return tablePattern;
        }

        @Override
        public final Builder tablePattern(String tablePattern) {
            this.tablePattern = tablePattern;
            return this;
        }

        public final void setTablePattern(String tablePattern) {
            this.tablePattern = tablePattern;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListTablesRequest build() {
            return new ListTablesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
