/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshiftdata.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExecuteStatementRequest extends RedshiftDataRequest implements
        ToCopyableBuilder<ExecuteStatementRequest.Builder, ExecuteStatementRequest> {
    private static final SdkField<String> CLUSTER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterIdentifier").getter(getter(ExecuteStatementRequest::clusterIdentifier))
            .setter(setter(Builder::clusterIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterIdentifier").build()).build();

    private static final SdkField<String> DATABASE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Database").getter(getter(ExecuteStatementRequest::database)).setter(setter(Builder::database))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Database").build()).build();

    private static final SdkField<String> DB_USER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("DbUser")
            .getter(getter(ExecuteStatementRequest::dbUser)).setter(setter(Builder::dbUser))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DbUser").build()).build();

    private static final SdkField<List<SqlParameter>> PARAMETERS_FIELD = SdkField
            .<List<SqlParameter>> builder(MarshallingType.LIST)
            .memberName("Parameters")
            .getter(getter(ExecuteStatementRequest::parameters))
            .setter(setter(Builder::parameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SqlParameter> builder(MarshallingType.SDK_POJO)
                                            .constructor(SqlParameter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SECRET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SecretArn").getter(getter(ExecuteStatementRequest::secretArn)).setter(setter(Builder::secretArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretArn").build()).build();

    private static final SdkField<String> SQL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Sql")
            .getter(getter(ExecuteStatementRequest::sql)).setter(setter(Builder::sql))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sql").build()).build();

    private static final SdkField<String> STATEMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatementName").getter(getter(ExecuteStatementRequest::statementName))
            .setter(setter(Builder::statementName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatementName").build()).build();

    private static final SdkField<Boolean> WITH_EVENT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("WithEvent").getter(getter(ExecuteStatementRequest::withEvent)).setter(setter(Builder::withEvent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WithEvent").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(CLUSTER_IDENTIFIER_FIELD, DATABASE_FIELD, DB_USER_FIELD, PARAMETERS_FIELD,
                    SECRET_ARN_FIELD, SQL_FIELD, STATEMENT_NAME_FIELD, WITH_EVENT_FIELD));

    private final String clusterIdentifier;

    private final String database;

    private final String dbUser;

    private final List<SqlParameter> parameters;

    private final String secretArn;

    private final String sql;

    private final String statementName;

    private final Boolean withEvent;

    private ExecuteStatementRequest(BuilderImpl builder) {
        super(builder);
        this.clusterIdentifier = builder.clusterIdentifier;
        this.database = builder.database;
        this.dbUser = builder.dbUser;
        this.parameters = builder.parameters;
        this.secretArn = builder.secretArn;
        this.sql = builder.sql;
        this.statementName = builder.statementName;
        this.withEvent = builder.withEvent;
    }

    /**
     * <p>
     * The cluster identifier. This parameter is required when authenticating using either AWS Secrets Manager or
     * temporary credentials.
     * </p>
     * 
     * @return The cluster identifier. This parameter is required when authenticating using either AWS Secrets Manager
     *         or temporary credentials.
     */
    public final String clusterIdentifier() {
        return clusterIdentifier;
    }

    /**
     * <p>
     * The name of the database. This parameter is required when authenticating using temporary credentials.
     * </p>
     * 
     * @return The name of the database. This parameter is required when authenticating using temporary credentials.
     */
    public final String database() {
        return database;
    }

    /**
     * <p>
     * The database user name. This parameter is required when authenticating using temporary credentials.
     * </p>
     * 
     * @return The database user name. This parameter is required when authenticating using temporary credentials.
     */
    public final String dbUser() {
        return dbUser;
    }

    /**
     * Returns true if the Parameters property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasParameters() {
        return parameters != null && !(parameters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The parameters for the SQL statement.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasParameters()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The parameters for the SQL statement.
     */
    public final List<SqlParameter> parameters() {
        return parameters;
    }

    /**
     * <p>
     * The name or ARN of the secret that enables access to the database. This parameter is required when authenticating
     * using AWS Secrets Manager.
     * </p>
     * 
     * @return The name or ARN of the secret that enables access to the database. This parameter is required when
     *         authenticating using AWS Secrets Manager.
     */
    public final String secretArn() {
        return secretArn;
    }

    /**
     * <p>
     * The SQL statement text to run.
     * </p>
     * 
     * @return The SQL statement text to run.
     */
    public final String sql() {
        return sql;
    }

    /**
     * <p>
     * The name of the SQL statement. You can name the SQL statement when you create it to identify the query.
     * </p>
     * 
     * @return The name of the SQL statement. You can name the SQL statement when you create it to identify the query.
     */
    public final String statementName() {
        return statementName;
    }

    /**
     * <p>
     * A value that indicates whether to send an event to the Amazon EventBridge event bus after the SQL statement runs.
     * </p>
     * 
     * @return A value that indicates whether to send an event to the Amazon EventBridge event bus after the SQL
     *         statement runs.
     */
    public final Boolean withEvent() {
        return withEvent;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(database());
        hashCode = 31 * hashCode + Objects.hashCode(dbUser());
        hashCode = 31 * hashCode + Objects.hashCode(hasParameters() ? parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(secretArn());
        hashCode = 31 * hashCode + Objects.hashCode(sql());
        hashCode = 31 * hashCode + Objects.hashCode(statementName());
        hashCode = 31 * hashCode + Objects.hashCode(withEvent());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecuteStatementRequest)) {
            return false;
        }
        ExecuteStatementRequest other = (ExecuteStatementRequest) obj;
        return Objects.equals(clusterIdentifier(), other.clusterIdentifier()) && Objects.equals(database(), other.database())
                && Objects.equals(dbUser(), other.dbUser()) && hasParameters() == other.hasParameters()
                && Objects.equals(parameters(), other.parameters()) && Objects.equals(secretArn(), other.secretArn())
                && Objects.equals(sql(), other.sql()) && Objects.equals(statementName(), other.statementName())
                && Objects.equals(withEvent(), other.withEvent());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExecuteStatementRequest").add("ClusterIdentifier", clusterIdentifier())
                .add("Database", database()).add("DbUser", dbUser()).add("Parameters", hasParameters() ? parameters() : null)
                .add("SecretArn", secretArn()).add("Sql", sql()).add("StatementName", statementName())
                .add("WithEvent", withEvent()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClusterIdentifier":
            return Optional.ofNullable(clazz.cast(clusterIdentifier()));
        case "Database":
            return Optional.ofNullable(clazz.cast(database()));
        case "DbUser":
            return Optional.ofNullable(clazz.cast(dbUser()));
        case "Parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        case "SecretArn":
            return Optional.ofNullable(clazz.cast(secretArn()));
        case "Sql":
            return Optional.ofNullable(clazz.cast(sql()));
        case "StatementName":
            return Optional.ofNullable(clazz.cast(statementName()));
        case "WithEvent":
            return Optional.ofNullable(clazz.cast(withEvent()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExecuteStatementRequest, T> g) {
        return obj -> g.apply((ExecuteStatementRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftDataRequest.Builder, SdkPojo, CopyableBuilder<Builder, ExecuteStatementRequest> {
        /**
         * <p>
         * The cluster identifier. This parameter is required when authenticating using either AWS Secrets Manager or
         * temporary credentials.
         * </p>
         * 
         * @param clusterIdentifier
         *        The cluster identifier. This parameter is required when authenticating using either AWS Secrets
         *        Manager or temporary credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterIdentifier(String clusterIdentifier);

        /**
         * <p>
         * The name of the database. This parameter is required when authenticating using temporary credentials.
         * </p>
         * 
         * @param database
         *        The name of the database. This parameter is required when authenticating using temporary credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder database(String database);

        /**
         * <p>
         * The database user name. This parameter is required when authenticating using temporary credentials.
         * </p>
         * 
         * @param dbUser
         *        The database user name. This parameter is required when authenticating using temporary credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbUser(String dbUser);

        /**
         * <p>
         * The parameters for the SQL statement.
         * </p>
         * 
         * @param parameters
         *        The parameters for the SQL statement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Collection<SqlParameter> parameters);

        /**
         * <p>
         * The parameters for the SQL statement.
         * </p>
         * 
         * @param parameters
         *        The parameters for the SQL statement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(SqlParameter... parameters);

        /**
         * <p>
         * The parameters for the SQL statement.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SqlParameter>.Builder} avoiding the need to
         * create one manually via {@link List<SqlParameter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SqlParameter>.Builder#build()} is called immediately and its
         * result is passed to {@link #parameters(List<SqlParameter>)}.
         * 
         * @param parameters
         *        a consumer that will call methods on {@link List<SqlParameter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parameters(List<SqlParameter>)
         */
        Builder parameters(Consumer<SqlParameter.Builder>... parameters);

        /**
         * <p>
         * The name or ARN of the secret that enables access to the database. This parameter is required when
         * authenticating using AWS Secrets Manager.
         * </p>
         * 
         * @param secretArn
         *        The name or ARN of the secret that enables access to the database. This parameter is required when
         *        authenticating using AWS Secrets Manager.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretArn(String secretArn);

        /**
         * <p>
         * The SQL statement text to run.
         * </p>
         * 
         * @param sql
         *        The SQL statement text to run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sql(String sql);

        /**
         * <p>
         * The name of the SQL statement. You can name the SQL statement when you create it to identify the query.
         * </p>
         * 
         * @param statementName
         *        The name of the SQL statement. You can name the SQL statement when you create it to identify the
         *        query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statementName(String statementName);

        /**
         * <p>
         * A value that indicates whether to send an event to the Amazon EventBridge event bus after the SQL statement
         * runs.
         * </p>
         * 
         * @param withEvent
         *        A value that indicates whether to send an event to the Amazon EventBridge event bus after the SQL
         *        statement runs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder withEvent(Boolean withEvent);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RedshiftDataRequest.BuilderImpl implements Builder {
        private String clusterIdentifier;

        private String database;

        private String dbUser;

        private List<SqlParameter> parameters = DefaultSdkAutoConstructList.getInstance();

        private String secretArn;

        private String sql;

        private String statementName;

        private Boolean withEvent;

        private BuilderImpl() {
        }

        private BuilderImpl(ExecuteStatementRequest model) {
            super(model);
            clusterIdentifier(model.clusterIdentifier);
            database(model.database);
            dbUser(model.dbUser);
            parameters(model.parameters);
            secretArn(model.secretArn);
            sql(model.sql);
            statementName(model.statementName);
            withEvent(model.withEvent);
        }

        public final String getClusterIdentifier() {
            return clusterIdentifier;
        }

        @Override
        public final Builder clusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        public final void setClusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
        }

        public final String getDatabase() {
            return database;
        }

        @Override
        public final Builder database(String database) {
            this.database = database;
            return this;
        }

        public final void setDatabase(String database) {
            this.database = database;
        }

        public final String getDbUser() {
            return dbUser;
        }

        @Override
        public final Builder dbUser(String dbUser) {
            this.dbUser = dbUser;
            return this;
        }

        public final void setDbUser(String dbUser) {
            this.dbUser = dbUser;
        }

        public final List<SqlParameter.Builder> getParameters() {
            List<SqlParameter.Builder> result = SqlParametersListCopier.copyToBuilder(this.parameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder parameters(Collection<SqlParameter> parameters) {
            this.parameters = SqlParametersListCopier.copy(parameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(SqlParameter... parameters) {
            parameters(Arrays.asList(parameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Consumer<SqlParameter.Builder>... parameters) {
            parameters(Stream.of(parameters).map(c -> SqlParameter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setParameters(Collection<SqlParameter.BuilderImpl> parameters) {
            this.parameters = SqlParametersListCopier.copyFromBuilder(parameters);
        }

        public final String getSecretArn() {
            return secretArn;
        }

        @Override
        public final Builder secretArn(String secretArn) {
            this.secretArn = secretArn;
            return this;
        }

        public final void setSecretArn(String secretArn) {
            this.secretArn = secretArn;
        }

        public final String getSql() {
            return sql;
        }

        @Override
        public final Builder sql(String sql) {
            this.sql = sql;
            return this;
        }

        public final void setSql(String sql) {
            this.sql = sql;
        }

        public final String getStatementName() {
            return statementName;
        }

        @Override
        public final Builder statementName(String statementName) {
            this.statementName = statementName;
            return this;
        }

        public final void setStatementName(String statementName) {
            this.statementName = statementName;
        }

        public final Boolean getWithEvent() {
            return withEvent;
        }

        @Override
        public final Builder withEvent(Boolean withEvent) {
            this.withEvent = withEvent;
            return this;
        }

        public final void setWithEvent(Boolean withEvent) {
            this.withEvent = withEvent;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ExecuteStatementRequest build() {
            return new ExecuteStatementRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
