/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshiftdata.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The SQL statement to run.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StatementData implements SdkPojo, Serializable, ToCopyableBuilder<StatementData.Builder, StatementData> {
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt").getter(getter(StatementData::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(StatementData::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<Boolean> IS_BATCH_STATEMENT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsBatchStatement").getter(getter(StatementData::isBatchStatement))
            .setter(setter(Builder::isBatchStatement))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsBatchStatement").build()).build();

    private static final SdkField<List<SqlParameter>> QUERY_PARAMETERS_FIELD = SdkField
            .<List<SqlParameter>> builder(MarshallingType.LIST)
            .memberName("QueryParameters")
            .getter(getter(StatementData::queryParameters))
            .setter(setter(Builder::queryParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryParameters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SqlParameter> builder(MarshallingType.SDK_POJO)
                                            .constructor(SqlParameter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> QUERY_STRING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QueryString").getter(getter(StatementData::queryString)).setter(setter(Builder::queryString))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryString").build()).build();

    private static final SdkField<List<String>> QUERY_STRINGS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("QueryStrings")
            .getter(getter(StatementData::queryStrings))
            .setter(setter(Builder::queryStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryStrings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SECRET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SecretArn").getter(getter(StatementData::secretArn)).setter(setter(Builder::secretArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretArn").build()).build();

    private static final SdkField<String> STATEMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatementName").getter(getter(StatementData::statementName)).setter(setter(Builder::statementName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatementName").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(StatementData::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("UpdatedAt").getter(getter(StatementData::updatedAt)).setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AT_FIELD, ID_FIELD,
            IS_BATCH_STATEMENT_FIELD, QUERY_PARAMETERS_FIELD, QUERY_STRING_FIELD, QUERY_STRINGS_FIELD, SECRET_ARN_FIELD,
            STATEMENT_NAME_FIELD, STATUS_FIELD, UPDATED_AT_FIELD));

    private static final long serialVersionUID = 1L;

    private final Instant createdAt;

    private final String id;

    private final Boolean isBatchStatement;

    private final List<SqlParameter> queryParameters;

    private final String queryString;

    private final List<String> queryStrings;

    private final String secretArn;

    private final String statementName;

    private final String status;

    private final Instant updatedAt;

    private StatementData(BuilderImpl builder) {
        this.createdAt = builder.createdAt;
        this.id = builder.id;
        this.isBatchStatement = builder.isBatchStatement;
        this.queryParameters = builder.queryParameters;
        this.queryString = builder.queryString;
        this.queryStrings = builder.queryStrings;
        this.secretArn = builder.secretArn;
        this.statementName = builder.statementName;
        this.status = builder.status;
        this.updatedAt = builder.updatedAt;
    }

    /**
     * <p>
     * The date and time (UTC) the statement was created.
     * </p>
     * 
     * @return The date and time (UTC) the statement was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The SQL statement identifier. This value is a universally unique identifier (UUID) generated by Amazon Redshift
     * Data API.
     * </p>
     * 
     * @return The SQL statement identifier. This value is a universally unique identifier (UUID) generated by Amazon
     *         Redshift Data API.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * A value that indicates whether the statement is a batch query request.
     * </p>
     * 
     * @return A value that indicates whether the statement is a batch query request.
     */
    public final Boolean isBatchStatement() {
        return isBatchStatement;
    }

    /**
     * Returns true if the QueryParameters property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasQueryParameters() {
        return queryParameters != null && !(queryParameters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The parameters used in a SQL statement.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasQueryParameters()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The parameters used in a SQL statement.
     */
    public final List<SqlParameter> queryParameters() {
        return queryParameters;
    }

    /**
     * <p>
     * The SQL statement.
     * </p>
     * 
     * @return The SQL statement.
     */
    public final String queryString() {
        return queryString;
    }

    /**
     * Returns true if the QueryStrings property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasQueryStrings() {
        return queryStrings != null && !(queryStrings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more SQL statements. Each query string in the array corresponds to one of the queries in a batch query
     * request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasQueryStrings()} to see if a value was sent in this field.
     * </p>
     * 
     * @return One or more SQL statements. Each query string in the array corresponds to one of the queries in a batch
     *         query request.
     */
    public final List<String> queryStrings() {
        return queryStrings;
    }

    /**
     * <p>
     * The name or Amazon Resource Name (ARN) of the secret that enables access to the database.
     * </p>
     * 
     * @return The name or Amazon Resource Name (ARN) of the secret that enables access to the database.
     */
    public final String secretArn() {
        return secretArn;
    }

    /**
     * <p>
     * The name of the SQL statement.
     * </p>
     * 
     * @return The name of the SQL statement.
     */
    public final String statementName() {
        return statementName;
    }

    /**
     * <p>
     * The status of the SQL statement. An example is the that the SQL statement finished.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link StatusString#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the SQL statement. An example is the that the SQL statement finished.
     * @see StatusString
     */
    public final StatusString status() {
        return StatusString.fromValue(status);
    }

    /**
     * <p>
     * The status of the SQL statement. An example is the that the SQL statement finished.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link StatusString#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the SQL statement. An example is the that the SQL statement finished.
     * @see StatusString
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The date and time (UTC) that the statement metadata was last updated.
     * </p>
     * 
     * @return The date and time (UTC) that the statement metadata was last updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(isBatchStatement());
        hashCode = 31 * hashCode + Objects.hashCode(hasQueryParameters() ? queryParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(queryString());
        hashCode = 31 * hashCode + Objects.hashCode(hasQueryStrings() ? queryStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(secretArn());
        hashCode = 31 * hashCode + Objects.hashCode(statementName());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StatementData)) {
            return false;
        }
        StatementData other = (StatementData) obj;
        return Objects.equals(createdAt(), other.createdAt()) && Objects.equals(id(), other.id())
                && Objects.equals(isBatchStatement(), other.isBatchStatement())
                && hasQueryParameters() == other.hasQueryParameters()
                && Objects.equals(queryParameters(), other.queryParameters())
                && Objects.equals(queryString(), other.queryString()) && hasQueryStrings() == other.hasQueryStrings()
                && Objects.equals(queryStrings(), other.queryStrings()) && Objects.equals(secretArn(), other.secretArn())
                && Objects.equals(statementName(), other.statementName())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(updatedAt(), other.updatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StatementData").add("CreatedAt", createdAt()).add("Id", id())
                .add("IsBatchStatement", isBatchStatement())
                .add("QueryParameters", hasQueryParameters() ? queryParameters() : null).add("QueryString", queryString())
                .add("QueryStrings", hasQueryStrings() ? queryStrings() : null).add("SecretArn", secretArn())
                .add("StatementName", statementName()).add("Status", statusAsString()).add("UpdatedAt", updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "IsBatchStatement":
            return Optional.ofNullable(clazz.cast(isBatchStatement()));
        case "QueryParameters":
            return Optional.ofNullable(clazz.cast(queryParameters()));
        case "QueryString":
            return Optional.ofNullable(clazz.cast(queryString()));
        case "QueryStrings":
            return Optional.ofNullable(clazz.cast(queryStrings()));
        case "SecretArn":
            return Optional.ofNullable(clazz.cast(secretArn()));
        case "StatementName":
            return Optional.ofNullable(clazz.cast(statementName()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "UpdatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StatementData, T> g) {
        return obj -> g.apply((StatementData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StatementData> {
        /**
         * <p>
         * The date and time (UTC) the statement was created.
         * </p>
         * 
         * @param createdAt
         *        The date and time (UTC) the statement was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The SQL statement identifier. This value is a universally unique identifier (UUID) generated by Amazon
         * Redshift Data API.
         * </p>
         * 
         * @param id
         *        The SQL statement identifier. This value is a universally unique identifier (UUID) generated by Amazon
         *        Redshift Data API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * A value that indicates whether the statement is a batch query request.
         * </p>
         * 
         * @param isBatchStatement
         *        A value that indicates whether the statement is a batch query request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isBatchStatement(Boolean isBatchStatement);

        /**
         * <p>
         * The parameters used in a SQL statement.
         * </p>
         * 
         * @param queryParameters
         *        The parameters used in a SQL statement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryParameters(Collection<SqlParameter> queryParameters);

        /**
         * <p>
         * The parameters used in a SQL statement.
         * </p>
         * 
         * @param queryParameters
         *        The parameters used in a SQL statement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryParameters(SqlParameter... queryParameters);

        /**
         * <p>
         * The parameters used in a SQL statement.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SqlParameter>.Builder} avoiding the need to
         * create one manually via {@link List<SqlParameter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SqlParameter>.Builder#build()} is called immediately and its
         * result is passed to {@link #queryParameters(List<SqlParameter>)}.
         * 
         * @param queryParameters
         *        a consumer that will call methods on {@link List<SqlParameter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #queryParameters(List<SqlParameter>)
         */
        Builder queryParameters(Consumer<SqlParameter.Builder>... queryParameters);

        /**
         * <p>
         * The SQL statement.
         * </p>
         * 
         * @param queryString
         *        The SQL statement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryString(String queryString);

        /**
         * <p>
         * One or more SQL statements. Each query string in the array corresponds to one of the queries in a batch query
         * request.
         * </p>
         * 
         * @param queryStrings
         *        One or more SQL statements. Each query string in the array corresponds to one of the queries in a
         *        batch query request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryStrings(Collection<String> queryStrings);

        /**
         * <p>
         * One or more SQL statements. Each query string in the array corresponds to one of the queries in a batch query
         * request.
         * </p>
         * 
         * @param queryStrings
         *        One or more SQL statements. Each query string in the array corresponds to one of the queries in a
         *        batch query request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryStrings(String... queryStrings);

        /**
         * <p>
         * The name or Amazon Resource Name (ARN) of the secret that enables access to the database.
         * </p>
         * 
         * @param secretArn
         *        The name or Amazon Resource Name (ARN) of the secret that enables access to the database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretArn(String secretArn);

        /**
         * <p>
         * The name of the SQL statement.
         * </p>
         * 
         * @param statementName
         *        The name of the SQL statement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statementName(String statementName);

        /**
         * <p>
         * The status of the SQL statement. An example is the that the SQL statement finished.
         * </p>
         * 
         * @param status
         *        The status of the SQL statement. An example is the that the SQL statement finished.
         * @see StatusString
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StatusString
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the SQL statement. An example is the that the SQL statement finished.
         * </p>
         * 
         * @param status
         *        The status of the SQL statement. An example is the that the SQL statement finished.
         * @see StatusString
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StatusString
         */
        Builder status(StatusString status);

        /**
         * <p>
         * The date and time (UTC) that the statement metadata was last updated.
         * </p>
         * 
         * @param updatedAt
         *        The date and time (UTC) that the statement metadata was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);
    }

    static final class BuilderImpl implements Builder {
        private Instant createdAt;

        private String id;

        private Boolean isBatchStatement;

        private List<SqlParameter> queryParameters = DefaultSdkAutoConstructList.getInstance();

        private String queryString;

        private List<String> queryStrings = DefaultSdkAutoConstructList.getInstance();

        private String secretArn;

        private String statementName;

        private String status;

        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(StatementData model) {
            createdAt(model.createdAt);
            id(model.id);
            isBatchStatement(model.isBatchStatement);
            queryParameters(model.queryParameters);
            queryString(model.queryString);
            queryStrings(model.queryStrings);
            secretArn(model.secretArn);
            statementName(model.statementName);
            status(model.status);
            updatedAt(model.updatedAt);
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        @Transient
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        @Transient
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Boolean getIsBatchStatement() {
            return isBatchStatement;
        }

        public final void setIsBatchStatement(Boolean isBatchStatement) {
            this.isBatchStatement = isBatchStatement;
        }

        @Override
        @Transient
        public final Builder isBatchStatement(Boolean isBatchStatement) {
            this.isBatchStatement = isBatchStatement;
            return this;
        }

        public final List<SqlParameter.Builder> getQueryParameters() {
            List<SqlParameter.Builder> result = SqlParametersListCopier.copyToBuilder(this.queryParameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setQueryParameters(Collection<SqlParameter.BuilderImpl> queryParameters) {
            this.queryParameters = SqlParametersListCopier.copyFromBuilder(queryParameters);
        }

        @Override
        @Transient
        public final Builder queryParameters(Collection<SqlParameter> queryParameters) {
            this.queryParameters = SqlParametersListCopier.copy(queryParameters);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder queryParameters(SqlParameter... queryParameters) {
            queryParameters(Arrays.asList(queryParameters));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder queryParameters(Consumer<SqlParameter.Builder>... queryParameters) {
            queryParameters(Stream.of(queryParameters).map(c -> SqlParameter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getQueryString() {
            return queryString;
        }

        public final void setQueryString(String queryString) {
            this.queryString = queryString;
        }

        @Override
        @Transient
        public final Builder queryString(String queryString) {
            this.queryString = queryString;
            return this;
        }

        public final Collection<String> getQueryStrings() {
            if (queryStrings instanceof SdkAutoConstructList) {
                return null;
            }
            return queryStrings;
        }

        public final void setQueryStrings(Collection<String> queryStrings) {
            this.queryStrings = StatementStringListCopier.copy(queryStrings);
        }

        @Override
        @Transient
        public final Builder queryStrings(Collection<String> queryStrings) {
            this.queryStrings = StatementStringListCopier.copy(queryStrings);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder queryStrings(String... queryStrings) {
            queryStrings(Arrays.asList(queryStrings));
            return this;
        }

        public final String getSecretArn() {
            return secretArn;
        }

        public final void setSecretArn(String secretArn) {
            this.secretArn = secretArn;
        }

        @Override
        @Transient
        public final Builder secretArn(String secretArn) {
            this.secretArn = secretArn;
            return this;
        }

        public final String getStatementName() {
            return statementName;
        }

        public final void setStatementName(String statementName) {
            this.statementName = statementName;
        }

        @Override
        @Transient
        public final Builder statementName(String statementName) {
            this.statementName = statementName;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(StatusString status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        @Transient
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public StatementData build() {
            return new StatementData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
