/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshiftdata.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchExecuteStatementRequest extends RedshiftDataRequest implements
        ToCopyableBuilder<BatchExecuteStatementRequest.Builder, BatchExecuteStatementRequest> {
    private static final SdkField<String> CLUSTER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterIdentifier").getter(getter(BatchExecuteStatementRequest::clusterIdentifier))
            .setter(setter(Builder::clusterIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterIdentifier").build()).build();

    private static final SdkField<String> DATABASE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Database").getter(getter(BatchExecuteStatementRequest::database)).setter(setter(Builder::database))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Database").build()).build();

    private static final SdkField<String> DB_USER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("DbUser")
            .getter(getter(BatchExecuteStatementRequest::dbUser)).setter(setter(Builder::dbUser))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DbUser").build()).build();

    private static final SdkField<String> SECRET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SecretArn").getter(getter(BatchExecuteStatementRequest::secretArn)).setter(setter(Builder::secretArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretArn").build()).build();

    private static final SdkField<List<String>> SQLS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Sqls")
            .getter(getter(BatchExecuteStatementRequest::sqls))
            .setter(setter(Builder::sqls))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sqls").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> STATEMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatementName").getter(getter(BatchExecuteStatementRequest::statementName))
            .setter(setter(Builder::statementName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatementName").build()).build();

    private static final SdkField<Boolean> WITH_EVENT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("WithEvent").getter(getter(BatchExecuteStatementRequest::withEvent)).setter(setter(Builder::withEvent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WithEvent").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_IDENTIFIER_FIELD,
            DATABASE_FIELD, DB_USER_FIELD, SECRET_ARN_FIELD, SQLS_FIELD, STATEMENT_NAME_FIELD, WITH_EVENT_FIELD));

    private final String clusterIdentifier;

    private final String database;

    private final String dbUser;

    private final String secretArn;

    private final List<String> sqls;

    private final String statementName;

    private final Boolean withEvent;

    private BatchExecuteStatementRequest(BuilderImpl builder) {
        super(builder);
        this.clusterIdentifier = builder.clusterIdentifier;
        this.database = builder.database;
        this.dbUser = builder.dbUser;
        this.secretArn = builder.secretArn;
        this.sqls = builder.sqls;
        this.statementName = builder.statementName;
        this.withEvent = builder.withEvent;
    }

    /**
     * <p>
     * The cluster identifier. This parameter is required when authenticating using either Secrets Manager or temporary
     * credentials.
     * </p>
     * 
     * @return The cluster identifier. This parameter is required when authenticating using either Secrets Manager or
     *         temporary credentials.
     */
    public final String clusterIdentifier() {
        return clusterIdentifier;
    }

    /**
     * <p>
     * The name of the database. This parameter is required when authenticating using either Secrets Manager or
     * temporary credentials.
     * </p>
     * 
     * @return The name of the database. This parameter is required when authenticating using either Secrets Manager or
     *         temporary credentials.
     */
    public final String database() {
        return database;
    }

    /**
     * <p>
     * The database user name. This parameter is required when authenticating using temporary credentials.
     * </p>
     * 
     * @return The database user name. This parameter is required when authenticating using temporary credentials.
     */
    public final String dbUser() {
        return dbUser;
    }

    /**
     * <p>
     * The name or ARN of the secret that enables access to the database. This parameter is required when authenticating
     * using Secrets Manager.
     * </p>
     * 
     * @return The name or ARN of the secret that enables access to the database. This parameter is required when
     *         authenticating using Secrets Manager.
     */
    public final String secretArn() {
        return secretArn;
    }

    /**
     * Returns true if the Sqls property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasSqls() {
        return sqls != null && !(sqls instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more SQL statements to run.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSqls()} to see if a value was sent in this field.
     * </p>
     * 
     * @return One or more SQL statements to run.
     */
    public final List<String> sqls() {
        return sqls;
    }

    /**
     * <p>
     * The name of the SQL statements. You can name the SQL statements when you create them to identify the query.
     * </p>
     * 
     * @return The name of the SQL statements. You can name the SQL statements when you create them to identify the
     *         query.
     */
    public final String statementName() {
        return statementName;
    }

    /**
     * <p>
     * A value that indicates whether to send an event to the Amazon EventBridge event bus after the SQL statements run.
     * </p>
     * 
     * @return A value that indicates whether to send an event to the Amazon EventBridge event bus after the SQL
     *         statements run.
     */
    public final Boolean withEvent() {
        return withEvent;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(database());
        hashCode = 31 * hashCode + Objects.hashCode(dbUser());
        hashCode = 31 * hashCode + Objects.hashCode(secretArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasSqls() ? sqls() : null);
        hashCode = 31 * hashCode + Objects.hashCode(statementName());
        hashCode = 31 * hashCode + Objects.hashCode(withEvent());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchExecuteStatementRequest)) {
            return false;
        }
        BatchExecuteStatementRequest other = (BatchExecuteStatementRequest) obj;
        return Objects.equals(clusterIdentifier(), other.clusterIdentifier()) && Objects.equals(database(), other.database())
                && Objects.equals(dbUser(), other.dbUser()) && Objects.equals(secretArn(), other.secretArn())
                && hasSqls() == other.hasSqls() && Objects.equals(sqls(), other.sqls())
                && Objects.equals(statementName(), other.statementName()) && Objects.equals(withEvent(), other.withEvent());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchExecuteStatementRequest").add("ClusterIdentifier", clusterIdentifier())
                .add("Database", database()).add("DbUser", dbUser()).add("SecretArn", secretArn())
                .add("Sqls", hasSqls() ? sqls() : null).add("StatementName", statementName()).add("WithEvent", withEvent())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClusterIdentifier":
            return Optional.ofNullable(clazz.cast(clusterIdentifier()));
        case "Database":
            return Optional.ofNullable(clazz.cast(database()));
        case "DbUser":
            return Optional.ofNullable(clazz.cast(dbUser()));
        case "SecretArn":
            return Optional.ofNullable(clazz.cast(secretArn()));
        case "Sqls":
            return Optional.ofNullable(clazz.cast(sqls()));
        case "StatementName":
            return Optional.ofNullable(clazz.cast(statementName()));
        case "WithEvent":
            return Optional.ofNullable(clazz.cast(withEvent()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchExecuteStatementRequest, T> g) {
        return obj -> g.apply((BatchExecuteStatementRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftDataRequest.Builder, SdkPojo, CopyableBuilder<Builder, BatchExecuteStatementRequest> {
        /**
         * <p>
         * The cluster identifier. This parameter is required when authenticating using either Secrets Manager or
         * temporary credentials.
         * </p>
         * 
         * @param clusterIdentifier
         *        The cluster identifier. This parameter is required when authenticating using either Secrets Manager or
         *        temporary credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterIdentifier(String clusterIdentifier);

        /**
         * <p>
         * The name of the database. This parameter is required when authenticating using either Secrets Manager or
         * temporary credentials.
         * </p>
         * 
         * @param database
         *        The name of the database. This parameter is required when authenticating using either Secrets Manager
         *        or temporary credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder database(String database);

        /**
         * <p>
         * The database user name. This parameter is required when authenticating using temporary credentials.
         * </p>
         * 
         * @param dbUser
         *        The database user name. This parameter is required when authenticating using temporary credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbUser(String dbUser);

        /**
         * <p>
         * The name or ARN of the secret that enables access to the database. This parameter is required when
         * authenticating using Secrets Manager.
         * </p>
         * 
         * @param secretArn
         *        The name or ARN of the secret that enables access to the database. This parameter is required when
         *        authenticating using Secrets Manager.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretArn(String secretArn);

        /**
         * <p>
         * One or more SQL statements to run.
         * </p>
         * 
         * @param sqls
         *        One or more SQL statements to run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sqls(Collection<String> sqls);

        /**
         * <p>
         * One or more SQL statements to run.
         * </p>
         * 
         * @param sqls
         *        One or more SQL statements to run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sqls(String... sqls);

        /**
         * <p>
         * The name of the SQL statements. You can name the SQL statements when you create them to identify the query.
         * </p>
         * 
         * @param statementName
         *        The name of the SQL statements. You can name the SQL statements when you create them to identify the
         *        query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statementName(String statementName);

        /**
         * <p>
         * A value that indicates whether to send an event to the Amazon EventBridge event bus after the SQL statements
         * run.
         * </p>
         * 
         * @param withEvent
         *        A value that indicates whether to send an event to the Amazon EventBridge event bus after the SQL
         *        statements run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder withEvent(Boolean withEvent);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RedshiftDataRequest.BuilderImpl implements Builder {
        private String clusterIdentifier;

        private String database;

        private String dbUser;

        private String secretArn;

        private List<String> sqls = DefaultSdkAutoConstructList.getInstance();

        private String statementName;

        private Boolean withEvent;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchExecuteStatementRequest model) {
            super(model);
            clusterIdentifier(model.clusterIdentifier);
            database(model.database);
            dbUser(model.dbUser);
            secretArn(model.secretArn);
            sqls(model.sqls);
            statementName(model.statementName);
            withEvent(model.withEvent);
        }

        public final String getClusterIdentifier() {
            return clusterIdentifier;
        }

        public final void setClusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
        }

        @Override
        @Transient
        public final Builder clusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        public final String getDatabase() {
            return database;
        }

        public final void setDatabase(String database) {
            this.database = database;
        }

        @Override
        @Transient
        public final Builder database(String database) {
            this.database = database;
            return this;
        }

        public final String getDbUser() {
            return dbUser;
        }

        public final void setDbUser(String dbUser) {
            this.dbUser = dbUser;
        }

        @Override
        @Transient
        public final Builder dbUser(String dbUser) {
            this.dbUser = dbUser;
            return this;
        }

        public final String getSecretArn() {
            return secretArn;
        }

        public final void setSecretArn(String secretArn) {
            this.secretArn = secretArn;
        }

        @Override
        @Transient
        public final Builder secretArn(String secretArn) {
            this.secretArn = secretArn;
            return this;
        }

        public final Collection<String> getSqls() {
            if (sqls instanceof SdkAutoConstructList) {
                return null;
            }
            return sqls;
        }

        public final void setSqls(Collection<String> sqls) {
            this.sqls = SqlListCopier.copy(sqls);
        }

        @Override
        @Transient
        public final Builder sqls(Collection<String> sqls) {
            this.sqls = SqlListCopier.copy(sqls);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder sqls(String... sqls) {
            sqls(Arrays.asList(sqls));
            return this;
        }

        public final String getStatementName() {
            return statementName;
        }

        public final void setStatementName(String statementName) {
            this.statementName = statementName;
        }

        @Override
        @Transient
        public final Builder statementName(String statementName) {
            this.statementName = statementName;
            return this;
        }

        public final Boolean getWithEvent() {
            return withEvent;
        }

        public final void setWithEvent(Boolean withEvent) {
            this.withEvent = withEvent;
        }

        @Override
        @Transient
        public final Builder withEvent(Boolean withEvent) {
            this.withEvent = withEvent;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchExecuteStatementRequest build() {
            return new BatchExecuteStatementRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
