/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshiftdata.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListStatementsRequest extends RedshiftDataRequest implements
        ToCopyableBuilder<ListStatementsRequest.Builder, ListStatementsRequest> {
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListStatementsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListStatementsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Boolean> ROLE_LEVEL_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("RoleLevel").getter(getter(ListStatementsRequest::roleLevel)).setter(setter(Builder::roleLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleLevel").build()).build();

    private static final SdkField<String> STATEMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatementName").getter(getter(ListStatementsRequest::statementName))
            .setter(setter(Builder::statementName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatementName").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(ListStatementsRequest::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_RESULTS_FIELD,
            NEXT_TOKEN_FIELD, ROLE_LEVEL_FIELD, STATEMENT_NAME_FIELD, STATUS_FIELD));

    private final Integer maxResults;

    private final String nextToken;

    private final Boolean roleLevel;

    private final String statementName;

    private final String status;

    private ListStatementsRequest(BuilderImpl builder) {
        super(builder);
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.roleLevel = builder.roleLevel;
        this.statementName = builder.statementName;
        this.status = builder.status;
    }

    /**
     * <p>
     * The maximum number of SQL statements to return in the response. If more SQL statements exist than fit in one
     * response, then <code>NextToken</code> is returned to page through the results.
     * </p>
     * 
     * @return The maximum number of SQL statements to return in the response. If more SQL statements exist than fit in
     *         one response, then <code>NextToken</code> is returned to page through the results.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * A value that indicates the starting point for the next set of response records in a subsequent request. If a
     * value is returned in a response, you can retrieve the next set of records by providing this returned NextToken
     * value in the next NextToken parameter and retrying the command. If the NextToken field is empty, all response
     * records have been retrieved for the request.
     * </p>
     * 
     * @return A value that indicates the starting point for the next set of response records in a subsequent request.
     *         If a value is returned in a response, you can retrieve the next set of records by providing this returned
     *         NextToken value in the next NextToken parameter and retrying the command. If the NextToken field is
     *         empty, all response records have been retrieved for the request.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * A value that filters which statements to return in the response. If true, all statements run by the caller's IAM
     * role are returned. If false, only statements run by the caller's IAM role in the current IAM session are
     * returned. The default is true.
     * </p>
     * 
     * @return A value that filters which statements to return in the response. If true, all statements run by the
     *         caller's IAM role are returned. If false, only statements run by the caller's IAM role in the current IAM
     *         session are returned. The default is true.
     */
    public final Boolean roleLevel() {
        return roleLevel;
    }

    /**
     * <p>
     * The name of the SQL statement specified as input to <code>BatchExecuteStatement</code> or
     * <code>ExecuteStatement</code> to identify the query. You can list multiple statements by providing a prefix that
     * matches the beginning of the statement name. For example, to list myStatement1, myStatement2, myStatement3, and
     * so on, then provide the a value of <code>myStatement</code>. Data API does a case-sensitive match of SQL
     * statement names to the prefix value you provide.
     * </p>
     * 
     * @return The name of the SQL statement specified as input to <code>BatchExecuteStatement</code> or
     *         <code>ExecuteStatement</code> to identify the query. You can list multiple statements by providing a
     *         prefix that matches the beginning of the statement name. For example, to list myStatement1, myStatement2,
     *         myStatement3, and so on, then provide the a value of <code>myStatement</code>. Data API does a
     *         case-sensitive match of SQL statement names to the prefix value you provide.
     */
    public final String statementName() {
        return statementName;
    }

    /**
     * <p>
     * The status of the SQL statement to list. Status values are defined as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * ABORTED - The query run was stopped by the user.
     * </p>
     * </li>
     * <li>
     * <p>
     * ALL - A status value that includes all query statuses. This value can be used to filter results.
     * </p>
     * </li>
     * <li>
     * <p>
     * FAILED - The query run failed.
     * </p>
     * </li>
     * <li>
     * <p>
     * FINISHED - The query has finished running.
     * </p>
     * </li>
     * <li>
     * <p>
     * PICKED - The query has been chosen to be run.
     * </p>
     * </li>
     * <li>
     * <p>
     * STARTED - The query run has started.
     * </p>
     * </li>
     * <li>
     * <p>
     * SUBMITTED - The query was submitted, but not yet processed.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link StatusString#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the SQL statement to list. Status values are defined as follows: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         ABORTED - The query run was stopped by the user.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ALL - A status value that includes all query statuses. This value can be used to filter results.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         FAILED - The query run failed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         FINISHED - The query has finished running.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PICKED - The query has been chosen to be run.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         STARTED - The query run has started.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SUBMITTED - The query was submitted, but not yet processed.
     *         </p>
     *         </li>
     * @see StatusString
     */
    public final StatusString status() {
        return StatusString.fromValue(status);
    }

    /**
     * <p>
     * The status of the SQL statement to list. Status values are defined as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * ABORTED - The query run was stopped by the user.
     * </p>
     * </li>
     * <li>
     * <p>
     * ALL - A status value that includes all query statuses. This value can be used to filter results.
     * </p>
     * </li>
     * <li>
     * <p>
     * FAILED - The query run failed.
     * </p>
     * </li>
     * <li>
     * <p>
     * FINISHED - The query has finished running.
     * </p>
     * </li>
     * <li>
     * <p>
     * PICKED - The query has been chosen to be run.
     * </p>
     * </li>
     * <li>
     * <p>
     * STARTED - The query run has started.
     * </p>
     * </li>
     * <li>
     * <p>
     * SUBMITTED - The query was submitted, but not yet processed.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link StatusString#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the SQL statement to list. Status values are defined as follows: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         ABORTED - The query run was stopped by the user.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ALL - A status value that includes all query statuses. This value can be used to filter results.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         FAILED - The query run failed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         FINISHED - The query has finished running.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PICKED - The query has been chosen to be run.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         STARTED - The query run has started.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SUBMITTED - The query was submitted, but not yet processed.
     *         </p>
     *         </li>
     * @see StatusString
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(roleLevel());
        hashCode = 31 * hashCode + Objects.hashCode(statementName());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStatementsRequest)) {
            return false;
        }
        ListStatementsRequest other = (ListStatementsRequest) obj;
        return Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(roleLevel(), other.roleLevel()) && Objects.equals(statementName(), other.statementName())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListStatementsRequest").add("MaxResults", maxResults()).add("NextToken", nextToken())
                .add("RoleLevel", roleLevel()).add("StatementName", statementName()).add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "RoleLevel":
            return Optional.ofNullable(clazz.cast(roleLevel()));
        case "StatementName":
            return Optional.ofNullable(clazz.cast(statementName()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListStatementsRequest, T> g) {
        return obj -> g.apply((ListStatementsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftDataRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListStatementsRequest> {
        /**
         * <p>
         * The maximum number of SQL statements to return in the response. If more SQL statements exist than fit in one
         * response, then <code>NextToken</code> is returned to page through the results.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of SQL statements to return in the response. If more SQL statements exist than fit
         *        in one response, then <code>NextToken</code> is returned to page through the results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * A value that indicates the starting point for the next set of response records in a subsequent request. If a
         * value is returned in a response, you can retrieve the next set of records by providing this returned
         * NextToken value in the next NextToken parameter and retrying the command. If the NextToken field is empty,
         * all response records have been retrieved for the request.
         * </p>
         * 
         * @param nextToken
         *        A value that indicates the starting point for the next set of response records in a subsequent
         *        request. If a value is returned in a response, you can retrieve the next set of records by providing
         *        this returned NextToken value in the next NextToken parameter and retrying the command. If the
         *        NextToken field is empty, all response records have been retrieved for the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * A value that filters which statements to return in the response. If true, all statements run by the caller's
         * IAM role are returned. If false, only statements run by the caller's IAM role in the current IAM session are
         * returned. The default is true.
         * </p>
         * 
         * @param roleLevel
         *        A value that filters which statements to return in the response. If true, all statements run by the
         *        caller's IAM role are returned. If false, only statements run by the caller's IAM role in the current
         *        IAM session are returned. The default is true.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleLevel(Boolean roleLevel);

        /**
         * <p>
         * The name of the SQL statement specified as input to <code>BatchExecuteStatement</code> or
         * <code>ExecuteStatement</code> to identify the query. You can list multiple statements by providing a prefix
         * that matches the beginning of the statement name. For example, to list myStatement1, myStatement2,
         * myStatement3, and so on, then provide the a value of <code>myStatement</code>. Data API does a case-sensitive
         * match of SQL statement names to the prefix value you provide.
         * </p>
         * 
         * @param statementName
         *        The name of the SQL statement specified as input to <code>BatchExecuteStatement</code> or
         *        <code>ExecuteStatement</code> to identify the query. You can list multiple statements by providing a
         *        prefix that matches the beginning of the statement name. For example, to list myStatement1,
         *        myStatement2, myStatement3, and so on, then provide the a value of <code>myStatement</code>. Data API
         *        does a case-sensitive match of SQL statement names to the prefix value you provide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statementName(String statementName);

        /**
         * <p>
         * The status of the SQL statement to list. Status values are defined as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * ABORTED - The query run was stopped by the user.
         * </p>
         * </li>
         * <li>
         * <p>
         * ALL - A status value that includes all query statuses. This value can be used to filter results.
         * </p>
         * </li>
         * <li>
         * <p>
         * FAILED - The query run failed.
         * </p>
         * </li>
         * <li>
         * <p>
         * FINISHED - The query has finished running.
         * </p>
         * </li>
         * <li>
         * <p>
         * PICKED - The query has been chosen to be run.
         * </p>
         * </li>
         * <li>
         * <p>
         * STARTED - The query run has started.
         * </p>
         * </li>
         * <li>
         * <p>
         * SUBMITTED - The query was submitted, but not yet processed.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the SQL statement to list. Status values are defined as follows: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        ABORTED - The query run was stopped by the user.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ALL - A status value that includes all query statuses. This value can be used to filter results.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        FAILED - The query run failed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        FINISHED - The query has finished running.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PICKED - The query has been chosen to be run.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        STARTED - The query run has started.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SUBMITTED - The query was submitted, but not yet processed.
         *        </p>
         *        </li>
         * @see StatusString
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StatusString
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the SQL statement to list. Status values are defined as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * ABORTED - The query run was stopped by the user.
         * </p>
         * </li>
         * <li>
         * <p>
         * ALL - A status value that includes all query statuses. This value can be used to filter results.
         * </p>
         * </li>
         * <li>
         * <p>
         * FAILED - The query run failed.
         * </p>
         * </li>
         * <li>
         * <p>
         * FINISHED - The query has finished running.
         * </p>
         * </li>
         * <li>
         * <p>
         * PICKED - The query has been chosen to be run.
         * </p>
         * </li>
         * <li>
         * <p>
         * STARTED - The query run has started.
         * </p>
         * </li>
         * <li>
         * <p>
         * SUBMITTED - The query was submitted, but not yet processed.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the SQL statement to list. Status values are defined as follows: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        ABORTED - The query run was stopped by the user.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ALL - A status value that includes all query statuses. This value can be used to filter results.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        FAILED - The query run failed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        FINISHED - The query has finished running.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PICKED - The query has been chosen to be run.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        STARTED - The query run has started.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SUBMITTED - The query was submitted, but not yet processed.
         *        </p>
         *        </li>
         * @see StatusString
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StatusString
         */
        Builder status(StatusString status);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RedshiftDataRequest.BuilderImpl implements Builder {
        private Integer maxResults;

        private String nextToken;

        private Boolean roleLevel;

        private String statementName;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(ListStatementsRequest model) {
            super(model);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            roleLevel(model.roleLevel);
            statementName(model.statementName);
            status(model.status);
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        @Transient
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Boolean getRoleLevel() {
            return roleLevel;
        }

        public final void setRoleLevel(Boolean roleLevel) {
            this.roleLevel = roleLevel;
        }

        @Override
        @Transient
        public final Builder roleLevel(Boolean roleLevel) {
            this.roleLevel = roleLevel;
            return this;
        }

        public final String getStatementName() {
            return statementName;
        }

        public final void setStatementName(String statementName) {
            this.statementName = statementName;
        }

        @Override
        @Transient
        public final Builder statementName(String statementName) {
            this.statementName = statementName;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(StatusString status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListStatementsRequest build() {
            return new ListStatementsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
