/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshiftdata.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about an SQL statement.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SubStatementData implements SdkPojo, Serializable,
        ToCopyableBuilder<SubStatementData.Builder, SubStatementData> {
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt").getter(getter(SubStatementData::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final SdkField<Long> DURATION_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("Duration")
            .getter(getter(SubStatementData::duration)).setter(setter(Builder::duration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Duration").build()).build();

    private static final SdkField<String> ERROR_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Error")
            .getter(getter(SubStatementData::error)).setter(setter(Builder::error))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Error").build()).build();

    private static final SdkField<Boolean> HAS_RESULT_SET_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("HasResultSet").getter(getter(SubStatementData::hasResultSet)).setter(setter(Builder::hasResultSet))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HasResultSet").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(SubStatementData::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> QUERY_STRING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QueryString").getter(getter(SubStatementData::queryString)).setter(setter(Builder::queryString))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryString").build()).build();

    private static final SdkField<Long> REDSHIFT_QUERY_ID_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("RedshiftQueryId").getter(getter(SubStatementData::redshiftQueryId))
            .setter(setter(Builder::redshiftQueryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RedshiftQueryId").build()).build();

    private static final SdkField<Long> RESULT_ROWS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("ResultRows").getter(getter(SubStatementData::resultRows)).setter(setter(Builder::resultRows))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultRows").build()).build();

    private static final SdkField<Long> RESULT_SIZE_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("ResultSize").getter(getter(SubStatementData::resultSize)).setter(setter(Builder::resultSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultSize").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(SubStatementData::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("UpdatedAt").getter(getter(SubStatementData::updatedAt)).setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AT_FIELD,
            DURATION_FIELD, ERROR_FIELD, HAS_RESULT_SET_FIELD, ID_FIELD, QUERY_STRING_FIELD, REDSHIFT_QUERY_ID_FIELD,
            RESULT_ROWS_FIELD, RESULT_SIZE_FIELD, STATUS_FIELD, UPDATED_AT_FIELD));

    private static final long serialVersionUID = 1L;

    private final Instant createdAt;

    private final Long duration;

    private final String error;

    private final Boolean hasResultSet;

    private final String id;

    private final String queryString;

    private final Long redshiftQueryId;

    private final Long resultRows;

    private final Long resultSize;

    private final String status;

    private final Instant updatedAt;

    private SubStatementData(BuilderImpl builder) {
        this.createdAt = builder.createdAt;
        this.duration = builder.duration;
        this.error = builder.error;
        this.hasResultSet = builder.hasResultSet;
        this.id = builder.id;
        this.queryString = builder.queryString;
        this.redshiftQueryId = builder.redshiftQueryId;
        this.resultRows = builder.resultRows;
        this.resultSize = builder.resultSize;
        this.status = builder.status;
        this.updatedAt = builder.updatedAt;
    }

    /**
     * <p>
     * The date and time (UTC) the statement was created.
     * </p>
     * 
     * @return The date and time (UTC) the statement was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The amount of time in nanoseconds that the statement ran.
     * </p>
     * 
     * @return The amount of time in nanoseconds that the statement ran.
     */
    public final Long duration() {
        return duration;
    }

    /**
     * <p>
     * The error message from the cluster if the SQL statement encountered an error while running.
     * </p>
     * 
     * @return The error message from the cluster if the SQL statement encountered an error while running.
     */
    public final String error() {
        return error;
    }

    /**
     * <p>
     * A value that indicates whether the statement has a result set. The result set can be empty.
     * </p>
     * 
     * @return A value that indicates whether the statement has a result set. The result set can be empty.
     */
    public final Boolean hasResultSet() {
        return hasResultSet;
    }

    /**
     * <p>
     * The identifier of the SQL statement. This value is a universally unique identifier (UUID) generated by Amazon
     * Redshift Data API. A suffix indicates the number of the SQL statement. For example,
     * <code>d9b6c0c9-0747-4bf4-b142-e8883122f766:2</code> has a suffix of <code>:2</code> that indicates the second SQL
     * statement of a batch query.
     * </p>
     * 
     * @return The identifier of the SQL statement. This value is a universally unique identifier (UUID) generated by
     *         Amazon Redshift Data API. A suffix indicates the number of the SQL statement. For example,
     *         <code>d9b6c0c9-0747-4bf4-b142-e8883122f766:2</code> has a suffix of <code>:2</code> that indicates the
     *         second SQL statement of a batch query.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The SQL statement text.
     * </p>
     * 
     * @return The SQL statement text.
     */
    public final String queryString() {
        return queryString;
    }

    /**
     * <p>
     * The SQL statement identifier. This value is a universally unique identifier (UUID) generated by Amazon Redshift
     * Data API.
     * </p>
     * 
     * @return The SQL statement identifier. This value is a universally unique identifier (UUID) generated by Amazon
     *         Redshift Data API.
     */
    public final Long redshiftQueryId() {
        return redshiftQueryId;
    }

    /**
     * <p>
     * Either the number of rows returned from the SQL statement or the number of rows affected. If result size is
     * greater than zero, the result rows can be the number of rows affected by SQL statements such as INSERT, UPDATE,
     * DELETE, COPY, and others. A <code>-1</code> indicates the value is null.
     * </p>
     * 
     * @return Either the number of rows returned from the SQL statement or the number of rows affected. If result size
     *         is greater than zero, the result rows can be the number of rows affected by SQL statements such as
     *         INSERT, UPDATE, DELETE, COPY, and others. A <code>-1</code> indicates the value is null.
     */
    public final Long resultRows() {
        return resultRows;
    }

    /**
     * <p>
     * The size in bytes of the returned results. A <code>-1</code> indicates the value is null.
     * </p>
     * 
     * @return The size in bytes of the returned results. A <code>-1</code> indicates the value is null.
     */
    public final Long resultSize() {
        return resultSize;
    }

    /**
     * <p>
     * The status of the SQL statement. An example is the that the SQL statement finished.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link StatementStatusString#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the SQL statement. An example is the that the SQL statement finished.
     * @see StatementStatusString
     */
    public final StatementStatusString status() {
        return StatementStatusString.fromValue(status);
    }

    /**
     * <p>
     * The status of the SQL statement. An example is the that the SQL statement finished.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link StatementStatusString#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the SQL statement. An example is the that the SQL statement finished.
     * @see StatementStatusString
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The date and time (UTC) that the statement metadata was last updated.
     * </p>
     * 
     * @return The date and time (UTC) that the statement metadata was last updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(duration());
        hashCode = 31 * hashCode + Objects.hashCode(error());
        hashCode = 31 * hashCode + Objects.hashCode(hasResultSet());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(queryString());
        hashCode = 31 * hashCode + Objects.hashCode(redshiftQueryId());
        hashCode = 31 * hashCode + Objects.hashCode(resultRows());
        hashCode = 31 * hashCode + Objects.hashCode(resultSize());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubStatementData)) {
            return false;
        }
        SubStatementData other = (SubStatementData) obj;
        return Objects.equals(createdAt(), other.createdAt()) && Objects.equals(duration(), other.duration())
                && Objects.equals(error(), other.error()) && Objects.equals(hasResultSet(), other.hasResultSet())
                && Objects.equals(id(), other.id()) && Objects.equals(queryString(), other.queryString())
                && Objects.equals(redshiftQueryId(), other.redshiftQueryId()) && Objects.equals(resultRows(), other.resultRows())
                && Objects.equals(resultSize(), other.resultSize()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(updatedAt(), other.updatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SubStatementData").add("CreatedAt", createdAt()).add("Duration", duration())
                .add("Error", error()).add("HasResultSet", hasResultSet()).add("Id", id()).add("QueryString", queryString())
                .add("RedshiftQueryId", redshiftQueryId()).add("ResultRows", resultRows()).add("ResultSize", resultSize())
                .add("Status", statusAsString()).add("UpdatedAt", updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "Duration":
            return Optional.ofNullable(clazz.cast(duration()));
        case "Error":
            return Optional.ofNullable(clazz.cast(error()));
        case "HasResultSet":
            return Optional.ofNullable(clazz.cast(hasResultSet()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "QueryString":
            return Optional.ofNullable(clazz.cast(queryString()));
        case "RedshiftQueryId":
            return Optional.ofNullable(clazz.cast(redshiftQueryId()));
        case "ResultRows":
            return Optional.ofNullable(clazz.cast(resultRows()));
        case "ResultSize":
            return Optional.ofNullable(clazz.cast(resultSize()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "UpdatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SubStatementData, T> g) {
        return obj -> g.apply((SubStatementData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SubStatementData> {
        /**
         * <p>
         * The date and time (UTC) the statement was created.
         * </p>
         * 
         * @param createdAt
         *        The date and time (UTC) the statement was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The amount of time in nanoseconds that the statement ran.
         * </p>
         * 
         * @param duration
         *        The amount of time in nanoseconds that the statement ran.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder duration(Long duration);

        /**
         * <p>
         * The error message from the cluster if the SQL statement encountered an error while running.
         * </p>
         * 
         * @param error
         *        The error message from the cluster if the SQL statement encountered an error while running.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder error(String error);

        /**
         * <p>
         * A value that indicates whether the statement has a result set. The result set can be empty.
         * </p>
         * 
         * @param hasResultSet
         *        A value that indicates whether the statement has a result set. The result set can be empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hasResultSet(Boolean hasResultSet);

        /**
         * <p>
         * The identifier of the SQL statement. This value is a universally unique identifier (UUID) generated by Amazon
         * Redshift Data API. A suffix indicates the number of the SQL statement. For example,
         * <code>d9b6c0c9-0747-4bf4-b142-e8883122f766:2</code> has a suffix of <code>:2</code> that indicates the second
         * SQL statement of a batch query.
         * </p>
         * 
         * @param id
         *        The identifier of the SQL statement. This value is a universally unique identifier (UUID) generated by
         *        Amazon Redshift Data API. A suffix indicates the number of the SQL statement. For example,
         *        <code>d9b6c0c9-0747-4bf4-b142-e8883122f766:2</code> has a suffix of <code>:2</code> that indicates the
         *        second SQL statement of a batch query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The SQL statement text.
         * </p>
         * 
         * @param queryString
         *        The SQL statement text.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryString(String queryString);

        /**
         * <p>
         * The SQL statement identifier. This value is a universally unique identifier (UUID) generated by Amazon
         * Redshift Data API.
         * </p>
         * 
         * @param redshiftQueryId
         *        The SQL statement identifier. This value is a universally unique identifier (UUID) generated by Amazon
         *        Redshift Data API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder redshiftQueryId(Long redshiftQueryId);

        /**
         * <p>
         * Either the number of rows returned from the SQL statement or the number of rows affected. If result size is
         * greater than zero, the result rows can be the number of rows affected by SQL statements such as INSERT,
         * UPDATE, DELETE, COPY, and others. A <code>-1</code> indicates the value is null.
         * </p>
         * 
         * @param resultRows
         *        Either the number of rows returned from the SQL statement or the number of rows affected. If result
         *        size is greater than zero, the result rows can be the number of rows affected by SQL statements such
         *        as INSERT, UPDATE, DELETE, COPY, and others. A <code>-1</code> indicates the value is null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resultRows(Long resultRows);

        /**
         * <p>
         * The size in bytes of the returned results. A <code>-1</code> indicates the value is null.
         * </p>
         * 
         * @param resultSize
         *        The size in bytes of the returned results. A <code>-1</code> indicates the value is null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resultSize(Long resultSize);

        /**
         * <p>
         * The status of the SQL statement. An example is the that the SQL statement finished.
         * </p>
         * 
         * @param status
         *        The status of the SQL statement. An example is the that the SQL statement finished.
         * @see StatementStatusString
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StatementStatusString
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the SQL statement. An example is the that the SQL statement finished.
         * </p>
         * 
         * @param status
         *        The status of the SQL statement. An example is the that the SQL statement finished.
         * @see StatementStatusString
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StatementStatusString
         */
        Builder status(StatementStatusString status);

        /**
         * <p>
         * The date and time (UTC) that the statement metadata was last updated.
         * </p>
         * 
         * @param updatedAt
         *        The date and time (UTC) that the statement metadata was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);
    }

    static final class BuilderImpl implements Builder {
        private Instant createdAt;

        private Long duration;

        private String error;

        private Boolean hasResultSet;

        private String id;

        private String queryString;

        private Long redshiftQueryId;

        private Long resultRows;

        private Long resultSize;

        private String status;

        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(SubStatementData model) {
            createdAt(model.createdAt);
            duration(model.duration);
            error(model.error);
            hasResultSet(model.hasResultSet);
            id(model.id);
            queryString(model.queryString);
            redshiftQueryId(model.redshiftQueryId);
            resultRows(model.resultRows);
            resultSize(model.resultSize);
            status(model.status);
            updatedAt(model.updatedAt);
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        @Transient
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Long getDuration() {
            return duration;
        }

        public final void setDuration(Long duration) {
            this.duration = duration;
        }

        @Override
        @Transient
        public final Builder duration(Long duration) {
            this.duration = duration;
            return this;
        }

        public final String getError() {
            return error;
        }

        public final void setError(String error) {
            this.error = error;
        }

        @Override
        @Transient
        public final Builder error(String error) {
            this.error = error;
            return this;
        }

        public final Boolean getHasResultSet() {
            return hasResultSet;
        }

        public final void setHasResultSet(Boolean hasResultSet) {
            this.hasResultSet = hasResultSet;
        }

        @Override
        @Transient
        public final Builder hasResultSet(Boolean hasResultSet) {
            this.hasResultSet = hasResultSet;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        @Transient
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getQueryString() {
            return queryString;
        }

        public final void setQueryString(String queryString) {
            this.queryString = queryString;
        }

        @Override
        @Transient
        public final Builder queryString(String queryString) {
            this.queryString = queryString;
            return this;
        }

        public final Long getRedshiftQueryId() {
            return redshiftQueryId;
        }

        public final void setRedshiftQueryId(Long redshiftQueryId) {
            this.redshiftQueryId = redshiftQueryId;
        }

        @Override
        @Transient
        public final Builder redshiftQueryId(Long redshiftQueryId) {
            this.redshiftQueryId = redshiftQueryId;
            return this;
        }

        public final Long getResultRows() {
            return resultRows;
        }

        public final void setResultRows(Long resultRows) {
            this.resultRows = resultRows;
        }

        @Override
        @Transient
        public final Builder resultRows(Long resultRows) {
            this.resultRows = resultRows;
            return this;
        }

        public final Long getResultSize() {
            return resultSize;
        }

        public final void setResultSize(Long resultSize) {
            this.resultSize = resultSize;
        }

        @Override
        @Transient
        public final Builder resultSize(Long resultSize) {
            this.resultSize = resultSize;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(StatementStatusString status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        @Transient
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public SubStatementData build() {
            return new SubStatementData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
