/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshiftdata.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeStatementResponse extends RedshiftDataResponse implements
        ToCopyableBuilder<DescribeStatementResponse.Builder, DescribeStatementResponse> {
    private static final SdkField<String> CLUSTER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterIdentifier").getter(getter(DescribeStatementResponse::clusterIdentifier))
            .setter(setter(Builder::clusterIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterIdentifier").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt").getter(getter(DescribeStatementResponse::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final SdkField<String> DATABASE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Database").getter(getter(DescribeStatementResponse::database)).setter(setter(Builder::database))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Database").build()).build();

    private static final SdkField<String> DB_USER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("DbUser")
            .getter(getter(DescribeStatementResponse::dbUser)).setter(setter(Builder::dbUser))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DbUser").build()).build();

    private static final SdkField<Long> DURATION_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("Duration")
            .getter(getter(DescribeStatementResponse::duration)).setter(setter(Builder::duration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Duration").build()).build();

    private static final SdkField<String> ERROR_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Error")
            .getter(getter(DescribeStatementResponse::error)).setter(setter(Builder::error))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Error").build()).build();

    private static final SdkField<Boolean> HAS_RESULT_SET_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("HasResultSet").getter(getter(DescribeStatementResponse::hasResultSet))
            .setter(setter(Builder::hasResultSet))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HasResultSet").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(DescribeStatementResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<List<SqlParameter>> QUERY_PARAMETERS_FIELD = SdkField
            .<List<SqlParameter>> builder(MarshallingType.LIST)
            .memberName("QueryParameters")
            .getter(getter(DescribeStatementResponse::queryParameters))
            .setter(setter(Builder::queryParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryParameters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SqlParameter> builder(MarshallingType.SDK_POJO)
                                            .constructor(SqlParameter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> QUERY_STRING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QueryString").getter(getter(DescribeStatementResponse::queryString))
            .setter(setter(Builder::queryString))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryString").build()).build();

    private static final SdkField<Long> REDSHIFT_PID_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("RedshiftPid").getter(getter(DescribeStatementResponse::redshiftPid))
            .setter(setter(Builder::redshiftPid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RedshiftPid").build()).build();

    private static final SdkField<Long> REDSHIFT_QUERY_ID_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("RedshiftQueryId").getter(getter(DescribeStatementResponse::redshiftQueryId))
            .setter(setter(Builder::redshiftQueryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RedshiftQueryId").build()).build();

    private static final SdkField<Long> RESULT_ROWS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("ResultRows").getter(getter(DescribeStatementResponse::resultRows)).setter(setter(Builder::resultRows))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultRows").build()).build();

    private static final SdkField<Long> RESULT_SIZE_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("ResultSize").getter(getter(DescribeStatementResponse::resultSize)).setter(setter(Builder::resultSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultSize").build()).build();

    private static final SdkField<String> SECRET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SecretArn").getter(getter(DescribeStatementResponse::secretArn)).setter(setter(Builder::secretArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretArn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(DescribeStatementResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<List<SubStatementData>> SUB_STATEMENTS_FIELD = SdkField
            .<List<SubStatementData>> builder(MarshallingType.LIST)
            .memberName("SubStatements")
            .getter(getter(DescribeStatementResponse::subStatements))
            .setter(setter(Builder::subStatements))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubStatements").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SubStatementData> builder(MarshallingType.SDK_POJO)
                                            .constructor(SubStatementData::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("UpdatedAt").getter(getter(DescribeStatementResponse::updatedAt)).setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build()).build();

    private static final SdkField<String> WORKGROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkgroupName").getter(getter(DescribeStatementResponse::workgroupName))
            .setter(setter(Builder::workgroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkgroupName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_IDENTIFIER_FIELD,
            CREATED_AT_FIELD, DATABASE_FIELD, DB_USER_FIELD, DURATION_FIELD, ERROR_FIELD, HAS_RESULT_SET_FIELD, ID_FIELD,
            QUERY_PARAMETERS_FIELD, QUERY_STRING_FIELD, REDSHIFT_PID_FIELD, REDSHIFT_QUERY_ID_FIELD, RESULT_ROWS_FIELD,
            RESULT_SIZE_FIELD, SECRET_ARN_FIELD, STATUS_FIELD, SUB_STATEMENTS_FIELD, UPDATED_AT_FIELD, WORKGROUP_NAME_FIELD));

    private final String clusterIdentifier;

    private final Instant createdAt;

    private final String database;

    private final String dbUser;

    private final Long duration;

    private final String error;

    private final Boolean hasResultSet;

    private final String id;

    private final List<SqlParameter> queryParameters;

    private final String queryString;

    private final Long redshiftPid;

    private final Long redshiftQueryId;

    private final Long resultRows;

    private final Long resultSize;

    private final String secretArn;

    private final String status;

    private final List<SubStatementData> subStatements;

    private final Instant updatedAt;

    private final String workgroupName;

    private DescribeStatementResponse(BuilderImpl builder) {
        super(builder);
        this.clusterIdentifier = builder.clusterIdentifier;
        this.createdAt = builder.createdAt;
        this.database = builder.database;
        this.dbUser = builder.dbUser;
        this.duration = builder.duration;
        this.error = builder.error;
        this.hasResultSet = builder.hasResultSet;
        this.id = builder.id;
        this.queryParameters = builder.queryParameters;
        this.queryString = builder.queryString;
        this.redshiftPid = builder.redshiftPid;
        this.redshiftQueryId = builder.redshiftQueryId;
        this.resultRows = builder.resultRows;
        this.resultSize = builder.resultSize;
        this.secretArn = builder.secretArn;
        this.status = builder.status;
        this.subStatements = builder.subStatements;
        this.updatedAt = builder.updatedAt;
        this.workgroupName = builder.workgroupName;
    }

    /**
     * <p>
     * The cluster identifier.
     * </p>
     * 
     * @return The cluster identifier.
     */
    public final String clusterIdentifier() {
        return clusterIdentifier;
    }

    /**
     * <p>
     * The date and time (UTC) when the SQL statement was submitted to run.
     * </p>
     * 
     * @return The date and time (UTC) when the SQL statement was submitted to run.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The name of the database.
     * </p>
     * 
     * @return The name of the database.
     */
    public final String database() {
        return database;
    }

    /**
     * <p>
     * The database user name.
     * </p>
     * 
     * @return The database user name.
     */
    public final String dbUser() {
        return dbUser;
    }

    /**
     * <p>
     * The amount of time in nanoseconds that the statement ran.
     * </p>
     * 
     * @return The amount of time in nanoseconds that the statement ran.
     */
    public final Long duration() {
        return duration;
    }

    /**
     * <p>
     * The error message from the cluster if the SQL statement encountered an error while running.
     * </p>
     * 
     * @return The error message from the cluster if the SQL statement encountered an error while running.
     */
    public final String error() {
        return error;
    }

    /**
     * <p>
     * A value that indicates whether the statement has a result set. The result set can be empty. The value is true for
     * an empty result set. The value is true if any substatement returns a result set.
     * </p>
     * 
     * @return A value that indicates whether the statement has a result set. The result set can be empty. The value is
     *         true for an empty result set. The value is true if any substatement returns a result set.
     */
    public final Boolean hasResultSet() {
        return hasResultSet;
    }

    /**
     * <p>
     * The identifier of the SQL statement described. This value is a universally unique identifier (UUID) generated by
     * Amazon Redshift Data API.
     * </p>
     * 
     * @return The identifier of the SQL statement described. This value is a universally unique identifier (UUID)
     *         generated by Amazon Redshift Data API.
     */
    public final String id() {
        return id;
    }

    /**
     * For responses, this returns true if the service returned a value for the QueryParameters property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasQueryParameters() {
        return queryParameters != null && !(queryParameters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The parameters for the SQL statement.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasQueryParameters} method.
     * </p>
     * 
     * @return The parameters for the SQL statement.
     */
    public final List<SqlParameter> queryParameters() {
        return queryParameters;
    }

    /**
     * <p>
     * The SQL statement text.
     * </p>
     * 
     * @return The SQL statement text.
     */
    public final String queryString() {
        return queryString;
    }

    /**
     * <p>
     * The process identifier from Amazon Redshift.
     * </p>
     * 
     * @return The process identifier from Amazon Redshift.
     */
    public final Long redshiftPid() {
        return redshiftPid;
    }

    /**
     * <p>
     * The identifier of the query generated by Amazon Redshift. These identifiers are also available in the
     * <code>query</code> column of the <code>STL_QUERY</code> system view.
     * </p>
     * 
     * @return The identifier of the query generated by Amazon Redshift. These identifiers are also available in the
     *         <code>query</code> column of the <code>STL_QUERY</code> system view.
     */
    public final Long redshiftQueryId() {
        return redshiftQueryId;
    }

    /**
     * <p>
     * Either the number of rows returned from the SQL statement or the number of rows affected. If result size is
     * greater than zero, the result rows can be the number of rows affected by SQL statements such as INSERT, UPDATE,
     * DELETE, COPY, and others. A <code>-1</code> indicates the value is null.
     * </p>
     * 
     * @return Either the number of rows returned from the SQL statement or the number of rows affected. If result size
     *         is greater than zero, the result rows can be the number of rows affected by SQL statements such as
     *         INSERT, UPDATE, DELETE, COPY, and others. A <code>-1</code> indicates the value is null.
     */
    public final Long resultRows() {
        return resultRows;
    }

    /**
     * <p>
     * The size in bytes of the returned results. A <code>-1</code> indicates the value is null.
     * </p>
     * 
     * @return The size in bytes of the returned results. A <code>-1</code> indicates the value is null.
     */
    public final Long resultSize() {
        return resultSize;
    }

    /**
     * <p>
     * The name or Amazon Resource Name (ARN) of the secret that enables access to the database.
     * </p>
     * 
     * @return The name or Amazon Resource Name (ARN) of the secret that enables access to the database.
     */
    public final String secretArn() {
        return secretArn;
    }

    /**
     * <p>
     * The status of the SQL statement being described. Status values are defined as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * ABORTED - The query run was stopped by the user.
     * </p>
     * </li>
     * <li>
     * <p>
     * ALL - A status value that includes all query statuses. This value can be used to filter results.
     * </p>
     * </li>
     * <li>
     * <p>
     * FAILED - The query run failed.
     * </p>
     * </li>
     * <li>
     * <p>
     * FINISHED - The query has finished running.
     * </p>
     * </li>
     * <li>
     * <p>
     * PICKED - The query has been chosen to be run.
     * </p>
     * </li>
     * <li>
     * <p>
     * STARTED - The query run has started.
     * </p>
     * </li>
     * <li>
     * <p>
     * SUBMITTED - The query was submitted, but not yet processed.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link StatusString#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the SQL statement being described. Status values are defined as follows: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         ABORTED - The query run was stopped by the user.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ALL - A status value that includes all query statuses. This value can be used to filter results.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         FAILED - The query run failed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         FINISHED - The query has finished running.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PICKED - The query has been chosen to be run.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         STARTED - The query run has started.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SUBMITTED - The query was submitted, but not yet processed.
     *         </p>
     *         </li>
     * @see StatusString
     */
    public final StatusString status() {
        return StatusString.fromValue(status);
    }

    /**
     * <p>
     * The status of the SQL statement being described. Status values are defined as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * ABORTED - The query run was stopped by the user.
     * </p>
     * </li>
     * <li>
     * <p>
     * ALL - A status value that includes all query statuses. This value can be used to filter results.
     * </p>
     * </li>
     * <li>
     * <p>
     * FAILED - The query run failed.
     * </p>
     * </li>
     * <li>
     * <p>
     * FINISHED - The query has finished running.
     * </p>
     * </li>
     * <li>
     * <p>
     * PICKED - The query has been chosen to be run.
     * </p>
     * </li>
     * <li>
     * <p>
     * STARTED - The query run has started.
     * </p>
     * </li>
     * <li>
     * <p>
     * SUBMITTED - The query was submitted, but not yet processed.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link StatusString#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the SQL statement being described. Status values are defined as follows: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         ABORTED - The query run was stopped by the user.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         ALL - A status value that includes all query statuses. This value can be used to filter results.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         FAILED - The query run failed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         FINISHED - The query has finished running.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PICKED - The query has been chosen to be run.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         STARTED - The query run has started.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SUBMITTED - The query was submitted, but not yet processed.
     *         </p>
     *         </li>
     * @see StatusString
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * For responses, this returns true if the service returned a value for the SubStatements property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSubStatements() {
        return subStatements != null && !(subStatements instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The SQL statements from a multiple statement run.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubStatements} method.
     * </p>
     * 
     * @return The SQL statements from a multiple statement run.
     */
    public final List<SubStatementData> subStatements() {
        return subStatements;
    }

    /**
     * <p>
     * The date and time (UTC) that the metadata for the SQL statement was last updated. An example is the time the
     * status last changed.
     * </p>
     * 
     * @return The date and time (UTC) that the metadata for the SQL statement was last updated. An example is the time
     *         the status last changed.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * <p>
     * The serverless workgroup name.
     * </p>
     * 
     * @return The serverless workgroup name.
     */
    public final String workgroupName() {
        return workgroupName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(database());
        hashCode = 31 * hashCode + Objects.hashCode(dbUser());
        hashCode = 31 * hashCode + Objects.hashCode(duration());
        hashCode = 31 * hashCode + Objects.hashCode(error());
        hashCode = 31 * hashCode + Objects.hashCode(hasResultSet());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(hasQueryParameters() ? queryParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(queryString());
        hashCode = 31 * hashCode + Objects.hashCode(redshiftPid());
        hashCode = 31 * hashCode + Objects.hashCode(redshiftQueryId());
        hashCode = 31 * hashCode + Objects.hashCode(resultRows());
        hashCode = 31 * hashCode + Objects.hashCode(resultSize());
        hashCode = 31 * hashCode + Objects.hashCode(secretArn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasSubStatements() ? subStatements() : null);
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(workgroupName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStatementResponse)) {
            return false;
        }
        DescribeStatementResponse other = (DescribeStatementResponse) obj;
        return Objects.equals(clusterIdentifier(), other.clusterIdentifier()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(database(), other.database()) && Objects.equals(dbUser(), other.dbUser())
                && Objects.equals(duration(), other.duration()) && Objects.equals(error(), other.error())
                && Objects.equals(hasResultSet(), other.hasResultSet()) && Objects.equals(id(), other.id())
                && hasQueryParameters() == other.hasQueryParameters()
                && Objects.equals(queryParameters(), other.queryParameters())
                && Objects.equals(queryString(), other.queryString()) && Objects.equals(redshiftPid(), other.redshiftPid())
                && Objects.equals(redshiftQueryId(), other.redshiftQueryId()) && Objects.equals(resultRows(), other.resultRows())
                && Objects.equals(resultSize(), other.resultSize()) && Objects.equals(secretArn(), other.secretArn())
                && Objects.equals(statusAsString(), other.statusAsString()) && hasSubStatements() == other.hasSubStatements()
                && Objects.equals(subStatements(), other.subStatements()) && Objects.equals(updatedAt(), other.updatedAt())
                && Objects.equals(workgroupName(), other.workgroupName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeStatementResponse").add("ClusterIdentifier", clusterIdentifier())
                .add("CreatedAt", createdAt()).add("Database", database()).add("DbUser", dbUser()).add("Duration", duration())
                .add("Error", error()).add("HasResultSet", hasResultSet()).add("Id", id())
                .add("QueryParameters", hasQueryParameters() ? queryParameters() : null).add("QueryString", queryString())
                .add("RedshiftPid", redshiftPid()).add("RedshiftQueryId", redshiftQueryId()).add("ResultRows", resultRows())
                .add("ResultSize", resultSize()).add("SecretArn", secretArn()).add("Status", statusAsString())
                .add("SubStatements", hasSubStatements() ? subStatements() : null).add("UpdatedAt", updatedAt())
                .add("WorkgroupName", workgroupName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClusterIdentifier":
            return Optional.ofNullable(clazz.cast(clusterIdentifier()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "Database":
            return Optional.ofNullable(clazz.cast(database()));
        case "DbUser":
            return Optional.ofNullable(clazz.cast(dbUser()));
        case "Duration":
            return Optional.ofNullable(clazz.cast(duration()));
        case "Error":
            return Optional.ofNullable(clazz.cast(error()));
        case "HasResultSet":
            return Optional.ofNullable(clazz.cast(hasResultSet()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "QueryParameters":
            return Optional.ofNullable(clazz.cast(queryParameters()));
        case "QueryString":
            return Optional.ofNullable(clazz.cast(queryString()));
        case "RedshiftPid":
            return Optional.ofNullable(clazz.cast(redshiftPid()));
        case "RedshiftQueryId":
            return Optional.ofNullable(clazz.cast(redshiftQueryId()));
        case "ResultRows":
            return Optional.ofNullable(clazz.cast(resultRows()));
        case "ResultSize":
            return Optional.ofNullable(clazz.cast(resultSize()));
        case "SecretArn":
            return Optional.ofNullable(clazz.cast(secretArn()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "SubStatements":
            return Optional.ofNullable(clazz.cast(subStatements()));
        case "UpdatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "WorkgroupName":
            return Optional.ofNullable(clazz.cast(workgroupName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeStatementResponse, T> g) {
        return obj -> g.apply((DescribeStatementResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftDataResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeStatementResponse> {
        /**
         * <p>
         * The cluster identifier.
         * </p>
         * 
         * @param clusterIdentifier
         *        The cluster identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterIdentifier(String clusterIdentifier);

        /**
         * <p>
         * The date and time (UTC) when the SQL statement was submitted to run.
         * </p>
         * 
         * @param createdAt
         *        The date and time (UTC) when the SQL statement was submitted to run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The name of the database.
         * </p>
         * 
         * @param database
         *        The name of the database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder database(String database);

        /**
         * <p>
         * The database user name.
         * </p>
         * 
         * @param dbUser
         *        The database user name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbUser(String dbUser);

        /**
         * <p>
         * The amount of time in nanoseconds that the statement ran.
         * </p>
         * 
         * @param duration
         *        The amount of time in nanoseconds that the statement ran.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder duration(Long duration);

        /**
         * <p>
         * The error message from the cluster if the SQL statement encountered an error while running.
         * </p>
         * 
         * @param error
         *        The error message from the cluster if the SQL statement encountered an error while running.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder error(String error);

        /**
         * <p>
         * A value that indicates whether the statement has a result set. The result set can be empty. The value is true
         * for an empty result set. The value is true if any substatement returns a result set.
         * </p>
         * 
         * @param hasResultSet
         *        A value that indicates whether the statement has a result set. The result set can be empty. The value
         *        is true for an empty result set. The value is true if any substatement returns a result set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hasResultSet(Boolean hasResultSet);

        /**
         * <p>
         * The identifier of the SQL statement described. This value is a universally unique identifier (UUID) generated
         * by Amazon Redshift Data API.
         * </p>
         * 
         * @param id
         *        The identifier of the SQL statement described. This value is a universally unique identifier (UUID)
         *        generated by Amazon Redshift Data API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The parameters for the SQL statement.
         * </p>
         * 
         * @param queryParameters
         *        The parameters for the SQL statement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryParameters(Collection<SqlParameter> queryParameters);

        /**
         * <p>
         * The parameters for the SQL statement.
         * </p>
         * 
         * @param queryParameters
         *        The parameters for the SQL statement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryParameters(SqlParameter... queryParameters);

        /**
         * <p>
         * The parameters for the SQL statement.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.redshiftdata.model.SqlParameter.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.redshiftdata.model.SqlParameter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.redshiftdata.model.SqlParameter.Builder#build()} is called immediately
         * and its result is passed to {@link #queryParameters(List<SqlParameter>)}.
         * 
         * @param queryParameters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.redshiftdata.model.SqlParameter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #queryParameters(java.util.Collection<SqlParameter>)
         */
        Builder queryParameters(Consumer<SqlParameter.Builder>... queryParameters);

        /**
         * <p>
         * The SQL statement text.
         * </p>
         * 
         * @param queryString
         *        The SQL statement text.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryString(String queryString);

        /**
         * <p>
         * The process identifier from Amazon Redshift.
         * </p>
         * 
         * @param redshiftPid
         *        The process identifier from Amazon Redshift.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder redshiftPid(Long redshiftPid);

        /**
         * <p>
         * The identifier of the query generated by Amazon Redshift. These identifiers are also available in the
         * <code>query</code> column of the <code>STL_QUERY</code> system view.
         * </p>
         * 
         * @param redshiftQueryId
         *        The identifier of the query generated by Amazon Redshift. These identifiers are also available in the
         *        <code>query</code> column of the <code>STL_QUERY</code> system view.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder redshiftQueryId(Long redshiftQueryId);

        /**
         * <p>
         * Either the number of rows returned from the SQL statement or the number of rows affected. If result size is
         * greater than zero, the result rows can be the number of rows affected by SQL statements such as INSERT,
         * UPDATE, DELETE, COPY, and others. A <code>-1</code> indicates the value is null.
         * </p>
         * 
         * @param resultRows
         *        Either the number of rows returned from the SQL statement or the number of rows affected. If result
         *        size is greater than zero, the result rows can be the number of rows affected by SQL statements such
         *        as INSERT, UPDATE, DELETE, COPY, and others. A <code>-1</code> indicates the value is null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resultRows(Long resultRows);

        /**
         * <p>
         * The size in bytes of the returned results. A <code>-1</code> indicates the value is null.
         * </p>
         * 
         * @param resultSize
         *        The size in bytes of the returned results. A <code>-1</code> indicates the value is null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resultSize(Long resultSize);

        /**
         * <p>
         * The name or Amazon Resource Name (ARN) of the secret that enables access to the database.
         * </p>
         * 
         * @param secretArn
         *        The name or Amazon Resource Name (ARN) of the secret that enables access to the database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretArn(String secretArn);

        /**
         * <p>
         * The status of the SQL statement being described. Status values are defined as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * ABORTED - The query run was stopped by the user.
         * </p>
         * </li>
         * <li>
         * <p>
         * ALL - A status value that includes all query statuses. This value can be used to filter results.
         * </p>
         * </li>
         * <li>
         * <p>
         * FAILED - The query run failed.
         * </p>
         * </li>
         * <li>
         * <p>
         * FINISHED - The query has finished running.
         * </p>
         * </li>
         * <li>
         * <p>
         * PICKED - The query has been chosen to be run.
         * </p>
         * </li>
         * <li>
         * <p>
         * STARTED - The query run has started.
         * </p>
         * </li>
         * <li>
         * <p>
         * SUBMITTED - The query was submitted, but not yet processed.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the SQL statement being described. Status values are defined as follows: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        ABORTED - The query run was stopped by the user.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ALL - A status value that includes all query statuses. This value can be used to filter results.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        FAILED - The query run failed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        FINISHED - The query has finished running.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PICKED - The query has been chosen to be run.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        STARTED - The query run has started.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SUBMITTED - The query was submitted, but not yet processed.
         *        </p>
         *        </li>
         * @see StatusString
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StatusString
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the SQL statement being described. Status values are defined as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * ABORTED - The query run was stopped by the user.
         * </p>
         * </li>
         * <li>
         * <p>
         * ALL - A status value that includes all query statuses. This value can be used to filter results.
         * </p>
         * </li>
         * <li>
         * <p>
         * FAILED - The query run failed.
         * </p>
         * </li>
         * <li>
         * <p>
         * FINISHED - The query has finished running.
         * </p>
         * </li>
         * <li>
         * <p>
         * PICKED - The query has been chosen to be run.
         * </p>
         * </li>
         * <li>
         * <p>
         * STARTED - The query run has started.
         * </p>
         * </li>
         * <li>
         * <p>
         * SUBMITTED - The query was submitted, but not yet processed.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the SQL statement being described. Status values are defined as follows: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        ABORTED - The query run was stopped by the user.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        ALL - A status value that includes all query statuses. This value can be used to filter results.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        FAILED - The query run failed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        FINISHED - The query has finished running.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PICKED - The query has been chosen to be run.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        STARTED - The query run has started.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SUBMITTED - The query was submitted, but not yet processed.
         *        </p>
         *        </li>
         * @see StatusString
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StatusString
         */
        Builder status(StatusString status);

        /**
         * <p>
         * The SQL statements from a multiple statement run.
         * </p>
         * 
         * @param subStatements
         *        The SQL statements from a multiple statement run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subStatements(Collection<SubStatementData> subStatements);

        /**
         * <p>
         * The SQL statements from a multiple statement run.
         * </p>
         * 
         * @param subStatements
         *        The SQL statements from a multiple statement run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subStatements(SubStatementData... subStatements);

        /**
         * <p>
         * The SQL statements from a multiple statement run.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.redshiftdata.model.SubStatementData.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.redshiftdata.model.SubStatementData#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.redshiftdata.model.SubStatementData.Builder#build()} is called
         * immediately and its result is passed to {@link #subStatements(List<SubStatementData>)}.
         * 
         * @param subStatements
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.redshiftdata.model.SubStatementData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #subStatements(java.util.Collection<SubStatementData>)
         */
        Builder subStatements(Consumer<SubStatementData.Builder>... subStatements);

        /**
         * <p>
         * The date and time (UTC) that the metadata for the SQL statement was last updated. An example is the time the
         * status last changed.
         * </p>
         * 
         * @param updatedAt
         *        The date and time (UTC) that the metadata for the SQL statement was last updated. An example is the
         *        time the status last changed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * The serverless workgroup name.
         * </p>
         * 
         * @param workgroupName
         *        The serverless workgroup name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workgroupName(String workgroupName);
    }

    static final class BuilderImpl extends RedshiftDataResponse.BuilderImpl implements Builder {
        private String clusterIdentifier;

        private Instant createdAt;

        private String database;

        private String dbUser;

        private Long duration;

        private String error;

        private Boolean hasResultSet;

        private String id;

        private List<SqlParameter> queryParameters = DefaultSdkAutoConstructList.getInstance();

        private String queryString;

        private Long redshiftPid;

        private Long redshiftQueryId;

        private Long resultRows;

        private Long resultSize;

        private String secretArn;

        private String status;

        private List<SubStatementData> subStatements = DefaultSdkAutoConstructList.getInstance();

        private Instant updatedAt;

        private String workgroupName;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStatementResponse model) {
            super(model);
            clusterIdentifier(model.clusterIdentifier);
            createdAt(model.createdAt);
            database(model.database);
            dbUser(model.dbUser);
            duration(model.duration);
            error(model.error);
            hasResultSet(model.hasResultSet);
            id(model.id);
            queryParameters(model.queryParameters);
            queryString(model.queryString);
            redshiftPid(model.redshiftPid);
            redshiftQueryId(model.redshiftQueryId);
            resultRows(model.resultRows);
            resultSize(model.resultSize);
            secretArn(model.secretArn);
            status(model.status);
            subStatements(model.subStatements);
            updatedAt(model.updatedAt);
            workgroupName(model.workgroupName);
        }

        public final String getClusterIdentifier() {
            return clusterIdentifier;
        }

        public final void setClusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
        }

        @Override
        public final Builder clusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getDatabase() {
            return database;
        }

        public final void setDatabase(String database) {
            this.database = database;
        }

        @Override
        public final Builder database(String database) {
            this.database = database;
            return this;
        }

        public final String getDbUser() {
            return dbUser;
        }

        public final void setDbUser(String dbUser) {
            this.dbUser = dbUser;
        }

        @Override
        public final Builder dbUser(String dbUser) {
            this.dbUser = dbUser;
            return this;
        }

        public final Long getDuration() {
            return duration;
        }

        public final void setDuration(Long duration) {
            this.duration = duration;
        }

        @Override
        public final Builder duration(Long duration) {
            this.duration = duration;
            return this;
        }

        public final String getError() {
            return error;
        }

        public final void setError(String error) {
            this.error = error;
        }

        @Override
        public final Builder error(String error) {
            this.error = error;
            return this;
        }

        public final Boolean getHasResultSet() {
            return hasResultSet;
        }

        public final void setHasResultSet(Boolean hasResultSet) {
            this.hasResultSet = hasResultSet;
        }

        @Override
        public final Builder hasResultSet(Boolean hasResultSet) {
            this.hasResultSet = hasResultSet;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final List<SqlParameter.Builder> getQueryParameters() {
            List<SqlParameter.Builder> result = SqlParametersListCopier.copyToBuilder(this.queryParameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setQueryParameters(Collection<SqlParameter.BuilderImpl> queryParameters) {
            this.queryParameters = SqlParametersListCopier.copyFromBuilder(queryParameters);
        }

        @Override
        public final Builder queryParameters(Collection<SqlParameter> queryParameters) {
            this.queryParameters = SqlParametersListCopier.copy(queryParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queryParameters(SqlParameter... queryParameters) {
            queryParameters(Arrays.asList(queryParameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queryParameters(Consumer<SqlParameter.Builder>... queryParameters) {
            queryParameters(Stream.of(queryParameters).map(c -> SqlParameter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getQueryString() {
            return queryString;
        }

        public final void setQueryString(String queryString) {
            this.queryString = queryString;
        }

        @Override
        public final Builder queryString(String queryString) {
            this.queryString = queryString;
            return this;
        }

        public final Long getRedshiftPid() {
            return redshiftPid;
        }

        public final void setRedshiftPid(Long redshiftPid) {
            this.redshiftPid = redshiftPid;
        }

        @Override
        public final Builder redshiftPid(Long redshiftPid) {
            this.redshiftPid = redshiftPid;
            return this;
        }

        public final Long getRedshiftQueryId() {
            return redshiftQueryId;
        }

        public final void setRedshiftQueryId(Long redshiftQueryId) {
            this.redshiftQueryId = redshiftQueryId;
        }

        @Override
        public final Builder redshiftQueryId(Long redshiftQueryId) {
            this.redshiftQueryId = redshiftQueryId;
            return this;
        }

        public final Long getResultRows() {
            return resultRows;
        }

        public final void setResultRows(Long resultRows) {
            this.resultRows = resultRows;
        }

        @Override
        public final Builder resultRows(Long resultRows) {
            this.resultRows = resultRows;
            return this;
        }

        public final Long getResultSize() {
            return resultSize;
        }

        public final void setResultSize(Long resultSize) {
            this.resultSize = resultSize;
        }

        @Override
        public final Builder resultSize(Long resultSize) {
            this.resultSize = resultSize;
            return this;
        }

        public final String getSecretArn() {
            return secretArn;
        }

        public final void setSecretArn(String secretArn) {
            this.secretArn = secretArn;
        }

        @Override
        public final Builder secretArn(String secretArn) {
            this.secretArn = secretArn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(StatusString status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final List<SubStatementData.Builder> getSubStatements() {
            List<SubStatementData.Builder> result = SubStatementListCopier.copyToBuilder(this.subStatements);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSubStatements(Collection<SubStatementData.BuilderImpl> subStatements) {
            this.subStatements = SubStatementListCopier.copyFromBuilder(subStatements);
        }

        @Override
        public final Builder subStatements(Collection<SubStatementData> subStatements) {
            this.subStatements = SubStatementListCopier.copy(subStatements);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subStatements(SubStatementData... subStatements) {
            subStatements(Arrays.asList(subStatements));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subStatements(Consumer<SubStatementData.Builder>... subStatements) {
            subStatements(Stream.of(subStatements).map(c -> SubStatementData.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getWorkgroupName() {
            return workgroupName;
        }

        public final void setWorkgroupName(String workgroupName) {
            this.workgroupName = workgroupName;
        }

        @Override
        public final Builder workgroupName(String workgroupName) {
            this.workgroupName = workgroupName;
            return this;
        }

        @Override
        public DescribeStatementResponse build() {
            return new DescribeStatementResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
