/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshiftdata;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.services.redshiftdata.model.BatchExecuteStatementRequest;
import software.amazon.awssdk.services.redshiftdata.model.BatchExecuteStatementResponse;
import software.amazon.awssdk.services.redshiftdata.model.CancelStatementRequest;
import software.amazon.awssdk.services.redshiftdata.model.CancelStatementResponse;
import software.amazon.awssdk.services.redshiftdata.model.DescribeStatementRequest;
import software.amazon.awssdk.services.redshiftdata.model.DescribeStatementResponse;
import software.amazon.awssdk.services.redshiftdata.model.DescribeTableRequest;
import software.amazon.awssdk.services.redshiftdata.model.DescribeTableResponse;
import software.amazon.awssdk.services.redshiftdata.model.ExecuteStatementRequest;
import software.amazon.awssdk.services.redshiftdata.model.ExecuteStatementResponse;
import software.amazon.awssdk.services.redshiftdata.model.GetStatementResultRequest;
import software.amazon.awssdk.services.redshiftdata.model.GetStatementResultResponse;
import software.amazon.awssdk.services.redshiftdata.model.ListDatabasesRequest;
import software.amazon.awssdk.services.redshiftdata.model.ListDatabasesResponse;
import software.amazon.awssdk.services.redshiftdata.model.ListSchemasRequest;
import software.amazon.awssdk.services.redshiftdata.model.ListSchemasResponse;
import software.amazon.awssdk.services.redshiftdata.model.ListStatementsRequest;
import software.amazon.awssdk.services.redshiftdata.model.ListStatementsResponse;
import software.amazon.awssdk.services.redshiftdata.model.ListTablesRequest;
import software.amazon.awssdk.services.redshiftdata.model.ListTablesResponse;
import software.amazon.awssdk.services.redshiftdata.paginators.DescribeTablePublisher;
import software.amazon.awssdk.services.redshiftdata.paginators.GetStatementResultPublisher;
import software.amazon.awssdk.services.redshiftdata.paginators.ListDatabasesPublisher;
import software.amazon.awssdk.services.redshiftdata.paginators.ListSchemasPublisher;
import software.amazon.awssdk.services.redshiftdata.paginators.ListStatementsPublisher;
import software.amazon.awssdk.services.redshiftdata.paginators.ListTablesPublisher;

/**
 * Service client for accessing Redshift Data API Service asynchronously. This can be created using the static
 * {@link #builder()} method.
 *
 * <p>
 * You can use the Amazon Redshift Data API to run queries on Amazon Redshift tables. You can run SQL statements, which
 * are committed if the statement succeeds.
 * </p>
 * <p>
 * For more information about the Amazon Redshift Data API and CLI usage examples, see <a
 * href="https://docs.aws.amazon.com/redshift/latest/mgmt/data-api.html">Using the Amazon Redshift Data API</a> in the
 * <i>Amazon Redshift Cluster Management Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface RedshiftDataAsyncClient extends SdkClient {
    String SERVICE_NAME = "redshift-data";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "redshift-data";

    /**
     * Create a {@link RedshiftDataAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static RedshiftDataAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link RedshiftDataAsyncClient}.
     */
    static RedshiftDataAsyncClientBuilder builder() {
        return new DefaultRedshiftDataAsyncClientBuilder();
    }

    /**
     * <p>
     * Runs one or more SQL statements, which can be data manipulation language (DML) or data definition language (DDL).
     * Depending on the authorization method, use one of the following combinations of request parameters:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Secrets Manager - when connecting to a cluster, specify the Amazon Resource Name (ARN) of the secret, the
     * database name, and the cluster identifier that matches the cluster in the secret. When connecting to a serverless
     * workgroup, specify the Amazon Resource Name (ARN) of the secret and the database name.
     * </p>
     * </li>
     * <li>
     * <p>
     * Temporary credentials - when connecting to a cluster, specify the cluster identifier, the database name, and the
     * database user name. Also, permission to call the <code>redshift:GetClusterCredentials</code> operation is
     * required. When connecting to a serverless workgroup, specify the workgroup name and database name. Also,
     * permission to call the <code>redshift-serverless:GetCredentials</code> operation is required.
     * </p>
     * </li>
     * </ul>
     *
     * @param batchExecuteStatementRequest
     * @return A Java Future containing the result of the BatchExecuteStatement operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The Amazon Redshift Data API operation failed due to invalid input.</li>
     *         <li>ActiveStatementsExceededException The number of active statements exceeds the limit.</li>
     *         <li>BatchExecuteStatementException An SQL statement encountered an environmental error while running.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftDataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftDataAsyncClient.BatchExecuteStatement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-data-2019-12-20/BatchExecuteStatement"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchExecuteStatementResponse> batchExecuteStatement(
            BatchExecuteStatementRequest batchExecuteStatementRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Runs one or more SQL statements, which can be data manipulation language (DML) or data definition language (DDL).
     * Depending on the authorization method, use one of the following combinations of request parameters:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Secrets Manager - when connecting to a cluster, specify the Amazon Resource Name (ARN) of the secret, the
     * database name, and the cluster identifier that matches the cluster in the secret. When connecting to a serverless
     * workgroup, specify the Amazon Resource Name (ARN) of the secret and the database name.
     * </p>
     * </li>
     * <li>
     * <p>
     * Temporary credentials - when connecting to a cluster, specify the cluster identifier, the database name, and the
     * database user name. Also, permission to call the <code>redshift:GetClusterCredentials</code> operation is
     * required. When connecting to a serverless workgroup, specify the workgroup name and database name. Also,
     * permission to call the <code>redshift-serverless:GetCredentials</code> operation is required.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchExecuteStatementRequest.Builder} avoiding the
     * need to create one manually via {@link BatchExecuteStatementRequest#builder()}
     * </p>
     *
     * @param batchExecuteStatementRequest
     *        A {@link Consumer} that will call methods on {@link BatchExecuteStatementInput.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the BatchExecuteStatement operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The Amazon Redshift Data API operation failed due to invalid input.</li>
     *         <li>ActiveStatementsExceededException The number of active statements exceeds the limit.</li>
     *         <li>BatchExecuteStatementException An SQL statement encountered an environmental error while running.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftDataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftDataAsyncClient.BatchExecuteStatement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-data-2019-12-20/BatchExecuteStatement"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchExecuteStatementResponse> batchExecuteStatement(
            Consumer<BatchExecuteStatementRequest.Builder> batchExecuteStatementRequest) {
        return batchExecuteStatement(BatchExecuteStatementRequest.builder().applyMutation(batchExecuteStatementRequest).build());
    }

    /**
     * <p>
     * Cancels a running query. To be canceled, a query must be running.
     * </p>
     *
     * @param cancelStatementRequest
     * @return A Java Future containing the result of the CancelStatement operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The Amazon Redshift Data API operation failed due to invalid input.</li>
     *         <li>ResourceNotFoundException The Amazon Redshift Data API operation failed due to a missing resource.</li>
     *         <li>InternalServerException The Amazon Redshift Data API operation failed due to invalid input.</li>
     *         <li>DatabaseConnectionException Connection to a database failed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftDataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftDataAsyncClient.CancelStatement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-data-2019-12-20/CancelStatement" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CancelStatementResponse> cancelStatement(CancelStatementRequest cancelStatementRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels a running query. To be canceled, a query must be running.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelStatementRequest.Builder} avoiding the need
     * to create one manually via {@link CancelStatementRequest#builder()}
     * </p>
     *
     * @param cancelStatementRequest
     *        A {@link Consumer} that will call methods on {@link CancelStatementRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CancelStatement operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The Amazon Redshift Data API operation failed due to invalid input.</li>
     *         <li>ResourceNotFoundException The Amazon Redshift Data API operation failed due to a missing resource.</li>
     *         <li>InternalServerException The Amazon Redshift Data API operation failed due to invalid input.</li>
     *         <li>DatabaseConnectionException Connection to a database failed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftDataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftDataAsyncClient.CancelStatement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-data-2019-12-20/CancelStatement" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CancelStatementResponse> cancelStatement(
            Consumer<CancelStatementRequest.Builder> cancelStatementRequest) {
        return cancelStatement(CancelStatementRequest.builder().applyMutation(cancelStatementRequest).build());
    }

    /**
     * <p>
     * Describes the details about a specific instance when a query was run by the Amazon Redshift Data API. The
     * information includes when the query started, when it finished, the query status, the number of rows returned, and
     * the SQL statement.
     * </p>
     *
     * @param describeStatementRequest
     * @return A Java Future containing the result of the DescribeStatement operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The Amazon Redshift Data API operation failed due to invalid input.</li>
     *         <li>ResourceNotFoundException The Amazon Redshift Data API operation failed due to a missing resource.</li>
     *         <li>InternalServerException The Amazon Redshift Data API operation failed due to invalid input.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftDataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftDataAsyncClient.DescribeStatement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-data-2019-12-20/DescribeStatement"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeStatementResponse> describeStatement(DescribeStatementRequest describeStatementRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the details about a specific instance when a query was run by the Amazon Redshift Data API. The
     * information includes when the query started, when it finished, the query status, the number of rows returned, and
     * the SQL statement.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeStatementRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeStatementRequest#builder()}
     * </p>
     *
     * @param describeStatementRequest
     *        A {@link Consumer} that will call methods on {@link DescribeStatementRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeStatement operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The Amazon Redshift Data API operation failed due to invalid input.</li>
     *         <li>ResourceNotFoundException The Amazon Redshift Data API operation failed due to a missing resource.</li>
     *         <li>InternalServerException The Amazon Redshift Data API operation failed due to invalid input.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftDataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftDataAsyncClient.DescribeStatement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-data-2019-12-20/DescribeStatement"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeStatementResponse> describeStatement(
            Consumer<DescribeStatementRequest.Builder> describeStatementRequest) {
        return describeStatement(DescribeStatementRequest.builder().applyMutation(describeStatementRequest).build());
    }

    /**
     * <p>
     * Describes the detailed information about a table from metadata in the cluster. The information includes its
     * columns. A token is returned to page through the column list. Depending on the authorization method, use one of
     * the following combinations of request parameters:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Secrets Manager - when connecting to a cluster, specify the Amazon Resource Name (ARN) of the secret, the
     * database name, and the cluster identifier that matches the cluster in the secret. When connecting to a serverless
     * workgroup, specify the Amazon Resource Name (ARN) of the secret and the database name.
     * </p>
     * </li>
     * <li>
     * <p>
     * Temporary credentials - when connecting to a cluster, specify the cluster identifier, the database name, and the
     * database user name. Also, permission to call the <code>redshift:GetClusterCredentials</code> operation is
     * required. When connecting to a serverless workgroup, specify the workgroup name and database name. Also,
     * permission to call the <code>redshift-serverless:GetCredentials</code> operation is required.
     * </p>
     * </li>
     * </ul>
     *
     * @param describeTableRequest
     * @return A Java Future containing the result of the DescribeTable operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The Amazon Redshift Data API operation failed due to invalid input.</li>
     *         <li>InternalServerException The Amazon Redshift Data API operation failed due to invalid input.</li>
     *         <li>DatabaseConnectionException Connection to a database failed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftDataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftDataAsyncClient.DescribeTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-data-2019-12-20/DescribeTable" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeTableResponse> describeTable(DescribeTableRequest describeTableRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the detailed information about a table from metadata in the cluster. The information includes its
     * columns. A token is returned to page through the column list. Depending on the authorization method, use one of
     * the following combinations of request parameters:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Secrets Manager - when connecting to a cluster, specify the Amazon Resource Name (ARN) of the secret, the
     * database name, and the cluster identifier that matches the cluster in the secret. When connecting to a serverless
     * workgroup, specify the Amazon Resource Name (ARN) of the secret and the database name.
     * </p>
     * </li>
     * <li>
     * <p>
     * Temporary credentials - when connecting to a cluster, specify the cluster identifier, the database name, and the
     * database user name. Also, permission to call the <code>redshift:GetClusterCredentials</code> operation is
     * required. When connecting to a serverless workgroup, specify the workgroup name and database name. Also,
     * permission to call the <code>redshift-serverless:GetCredentials</code> operation is required.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTableRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeTableRequest#builder()}
     * </p>
     *
     * @param describeTableRequest
     *        A {@link Consumer} that will call methods on {@link DescribeTableRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeTable operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The Amazon Redshift Data API operation failed due to invalid input.</li>
     *         <li>InternalServerException The Amazon Redshift Data API operation failed due to invalid input.</li>
     *         <li>DatabaseConnectionException Connection to a database failed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftDataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftDataAsyncClient.DescribeTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-data-2019-12-20/DescribeTable" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeTableResponse> describeTable(Consumer<DescribeTableRequest.Builder> describeTableRequest) {
        return describeTable(DescribeTableRequest.builder().applyMutation(describeTableRequest).build());
    }

    /**
     * <p>
     * Describes the detailed information about a table from metadata in the cluster. The information includes its
     * columns. A token is returned to page through the column list. Depending on the authorization method, use one of
     * the following combinations of request parameters:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Secrets Manager - when connecting to a cluster, specify the Amazon Resource Name (ARN) of the secret, the
     * database name, and the cluster identifier that matches the cluster in the secret. When connecting to a serverless
     * workgroup, specify the Amazon Resource Name (ARN) of the secret and the database name.
     * </p>
     * </li>
     * <li>
     * <p>
     * Temporary credentials - when connecting to a cluster, specify the cluster identifier, the database name, and the
     * database user name. Also, permission to call the <code>redshift:GetClusterCredentials</code> operation is
     * required. When connecting to a serverless workgroup, specify the workgroup name and database name. Also,
     * permission to call the <code>redshift-serverless:GetCredentials</code> operation is required.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeTable(software.amazon.awssdk.services.redshiftdata.model.DescribeTableRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftdata.paginators.DescribeTablePublisher publisher = client.describeTablePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftdata.paginators.DescribeTablePublisher publisher = client.describeTablePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshiftdata.model.DescribeTableResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshiftdata.model.DescribeTableResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeTable(software.amazon.awssdk.services.redshiftdata.model.DescribeTableRequest)} operation.</b>
     * </p>
     *
     * @param describeTableRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The Amazon Redshift Data API operation failed due to invalid input.</li>
     *         <li>InternalServerException The Amazon Redshift Data API operation failed due to invalid input.</li>
     *         <li>DatabaseConnectionException Connection to a database failed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftDataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftDataAsyncClient.DescribeTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-data-2019-12-20/DescribeTable" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeTablePublisher describeTablePaginator(DescribeTableRequest describeTableRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the detailed information about a table from metadata in the cluster. The information includes its
     * columns. A token is returned to page through the column list. Depending on the authorization method, use one of
     * the following combinations of request parameters:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Secrets Manager - when connecting to a cluster, specify the Amazon Resource Name (ARN) of the secret, the
     * database name, and the cluster identifier that matches the cluster in the secret. When connecting to a serverless
     * workgroup, specify the Amazon Resource Name (ARN) of the secret and the database name.
     * </p>
     * </li>
     * <li>
     * <p>
     * Temporary credentials - when connecting to a cluster, specify the cluster identifier, the database name, and the
     * database user name. Also, permission to call the <code>redshift:GetClusterCredentials</code> operation is
     * required. When connecting to a serverless workgroup, specify the workgroup name and database name. Also,
     * permission to call the <code>redshift-serverless:GetCredentials</code> operation is required.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeTable(software.amazon.awssdk.services.redshiftdata.model.DescribeTableRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftdata.paginators.DescribeTablePublisher publisher = client.describeTablePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftdata.paginators.DescribeTablePublisher publisher = client.describeTablePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshiftdata.model.DescribeTableResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshiftdata.model.DescribeTableResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeTable(software.amazon.awssdk.services.redshiftdata.model.DescribeTableRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTableRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeTableRequest#builder()}
     * </p>
     *
     * @param describeTableRequest
     *        A {@link Consumer} that will call methods on {@link DescribeTableRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The Amazon Redshift Data API operation failed due to invalid input.</li>
     *         <li>InternalServerException The Amazon Redshift Data API operation failed due to invalid input.</li>
     *         <li>DatabaseConnectionException Connection to a database failed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftDataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftDataAsyncClient.DescribeTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-data-2019-12-20/DescribeTable" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeTablePublisher describeTablePaginator(Consumer<DescribeTableRequest.Builder> describeTableRequest) {
        return describeTablePaginator(DescribeTableRequest.builder().applyMutation(describeTableRequest).build());
    }

    /**
     * <p>
     * Runs an SQL statement, which can be data manipulation language (DML) or data definition language (DDL). This
     * statement must be a single SQL statement. Depending on the authorization method, use one of the following
     * combinations of request parameters:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Secrets Manager - when connecting to a cluster, specify the Amazon Resource Name (ARN) of the secret, the
     * database name, and the cluster identifier that matches the cluster in the secret. When connecting to a serverless
     * workgroup, specify the Amazon Resource Name (ARN) of the secret and the database name.
     * </p>
     * </li>
     * <li>
     * <p>
     * Temporary credentials - when connecting to a cluster, specify the cluster identifier, the database name, and the
     * database user name. Also, permission to call the <code>redshift:GetClusterCredentials</code> operation is
     * required. When connecting to a serverless workgroup, specify the workgroup name and database name. Also,
     * permission to call the <code>redshift-serverless:GetCredentials</code> operation is required.
     * </p>
     * </li>
     * </ul>
     *
     * @param executeStatementRequest
     * @return A Java Future containing the result of the ExecuteStatement operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The Amazon Redshift Data API operation failed due to invalid input.</li>
     *         <li>ExecuteStatementException The SQL statement encountered an environmental error while running.</li>
     *         <li>ActiveStatementsExceededException The number of active statements exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftDataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftDataAsyncClient.ExecuteStatement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-data-2019-12-20/ExecuteStatement"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ExecuteStatementResponse> executeStatement(ExecuteStatementRequest executeStatementRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Runs an SQL statement, which can be data manipulation language (DML) or data definition language (DDL). This
     * statement must be a single SQL statement. Depending on the authorization method, use one of the following
     * combinations of request parameters:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Secrets Manager - when connecting to a cluster, specify the Amazon Resource Name (ARN) of the secret, the
     * database name, and the cluster identifier that matches the cluster in the secret. When connecting to a serverless
     * workgroup, specify the Amazon Resource Name (ARN) of the secret and the database name.
     * </p>
     * </li>
     * <li>
     * <p>
     * Temporary credentials - when connecting to a cluster, specify the cluster identifier, the database name, and the
     * database user name. Also, permission to call the <code>redshift:GetClusterCredentials</code> operation is
     * required. When connecting to a serverless workgroup, specify the workgroup name and database name. Also,
     * permission to call the <code>redshift-serverless:GetCredentials</code> operation is required.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ExecuteStatementRequest.Builder} avoiding the need
     * to create one manually via {@link ExecuteStatementRequest#builder()}
     * </p>
     *
     * @param executeStatementRequest
     *        A {@link Consumer} that will call methods on {@link ExecuteStatementInput.Builder} to create a request.
     * @return A Java Future containing the result of the ExecuteStatement operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The Amazon Redshift Data API operation failed due to invalid input.</li>
     *         <li>ExecuteStatementException The SQL statement encountered an environmental error while running.</li>
     *         <li>ActiveStatementsExceededException The number of active statements exceeds the limit.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftDataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftDataAsyncClient.ExecuteStatement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-data-2019-12-20/ExecuteStatement"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ExecuteStatementResponse> executeStatement(
            Consumer<ExecuteStatementRequest.Builder> executeStatementRequest) {
        return executeStatement(ExecuteStatementRequest.builder().applyMutation(executeStatementRequest).build());
    }

    /**
     * <p>
     * Fetches the temporarily cached result of an SQL statement. A token is returned to page through the statement
     * results.
     * </p>
     *
     * @param getStatementResultRequest
     * @return A Java Future containing the result of the GetStatementResult operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The Amazon Redshift Data API operation failed due to invalid input.</li>
     *         <li>ResourceNotFoundException The Amazon Redshift Data API operation failed due to a missing resource.</li>
     *         <li>InternalServerException The Amazon Redshift Data API operation failed due to invalid input.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftDataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftDataAsyncClient.GetStatementResult
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-data-2019-12-20/GetStatementResult"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetStatementResultResponse> getStatementResult(GetStatementResultRequest getStatementResultRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Fetches the temporarily cached result of an SQL statement. A token is returned to page through the statement
     * results.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetStatementResultRequest.Builder} avoiding the
     * need to create one manually via {@link GetStatementResultRequest#builder()}
     * </p>
     *
     * @param getStatementResultRequest
     *        A {@link Consumer} that will call methods on {@link GetStatementResultRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetStatementResult operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The Amazon Redshift Data API operation failed due to invalid input.</li>
     *         <li>ResourceNotFoundException The Amazon Redshift Data API operation failed due to a missing resource.</li>
     *         <li>InternalServerException The Amazon Redshift Data API operation failed due to invalid input.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftDataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftDataAsyncClient.GetStatementResult
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-data-2019-12-20/GetStatementResult"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetStatementResultResponse> getStatementResult(
            Consumer<GetStatementResultRequest.Builder> getStatementResultRequest) {
        return getStatementResult(GetStatementResultRequest.builder().applyMutation(getStatementResultRequest).build());
    }

    /**
     * <p>
     * Fetches the temporarily cached result of an SQL statement. A token is returned to page through the statement
     * results.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getStatementResult(software.amazon.awssdk.services.redshiftdata.model.GetStatementResultRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftdata.paginators.GetStatementResultPublisher publisher = client.getStatementResultPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftdata.paginators.GetStatementResultPublisher publisher = client.getStatementResultPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshiftdata.model.GetStatementResultResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshiftdata.model.GetStatementResultResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getStatementResult(software.amazon.awssdk.services.redshiftdata.model.GetStatementResultRequest)}
     * operation.</b>
     * </p>
     *
     * @param getStatementResultRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The Amazon Redshift Data API operation failed due to invalid input.</li>
     *         <li>ResourceNotFoundException The Amazon Redshift Data API operation failed due to a missing resource.</li>
     *         <li>InternalServerException The Amazon Redshift Data API operation failed due to invalid input.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftDataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftDataAsyncClient.GetStatementResult
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-data-2019-12-20/GetStatementResult"
     *      target="_top">AWS API Documentation</a>
     */
    default GetStatementResultPublisher getStatementResultPaginator(GetStatementResultRequest getStatementResultRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Fetches the temporarily cached result of an SQL statement. A token is returned to page through the statement
     * results.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getStatementResult(software.amazon.awssdk.services.redshiftdata.model.GetStatementResultRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftdata.paginators.GetStatementResultPublisher publisher = client.getStatementResultPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftdata.paginators.GetStatementResultPublisher publisher = client.getStatementResultPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshiftdata.model.GetStatementResultResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshiftdata.model.GetStatementResultResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getStatementResult(software.amazon.awssdk.services.redshiftdata.model.GetStatementResultRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetStatementResultRequest.Builder} avoiding the
     * need to create one manually via {@link GetStatementResultRequest#builder()}
     * </p>
     *
     * @param getStatementResultRequest
     *        A {@link Consumer} that will call methods on {@link GetStatementResultRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The Amazon Redshift Data API operation failed due to invalid input.</li>
     *         <li>ResourceNotFoundException The Amazon Redshift Data API operation failed due to a missing resource.</li>
     *         <li>InternalServerException The Amazon Redshift Data API operation failed due to invalid input.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftDataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftDataAsyncClient.GetStatementResult
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-data-2019-12-20/GetStatementResult"
     *      target="_top">AWS API Documentation</a>
     */
    default GetStatementResultPublisher getStatementResultPaginator(
            Consumer<GetStatementResultRequest.Builder> getStatementResultRequest) {
        return getStatementResultPaginator(GetStatementResultRequest.builder().applyMutation(getStatementResultRequest).build());
    }

    /**
     * <p>
     * List the databases in a cluster. A token is returned to page through the database list. Depending on the
     * authorization method, use one of the following combinations of request parameters:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Secrets Manager - when connecting to a cluster, specify the Amazon Resource Name (ARN) of the secret, the
     * database name, and the cluster identifier that matches the cluster in the secret. When connecting to a serverless
     * workgroup, specify the Amazon Resource Name (ARN) of the secret and the database name.
     * </p>
     * </li>
     * <li>
     * <p>
     * Temporary credentials - when connecting to a cluster, specify the cluster identifier, the database name, and the
     * database user name. Also, permission to call the <code>redshift:GetClusterCredentials</code> operation is
     * required. When connecting to a serverless workgroup, specify the workgroup name and database name. Also,
     * permission to call the <code>redshift-serverless:GetCredentials</code> operation is required.
     * </p>
     * </li>
     * </ul>
     *
     * @param listDatabasesRequest
     * @return A Java Future containing the result of the ListDatabases operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The Amazon Redshift Data API operation failed due to invalid input.</li>
     *         <li>InternalServerException The Amazon Redshift Data API operation failed due to invalid input.</li>
     *         <li>DatabaseConnectionException Connection to a database failed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftDataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftDataAsyncClient.ListDatabases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-data-2019-12-20/ListDatabases" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListDatabasesResponse> listDatabases(ListDatabasesRequest listDatabasesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the databases in a cluster. A token is returned to page through the database list. Depending on the
     * authorization method, use one of the following combinations of request parameters:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Secrets Manager - when connecting to a cluster, specify the Amazon Resource Name (ARN) of the secret, the
     * database name, and the cluster identifier that matches the cluster in the secret. When connecting to a serverless
     * workgroup, specify the Amazon Resource Name (ARN) of the secret and the database name.
     * </p>
     * </li>
     * <li>
     * <p>
     * Temporary credentials - when connecting to a cluster, specify the cluster identifier, the database name, and the
     * database user name. Also, permission to call the <code>redshift:GetClusterCredentials</code> operation is
     * required. When connecting to a serverless workgroup, specify the workgroup name and database name. Also,
     * permission to call the <code>redshift-serverless:GetCredentials</code> operation is required.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDatabasesRequest.Builder} avoiding the need to
     * create one manually via {@link ListDatabasesRequest#builder()}
     * </p>
     *
     * @param listDatabasesRequest
     *        A {@link Consumer} that will call methods on {@link ListDatabasesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListDatabases operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The Amazon Redshift Data API operation failed due to invalid input.</li>
     *         <li>InternalServerException The Amazon Redshift Data API operation failed due to invalid input.</li>
     *         <li>DatabaseConnectionException Connection to a database failed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftDataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftDataAsyncClient.ListDatabases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-data-2019-12-20/ListDatabases" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListDatabasesResponse> listDatabases(Consumer<ListDatabasesRequest.Builder> listDatabasesRequest) {
        return listDatabases(ListDatabasesRequest.builder().applyMutation(listDatabasesRequest).build());
    }

    /**
     * <p>
     * List the databases in a cluster. A token is returned to page through the database list. Depending on the
     * authorization method, use one of the following combinations of request parameters:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Secrets Manager - when connecting to a cluster, specify the Amazon Resource Name (ARN) of the secret, the
     * database name, and the cluster identifier that matches the cluster in the secret. When connecting to a serverless
     * workgroup, specify the Amazon Resource Name (ARN) of the secret and the database name.
     * </p>
     * </li>
     * <li>
     * <p>
     * Temporary credentials - when connecting to a cluster, specify the cluster identifier, the database name, and the
     * database user name. Also, permission to call the <code>redshift:GetClusterCredentials</code> operation is
     * required. When connecting to a serverless workgroup, specify the workgroup name and database name. Also,
     * permission to call the <code>redshift-serverless:GetCredentials</code> operation is required.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDatabases(software.amazon.awssdk.services.redshiftdata.model.ListDatabasesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftdata.paginators.ListDatabasesPublisher publisher = client.listDatabasesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftdata.paginators.ListDatabasesPublisher publisher = client.listDatabasesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshiftdata.model.ListDatabasesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshiftdata.model.ListDatabasesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDatabases(software.amazon.awssdk.services.redshiftdata.model.ListDatabasesRequest)} operation.</b>
     * </p>
     *
     * @param listDatabasesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The Amazon Redshift Data API operation failed due to invalid input.</li>
     *         <li>InternalServerException The Amazon Redshift Data API operation failed due to invalid input.</li>
     *         <li>DatabaseConnectionException Connection to a database failed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftDataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftDataAsyncClient.ListDatabases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-data-2019-12-20/ListDatabases" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDatabasesPublisher listDatabasesPaginator(ListDatabasesRequest listDatabasesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the databases in a cluster. A token is returned to page through the database list. Depending on the
     * authorization method, use one of the following combinations of request parameters:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Secrets Manager - when connecting to a cluster, specify the Amazon Resource Name (ARN) of the secret, the
     * database name, and the cluster identifier that matches the cluster in the secret. When connecting to a serverless
     * workgroup, specify the Amazon Resource Name (ARN) of the secret and the database name.
     * </p>
     * </li>
     * <li>
     * <p>
     * Temporary credentials - when connecting to a cluster, specify the cluster identifier, the database name, and the
     * database user name. Also, permission to call the <code>redshift:GetClusterCredentials</code> operation is
     * required. When connecting to a serverless workgroup, specify the workgroup name and database name. Also,
     * permission to call the <code>redshift-serverless:GetCredentials</code> operation is required.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDatabases(software.amazon.awssdk.services.redshiftdata.model.ListDatabasesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftdata.paginators.ListDatabasesPublisher publisher = client.listDatabasesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftdata.paginators.ListDatabasesPublisher publisher = client.listDatabasesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshiftdata.model.ListDatabasesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshiftdata.model.ListDatabasesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDatabases(software.amazon.awssdk.services.redshiftdata.model.ListDatabasesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDatabasesRequest.Builder} avoiding the need to
     * create one manually via {@link ListDatabasesRequest#builder()}
     * </p>
     *
     * @param listDatabasesRequest
     *        A {@link Consumer} that will call methods on {@link ListDatabasesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The Amazon Redshift Data API operation failed due to invalid input.</li>
     *         <li>InternalServerException The Amazon Redshift Data API operation failed due to invalid input.</li>
     *         <li>DatabaseConnectionException Connection to a database failed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftDataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftDataAsyncClient.ListDatabases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-data-2019-12-20/ListDatabases" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDatabasesPublisher listDatabasesPaginator(Consumer<ListDatabasesRequest.Builder> listDatabasesRequest) {
        return listDatabasesPaginator(ListDatabasesRequest.builder().applyMutation(listDatabasesRequest).build());
    }

    /**
     * <p>
     * Lists the schemas in a database. A token is returned to page through the schema list. Depending on the
     * authorization method, use one of the following combinations of request parameters:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Secrets Manager - when connecting to a cluster, specify the Amazon Resource Name (ARN) of the secret, the
     * database name, and the cluster identifier that matches the cluster in the secret. When connecting to a serverless
     * workgroup, specify the Amazon Resource Name (ARN) of the secret and the database name.
     * </p>
     * </li>
     * <li>
     * <p>
     * Temporary credentials - when connecting to a cluster, specify the cluster identifier, the database name, and the
     * database user name. Also, permission to call the <code>redshift:GetClusterCredentials</code> operation is
     * required. When connecting to a serverless workgroup, specify the workgroup name and database name. Also,
     * permission to call the <code>redshift-serverless:GetCredentials</code> operation is required.
     * </p>
     * </li>
     * </ul>
     *
     * @param listSchemasRequest
     * @return A Java Future containing the result of the ListSchemas operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The Amazon Redshift Data API operation failed due to invalid input.</li>
     *         <li>InternalServerException The Amazon Redshift Data API operation failed due to invalid input.</li>
     *         <li>DatabaseConnectionException Connection to a database failed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftDataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftDataAsyncClient.ListSchemas
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-data-2019-12-20/ListSchemas" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListSchemasResponse> listSchemas(ListSchemasRequest listSchemasRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the schemas in a database. A token is returned to page through the schema list. Depending on the
     * authorization method, use one of the following combinations of request parameters:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Secrets Manager - when connecting to a cluster, specify the Amazon Resource Name (ARN) of the secret, the
     * database name, and the cluster identifier that matches the cluster in the secret. When connecting to a serverless
     * workgroup, specify the Amazon Resource Name (ARN) of the secret and the database name.
     * </p>
     * </li>
     * <li>
     * <p>
     * Temporary credentials - when connecting to a cluster, specify the cluster identifier, the database name, and the
     * database user name. Also, permission to call the <code>redshift:GetClusterCredentials</code> operation is
     * required. When connecting to a serverless workgroup, specify the workgroup name and database name. Also,
     * permission to call the <code>redshift-serverless:GetCredentials</code> operation is required.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSchemasRequest.Builder} avoiding the need to
     * create one manually via {@link ListSchemasRequest#builder()}
     * </p>
     *
     * @param listSchemasRequest
     *        A {@link Consumer} that will call methods on {@link ListSchemasRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListSchemas operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The Amazon Redshift Data API operation failed due to invalid input.</li>
     *         <li>InternalServerException The Amazon Redshift Data API operation failed due to invalid input.</li>
     *         <li>DatabaseConnectionException Connection to a database failed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftDataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftDataAsyncClient.ListSchemas
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-data-2019-12-20/ListSchemas" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListSchemasResponse> listSchemas(Consumer<ListSchemasRequest.Builder> listSchemasRequest) {
        return listSchemas(ListSchemasRequest.builder().applyMutation(listSchemasRequest).build());
    }

    /**
     * <p>
     * Lists the schemas in a database. A token is returned to page through the schema list. Depending on the
     * authorization method, use one of the following combinations of request parameters:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Secrets Manager - when connecting to a cluster, specify the Amazon Resource Name (ARN) of the secret, the
     * database name, and the cluster identifier that matches the cluster in the secret. When connecting to a serverless
     * workgroup, specify the Amazon Resource Name (ARN) of the secret and the database name.
     * </p>
     * </li>
     * <li>
     * <p>
     * Temporary credentials - when connecting to a cluster, specify the cluster identifier, the database name, and the
     * database user name. Also, permission to call the <code>redshift:GetClusterCredentials</code> operation is
     * required. When connecting to a serverless workgroup, specify the workgroup name and database name. Also,
     * permission to call the <code>redshift-serverless:GetCredentials</code> operation is required.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a variant of {@link #listSchemas(software.amazon.awssdk.services.redshiftdata.model.ListSchemasRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftdata.paginators.ListSchemasPublisher publisher = client.listSchemasPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftdata.paginators.ListSchemasPublisher publisher = client.listSchemasPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshiftdata.model.ListSchemasResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshiftdata.model.ListSchemasResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSchemas(software.amazon.awssdk.services.redshiftdata.model.ListSchemasRequest)} operation.</b>
     * </p>
     *
     * @param listSchemasRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The Amazon Redshift Data API operation failed due to invalid input.</li>
     *         <li>InternalServerException The Amazon Redshift Data API operation failed due to invalid input.</li>
     *         <li>DatabaseConnectionException Connection to a database failed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftDataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftDataAsyncClient.ListSchemas
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-data-2019-12-20/ListSchemas" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSchemasPublisher listSchemasPaginator(ListSchemasRequest listSchemasRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the schemas in a database. A token is returned to page through the schema list. Depending on the
     * authorization method, use one of the following combinations of request parameters:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Secrets Manager - when connecting to a cluster, specify the Amazon Resource Name (ARN) of the secret, the
     * database name, and the cluster identifier that matches the cluster in the secret. When connecting to a serverless
     * workgroup, specify the Amazon Resource Name (ARN) of the secret and the database name.
     * </p>
     * </li>
     * <li>
     * <p>
     * Temporary credentials - when connecting to a cluster, specify the cluster identifier, the database name, and the
     * database user name. Also, permission to call the <code>redshift:GetClusterCredentials</code> operation is
     * required. When connecting to a serverless workgroup, specify the workgroup name and database name. Also,
     * permission to call the <code>redshift-serverless:GetCredentials</code> operation is required.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a variant of {@link #listSchemas(software.amazon.awssdk.services.redshiftdata.model.ListSchemasRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftdata.paginators.ListSchemasPublisher publisher = client.listSchemasPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftdata.paginators.ListSchemasPublisher publisher = client.listSchemasPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshiftdata.model.ListSchemasResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshiftdata.model.ListSchemasResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSchemas(software.amazon.awssdk.services.redshiftdata.model.ListSchemasRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSchemasRequest.Builder} avoiding the need to
     * create one manually via {@link ListSchemasRequest#builder()}
     * </p>
     *
     * @param listSchemasRequest
     *        A {@link Consumer} that will call methods on {@link ListSchemasRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The Amazon Redshift Data API operation failed due to invalid input.</li>
     *         <li>InternalServerException The Amazon Redshift Data API operation failed due to invalid input.</li>
     *         <li>DatabaseConnectionException Connection to a database failed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftDataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftDataAsyncClient.ListSchemas
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-data-2019-12-20/ListSchemas" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSchemasPublisher listSchemasPaginator(Consumer<ListSchemasRequest.Builder> listSchemasRequest) {
        return listSchemasPaginator(ListSchemasRequest.builder().applyMutation(listSchemasRequest).build());
    }

    /**
     * <p>
     * List of SQL statements. By default, only finished statements are shown. A token is returned to page through the
     * statement list.
     * </p>
     *
     * @param listStatementsRequest
     * @return A Java Future containing the result of the ListStatements operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The Amazon Redshift Data API operation failed due to invalid input.</li>
     *         <li>InternalServerException The Amazon Redshift Data API operation failed due to invalid input.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftDataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftDataAsyncClient.ListStatements
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-data-2019-12-20/ListStatements" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListStatementsResponse> listStatements(ListStatementsRequest listStatementsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List of SQL statements. By default, only finished statements are shown. A token is returned to page through the
     * statement list.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStatementsRequest.Builder} avoiding the need to
     * create one manually via {@link ListStatementsRequest#builder()}
     * </p>
     *
     * @param listStatementsRequest
     *        A {@link Consumer} that will call methods on {@link ListStatementsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListStatements operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The Amazon Redshift Data API operation failed due to invalid input.</li>
     *         <li>InternalServerException The Amazon Redshift Data API operation failed due to invalid input.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftDataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftDataAsyncClient.ListStatements
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-data-2019-12-20/ListStatements" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListStatementsResponse> listStatements(Consumer<ListStatementsRequest.Builder> listStatementsRequest) {
        return listStatements(ListStatementsRequest.builder().applyMutation(listStatementsRequest).build());
    }

    /**
     * <p>
     * List of SQL statements. By default, only finished statements are shown. A token is returned to page through the
     * statement list.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listStatements(software.amazon.awssdk.services.redshiftdata.model.ListStatementsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftdata.paginators.ListStatementsPublisher publisher = client.listStatementsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftdata.paginators.ListStatementsPublisher publisher = client.listStatementsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshiftdata.model.ListStatementsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshiftdata.model.ListStatementsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStatements(software.amazon.awssdk.services.redshiftdata.model.ListStatementsRequest)} operation.</b>
     * </p>
     *
     * @param listStatementsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The Amazon Redshift Data API operation failed due to invalid input.</li>
     *         <li>InternalServerException The Amazon Redshift Data API operation failed due to invalid input.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftDataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftDataAsyncClient.ListStatements
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-data-2019-12-20/ListStatements" target="_top">AWS
     *      API Documentation</a>
     */
    default ListStatementsPublisher listStatementsPaginator(ListStatementsRequest listStatementsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List of SQL statements. By default, only finished statements are shown. A token is returned to page through the
     * statement list.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listStatements(software.amazon.awssdk.services.redshiftdata.model.ListStatementsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftdata.paginators.ListStatementsPublisher publisher = client.listStatementsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftdata.paginators.ListStatementsPublisher publisher = client.listStatementsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshiftdata.model.ListStatementsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshiftdata.model.ListStatementsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStatements(software.amazon.awssdk.services.redshiftdata.model.ListStatementsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStatementsRequest.Builder} avoiding the need to
     * create one manually via {@link ListStatementsRequest#builder()}
     * </p>
     *
     * @param listStatementsRequest
     *        A {@link Consumer} that will call methods on {@link ListStatementsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The Amazon Redshift Data API operation failed due to invalid input.</li>
     *         <li>InternalServerException The Amazon Redshift Data API operation failed due to invalid input.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftDataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftDataAsyncClient.ListStatements
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-data-2019-12-20/ListStatements" target="_top">AWS
     *      API Documentation</a>
     */
    default ListStatementsPublisher listStatementsPaginator(Consumer<ListStatementsRequest.Builder> listStatementsRequest) {
        return listStatementsPaginator(ListStatementsRequest.builder().applyMutation(listStatementsRequest).build());
    }

    /**
     * <p>
     * List the tables in a database. If neither <code>SchemaPattern</code> nor <code>TablePattern</code> are specified,
     * then all tables in the database are returned. A token is returned to page through the table list. Depending on
     * the authorization method, use one of the following combinations of request parameters:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Secrets Manager - when connecting to a cluster, specify the Amazon Resource Name (ARN) of the secret, the
     * database name, and the cluster identifier that matches the cluster in the secret. When connecting to a serverless
     * workgroup, specify the Amazon Resource Name (ARN) of the secret and the database name.
     * </p>
     * </li>
     * <li>
     * <p>
     * Temporary credentials - when connecting to a cluster, specify the cluster identifier, the database name, and the
     * database user name. Also, permission to call the <code>redshift:GetClusterCredentials</code> operation is
     * required. When connecting to a serverless workgroup, specify the workgroup name and database name. Also,
     * permission to call the <code>redshift-serverless:GetCredentials</code> operation is required.
     * </p>
     * </li>
     * </ul>
     *
     * @param listTablesRequest
     * @return A Java Future containing the result of the ListTables operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The Amazon Redshift Data API operation failed due to invalid input.</li>
     *         <li>InternalServerException The Amazon Redshift Data API operation failed due to invalid input.</li>
     *         <li>DatabaseConnectionException Connection to a database failed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftDataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftDataAsyncClient.ListTables
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-data-2019-12-20/ListTables" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTablesResponse> listTables(ListTablesRequest listTablesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the tables in a database. If neither <code>SchemaPattern</code> nor <code>TablePattern</code> are specified,
     * then all tables in the database are returned. A token is returned to page through the table list. Depending on
     * the authorization method, use one of the following combinations of request parameters:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Secrets Manager - when connecting to a cluster, specify the Amazon Resource Name (ARN) of the secret, the
     * database name, and the cluster identifier that matches the cluster in the secret. When connecting to a serverless
     * workgroup, specify the Amazon Resource Name (ARN) of the secret and the database name.
     * </p>
     * </li>
     * <li>
     * <p>
     * Temporary credentials - when connecting to a cluster, specify the cluster identifier, the database name, and the
     * database user name. Also, permission to call the <code>redshift:GetClusterCredentials</code> operation is
     * required. When connecting to a serverless workgroup, specify the workgroup name and database name. Also,
     * permission to call the <code>redshift-serverless:GetCredentials</code> operation is required.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTablesRequest.Builder} avoiding the need to
     * create one manually via {@link ListTablesRequest#builder()}
     * </p>
     *
     * @param listTablesRequest
     *        A {@link Consumer} that will call methods on {@link ListTablesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListTables operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The Amazon Redshift Data API operation failed due to invalid input.</li>
     *         <li>InternalServerException The Amazon Redshift Data API operation failed due to invalid input.</li>
     *         <li>DatabaseConnectionException Connection to a database failed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftDataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftDataAsyncClient.ListTables
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-data-2019-12-20/ListTables" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTablesResponse> listTables(Consumer<ListTablesRequest.Builder> listTablesRequest) {
        return listTables(ListTablesRequest.builder().applyMutation(listTablesRequest).build());
    }

    /**
     * <p>
     * List the tables in a database. If neither <code>SchemaPattern</code> nor <code>TablePattern</code> are specified,
     * then all tables in the database are returned. A token is returned to page through the table list. Depending on
     * the authorization method, use one of the following combinations of request parameters:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Secrets Manager - when connecting to a cluster, specify the Amazon Resource Name (ARN) of the secret, the
     * database name, and the cluster identifier that matches the cluster in the secret. When connecting to a serverless
     * workgroup, specify the Amazon Resource Name (ARN) of the secret and the database name.
     * </p>
     * </li>
     * <li>
     * <p>
     * Temporary credentials - when connecting to a cluster, specify the cluster identifier, the database name, and the
     * database user name. Also, permission to call the <code>redshift:GetClusterCredentials</code> operation is
     * required. When connecting to a serverless workgroup, specify the workgroup name and database name. Also,
     * permission to call the <code>redshift-serverless:GetCredentials</code> operation is required.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a variant of {@link #listTables(software.amazon.awssdk.services.redshiftdata.model.ListTablesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftdata.paginators.ListTablesPublisher publisher = client.listTablesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftdata.paginators.ListTablesPublisher publisher = client.listTablesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshiftdata.model.ListTablesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshiftdata.model.ListTablesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTables(software.amazon.awssdk.services.redshiftdata.model.ListTablesRequest)} operation.</b>
     * </p>
     *
     * @param listTablesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The Amazon Redshift Data API operation failed due to invalid input.</li>
     *         <li>InternalServerException The Amazon Redshift Data API operation failed due to invalid input.</li>
     *         <li>DatabaseConnectionException Connection to a database failed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftDataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftDataAsyncClient.ListTables
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-data-2019-12-20/ListTables" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTablesPublisher listTablesPaginator(ListTablesRequest listTablesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the tables in a database. If neither <code>SchemaPattern</code> nor <code>TablePattern</code> are specified,
     * then all tables in the database are returned. A token is returned to page through the table list. Depending on
     * the authorization method, use one of the following combinations of request parameters:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Secrets Manager - when connecting to a cluster, specify the Amazon Resource Name (ARN) of the secret, the
     * database name, and the cluster identifier that matches the cluster in the secret. When connecting to a serverless
     * workgroup, specify the Amazon Resource Name (ARN) of the secret and the database name.
     * </p>
     * </li>
     * <li>
     * <p>
     * Temporary credentials - when connecting to a cluster, specify the cluster identifier, the database name, and the
     * database user name. Also, permission to call the <code>redshift:GetClusterCredentials</code> operation is
     * required. When connecting to a serverless workgroup, specify the workgroup name and database name. Also,
     * permission to call the <code>redshift-serverless:GetCredentials</code> operation is required.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a variant of {@link #listTables(software.amazon.awssdk.services.redshiftdata.model.ListTablesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftdata.paginators.ListTablesPublisher publisher = client.listTablesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftdata.paginators.ListTablesPublisher publisher = client.listTablesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.redshiftdata.model.ListTablesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.redshiftdata.model.ListTablesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTables(software.amazon.awssdk.services.redshiftdata.model.ListTablesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTablesRequest.Builder} avoiding the need to
     * create one manually via {@link ListTablesRequest#builder()}
     * </p>
     *
     * @param listTablesRequest
     *        A {@link Consumer} that will call methods on {@link ListTablesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException The Amazon Redshift Data API operation failed due to invalid input.</li>
     *         <li>InternalServerException The Amazon Redshift Data API operation failed due to invalid input.</li>
     *         <li>DatabaseConnectionException Connection to a database failed.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>RedshiftDataException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample RedshiftDataAsyncClient.ListTables
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-data-2019-12-20/ListTables" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTablesPublisher listTablesPaginator(Consumer<ListTablesRequest.Builder> listTablesRequest) {
        return listTablesPaginator(ListTablesRequest.builder().applyMutation(listTablesRequest).build());
    }
}
