/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshiftdata;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.redshiftdata.DefaultRedshiftDataAsyncClient;
import software.amazon.awssdk.services.redshiftdata.DefaultRedshiftDataBaseClientBuilder;
import software.amazon.awssdk.services.redshiftdata.RedshiftDataAsyncClient;
import software.amazon.awssdk.services.redshiftdata.RedshiftDataAsyncClientBuilder;
import software.amazon.awssdk.services.redshiftdata.RedshiftDataServiceClientConfiguration;
import software.amazon.awssdk.services.redshiftdata.endpoints.RedshiftDataEndpointProvider;

@SdkInternalApi
final class DefaultRedshiftDataAsyncClientBuilder
extends DefaultRedshiftDataBaseClientBuilder<RedshiftDataAsyncClientBuilder, RedshiftDataAsyncClient>
implements RedshiftDataAsyncClientBuilder {
    DefaultRedshiftDataAsyncClientBuilder() {
    }

    @Override
    public DefaultRedshiftDataAsyncClientBuilder endpointProvider(RedshiftDataEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final RedshiftDataAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultRedshiftDataAsyncClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        RedshiftDataServiceClientConfiguration serviceClientConfiguration = RedshiftDataServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultRedshiftDataAsyncClient(serviceClientConfiguration, clientConfiguration);
    }
}

