/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshiftdata.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.redshiftdata.RedshiftDataClient;
import software.amazon.awssdk.services.redshiftdata.model.ListStatementsRequest;
import software.amazon.awssdk.services.redshiftdata.model.ListStatementsResponse;
import software.amazon.awssdk.services.redshiftdata.model.StatementData;

public class ListStatementsIterable
implements SdkIterable<ListStatementsResponse> {
    private final RedshiftDataClient client;
    private final ListStatementsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListStatementsIterable(RedshiftDataClient client, ListStatementsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListStatementsResponseFetcher();
    }

    public Iterator<ListStatementsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<StatementData> statements() {
        Function<ListStatementsResponse, Iterator> getIterator = response -> {
            if (response != null && response.statements() != null) {
                return response.statements().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListStatementsResponseFetcher
    implements SyncPageFetcher<ListStatementsResponse> {
        private ListStatementsResponseFetcher() {
        }

        public boolean hasNextPage(ListStatementsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListStatementsResponse nextPage(ListStatementsResponse previousPage) {
            if (previousPage == null) {
                return ListStatementsIterable.this.client.listStatements(ListStatementsIterable.this.firstRequest);
            }
            return ListStatementsIterable.this.client.listStatements((ListStatementsRequest)((Object)ListStatementsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

