/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshiftdata;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.redshiftdata.model.ActiveStatementsExceededException;
import software.amazon.awssdk.services.redshiftdata.model.BatchExecuteStatementException;
import software.amazon.awssdk.services.redshiftdata.model.BatchExecuteStatementRequest;
import software.amazon.awssdk.services.redshiftdata.model.BatchExecuteStatementResponse;
import software.amazon.awssdk.services.redshiftdata.model.CancelStatementRequest;
import software.amazon.awssdk.services.redshiftdata.model.CancelStatementResponse;
import software.amazon.awssdk.services.redshiftdata.model.DatabaseConnectionException;
import software.amazon.awssdk.services.redshiftdata.model.DescribeStatementRequest;
import software.amazon.awssdk.services.redshiftdata.model.DescribeStatementResponse;
import software.amazon.awssdk.services.redshiftdata.model.DescribeTableRequest;
import software.amazon.awssdk.services.redshiftdata.model.DescribeTableResponse;
import software.amazon.awssdk.services.redshiftdata.model.ExecuteStatementException;
import software.amazon.awssdk.services.redshiftdata.model.ExecuteStatementRequest;
import software.amazon.awssdk.services.redshiftdata.model.ExecuteStatementResponse;
import software.amazon.awssdk.services.redshiftdata.model.GetStatementResultRequest;
import software.amazon.awssdk.services.redshiftdata.model.GetStatementResultResponse;
import software.amazon.awssdk.services.redshiftdata.model.InternalServerException;
import software.amazon.awssdk.services.redshiftdata.model.ListDatabasesRequest;
import software.amazon.awssdk.services.redshiftdata.model.ListDatabasesResponse;
import software.amazon.awssdk.services.redshiftdata.model.ListSchemasRequest;
import software.amazon.awssdk.services.redshiftdata.model.ListSchemasResponse;
import software.amazon.awssdk.services.redshiftdata.model.ListStatementsRequest;
import software.amazon.awssdk.services.redshiftdata.model.ListStatementsResponse;
import software.amazon.awssdk.services.redshiftdata.model.ListTablesRequest;
import software.amazon.awssdk.services.redshiftdata.model.ListTablesResponse;
import software.amazon.awssdk.services.redshiftdata.model.RedshiftDataException;
import software.amazon.awssdk.services.redshiftdata.model.ResourceNotFoundException;
import software.amazon.awssdk.services.redshiftdata.model.ValidationException;
import software.amazon.awssdk.services.redshiftdata.paginators.DescribeTableIterable;
import software.amazon.awssdk.services.redshiftdata.paginators.GetStatementResultIterable;
import software.amazon.awssdk.services.redshiftdata.paginators.ListDatabasesIterable;
import software.amazon.awssdk.services.redshiftdata.paginators.ListSchemasIterable;
import software.amazon.awssdk.services.redshiftdata.paginators.ListStatementsIterable;
import software.amazon.awssdk.services.redshiftdata.paginators.ListTablesIterable;

/**
 * Service client for accessing Redshift Data API Service. This can be created using the static {@link #builder()}
 * method.
 *
 * <p>
 * You can use the Amazon Redshift Data API to run queries on Amazon Redshift tables. You can run SQL statements, which
 * are committed if the statement succeeds.
 * </p>
 * <p>
 * For more information about the Amazon Redshift Data API and CLI usage examples, see <a
 * href="https://docs.aws.amazon.com/redshift/latest/mgmt/data-api.html">Using the Amazon Redshift Data API</a> in the
 * <i>Amazon Redshift Management Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface RedshiftDataClient extends AwsClient {
    String SERVICE_NAME = "redshift-data";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "redshift-data";

    /**
     * <p>
     * Runs one or more SQL statements, which can be data manipulation language (DML) or data definition language (DDL).
     * Depending on the authorization method, use one of the following combinations of request parameters:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Secrets Manager - when connecting to a cluster, provide the <code>secret-arn</code> of a secret stored in Secrets
     * Manager which has <code>username</code> and <code>password</code>. The specified secret contains credentials to
     * connect to the <code>database</code> you specify. When you are connecting to a cluster, you also supply the
     * database name, If you provide a cluster identifier (<code>dbClusterIdentifier</code>), it must match the cluster
     * identifier stored in the secret. When you are connecting to a serverless workgroup, you also supply the database
     * name.
     * </p>
     * </li>
     * <li>
     * <p>
     * Temporary credentials - when connecting to your data warehouse, choose one of the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * When connecting to a serverless workgroup, specify the workgroup name and database name. The database user name
     * is derived from the IAM identity. For example, <code>arn:iam::123456789012:user:foo</code> has the database user
     * name <code>IAM:foo</code>. Also, permission to call the <code>redshift-serverless:GetCredentials</code> operation
     * is required.
     * </p>
     * </li>
     * <li>
     * <p>
     * When connecting to a cluster as an IAM identity, specify the cluster identifier and the database name. The
     * database user name is derived from the IAM identity. For example, <code>arn:iam::123456789012:user:foo</code> has
     * the database user name <code>IAM:foo</code>. Also, permission to call the
     * <code>redshift:GetClusterCredentialsWithIAM</code> operation is required.
     * </p>
     * </li>
     * <li>
     * <p>
     * When connecting to a cluster as a database user, specify the cluster identifier, the database name, and the
     * database user name. Also, permission to call the <code>redshift:GetClusterCredentials</code> operation is
     * required.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * For more information about the Amazon Redshift Data API and CLI usage examples, see <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/data-api.html">Using the Amazon Redshift Data API</a> in
     * the <i>Amazon Redshift Management Guide</i>.
     * </p>
     *
     * @param batchExecuteStatementRequest
     * @return Result of the BatchExecuteStatement operation returned by the service.
     * @throws ValidationException
     *         The Amazon Redshift Data API operation failed due to invalid input.
     * @throws ActiveStatementsExceededException
     *         The number of active statements exceeds the limit.
     * @throws BatchExecuteStatementException
     *         An SQL statement encountered an environmental error while running.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftDataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftDataClient.BatchExecuteStatement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-data-2019-12-20/BatchExecuteStatement"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchExecuteStatementResponse batchExecuteStatement(BatchExecuteStatementRequest batchExecuteStatementRequest)
            throws ValidationException, ActiveStatementsExceededException, BatchExecuteStatementException, AwsServiceException,
            SdkClientException, RedshiftDataException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Runs one or more SQL statements, which can be data manipulation language (DML) or data definition language (DDL).
     * Depending on the authorization method, use one of the following combinations of request parameters:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Secrets Manager - when connecting to a cluster, provide the <code>secret-arn</code> of a secret stored in Secrets
     * Manager which has <code>username</code> and <code>password</code>. The specified secret contains credentials to
     * connect to the <code>database</code> you specify. When you are connecting to a cluster, you also supply the
     * database name, If you provide a cluster identifier (<code>dbClusterIdentifier</code>), it must match the cluster
     * identifier stored in the secret. When you are connecting to a serverless workgroup, you also supply the database
     * name.
     * </p>
     * </li>
     * <li>
     * <p>
     * Temporary credentials - when connecting to your data warehouse, choose one of the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * When connecting to a serverless workgroup, specify the workgroup name and database name. The database user name
     * is derived from the IAM identity. For example, <code>arn:iam::123456789012:user:foo</code> has the database user
     * name <code>IAM:foo</code>. Also, permission to call the <code>redshift-serverless:GetCredentials</code> operation
     * is required.
     * </p>
     * </li>
     * <li>
     * <p>
     * When connecting to a cluster as an IAM identity, specify the cluster identifier and the database name. The
     * database user name is derived from the IAM identity. For example, <code>arn:iam::123456789012:user:foo</code> has
     * the database user name <code>IAM:foo</code>. Also, permission to call the
     * <code>redshift:GetClusterCredentialsWithIAM</code> operation is required.
     * </p>
     * </li>
     * <li>
     * <p>
     * When connecting to a cluster as a database user, specify the cluster identifier, the database name, and the
     * database user name. Also, permission to call the <code>redshift:GetClusterCredentials</code> operation is
     * required.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * For more information about the Amazon Redshift Data API and CLI usage examples, see <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/data-api.html">Using the Amazon Redshift Data API</a> in
     * the <i>Amazon Redshift Management Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchExecuteStatementRequest.Builder} avoiding the
     * need to create one manually via {@link BatchExecuteStatementRequest#builder()}
     * </p>
     *
     * @param batchExecuteStatementRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftdata.model.BatchExecuteStatementRequest.Builder} to create
     *        a request.
     * @return Result of the BatchExecuteStatement operation returned by the service.
     * @throws ValidationException
     *         The Amazon Redshift Data API operation failed due to invalid input.
     * @throws ActiveStatementsExceededException
     *         The number of active statements exceeds the limit.
     * @throws BatchExecuteStatementException
     *         An SQL statement encountered an environmental error while running.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftDataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftDataClient.BatchExecuteStatement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-data-2019-12-20/BatchExecuteStatement"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchExecuteStatementResponse batchExecuteStatement(
            Consumer<BatchExecuteStatementRequest.Builder> batchExecuteStatementRequest) throws ValidationException,
            ActiveStatementsExceededException, BatchExecuteStatementException, AwsServiceException, SdkClientException,
            RedshiftDataException {
        return batchExecuteStatement(BatchExecuteStatementRequest.builder().applyMutation(batchExecuteStatementRequest).build());
    }

    /**
     * <p>
     * Cancels a running query. To be canceled, a query must be running.
     * </p>
     * <p>
     * For more information about the Amazon Redshift Data API and CLI usage examples, see <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/data-api.html">Using the Amazon Redshift Data API</a> in
     * the <i>Amazon Redshift Management Guide</i>.
     * </p>
     *
     * @param cancelStatementRequest
     * @return Result of the CancelStatement operation returned by the service.
     * @throws ValidationException
     *         The Amazon Redshift Data API operation failed due to invalid input.
     * @throws ResourceNotFoundException
     *         The Amazon Redshift Data API operation failed due to a missing resource.
     * @throws InternalServerException
     *         The Amazon Redshift Data API operation failed due to invalid input.
     * @throws DatabaseConnectionException
     *         Connection to a database failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftDataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftDataClient.CancelStatement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-data-2019-12-20/CancelStatement" target="_top">AWS
     *      API Documentation</a>
     */
    default CancelStatementResponse cancelStatement(CancelStatementRequest cancelStatementRequest) throws ValidationException,
            ResourceNotFoundException, InternalServerException, DatabaseConnectionException, AwsServiceException,
            SdkClientException, RedshiftDataException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels a running query. To be canceled, a query must be running.
     * </p>
     * <p>
     * For more information about the Amazon Redshift Data API and CLI usage examples, see <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/data-api.html">Using the Amazon Redshift Data API</a> in
     * the <i>Amazon Redshift Management Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelStatementRequest.Builder} avoiding the need
     * to create one manually via {@link CancelStatementRequest#builder()}
     * </p>
     *
     * @param cancelStatementRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftdata.model.CancelStatementRequest.Builder} to create a
     *        request.
     * @return Result of the CancelStatement operation returned by the service.
     * @throws ValidationException
     *         The Amazon Redshift Data API operation failed due to invalid input.
     * @throws ResourceNotFoundException
     *         The Amazon Redshift Data API operation failed due to a missing resource.
     * @throws InternalServerException
     *         The Amazon Redshift Data API operation failed due to invalid input.
     * @throws DatabaseConnectionException
     *         Connection to a database failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftDataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftDataClient.CancelStatement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-data-2019-12-20/CancelStatement" target="_top">AWS
     *      API Documentation</a>
     */
    default CancelStatementResponse cancelStatement(Consumer<CancelStatementRequest.Builder> cancelStatementRequest)
            throws ValidationException, ResourceNotFoundException, InternalServerException, DatabaseConnectionException,
            AwsServiceException, SdkClientException, RedshiftDataException {
        return cancelStatement(CancelStatementRequest.builder().applyMutation(cancelStatementRequest).build());
    }

    /**
     * <p>
     * Describes the details about a specific instance when a query was run by the Amazon Redshift Data API. The
     * information includes when the query started, when it finished, the query status, the number of rows returned, and
     * the SQL statement.
     * </p>
     * <p>
     * For more information about the Amazon Redshift Data API and CLI usage examples, see <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/data-api.html">Using the Amazon Redshift Data API</a> in
     * the <i>Amazon Redshift Management Guide</i>.
     * </p>
     *
     * @param describeStatementRequest
     * @return Result of the DescribeStatement operation returned by the service.
     * @throws ValidationException
     *         The Amazon Redshift Data API operation failed due to invalid input.
     * @throws ResourceNotFoundException
     *         The Amazon Redshift Data API operation failed due to a missing resource.
     * @throws InternalServerException
     *         The Amazon Redshift Data API operation failed due to invalid input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftDataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftDataClient.DescribeStatement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-data-2019-12-20/DescribeStatement"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeStatementResponse describeStatement(DescribeStatementRequest describeStatementRequest)
            throws ValidationException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, RedshiftDataException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the details about a specific instance when a query was run by the Amazon Redshift Data API. The
     * information includes when the query started, when it finished, the query status, the number of rows returned, and
     * the SQL statement.
     * </p>
     * <p>
     * For more information about the Amazon Redshift Data API and CLI usage examples, see <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/data-api.html">Using the Amazon Redshift Data API</a> in
     * the <i>Amazon Redshift Management Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeStatementRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeStatementRequest#builder()}
     * </p>
     *
     * @param describeStatementRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftdata.model.DescribeStatementRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeStatement operation returned by the service.
     * @throws ValidationException
     *         The Amazon Redshift Data API operation failed due to invalid input.
     * @throws ResourceNotFoundException
     *         The Amazon Redshift Data API operation failed due to a missing resource.
     * @throws InternalServerException
     *         The Amazon Redshift Data API operation failed due to invalid input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftDataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftDataClient.DescribeStatement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-data-2019-12-20/DescribeStatement"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeStatementResponse describeStatement(Consumer<DescribeStatementRequest.Builder> describeStatementRequest)
            throws ValidationException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, RedshiftDataException {
        return describeStatement(DescribeStatementRequest.builder().applyMutation(describeStatementRequest).build());
    }

    /**
     * <p>
     * Describes the detailed information about a table from metadata in the cluster. The information includes its
     * columns. A token is returned to page through the column list. Depending on the authorization method, use one of
     * the following combinations of request parameters:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Secrets Manager - when connecting to a cluster, provide the <code>secret-arn</code> of a secret stored in Secrets
     * Manager which has <code>username</code> and <code>password</code>. The specified secret contains credentials to
     * connect to the <code>database</code> you specify. When you are connecting to a cluster, you also supply the
     * database name, If you provide a cluster identifier (<code>dbClusterIdentifier</code>), it must match the cluster
     * identifier stored in the secret. When you are connecting to a serverless workgroup, you also supply the database
     * name.
     * </p>
     * </li>
     * <li>
     * <p>
     * Temporary credentials - when connecting to your data warehouse, choose one of the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * When connecting to a serverless workgroup, specify the workgroup name and database name. The database user name
     * is derived from the IAM identity. For example, <code>arn:iam::123456789012:user:foo</code> has the database user
     * name <code>IAM:foo</code>. Also, permission to call the <code>redshift-serverless:GetCredentials</code> operation
     * is required.
     * </p>
     * </li>
     * <li>
     * <p>
     * When connecting to a cluster as an IAM identity, specify the cluster identifier and the database name. The
     * database user name is derived from the IAM identity. For example, <code>arn:iam::123456789012:user:foo</code> has
     * the database user name <code>IAM:foo</code>. Also, permission to call the
     * <code>redshift:GetClusterCredentialsWithIAM</code> operation is required.
     * </p>
     * </li>
     * <li>
     * <p>
     * When connecting to a cluster as a database user, specify the cluster identifier, the database name, and the
     * database user name. Also, permission to call the <code>redshift:GetClusterCredentials</code> operation is
     * required.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * For more information about the Amazon Redshift Data API and CLI usage examples, see <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/data-api.html">Using the Amazon Redshift Data API</a> in
     * the <i>Amazon Redshift Management Guide</i>.
     * </p>
     *
     * @param describeTableRequest
     * @return Result of the DescribeTable operation returned by the service.
     * @throws ValidationException
     *         The Amazon Redshift Data API operation failed due to invalid input.
     * @throws InternalServerException
     *         The Amazon Redshift Data API operation failed due to invalid input.
     * @throws DatabaseConnectionException
     *         Connection to a database failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftDataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftDataClient.DescribeTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-data-2019-12-20/DescribeTable" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeTableResponse describeTable(DescribeTableRequest describeTableRequest) throws ValidationException,
            InternalServerException, DatabaseConnectionException, AwsServiceException, SdkClientException, RedshiftDataException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the detailed information about a table from metadata in the cluster. The information includes its
     * columns. A token is returned to page through the column list. Depending on the authorization method, use one of
     * the following combinations of request parameters:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Secrets Manager - when connecting to a cluster, provide the <code>secret-arn</code> of a secret stored in Secrets
     * Manager which has <code>username</code> and <code>password</code>. The specified secret contains credentials to
     * connect to the <code>database</code> you specify. When you are connecting to a cluster, you also supply the
     * database name, If you provide a cluster identifier (<code>dbClusterIdentifier</code>), it must match the cluster
     * identifier stored in the secret. When you are connecting to a serverless workgroup, you also supply the database
     * name.
     * </p>
     * </li>
     * <li>
     * <p>
     * Temporary credentials - when connecting to your data warehouse, choose one of the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * When connecting to a serverless workgroup, specify the workgroup name and database name. The database user name
     * is derived from the IAM identity. For example, <code>arn:iam::123456789012:user:foo</code> has the database user
     * name <code>IAM:foo</code>. Also, permission to call the <code>redshift-serverless:GetCredentials</code> operation
     * is required.
     * </p>
     * </li>
     * <li>
     * <p>
     * When connecting to a cluster as an IAM identity, specify the cluster identifier and the database name. The
     * database user name is derived from the IAM identity. For example, <code>arn:iam::123456789012:user:foo</code> has
     * the database user name <code>IAM:foo</code>. Also, permission to call the
     * <code>redshift:GetClusterCredentialsWithIAM</code> operation is required.
     * </p>
     * </li>
     * <li>
     * <p>
     * When connecting to a cluster as a database user, specify the cluster identifier, the database name, and the
     * database user name. Also, permission to call the <code>redshift:GetClusterCredentials</code> operation is
     * required.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * For more information about the Amazon Redshift Data API and CLI usage examples, see <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/data-api.html">Using the Amazon Redshift Data API</a> in
     * the <i>Amazon Redshift Management Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTableRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeTableRequest#builder()}
     * </p>
     *
     * @param describeTableRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftdata.model.DescribeTableRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeTable operation returned by the service.
     * @throws ValidationException
     *         The Amazon Redshift Data API operation failed due to invalid input.
     * @throws InternalServerException
     *         The Amazon Redshift Data API operation failed due to invalid input.
     * @throws DatabaseConnectionException
     *         Connection to a database failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftDataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftDataClient.DescribeTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-data-2019-12-20/DescribeTable" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeTableResponse describeTable(Consumer<DescribeTableRequest.Builder> describeTableRequest)
            throws ValidationException, InternalServerException, DatabaseConnectionException, AwsServiceException,
            SdkClientException, RedshiftDataException {
        return describeTable(DescribeTableRequest.builder().applyMutation(describeTableRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeTable(software.amazon.awssdk.services.redshiftdata.model.DescribeTableRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftdata.paginators.DescribeTableIterable responses = client.describeTablePaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.redshiftdata.paginators.DescribeTableIterable responses = client
     *             .describeTablePaginator(request);
     *     for (software.amazon.awssdk.services.redshiftdata.model.DescribeTableResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftdata.paginators.DescribeTableIterable responses = client.describeTablePaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeTable(software.amazon.awssdk.services.redshiftdata.model.DescribeTableRequest)} operation.</b>
     * </p>
     *
     * @param describeTableRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The Amazon Redshift Data API operation failed due to invalid input.
     * @throws InternalServerException
     *         The Amazon Redshift Data API operation failed due to invalid input.
     * @throws DatabaseConnectionException
     *         Connection to a database failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftDataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftDataClient.DescribeTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-data-2019-12-20/DescribeTable" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeTableIterable describeTablePaginator(DescribeTableRequest describeTableRequest) throws ValidationException,
            InternalServerException, DatabaseConnectionException, AwsServiceException, SdkClientException, RedshiftDataException {
        return new DescribeTableIterable(this, describeTableRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeTable(software.amazon.awssdk.services.redshiftdata.model.DescribeTableRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftdata.paginators.DescribeTableIterable responses = client.describeTablePaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.redshiftdata.paginators.DescribeTableIterable responses = client
     *             .describeTablePaginator(request);
     *     for (software.amazon.awssdk.services.redshiftdata.model.DescribeTableResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftdata.paginators.DescribeTableIterable responses = client.describeTablePaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeTable(software.amazon.awssdk.services.redshiftdata.model.DescribeTableRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTableRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeTableRequest#builder()}
     * </p>
     *
     * @param describeTableRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftdata.model.DescribeTableRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The Amazon Redshift Data API operation failed due to invalid input.
     * @throws InternalServerException
     *         The Amazon Redshift Data API operation failed due to invalid input.
     * @throws DatabaseConnectionException
     *         Connection to a database failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftDataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftDataClient.DescribeTable
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-data-2019-12-20/DescribeTable" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeTableIterable describeTablePaginator(Consumer<DescribeTableRequest.Builder> describeTableRequest)
            throws ValidationException, InternalServerException, DatabaseConnectionException, AwsServiceException,
            SdkClientException, RedshiftDataException {
        return describeTablePaginator(DescribeTableRequest.builder().applyMutation(describeTableRequest).build());
    }

    /**
     * <p>
     * Runs an SQL statement, which can be data manipulation language (DML) or data definition language (DDL). This
     * statement must be a single SQL statement. Depending on the authorization method, use one of the following
     * combinations of request parameters:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Secrets Manager - when connecting to a cluster, provide the <code>secret-arn</code> of a secret stored in Secrets
     * Manager which has <code>username</code> and <code>password</code>. The specified secret contains credentials to
     * connect to the <code>database</code> you specify. When you are connecting to a cluster, you also supply the
     * database name, If you provide a cluster identifier (<code>dbClusterIdentifier</code>), it must match the cluster
     * identifier stored in the secret. When you are connecting to a serverless workgroup, you also supply the database
     * name.
     * </p>
     * </li>
     * <li>
     * <p>
     * Temporary credentials - when connecting to your data warehouse, choose one of the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * When connecting to a serverless workgroup, specify the workgroup name and database name. The database user name
     * is derived from the IAM identity. For example, <code>arn:iam::123456789012:user:foo</code> has the database user
     * name <code>IAM:foo</code>. Also, permission to call the <code>redshift-serverless:GetCredentials</code> operation
     * is required.
     * </p>
     * </li>
     * <li>
     * <p>
     * When connecting to a cluster as an IAM identity, specify the cluster identifier and the database name. The
     * database user name is derived from the IAM identity. For example, <code>arn:iam::123456789012:user:foo</code> has
     * the database user name <code>IAM:foo</code>. Also, permission to call the
     * <code>redshift:GetClusterCredentialsWithIAM</code> operation is required.
     * </p>
     * </li>
     * <li>
     * <p>
     * When connecting to a cluster as a database user, specify the cluster identifier, the database name, and the
     * database user name. Also, permission to call the <code>redshift:GetClusterCredentials</code> operation is
     * required.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * For more information about the Amazon Redshift Data API and CLI usage examples, see <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/data-api.html">Using the Amazon Redshift Data API</a> in
     * the <i>Amazon Redshift Management Guide</i>.
     * </p>
     *
     * @param executeStatementRequest
     * @return Result of the ExecuteStatement operation returned by the service.
     * @throws ValidationException
     *         The Amazon Redshift Data API operation failed due to invalid input.
     * @throws ExecuteStatementException
     *         The SQL statement encountered an environmental error while running.
     * @throws ActiveStatementsExceededException
     *         The number of active statements exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftDataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftDataClient.ExecuteStatement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-data-2019-12-20/ExecuteStatement"
     *      target="_top">AWS API Documentation</a>
     */
    default ExecuteStatementResponse executeStatement(ExecuteStatementRequest executeStatementRequest)
            throws ValidationException, ExecuteStatementException, ActiveStatementsExceededException, AwsServiceException,
            SdkClientException, RedshiftDataException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Runs an SQL statement, which can be data manipulation language (DML) or data definition language (DDL). This
     * statement must be a single SQL statement. Depending on the authorization method, use one of the following
     * combinations of request parameters:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Secrets Manager - when connecting to a cluster, provide the <code>secret-arn</code> of a secret stored in Secrets
     * Manager which has <code>username</code> and <code>password</code>. The specified secret contains credentials to
     * connect to the <code>database</code> you specify. When you are connecting to a cluster, you also supply the
     * database name, If you provide a cluster identifier (<code>dbClusterIdentifier</code>), it must match the cluster
     * identifier stored in the secret. When you are connecting to a serverless workgroup, you also supply the database
     * name.
     * </p>
     * </li>
     * <li>
     * <p>
     * Temporary credentials - when connecting to your data warehouse, choose one of the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * When connecting to a serverless workgroup, specify the workgroup name and database name. The database user name
     * is derived from the IAM identity. For example, <code>arn:iam::123456789012:user:foo</code> has the database user
     * name <code>IAM:foo</code>. Also, permission to call the <code>redshift-serverless:GetCredentials</code> operation
     * is required.
     * </p>
     * </li>
     * <li>
     * <p>
     * When connecting to a cluster as an IAM identity, specify the cluster identifier and the database name. The
     * database user name is derived from the IAM identity. For example, <code>arn:iam::123456789012:user:foo</code> has
     * the database user name <code>IAM:foo</code>. Also, permission to call the
     * <code>redshift:GetClusterCredentialsWithIAM</code> operation is required.
     * </p>
     * </li>
     * <li>
     * <p>
     * When connecting to a cluster as a database user, specify the cluster identifier, the database name, and the
     * database user name. Also, permission to call the <code>redshift:GetClusterCredentials</code> operation is
     * required.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * For more information about the Amazon Redshift Data API and CLI usage examples, see <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/data-api.html">Using the Amazon Redshift Data API</a> in
     * the <i>Amazon Redshift Management Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ExecuteStatementRequest.Builder} avoiding the need
     * to create one manually via {@link ExecuteStatementRequest#builder()}
     * </p>
     *
     * @param executeStatementRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftdata.model.ExecuteStatementRequest.Builder} to create a
     *        request.
     * @return Result of the ExecuteStatement operation returned by the service.
     * @throws ValidationException
     *         The Amazon Redshift Data API operation failed due to invalid input.
     * @throws ExecuteStatementException
     *         The SQL statement encountered an environmental error while running.
     * @throws ActiveStatementsExceededException
     *         The number of active statements exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftDataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftDataClient.ExecuteStatement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-data-2019-12-20/ExecuteStatement"
     *      target="_top">AWS API Documentation</a>
     */
    default ExecuteStatementResponse executeStatement(Consumer<ExecuteStatementRequest.Builder> executeStatementRequest)
            throws ValidationException, ExecuteStatementException, ActiveStatementsExceededException, AwsServiceException,
            SdkClientException, RedshiftDataException {
        return executeStatement(ExecuteStatementRequest.builder().applyMutation(executeStatementRequest).build());
    }

    /**
     * <p>
     * Fetches the temporarily cached result of an SQL statement. A token is returned to page through the statement
     * results.
     * </p>
     * <p>
     * For more information about the Amazon Redshift Data API and CLI usage examples, see <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/data-api.html">Using the Amazon Redshift Data API</a> in
     * the <i>Amazon Redshift Management Guide</i>.
     * </p>
     *
     * @param getStatementResultRequest
     * @return Result of the GetStatementResult operation returned by the service.
     * @throws ValidationException
     *         The Amazon Redshift Data API operation failed due to invalid input.
     * @throws ResourceNotFoundException
     *         The Amazon Redshift Data API operation failed due to a missing resource.
     * @throws InternalServerException
     *         The Amazon Redshift Data API operation failed due to invalid input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftDataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftDataClient.GetStatementResult
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-data-2019-12-20/GetStatementResult"
     *      target="_top">AWS API Documentation</a>
     */
    default GetStatementResultResponse getStatementResult(GetStatementResultRequest getStatementResultRequest)
            throws ValidationException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, RedshiftDataException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Fetches the temporarily cached result of an SQL statement. A token is returned to page through the statement
     * results.
     * </p>
     * <p>
     * For more information about the Amazon Redshift Data API and CLI usage examples, see <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/data-api.html">Using the Amazon Redshift Data API</a> in
     * the <i>Amazon Redshift Management Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetStatementResultRequest.Builder} avoiding the
     * need to create one manually via {@link GetStatementResultRequest#builder()}
     * </p>
     *
     * @param getStatementResultRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftdata.model.GetStatementResultRequest.Builder} to create a
     *        request.
     * @return Result of the GetStatementResult operation returned by the service.
     * @throws ValidationException
     *         The Amazon Redshift Data API operation failed due to invalid input.
     * @throws ResourceNotFoundException
     *         The Amazon Redshift Data API operation failed due to a missing resource.
     * @throws InternalServerException
     *         The Amazon Redshift Data API operation failed due to invalid input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftDataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftDataClient.GetStatementResult
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-data-2019-12-20/GetStatementResult"
     *      target="_top">AWS API Documentation</a>
     */
    default GetStatementResultResponse getStatementResult(Consumer<GetStatementResultRequest.Builder> getStatementResultRequest)
            throws ValidationException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, RedshiftDataException {
        return getStatementResult(GetStatementResultRequest.builder().applyMutation(getStatementResultRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getStatementResult(software.amazon.awssdk.services.redshiftdata.model.GetStatementResultRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftdata.paginators.GetStatementResultIterable responses = client.getStatementResultPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.redshiftdata.paginators.GetStatementResultIterable responses = client
     *             .getStatementResultPaginator(request);
     *     for (software.amazon.awssdk.services.redshiftdata.model.GetStatementResultResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftdata.paginators.GetStatementResultIterable responses = client.getStatementResultPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getStatementResult(software.amazon.awssdk.services.redshiftdata.model.GetStatementResultRequest)}
     * operation.</b>
     * </p>
     *
     * @param getStatementResultRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The Amazon Redshift Data API operation failed due to invalid input.
     * @throws ResourceNotFoundException
     *         The Amazon Redshift Data API operation failed due to a missing resource.
     * @throws InternalServerException
     *         The Amazon Redshift Data API operation failed due to invalid input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftDataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftDataClient.GetStatementResult
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-data-2019-12-20/GetStatementResult"
     *      target="_top">AWS API Documentation</a>
     */
    default GetStatementResultIterable getStatementResultPaginator(GetStatementResultRequest getStatementResultRequest)
            throws ValidationException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, RedshiftDataException {
        return new GetStatementResultIterable(this, getStatementResultRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getStatementResult(software.amazon.awssdk.services.redshiftdata.model.GetStatementResultRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftdata.paginators.GetStatementResultIterable responses = client.getStatementResultPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.redshiftdata.paginators.GetStatementResultIterable responses = client
     *             .getStatementResultPaginator(request);
     *     for (software.amazon.awssdk.services.redshiftdata.model.GetStatementResultResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftdata.paginators.GetStatementResultIterable responses = client.getStatementResultPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getStatementResult(software.amazon.awssdk.services.redshiftdata.model.GetStatementResultRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetStatementResultRequest.Builder} avoiding the
     * need to create one manually via {@link GetStatementResultRequest#builder()}
     * </p>
     *
     * @param getStatementResultRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftdata.model.GetStatementResultRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The Amazon Redshift Data API operation failed due to invalid input.
     * @throws ResourceNotFoundException
     *         The Amazon Redshift Data API operation failed due to a missing resource.
     * @throws InternalServerException
     *         The Amazon Redshift Data API operation failed due to invalid input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftDataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftDataClient.GetStatementResult
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-data-2019-12-20/GetStatementResult"
     *      target="_top">AWS API Documentation</a>
     */
    default GetStatementResultIterable getStatementResultPaginator(
            Consumer<GetStatementResultRequest.Builder> getStatementResultRequest) throws ValidationException,
            ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, RedshiftDataException {
        return getStatementResultPaginator(GetStatementResultRequest.builder().applyMutation(getStatementResultRequest).build());
    }

    /**
     * <p>
     * List the databases in a cluster. A token is returned to page through the database list. Depending on the
     * authorization method, use one of the following combinations of request parameters:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Secrets Manager - when connecting to a cluster, provide the <code>secret-arn</code> of a secret stored in Secrets
     * Manager which has <code>username</code> and <code>password</code>. The specified secret contains credentials to
     * connect to the <code>database</code> you specify. When you are connecting to a cluster, you also supply the
     * database name, If you provide a cluster identifier (<code>dbClusterIdentifier</code>), it must match the cluster
     * identifier stored in the secret. When you are connecting to a serverless workgroup, you also supply the database
     * name.
     * </p>
     * </li>
     * <li>
     * <p>
     * Temporary credentials - when connecting to your data warehouse, choose one of the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * When connecting to a serverless workgroup, specify the workgroup name and database name. The database user name
     * is derived from the IAM identity. For example, <code>arn:iam::123456789012:user:foo</code> has the database user
     * name <code>IAM:foo</code>. Also, permission to call the <code>redshift-serverless:GetCredentials</code> operation
     * is required.
     * </p>
     * </li>
     * <li>
     * <p>
     * When connecting to a cluster as an IAM identity, specify the cluster identifier and the database name. The
     * database user name is derived from the IAM identity. For example, <code>arn:iam::123456789012:user:foo</code> has
     * the database user name <code>IAM:foo</code>. Also, permission to call the
     * <code>redshift:GetClusterCredentialsWithIAM</code> operation is required.
     * </p>
     * </li>
     * <li>
     * <p>
     * When connecting to a cluster as a database user, specify the cluster identifier, the database name, and the
     * database user name. Also, permission to call the <code>redshift:GetClusterCredentials</code> operation is
     * required.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * For more information about the Amazon Redshift Data API and CLI usage examples, see <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/data-api.html">Using the Amazon Redshift Data API</a> in
     * the <i>Amazon Redshift Management Guide</i>.
     * </p>
     *
     * @param listDatabasesRequest
     * @return Result of the ListDatabases operation returned by the service.
     * @throws ValidationException
     *         The Amazon Redshift Data API operation failed due to invalid input.
     * @throws InternalServerException
     *         The Amazon Redshift Data API operation failed due to invalid input.
     * @throws DatabaseConnectionException
     *         Connection to a database failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftDataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftDataClient.ListDatabases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-data-2019-12-20/ListDatabases" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDatabasesResponse listDatabases(ListDatabasesRequest listDatabasesRequest) throws ValidationException,
            InternalServerException, DatabaseConnectionException, AwsServiceException, SdkClientException, RedshiftDataException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the databases in a cluster. A token is returned to page through the database list. Depending on the
     * authorization method, use one of the following combinations of request parameters:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Secrets Manager - when connecting to a cluster, provide the <code>secret-arn</code> of a secret stored in Secrets
     * Manager which has <code>username</code> and <code>password</code>. The specified secret contains credentials to
     * connect to the <code>database</code> you specify. When you are connecting to a cluster, you also supply the
     * database name, If you provide a cluster identifier (<code>dbClusterIdentifier</code>), it must match the cluster
     * identifier stored in the secret. When you are connecting to a serverless workgroup, you also supply the database
     * name.
     * </p>
     * </li>
     * <li>
     * <p>
     * Temporary credentials - when connecting to your data warehouse, choose one of the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * When connecting to a serverless workgroup, specify the workgroup name and database name. The database user name
     * is derived from the IAM identity. For example, <code>arn:iam::123456789012:user:foo</code> has the database user
     * name <code>IAM:foo</code>. Also, permission to call the <code>redshift-serverless:GetCredentials</code> operation
     * is required.
     * </p>
     * </li>
     * <li>
     * <p>
     * When connecting to a cluster as an IAM identity, specify the cluster identifier and the database name. The
     * database user name is derived from the IAM identity. For example, <code>arn:iam::123456789012:user:foo</code> has
     * the database user name <code>IAM:foo</code>. Also, permission to call the
     * <code>redshift:GetClusterCredentialsWithIAM</code> operation is required.
     * </p>
     * </li>
     * <li>
     * <p>
     * When connecting to a cluster as a database user, specify the cluster identifier, the database name, and the
     * database user name. Also, permission to call the <code>redshift:GetClusterCredentials</code> operation is
     * required.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * For more information about the Amazon Redshift Data API and CLI usage examples, see <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/data-api.html">Using the Amazon Redshift Data API</a> in
     * the <i>Amazon Redshift Management Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDatabasesRequest.Builder} avoiding the need to
     * create one manually via {@link ListDatabasesRequest#builder()}
     * </p>
     *
     * @param listDatabasesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftdata.model.ListDatabasesRequest.Builder} to create a
     *        request.
     * @return Result of the ListDatabases operation returned by the service.
     * @throws ValidationException
     *         The Amazon Redshift Data API operation failed due to invalid input.
     * @throws InternalServerException
     *         The Amazon Redshift Data API operation failed due to invalid input.
     * @throws DatabaseConnectionException
     *         Connection to a database failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftDataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftDataClient.ListDatabases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-data-2019-12-20/ListDatabases" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDatabasesResponse listDatabases(Consumer<ListDatabasesRequest.Builder> listDatabasesRequest)
            throws ValidationException, InternalServerException, DatabaseConnectionException, AwsServiceException,
            SdkClientException, RedshiftDataException {
        return listDatabases(ListDatabasesRequest.builder().applyMutation(listDatabasesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDatabases(software.amazon.awssdk.services.redshiftdata.model.ListDatabasesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftdata.paginators.ListDatabasesIterable responses = client.listDatabasesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.redshiftdata.paginators.ListDatabasesIterable responses = client
     *             .listDatabasesPaginator(request);
     *     for (software.amazon.awssdk.services.redshiftdata.model.ListDatabasesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftdata.paginators.ListDatabasesIterable responses = client.listDatabasesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDatabases(software.amazon.awssdk.services.redshiftdata.model.ListDatabasesRequest)} operation.</b>
     * </p>
     *
     * @param listDatabasesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The Amazon Redshift Data API operation failed due to invalid input.
     * @throws InternalServerException
     *         The Amazon Redshift Data API operation failed due to invalid input.
     * @throws DatabaseConnectionException
     *         Connection to a database failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftDataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftDataClient.ListDatabases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-data-2019-12-20/ListDatabases" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDatabasesIterable listDatabasesPaginator(ListDatabasesRequest listDatabasesRequest) throws ValidationException,
            InternalServerException, DatabaseConnectionException, AwsServiceException, SdkClientException, RedshiftDataException {
        return new ListDatabasesIterable(this, listDatabasesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDatabases(software.amazon.awssdk.services.redshiftdata.model.ListDatabasesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftdata.paginators.ListDatabasesIterable responses = client.listDatabasesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.redshiftdata.paginators.ListDatabasesIterable responses = client
     *             .listDatabasesPaginator(request);
     *     for (software.amazon.awssdk.services.redshiftdata.model.ListDatabasesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftdata.paginators.ListDatabasesIterable responses = client.listDatabasesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDatabases(software.amazon.awssdk.services.redshiftdata.model.ListDatabasesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDatabasesRequest.Builder} avoiding the need to
     * create one manually via {@link ListDatabasesRequest#builder()}
     * </p>
     *
     * @param listDatabasesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftdata.model.ListDatabasesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The Amazon Redshift Data API operation failed due to invalid input.
     * @throws InternalServerException
     *         The Amazon Redshift Data API operation failed due to invalid input.
     * @throws DatabaseConnectionException
     *         Connection to a database failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftDataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftDataClient.ListDatabases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-data-2019-12-20/ListDatabases" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDatabasesIterable listDatabasesPaginator(Consumer<ListDatabasesRequest.Builder> listDatabasesRequest)
            throws ValidationException, InternalServerException, DatabaseConnectionException, AwsServiceException,
            SdkClientException, RedshiftDataException {
        return listDatabasesPaginator(ListDatabasesRequest.builder().applyMutation(listDatabasesRequest).build());
    }

    /**
     * <p>
     * Lists the schemas in a database. A token is returned to page through the schema list. Depending on the
     * authorization method, use one of the following combinations of request parameters:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Secrets Manager - when connecting to a cluster, provide the <code>secret-arn</code> of a secret stored in Secrets
     * Manager which has <code>username</code> and <code>password</code>. The specified secret contains credentials to
     * connect to the <code>database</code> you specify. When you are connecting to a cluster, you also supply the
     * database name, If you provide a cluster identifier (<code>dbClusterIdentifier</code>), it must match the cluster
     * identifier stored in the secret. When you are connecting to a serverless workgroup, you also supply the database
     * name.
     * </p>
     * </li>
     * <li>
     * <p>
     * Temporary credentials - when connecting to your data warehouse, choose one of the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * When connecting to a serverless workgroup, specify the workgroup name and database name. The database user name
     * is derived from the IAM identity. For example, <code>arn:iam::123456789012:user:foo</code> has the database user
     * name <code>IAM:foo</code>. Also, permission to call the <code>redshift-serverless:GetCredentials</code> operation
     * is required.
     * </p>
     * </li>
     * <li>
     * <p>
     * When connecting to a cluster as an IAM identity, specify the cluster identifier and the database name. The
     * database user name is derived from the IAM identity. For example, <code>arn:iam::123456789012:user:foo</code> has
     * the database user name <code>IAM:foo</code>. Also, permission to call the
     * <code>redshift:GetClusterCredentialsWithIAM</code> operation is required.
     * </p>
     * </li>
     * <li>
     * <p>
     * When connecting to a cluster as a database user, specify the cluster identifier, the database name, and the
     * database user name. Also, permission to call the <code>redshift:GetClusterCredentials</code> operation is
     * required.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * For more information about the Amazon Redshift Data API and CLI usage examples, see <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/data-api.html">Using the Amazon Redshift Data API</a> in
     * the <i>Amazon Redshift Management Guide</i>.
     * </p>
     *
     * @param listSchemasRequest
     * @return Result of the ListSchemas operation returned by the service.
     * @throws ValidationException
     *         The Amazon Redshift Data API operation failed due to invalid input.
     * @throws InternalServerException
     *         The Amazon Redshift Data API operation failed due to invalid input.
     * @throws DatabaseConnectionException
     *         Connection to a database failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftDataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftDataClient.ListSchemas
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-data-2019-12-20/ListSchemas" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSchemasResponse listSchemas(ListSchemasRequest listSchemasRequest) throws ValidationException,
            InternalServerException, DatabaseConnectionException, AwsServiceException, SdkClientException, RedshiftDataException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the schemas in a database. A token is returned to page through the schema list. Depending on the
     * authorization method, use one of the following combinations of request parameters:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Secrets Manager - when connecting to a cluster, provide the <code>secret-arn</code> of a secret stored in Secrets
     * Manager which has <code>username</code> and <code>password</code>. The specified secret contains credentials to
     * connect to the <code>database</code> you specify. When you are connecting to a cluster, you also supply the
     * database name, If you provide a cluster identifier (<code>dbClusterIdentifier</code>), it must match the cluster
     * identifier stored in the secret. When you are connecting to a serverless workgroup, you also supply the database
     * name.
     * </p>
     * </li>
     * <li>
     * <p>
     * Temporary credentials - when connecting to your data warehouse, choose one of the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * When connecting to a serverless workgroup, specify the workgroup name and database name. The database user name
     * is derived from the IAM identity. For example, <code>arn:iam::123456789012:user:foo</code> has the database user
     * name <code>IAM:foo</code>. Also, permission to call the <code>redshift-serverless:GetCredentials</code> operation
     * is required.
     * </p>
     * </li>
     * <li>
     * <p>
     * When connecting to a cluster as an IAM identity, specify the cluster identifier and the database name. The
     * database user name is derived from the IAM identity. For example, <code>arn:iam::123456789012:user:foo</code> has
     * the database user name <code>IAM:foo</code>. Also, permission to call the
     * <code>redshift:GetClusterCredentialsWithIAM</code> operation is required.
     * </p>
     * </li>
     * <li>
     * <p>
     * When connecting to a cluster as a database user, specify the cluster identifier, the database name, and the
     * database user name. Also, permission to call the <code>redshift:GetClusterCredentials</code> operation is
     * required.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * For more information about the Amazon Redshift Data API and CLI usage examples, see <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/data-api.html">Using the Amazon Redshift Data API</a> in
     * the <i>Amazon Redshift Management Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSchemasRequest.Builder} avoiding the need to
     * create one manually via {@link ListSchemasRequest#builder()}
     * </p>
     *
     * @param listSchemasRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftdata.model.ListSchemasRequest.Builder} to create a request.
     * @return Result of the ListSchemas operation returned by the service.
     * @throws ValidationException
     *         The Amazon Redshift Data API operation failed due to invalid input.
     * @throws InternalServerException
     *         The Amazon Redshift Data API operation failed due to invalid input.
     * @throws DatabaseConnectionException
     *         Connection to a database failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftDataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftDataClient.ListSchemas
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-data-2019-12-20/ListSchemas" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSchemasResponse listSchemas(Consumer<ListSchemasRequest.Builder> listSchemasRequest) throws ValidationException,
            InternalServerException, DatabaseConnectionException, AwsServiceException, SdkClientException, RedshiftDataException {
        return listSchemas(ListSchemasRequest.builder().applyMutation(listSchemasRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listSchemas(software.amazon.awssdk.services.redshiftdata.model.ListSchemasRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftdata.paginators.ListSchemasIterable responses = client.listSchemasPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.redshiftdata.paginators.ListSchemasIterable responses = client.listSchemasPaginator(request);
     *     for (software.amazon.awssdk.services.redshiftdata.model.ListSchemasResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftdata.paginators.ListSchemasIterable responses = client.listSchemasPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSchemas(software.amazon.awssdk.services.redshiftdata.model.ListSchemasRequest)} operation.</b>
     * </p>
     *
     * @param listSchemasRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The Amazon Redshift Data API operation failed due to invalid input.
     * @throws InternalServerException
     *         The Amazon Redshift Data API operation failed due to invalid input.
     * @throws DatabaseConnectionException
     *         Connection to a database failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftDataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftDataClient.ListSchemas
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-data-2019-12-20/ListSchemas" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSchemasIterable listSchemasPaginator(ListSchemasRequest listSchemasRequest) throws ValidationException,
            InternalServerException, DatabaseConnectionException, AwsServiceException, SdkClientException, RedshiftDataException {
        return new ListSchemasIterable(this, listSchemasRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listSchemas(software.amazon.awssdk.services.redshiftdata.model.ListSchemasRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftdata.paginators.ListSchemasIterable responses = client.listSchemasPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.redshiftdata.paginators.ListSchemasIterable responses = client.listSchemasPaginator(request);
     *     for (software.amazon.awssdk.services.redshiftdata.model.ListSchemasResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftdata.paginators.ListSchemasIterable responses = client.listSchemasPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSchemas(software.amazon.awssdk.services.redshiftdata.model.ListSchemasRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSchemasRequest.Builder} avoiding the need to
     * create one manually via {@link ListSchemasRequest#builder()}
     * </p>
     *
     * @param listSchemasRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftdata.model.ListSchemasRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The Amazon Redshift Data API operation failed due to invalid input.
     * @throws InternalServerException
     *         The Amazon Redshift Data API operation failed due to invalid input.
     * @throws DatabaseConnectionException
     *         Connection to a database failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftDataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftDataClient.ListSchemas
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-data-2019-12-20/ListSchemas" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSchemasIterable listSchemasPaginator(Consumer<ListSchemasRequest.Builder> listSchemasRequest)
            throws ValidationException, InternalServerException, DatabaseConnectionException, AwsServiceException,
            SdkClientException, RedshiftDataException {
        return listSchemasPaginator(ListSchemasRequest.builder().applyMutation(listSchemasRequest).build());
    }

    /**
     * <p>
     * List of SQL statements. By default, only finished statements are shown. A token is returned to page through the
     * statement list.
     * </p>
     * <p>
     * For more information about the Amazon Redshift Data API and CLI usage examples, see <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/data-api.html">Using the Amazon Redshift Data API</a> in
     * the <i>Amazon Redshift Management Guide</i>.
     * </p>
     *
     * @param listStatementsRequest
     * @return Result of the ListStatements operation returned by the service.
     * @throws ValidationException
     *         The Amazon Redshift Data API operation failed due to invalid input.
     * @throws InternalServerException
     *         The Amazon Redshift Data API operation failed due to invalid input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftDataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftDataClient.ListStatements
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-data-2019-12-20/ListStatements" target="_top">AWS
     *      API Documentation</a>
     */
    default ListStatementsResponse listStatements(ListStatementsRequest listStatementsRequest) throws ValidationException,
            InternalServerException, AwsServiceException, SdkClientException, RedshiftDataException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List of SQL statements. By default, only finished statements are shown. A token is returned to page through the
     * statement list.
     * </p>
     * <p>
     * For more information about the Amazon Redshift Data API and CLI usage examples, see <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/data-api.html">Using the Amazon Redshift Data API</a> in
     * the <i>Amazon Redshift Management Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStatementsRequest.Builder} avoiding the need to
     * create one manually via {@link ListStatementsRequest#builder()}
     * </p>
     *
     * @param listStatementsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftdata.model.ListStatementsRequest.Builder} to create a
     *        request.
     * @return Result of the ListStatements operation returned by the service.
     * @throws ValidationException
     *         The Amazon Redshift Data API operation failed due to invalid input.
     * @throws InternalServerException
     *         The Amazon Redshift Data API operation failed due to invalid input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftDataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftDataClient.ListStatements
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-data-2019-12-20/ListStatements" target="_top">AWS
     *      API Documentation</a>
     */
    default ListStatementsResponse listStatements(Consumer<ListStatementsRequest.Builder> listStatementsRequest)
            throws ValidationException, InternalServerException, AwsServiceException, SdkClientException, RedshiftDataException {
        return listStatements(ListStatementsRequest.builder().applyMutation(listStatementsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listStatements(software.amazon.awssdk.services.redshiftdata.model.ListStatementsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftdata.paginators.ListStatementsIterable responses = client.listStatementsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.redshiftdata.paginators.ListStatementsIterable responses = client
     *             .listStatementsPaginator(request);
     *     for (software.amazon.awssdk.services.redshiftdata.model.ListStatementsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftdata.paginators.ListStatementsIterable responses = client.listStatementsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStatements(software.amazon.awssdk.services.redshiftdata.model.ListStatementsRequest)} operation.</b>
     * </p>
     *
     * @param listStatementsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The Amazon Redshift Data API operation failed due to invalid input.
     * @throws InternalServerException
     *         The Amazon Redshift Data API operation failed due to invalid input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftDataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftDataClient.ListStatements
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-data-2019-12-20/ListStatements" target="_top">AWS
     *      API Documentation</a>
     */
    default ListStatementsIterable listStatementsPaginator(ListStatementsRequest listStatementsRequest)
            throws ValidationException, InternalServerException, AwsServiceException, SdkClientException, RedshiftDataException {
        return new ListStatementsIterable(this, listStatementsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listStatements(software.amazon.awssdk.services.redshiftdata.model.ListStatementsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftdata.paginators.ListStatementsIterable responses = client.listStatementsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.redshiftdata.paginators.ListStatementsIterable responses = client
     *             .listStatementsPaginator(request);
     *     for (software.amazon.awssdk.services.redshiftdata.model.ListStatementsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftdata.paginators.ListStatementsIterable responses = client.listStatementsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStatements(software.amazon.awssdk.services.redshiftdata.model.ListStatementsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStatementsRequest.Builder} avoiding the need to
     * create one manually via {@link ListStatementsRequest#builder()}
     * </p>
     *
     * @param listStatementsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftdata.model.ListStatementsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The Amazon Redshift Data API operation failed due to invalid input.
     * @throws InternalServerException
     *         The Amazon Redshift Data API operation failed due to invalid input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftDataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftDataClient.ListStatements
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-data-2019-12-20/ListStatements" target="_top">AWS
     *      API Documentation</a>
     */
    default ListStatementsIterable listStatementsPaginator(Consumer<ListStatementsRequest.Builder> listStatementsRequest)
            throws ValidationException, InternalServerException, AwsServiceException, SdkClientException, RedshiftDataException {
        return listStatementsPaginator(ListStatementsRequest.builder().applyMutation(listStatementsRequest).build());
    }

    /**
     * <p>
     * List the tables in a database. If neither <code>SchemaPattern</code> nor <code>TablePattern</code> are specified,
     * then all tables in the database are returned. A token is returned to page through the table list. Depending on
     * the authorization method, use one of the following combinations of request parameters:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Secrets Manager - when connecting to a cluster, provide the <code>secret-arn</code> of a secret stored in Secrets
     * Manager which has <code>username</code> and <code>password</code>. The specified secret contains credentials to
     * connect to the <code>database</code> you specify. When you are connecting to a cluster, you also supply the
     * database name, If you provide a cluster identifier (<code>dbClusterIdentifier</code>), it must match the cluster
     * identifier stored in the secret. When you are connecting to a serverless workgroup, you also supply the database
     * name.
     * </p>
     * </li>
     * <li>
     * <p>
     * Temporary credentials - when connecting to your data warehouse, choose one of the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * When connecting to a serverless workgroup, specify the workgroup name and database name. The database user name
     * is derived from the IAM identity. For example, <code>arn:iam::123456789012:user:foo</code> has the database user
     * name <code>IAM:foo</code>. Also, permission to call the <code>redshift-serverless:GetCredentials</code> operation
     * is required.
     * </p>
     * </li>
     * <li>
     * <p>
     * When connecting to a cluster as an IAM identity, specify the cluster identifier and the database name. The
     * database user name is derived from the IAM identity. For example, <code>arn:iam::123456789012:user:foo</code> has
     * the database user name <code>IAM:foo</code>. Also, permission to call the
     * <code>redshift:GetClusterCredentialsWithIAM</code> operation is required.
     * </p>
     * </li>
     * <li>
     * <p>
     * When connecting to a cluster as a database user, specify the cluster identifier, the database name, and the
     * database user name. Also, permission to call the <code>redshift:GetClusterCredentials</code> operation is
     * required.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * For more information about the Amazon Redshift Data API and CLI usage examples, see <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/data-api.html">Using the Amazon Redshift Data API</a> in
     * the <i>Amazon Redshift Management Guide</i>.
     * </p>
     *
     * @param listTablesRequest
     * @return Result of the ListTables operation returned by the service.
     * @throws ValidationException
     *         The Amazon Redshift Data API operation failed due to invalid input.
     * @throws InternalServerException
     *         The Amazon Redshift Data API operation failed due to invalid input.
     * @throws DatabaseConnectionException
     *         Connection to a database failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftDataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftDataClient.ListTables
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-data-2019-12-20/ListTables" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTablesResponse listTables(ListTablesRequest listTablesRequest) throws ValidationException,
            InternalServerException, DatabaseConnectionException, AwsServiceException, SdkClientException, RedshiftDataException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the tables in a database. If neither <code>SchemaPattern</code> nor <code>TablePattern</code> are specified,
     * then all tables in the database are returned. A token is returned to page through the table list. Depending on
     * the authorization method, use one of the following combinations of request parameters:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Secrets Manager - when connecting to a cluster, provide the <code>secret-arn</code> of a secret stored in Secrets
     * Manager which has <code>username</code> and <code>password</code>. The specified secret contains credentials to
     * connect to the <code>database</code> you specify. When you are connecting to a cluster, you also supply the
     * database name, If you provide a cluster identifier (<code>dbClusterIdentifier</code>), it must match the cluster
     * identifier stored in the secret. When you are connecting to a serverless workgroup, you also supply the database
     * name.
     * </p>
     * </li>
     * <li>
     * <p>
     * Temporary credentials - when connecting to your data warehouse, choose one of the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * When connecting to a serverless workgroup, specify the workgroup name and database name. The database user name
     * is derived from the IAM identity. For example, <code>arn:iam::123456789012:user:foo</code> has the database user
     * name <code>IAM:foo</code>. Also, permission to call the <code>redshift-serverless:GetCredentials</code> operation
     * is required.
     * </p>
     * </li>
     * <li>
     * <p>
     * When connecting to a cluster as an IAM identity, specify the cluster identifier and the database name. The
     * database user name is derived from the IAM identity. For example, <code>arn:iam::123456789012:user:foo</code> has
     * the database user name <code>IAM:foo</code>. Also, permission to call the
     * <code>redshift:GetClusterCredentialsWithIAM</code> operation is required.
     * </p>
     * </li>
     * <li>
     * <p>
     * When connecting to a cluster as a database user, specify the cluster identifier, the database name, and the
     * database user name. Also, permission to call the <code>redshift:GetClusterCredentials</code> operation is
     * required.
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * For more information about the Amazon Redshift Data API and CLI usage examples, see <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/data-api.html">Using the Amazon Redshift Data API</a> in
     * the <i>Amazon Redshift Management Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTablesRequest.Builder} avoiding the need to
     * create one manually via {@link ListTablesRequest#builder()}
     * </p>
     *
     * @param listTablesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftdata.model.ListTablesRequest.Builder} to create a request.
     * @return Result of the ListTables operation returned by the service.
     * @throws ValidationException
     *         The Amazon Redshift Data API operation failed due to invalid input.
     * @throws InternalServerException
     *         The Amazon Redshift Data API operation failed due to invalid input.
     * @throws DatabaseConnectionException
     *         Connection to a database failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftDataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftDataClient.ListTables
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-data-2019-12-20/ListTables" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTablesResponse listTables(Consumer<ListTablesRequest.Builder> listTablesRequest) throws ValidationException,
            InternalServerException, DatabaseConnectionException, AwsServiceException, SdkClientException, RedshiftDataException {
        return listTables(ListTablesRequest.builder().applyMutation(listTablesRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listTables(software.amazon.awssdk.services.redshiftdata.model.ListTablesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftdata.paginators.ListTablesIterable responses = client.listTablesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.redshiftdata.paginators.ListTablesIterable responses = client.listTablesPaginator(request);
     *     for (software.amazon.awssdk.services.redshiftdata.model.ListTablesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftdata.paginators.ListTablesIterable responses = client.listTablesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTables(software.amazon.awssdk.services.redshiftdata.model.ListTablesRequest)} operation.</b>
     * </p>
     *
     * @param listTablesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The Amazon Redshift Data API operation failed due to invalid input.
     * @throws InternalServerException
     *         The Amazon Redshift Data API operation failed due to invalid input.
     * @throws DatabaseConnectionException
     *         Connection to a database failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftDataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftDataClient.ListTables
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-data-2019-12-20/ListTables" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTablesIterable listTablesPaginator(ListTablesRequest listTablesRequest) throws ValidationException,
            InternalServerException, DatabaseConnectionException, AwsServiceException, SdkClientException, RedshiftDataException {
        return new ListTablesIterable(this, listTablesRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listTables(software.amazon.awssdk.services.redshiftdata.model.ListTablesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftdata.paginators.ListTablesIterable responses = client.listTablesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.redshiftdata.paginators.ListTablesIterable responses = client.listTablesPaginator(request);
     *     for (software.amazon.awssdk.services.redshiftdata.model.ListTablesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.redshiftdata.paginators.ListTablesIterable responses = client.listTablesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTables(software.amazon.awssdk.services.redshiftdata.model.ListTablesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTablesRequest.Builder} avoiding the need to
     * create one manually via {@link ListTablesRequest#builder()}
     * </p>
     *
     * @param listTablesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.redshiftdata.model.ListTablesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         The Amazon Redshift Data API operation failed due to invalid input.
     * @throws InternalServerException
     *         The Amazon Redshift Data API operation failed due to invalid input.
     * @throws DatabaseConnectionException
     *         Connection to a database failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws RedshiftDataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample RedshiftDataClient.ListTables
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/redshift-data-2019-12-20/ListTables" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTablesIterable listTablesPaginator(Consumer<ListTablesRequest.Builder> listTablesRequest)
            throws ValidationException, InternalServerException, DatabaseConnectionException, AwsServiceException,
            SdkClientException, RedshiftDataException {
        return listTablesPaginator(ListTablesRequest.builder().applyMutation(listTablesRequest).build());
    }

    /**
     * Create a {@link RedshiftDataClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static RedshiftDataClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link RedshiftDataClient}.
     */
    static RedshiftDataClientBuilder builder() {
        return new DefaultRedshiftDataClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default RedshiftDataServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
