/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshiftdata.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExecuteStatementRequest extends RedshiftDataRequest implements
        ToCopyableBuilder<ExecuteStatementRequest.Builder, ExecuteStatementRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(ExecuteStatementRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> CLUSTER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterIdentifier").getter(getter(ExecuteStatementRequest::clusterIdentifier))
            .setter(setter(Builder::clusterIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterIdentifier").build()).build();

    private static final SdkField<String> DATABASE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Database").getter(getter(ExecuteStatementRequest::database)).setter(setter(Builder::database))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Database").build()).build();

    private static final SdkField<String> DB_USER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("DbUser")
            .getter(getter(ExecuteStatementRequest::dbUser)).setter(setter(Builder::dbUser))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DbUser").build()).build();

    private static final SdkField<List<SqlParameter>> PARAMETERS_FIELD = SdkField
            .<List<SqlParameter>> builder(MarshallingType.LIST)
            .memberName("Parameters")
            .getter(getter(ExecuteStatementRequest::parameters))
            .setter(setter(Builder::parameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SqlParameter> builder(MarshallingType.SDK_POJO)
                                            .constructor(SqlParameter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> RESULT_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResultFormat").getter(getter(ExecuteStatementRequest::resultFormatAsString))
            .setter(setter(Builder::resultFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultFormat").build()).build();

    private static final SdkField<String> SECRET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SecretArn").getter(getter(ExecuteStatementRequest::secretArn)).setter(setter(Builder::secretArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretArn").build()).build();

    private static final SdkField<String> SESSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SessionId").getter(getter(ExecuteStatementRequest::sessionId)).setter(setter(Builder::sessionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionId").build()).build();

    private static final SdkField<Integer> SESSION_KEEP_ALIVE_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SessionKeepAliveSeconds").getter(getter(ExecuteStatementRequest::sessionKeepAliveSeconds))
            .setter(setter(Builder::sessionKeepAliveSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionKeepAliveSeconds").build())
            .build();

    private static final SdkField<String> SQL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Sql")
            .getter(getter(ExecuteStatementRequest::sql)).setter(setter(Builder::sql))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sql").build()).build();

    private static final SdkField<String> STATEMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatementName").getter(getter(ExecuteStatementRequest::statementName))
            .setter(setter(Builder::statementName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatementName").build()).build();

    private static final SdkField<Boolean> WITH_EVENT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("WithEvent").getter(getter(ExecuteStatementRequest::withEvent)).setter(setter(Builder::withEvent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WithEvent").build()).build();

    private static final SdkField<String> WORKGROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkgroupName").getter(getter(ExecuteStatementRequest::workgroupName))
            .setter(setter(Builder::workgroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkgroupName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            CLUSTER_IDENTIFIER_FIELD, DATABASE_FIELD, DB_USER_FIELD, PARAMETERS_FIELD, RESULT_FORMAT_FIELD, SECRET_ARN_FIELD,
            SESSION_ID_FIELD, SESSION_KEEP_ALIVE_SECONDS_FIELD, SQL_FIELD, STATEMENT_NAME_FIELD, WITH_EVENT_FIELD,
            WORKGROUP_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String clientToken;

    private final String clusterIdentifier;

    private final String database;

    private final String dbUser;

    private final List<SqlParameter> parameters;

    private final String resultFormat;

    private final String secretArn;

    private final String sessionId;

    private final Integer sessionKeepAliveSeconds;

    private final String sql;

    private final String statementName;

    private final Boolean withEvent;

    private final String workgroupName;

    private ExecuteStatementRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.clusterIdentifier = builder.clusterIdentifier;
        this.database = builder.database;
        this.dbUser = builder.dbUser;
        this.parameters = builder.parameters;
        this.resultFormat = builder.resultFormat;
        this.secretArn = builder.secretArn;
        this.sessionId = builder.sessionId;
        this.sessionKeepAliveSeconds = builder.sessionKeepAliveSeconds;
        this.sql = builder.sql;
        this.statementName = builder.statementName;
        this.withEvent = builder.withEvent;
        this.workgroupName = builder.workgroupName;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The cluster identifier. This parameter is required when connecting to a cluster and authenticating using either
     * Secrets Manager or temporary credentials.
     * </p>
     * 
     * @return The cluster identifier. This parameter is required when connecting to a cluster and authenticating using
     *         either Secrets Manager or temporary credentials.
     */
    public final String clusterIdentifier() {
        return clusterIdentifier;
    }

    /**
     * <p>
     * The name of the database. This parameter is required when authenticating using either Secrets Manager or
     * temporary credentials.
     * </p>
     * 
     * @return The name of the database. This parameter is required when authenticating using either Secrets Manager or
     *         temporary credentials.
     */
    public final String database() {
        return database;
    }

    /**
     * <p>
     * The database user name. This parameter is required when connecting to a cluster as a database user and
     * authenticating using temporary credentials.
     * </p>
     * 
     * @return The database user name. This parameter is required when connecting to a cluster as a database user and
     *         authenticating using temporary credentials.
     */
    public final String dbUser() {
        return dbUser;
    }

    /**
     * For responses, this returns true if the service returned a value for the Parameters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasParameters() {
        return parameters != null && !(parameters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The parameters for the SQL statement.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasParameters} method.
     * </p>
     * 
     * @return The parameters for the SQL statement.
     */
    public final List<SqlParameter> parameters() {
        return parameters;
    }

    /**
     * <p>
     * The data format of the result of the SQL statement. If no format is specified, the default is JSON.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resultFormat} will
     * return {@link ResultFormatString#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resultFormatAsString}.
     * </p>
     * 
     * @return The data format of the result of the SQL statement. If no format is specified, the default is JSON.
     * @see ResultFormatString
     */
    public final ResultFormatString resultFormat() {
        return ResultFormatString.fromValue(resultFormat);
    }

    /**
     * <p>
     * The data format of the result of the SQL statement. If no format is specified, the default is JSON.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resultFormat} will
     * return {@link ResultFormatString#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resultFormatAsString}.
     * </p>
     * 
     * @return The data format of the result of the SQL statement. If no format is specified, the default is JSON.
     * @see ResultFormatString
     */
    public final String resultFormatAsString() {
        return resultFormat;
    }

    /**
     * <p>
     * The name or ARN of the secret that enables access to the database. This parameter is required when authenticating
     * using Secrets Manager.
     * </p>
     * 
     * @return The name or ARN of the secret that enables access to the database. This parameter is required when
     *         authenticating using Secrets Manager.
     */
    public final String secretArn() {
        return secretArn;
    }

    /**
     * <p>
     * The session identifier of the query.
     * </p>
     * 
     * @return The session identifier of the query.
     */
    public final String sessionId() {
        return sessionId;
    }

    /**
     * <p>
     * The number of seconds to keep the session alive after the query finishes. The maximum time a session can keep
     * alive is 24 hours. After 24 hours, the session is forced closed and the query is terminated.
     * </p>
     * 
     * @return The number of seconds to keep the session alive after the query finishes. The maximum time a session can
     *         keep alive is 24 hours. After 24 hours, the session is forced closed and the query is terminated.
     */
    public final Integer sessionKeepAliveSeconds() {
        return sessionKeepAliveSeconds;
    }

    /**
     * <p>
     * The SQL statement text to run.
     * </p>
     * 
     * @return The SQL statement text to run.
     */
    public final String sql() {
        return sql;
    }

    /**
     * <p>
     * The name of the SQL statement. You can name the SQL statement when you create it to identify the query.
     * </p>
     * 
     * @return The name of the SQL statement. You can name the SQL statement when you create it to identify the query.
     */
    public final String statementName() {
        return statementName;
    }

    /**
     * <p>
     * A value that indicates whether to send an event to the Amazon EventBridge event bus after the SQL statement runs.
     * </p>
     * 
     * @return A value that indicates whether to send an event to the Amazon EventBridge event bus after the SQL
     *         statement runs.
     */
    public final Boolean withEvent() {
        return withEvent;
    }

    /**
     * <p>
     * The serverless workgroup name or Amazon Resource Name (ARN). This parameter is required when connecting to a
     * serverless workgroup and authenticating using either Secrets Manager or temporary credentials.
     * </p>
     * 
     * @return The serverless workgroup name or Amazon Resource Name (ARN). This parameter is required when connecting
     *         to a serverless workgroup and authenticating using either Secrets Manager or temporary credentials.
     */
    public final String workgroupName() {
        return workgroupName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(clusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(database());
        hashCode = 31 * hashCode + Objects.hashCode(dbUser());
        hashCode = 31 * hashCode + Objects.hashCode(hasParameters() ? parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(resultFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(secretArn());
        hashCode = 31 * hashCode + Objects.hashCode(sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(sessionKeepAliveSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(sql());
        hashCode = 31 * hashCode + Objects.hashCode(statementName());
        hashCode = 31 * hashCode + Objects.hashCode(withEvent());
        hashCode = 31 * hashCode + Objects.hashCode(workgroupName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecuteStatementRequest)) {
            return false;
        }
        ExecuteStatementRequest other = (ExecuteStatementRequest) obj;
        return Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(clusterIdentifier(), other.clusterIdentifier()) && Objects.equals(database(), other.database())
                && Objects.equals(dbUser(), other.dbUser()) && hasParameters() == other.hasParameters()
                && Objects.equals(parameters(), other.parameters())
                && Objects.equals(resultFormatAsString(), other.resultFormatAsString())
                && Objects.equals(secretArn(), other.secretArn()) && Objects.equals(sessionId(), other.sessionId())
                && Objects.equals(sessionKeepAliveSeconds(), other.sessionKeepAliveSeconds())
                && Objects.equals(sql(), other.sql()) && Objects.equals(statementName(), other.statementName())
                && Objects.equals(withEvent(), other.withEvent()) && Objects.equals(workgroupName(), other.workgroupName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExecuteStatementRequest").add("ClientToken", clientToken())
                .add("ClusterIdentifier", clusterIdentifier()).add("Database", database()).add("DbUser", dbUser())
                .add("Parameters", hasParameters() ? parameters() : null).add("ResultFormat", resultFormatAsString())
                .add("SecretArn", secretArn()).add("SessionId", sessionId())
                .add("SessionKeepAliveSeconds", sessionKeepAliveSeconds()).add("Sql", sql())
                .add("StatementName", statementName()).add("WithEvent", withEvent()).add("WorkgroupName", workgroupName())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "ClusterIdentifier":
            return Optional.ofNullable(clazz.cast(clusterIdentifier()));
        case "Database":
            return Optional.ofNullable(clazz.cast(database()));
        case "DbUser":
            return Optional.ofNullable(clazz.cast(dbUser()));
        case "Parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        case "ResultFormat":
            return Optional.ofNullable(clazz.cast(resultFormatAsString()));
        case "SecretArn":
            return Optional.ofNullable(clazz.cast(secretArn()));
        case "SessionId":
            return Optional.ofNullable(clazz.cast(sessionId()));
        case "SessionKeepAliveSeconds":
            return Optional.ofNullable(clazz.cast(sessionKeepAliveSeconds()));
        case "Sql":
            return Optional.ofNullable(clazz.cast(sql()));
        case "StatementName":
            return Optional.ofNullable(clazz.cast(statementName()));
        case "WithEvent":
            return Optional.ofNullable(clazz.cast(withEvent()));
        case "WorkgroupName":
            return Optional.ofNullable(clazz.cast(workgroupName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("ClusterIdentifier", CLUSTER_IDENTIFIER_FIELD);
        map.put("Database", DATABASE_FIELD);
        map.put("DbUser", DB_USER_FIELD);
        map.put("Parameters", PARAMETERS_FIELD);
        map.put("ResultFormat", RESULT_FORMAT_FIELD);
        map.put("SecretArn", SECRET_ARN_FIELD);
        map.put("SessionId", SESSION_ID_FIELD);
        map.put("SessionKeepAliveSeconds", SESSION_KEEP_ALIVE_SECONDS_FIELD);
        map.put("Sql", SQL_FIELD);
        map.put("StatementName", STATEMENT_NAME_FIELD);
        map.put("WithEvent", WITH_EVENT_FIELD);
        map.put("WorkgroupName", WORKGROUP_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExecuteStatementRequest, T> g) {
        return obj -> g.apply((ExecuteStatementRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftDataRequest.Builder, SdkPojo, CopyableBuilder<Builder, ExecuteStatementRequest> {
        /**
         * <p>
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The cluster identifier. This parameter is required when connecting to a cluster and authenticating using
         * either Secrets Manager or temporary credentials.
         * </p>
         * 
         * @param clusterIdentifier
         *        The cluster identifier. This parameter is required when connecting to a cluster and authenticating
         *        using either Secrets Manager or temporary credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterIdentifier(String clusterIdentifier);

        /**
         * <p>
         * The name of the database. This parameter is required when authenticating using either Secrets Manager or
         * temporary credentials.
         * </p>
         * 
         * @param database
         *        The name of the database. This parameter is required when authenticating using either Secrets Manager
         *        or temporary credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder database(String database);

        /**
         * <p>
         * The database user name. This parameter is required when connecting to a cluster as a database user and
         * authenticating using temporary credentials.
         * </p>
         * 
         * @param dbUser
         *        The database user name. This parameter is required when connecting to a cluster as a database user and
         *        authenticating using temporary credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbUser(String dbUser);

        /**
         * <p>
         * The parameters for the SQL statement.
         * </p>
         * 
         * @param parameters
         *        The parameters for the SQL statement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Collection<SqlParameter> parameters);

        /**
         * <p>
         * The parameters for the SQL statement.
         * </p>
         * 
         * @param parameters
         *        The parameters for the SQL statement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(SqlParameter... parameters);

        /**
         * <p>
         * The parameters for the SQL statement.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.redshiftdata.model.SqlParameter.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.redshiftdata.model.SqlParameter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.redshiftdata.model.SqlParameter.Builder#build()} is called immediately
         * and its result is passed to {@link #parameters(List<SqlParameter>)}.
         * 
         * @param parameters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.redshiftdata.model.SqlParameter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parameters(java.util.Collection<SqlParameter>)
         */
        Builder parameters(Consumer<SqlParameter.Builder>... parameters);

        /**
         * <p>
         * The data format of the result of the SQL statement. If no format is specified, the default is JSON.
         * </p>
         * 
         * @param resultFormat
         *        The data format of the result of the SQL statement. If no format is specified, the default is JSON.
         * @see ResultFormatString
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResultFormatString
         */
        Builder resultFormat(String resultFormat);

        /**
         * <p>
         * The data format of the result of the SQL statement. If no format is specified, the default is JSON.
         * </p>
         * 
         * @param resultFormat
         *        The data format of the result of the SQL statement. If no format is specified, the default is JSON.
         * @see ResultFormatString
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResultFormatString
         */
        Builder resultFormat(ResultFormatString resultFormat);

        /**
         * <p>
         * The name or ARN of the secret that enables access to the database. This parameter is required when
         * authenticating using Secrets Manager.
         * </p>
         * 
         * @param secretArn
         *        The name or ARN of the secret that enables access to the database. This parameter is required when
         *        authenticating using Secrets Manager.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretArn(String secretArn);

        /**
         * <p>
         * The session identifier of the query.
         * </p>
         * 
         * @param sessionId
         *        The session identifier of the query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionId(String sessionId);

        /**
         * <p>
         * The number of seconds to keep the session alive after the query finishes. The maximum time a session can keep
         * alive is 24 hours. After 24 hours, the session is forced closed and the query is terminated.
         * </p>
         * 
         * @param sessionKeepAliveSeconds
         *        The number of seconds to keep the session alive after the query finishes. The maximum time a session
         *        can keep alive is 24 hours. After 24 hours, the session is forced closed and the query is terminated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionKeepAliveSeconds(Integer sessionKeepAliveSeconds);

        /**
         * <p>
         * The SQL statement text to run.
         * </p>
         * 
         * @param sql
         *        The SQL statement text to run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sql(String sql);

        /**
         * <p>
         * The name of the SQL statement. You can name the SQL statement when you create it to identify the query.
         * </p>
         * 
         * @param statementName
         *        The name of the SQL statement. You can name the SQL statement when you create it to identify the
         *        query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statementName(String statementName);

        /**
         * <p>
         * A value that indicates whether to send an event to the Amazon EventBridge event bus after the SQL statement
         * runs.
         * </p>
         * 
         * @param withEvent
         *        A value that indicates whether to send an event to the Amazon EventBridge event bus after the SQL
         *        statement runs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder withEvent(Boolean withEvent);

        /**
         * <p>
         * The serverless workgroup name or Amazon Resource Name (ARN). This parameter is required when connecting to a
         * serverless workgroup and authenticating using either Secrets Manager or temporary credentials.
         * </p>
         * 
         * @param workgroupName
         *        The serverless workgroup name or Amazon Resource Name (ARN). This parameter is required when
         *        connecting to a serverless workgroup and authenticating using either Secrets Manager or temporary
         *        credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workgroupName(String workgroupName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RedshiftDataRequest.BuilderImpl implements Builder {
        private String clientToken;

        private String clusterIdentifier;

        private String database;

        private String dbUser;

        private List<SqlParameter> parameters = DefaultSdkAutoConstructList.getInstance();

        private String resultFormat;

        private String secretArn;

        private String sessionId;

        private Integer sessionKeepAliveSeconds;

        private String sql;

        private String statementName;

        private Boolean withEvent;

        private String workgroupName;

        private BuilderImpl() {
        }

        private BuilderImpl(ExecuteStatementRequest model) {
            super(model);
            clientToken(model.clientToken);
            clusterIdentifier(model.clusterIdentifier);
            database(model.database);
            dbUser(model.dbUser);
            parameters(model.parameters);
            resultFormat(model.resultFormat);
            secretArn(model.secretArn);
            sessionId(model.sessionId);
            sessionKeepAliveSeconds(model.sessionKeepAliveSeconds);
            sql(model.sql);
            statementName(model.statementName);
            withEvent(model.withEvent);
            workgroupName(model.workgroupName);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getClusterIdentifier() {
            return clusterIdentifier;
        }

        public final void setClusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
        }

        @Override
        public final Builder clusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        public final String getDatabase() {
            return database;
        }

        public final void setDatabase(String database) {
            this.database = database;
        }

        @Override
        public final Builder database(String database) {
            this.database = database;
            return this;
        }

        public final String getDbUser() {
            return dbUser;
        }

        public final void setDbUser(String dbUser) {
            this.dbUser = dbUser;
        }

        @Override
        public final Builder dbUser(String dbUser) {
            this.dbUser = dbUser;
            return this;
        }

        public final List<SqlParameter.Builder> getParameters() {
            List<SqlParameter.Builder> result = SqlParametersListCopier.copyToBuilder(this.parameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setParameters(Collection<SqlParameter.BuilderImpl> parameters) {
            this.parameters = SqlParametersListCopier.copyFromBuilder(parameters);
        }

        @Override
        public final Builder parameters(Collection<SqlParameter> parameters) {
            this.parameters = SqlParametersListCopier.copy(parameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(SqlParameter... parameters) {
            parameters(Arrays.asList(parameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Consumer<SqlParameter.Builder>... parameters) {
            parameters(Stream.of(parameters).map(c -> SqlParameter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getResultFormat() {
            return resultFormat;
        }

        public final void setResultFormat(String resultFormat) {
            this.resultFormat = resultFormat;
        }

        @Override
        public final Builder resultFormat(String resultFormat) {
            this.resultFormat = resultFormat;
            return this;
        }

        @Override
        public final Builder resultFormat(ResultFormatString resultFormat) {
            this.resultFormat(resultFormat == null ? null : resultFormat.toString());
            return this;
        }

        public final String getSecretArn() {
            return secretArn;
        }

        public final void setSecretArn(String secretArn) {
            this.secretArn = secretArn;
        }

        @Override
        public final Builder secretArn(String secretArn) {
            this.secretArn = secretArn;
            return this;
        }

        public final String getSessionId() {
            return sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final Integer getSessionKeepAliveSeconds() {
            return sessionKeepAliveSeconds;
        }

        public final void setSessionKeepAliveSeconds(Integer sessionKeepAliveSeconds) {
            this.sessionKeepAliveSeconds = sessionKeepAliveSeconds;
        }

        @Override
        public final Builder sessionKeepAliveSeconds(Integer sessionKeepAliveSeconds) {
            this.sessionKeepAliveSeconds = sessionKeepAliveSeconds;
            return this;
        }

        public final String getSql() {
            return sql;
        }

        public final void setSql(String sql) {
            this.sql = sql;
        }

        @Override
        public final Builder sql(String sql) {
            this.sql = sql;
            return this;
        }

        public final String getStatementName() {
            return statementName;
        }

        public final void setStatementName(String statementName) {
            this.statementName = statementName;
        }

        @Override
        public final Builder statementName(String statementName) {
            this.statementName = statementName;
            return this;
        }

        public final Boolean getWithEvent() {
            return withEvent;
        }

        public final void setWithEvent(Boolean withEvent) {
            this.withEvent = withEvent;
        }

        @Override
        public final Builder withEvent(Boolean withEvent) {
            this.withEvent = withEvent;
            return this;
        }

        public final String getWorkgroupName() {
            return workgroupName;
        }

        public final void setWorkgroupName(String workgroupName) {
            this.workgroupName = workgroupName;
        }

        @Override
        public final Builder workgroupName(String workgroupName) {
            this.workgroupName = workgroupName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ExecuteStatementRequest build() {
            return new ExecuteStatementRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
