/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshiftdata.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetStatementResultV2Response extends RedshiftDataResponse implements
        ToCopyableBuilder<GetStatementResultV2Response.Builder, GetStatementResultV2Response> {
    private static final SdkField<List<ColumnMetadata>> COLUMN_METADATA_FIELD = SdkField
            .<List<ColumnMetadata>> builder(MarshallingType.LIST)
            .memberName("ColumnMetadata")
            .getter(getter(GetStatementResultV2Response::columnMetadata))
            .setter(setter(Builder::columnMetadata))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnMetadata").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ColumnMetadata> builder(MarshallingType.SDK_POJO)
                                            .constructor(ColumnMetadata::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(GetStatementResultV2Response::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<QueryRecords>> RECORDS_FIELD = SdkField
            .<List<QueryRecords>> builder(MarshallingType.LIST)
            .memberName("Records")
            .getter(getter(GetStatementResultV2Response::records))
            .setter(setter(Builder::records))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Records").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<QueryRecords> builder(MarshallingType.SDK_POJO)
                                            .constructor(QueryRecords::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> RESULT_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResultFormat").getter(getter(GetStatementResultV2Response::resultFormatAsString))
            .setter(setter(Builder::resultFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultFormat").build()).build();

    private static final SdkField<Long> TOTAL_NUM_ROWS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("TotalNumRows").getter(getter(GetStatementResultV2Response::totalNumRows))
            .setter(setter(Builder::totalNumRows))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalNumRows").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLUMN_METADATA_FIELD,
            NEXT_TOKEN_FIELD, RECORDS_FIELD, RESULT_FORMAT_FIELD, TOTAL_NUM_ROWS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<ColumnMetadata> columnMetadata;

    private final String nextToken;

    private final List<QueryRecords> records;

    private final String resultFormat;

    private final Long totalNumRows;

    private GetStatementResultV2Response(BuilderImpl builder) {
        super(builder);
        this.columnMetadata = builder.columnMetadata;
        this.nextToken = builder.nextToken;
        this.records = builder.records;
        this.resultFormat = builder.resultFormat;
        this.totalNumRows = builder.totalNumRows;
    }

    /**
     * For responses, this returns true if the service returned a value for the ColumnMetadata property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasColumnMetadata() {
        return columnMetadata != null && !(columnMetadata instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The properties (metadata) of a column.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasColumnMetadata} method.
     * </p>
     * 
     * @return The properties (metadata) of a column.
     */
    public final List<ColumnMetadata> columnMetadata() {
        return columnMetadata;
    }

    /**
     * <p>
     * A value that indicates the starting point for the next set of response records in a subsequent request. If a
     * value is returned in a response, you can retrieve the next set of records by providing this returned NextToken
     * value in the next NextToken parameter and retrying the command. If the NextToken field is empty, all response
     * records have been retrieved for the request.
     * </p>
     * 
     * @return A value that indicates the starting point for the next set of response records in a subsequent request.
     *         If a value is returned in a response, you can retrieve the next set of records by providing this returned
     *         NextToken value in the next NextToken parameter and retrying the command. If the NextToken field is
     *         empty, all response records have been retrieved for the request.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Records property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasRecords() {
        return records != null && !(records instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The results of the SQL statement in CSV format.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRecords} method.
     * </p>
     * 
     * @return The results of the SQL statement in CSV format.
     */
    public final List<QueryRecords> records() {
        return records;
    }

    /**
     * <p>
     * The data format of the result of the SQL statement.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resultFormat} will
     * return {@link ResultFormatString#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resultFormatAsString}.
     * </p>
     * 
     * @return The data format of the result of the SQL statement.
     * @see ResultFormatString
     */
    public final ResultFormatString resultFormat() {
        return ResultFormatString.fromValue(resultFormat);
    }

    /**
     * <p>
     * The data format of the result of the SQL statement.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resultFormat} will
     * return {@link ResultFormatString#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resultFormatAsString}.
     * </p>
     * 
     * @return The data format of the result of the SQL statement.
     * @see ResultFormatString
     */
    public final String resultFormatAsString() {
        return resultFormat;
    }

    /**
     * <p>
     * The total number of rows in the result set returned from a query. You can use this number to estimate the number
     * of calls to the <code>GetStatementResultV2</code> operation needed to page through the results.
     * </p>
     * 
     * @return The total number of rows in the result set returned from a query. You can use this number to estimate the
     *         number of calls to the <code>GetStatementResultV2</code> operation needed to page through the results.
     */
    public final Long totalNumRows() {
        return totalNumRows;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasColumnMetadata() ? columnMetadata() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasRecords() ? records() : null);
        hashCode = 31 * hashCode + Objects.hashCode(resultFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(totalNumRows());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetStatementResultV2Response)) {
            return false;
        }
        GetStatementResultV2Response other = (GetStatementResultV2Response) obj;
        return hasColumnMetadata() == other.hasColumnMetadata() && Objects.equals(columnMetadata(), other.columnMetadata())
                && Objects.equals(nextToken(), other.nextToken()) && hasRecords() == other.hasRecords()
                && Objects.equals(records(), other.records())
                && Objects.equals(resultFormatAsString(), other.resultFormatAsString())
                && Objects.equals(totalNumRows(), other.totalNumRows());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetStatementResultV2Response")
                .add("ColumnMetadata", hasColumnMetadata() ? columnMetadata() : null).add("NextToken", nextToken())
                .add("Records", hasRecords() ? records() : null).add("ResultFormat", resultFormatAsString())
                .add("TotalNumRows", totalNumRows()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ColumnMetadata":
            return Optional.ofNullable(clazz.cast(columnMetadata()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "Records":
            return Optional.ofNullable(clazz.cast(records()));
        case "ResultFormat":
            return Optional.ofNullable(clazz.cast(resultFormatAsString()));
        case "TotalNumRows":
            return Optional.ofNullable(clazz.cast(totalNumRows()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ColumnMetadata", COLUMN_METADATA_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("Records", RECORDS_FIELD);
        map.put("ResultFormat", RESULT_FORMAT_FIELD);
        map.put("TotalNumRows", TOTAL_NUM_ROWS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetStatementResultV2Response, T> g) {
        return obj -> g.apply((GetStatementResultV2Response) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftDataResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetStatementResultV2Response> {
        /**
         * <p>
         * The properties (metadata) of a column.
         * </p>
         * 
         * @param columnMetadata
         *        The properties (metadata) of a column.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnMetadata(Collection<ColumnMetadata> columnMetadata);

        /**
         * <p>
         * The properties (metadata) of a column.
         * </p>
         * 
         * @param columnMetadata
         *        The properties (metadata) of a column.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnMetadata(ColumnMetadata... columnMetadata);

        /**
         * <p>
         * The properties (metadata) of a column.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.redshiftdata.model.ColumnMetadata.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.redshiftdata.model.ColumnMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.redshiftdata.model.ColumnMetadata.Builder#build()} is called
         * immediately and its result is passed to {@link #columnMetadata(List<ColumnMetadata>)}.
         * 
         * @param columnMetadata
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.redshiftdata.model.ColumnMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #columnMetadata(java.util.Collection<ColumnMetadata>)
         */
        Builder columnMetadata(Consumer<ColumnMetadata.Builder>... columnMetadata);

        /**
         * <p>
         * A value that indicates the starting point for the next set of response records in a subsequent request. If a
         * value is returned in a response, you can retrieve the next set of records by providing this returned
         * NextToken value in the next NextToken parameter and retrying the command. If the NextToken field is empty,
         * all response records have been retrieved for the request.
         * </p>
         * 
         * @param nextToken
         *        A value that indicates the starting point for the next set of response records in a subsequent
         *        request. If a value is returned in a response, you can retrieve the next set of records by providing
         *        this returned NextToken value in the next NextToken parameter and retrying the command. If the
         *        NextToken field is empty, all response records have been retrieved for the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The results of the SQL statement in CSV format.
         * </p>
         * 
         * @param records
         *        The results of the SQL statement in CSV format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder records(Collection<QueryRecords> records);

        /**
         * <p>
         * The results of the SQL statement in CSV format.
         * </p>
         * 
         * @param records
         *        The results of the SQL statement in CSV format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder records(QueryRecords... records);

        /**
         * <p>
         * The results of the SQL statement in CSV format.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.redshiftdata.model.QueryRecords.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.redshiftdata.model.QueryRecords#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.redshiftdata.model.QueryRecords.Builder#build()} is called immediately
         * and its result is passed to {@link #records(List<QueryRecords>)}.
         * 
         * @param records
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.redshiftdata.model.QueryRecords.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #records(java.util.Collection<QueryRecords>)
         */
        Builder records(Consumer<QueryRecords.Builder>... records);

        /**
         * <p>
         * The data format of the result of the SQL statement.
         * </p>
         * 
         * @param resultFormat
         *        The data format of the result of the SQL statement.
         * @see ResultFormatString
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResultFormatString
         */
        Builder resultFormat(String resultFormat);

        /**
         * <p>
         * The data format of the result of the SQL statement.
         * </p>
         * 
         * @param resultFormat
         *        The data format of the result of the SQL statement.
         * @see ResultFormatString
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResultFormatString
         */
        Builder resultFormat(ResultFormatString resultFormat);

        /**
         * <p>
         * The total number of rows in the result set returned from a query. You can use this number to estimate the
         * number of calls to the <code>GetStatementResultV2</code> operation needed to page through the results.
         * </p>
         * 
         * @param totalNumRows
         *        The total number of rows in the result set returned from a query. You can use this number to estimate
         *        the number of calls to the <code>GetStatementResultV2</code> operation needed to page through the
         *        results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalNumRows(Long totalNumRows);
    }

    static final class BuilderImpl extends RedshiftDataResponse.BuilderImpl implements Builder {
        private List<ColumnMetadata> columnMetadata = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private List<QueryRecords> records = DefaultSdkAutoConstructList.getInstance();

        private String resultFormat;

        private Long totalNumRows;

        private BuilderImpl() {
        }

        private BuilderImpl(GetStatementResultV2Response model) {
            super(model);
            columnMetadata(model.columnMetadata);
            nextToken(model.nextToken);
            records(model.records);
            resultFormat(model.resultFormat);
            totalNumRows(model.totalNumRows);
        }

        public final List<ColumnMetadata.Builder> getColumnMetadata() {
            List<ColumnMetadata.Builder> result = ColumnMetadataListCopier.copyToBuilder(this.columnMetadata);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setColumnMetadata(Collection<ColumnMetadata.BuilderImpl> columnMetadata) {
            this.columnMetadata = ColumnMetadataListCopier.copyFromBuilder(columnMetadata);
        }

        @Override
        public final Builder columnMetadata(Collection<ColumnMetadata> columnMetadata) {
            this.columnMetadata = ColumnMetadataListCopier.copy(columnMetadata);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columnMetadata(ColumnMetadata... columnMetadata) {
            columnMetadata(Arrays.asList(columnMetadata));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columnMetadata(Consumer<ColumnMetadata.Builder>... columnMetadata) {
            columnMetadata(Stream.of(columnMetadata).map(c -> ColumnMetadata.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<QueryRecords.Builder> getRecords() {
            List<QueryRecords.Builder> result = FormattedSqlRecordsCopier.copyToBuilder(this.records);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRecords(Collection<QueryRecords.BuilderImpl> records) {
            this.records = FormattedSqlRecordsCopier.copyFromBuilder(records);
        }

        @Override
        public final Builder records(Collection<QueryRecords> records) {
            this.records = FormattedSqlRecordsCopier.copy(records);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder records(QueryRecords... records) {
            records(Arrays.asList(records));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder records(Consumer<QueryRecords.Builder>... records) {
            records(Stream.of(records).map(c -> QueryRecords.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getResultFormat() {
            return resultFormat;
        }

        public final void setResultFormat(String resultFormat) {
            this.resultFormat = resultFormat;
        }

        @Override
        public final Builder resultFormat(String resultFormat) {
            this.resultFormat = resultFormat;
            return this;
        }

        @Override
        public final Builder resultFormat(ResultFormatString resultFormat) {
            this.resultFormat(resultFormat == null ? null : resultFormat.toString());
            return this;
        }

        public final Long getTotalNumRows() {
            return totalNumRows;
        }

        public final void setTotalNumRows(Long totalNumRows) {
            this.totalNumRows = totalNumRows;
        }

        @Override
        public final Builder totalNumRows(Long totalNumRows) {
            this.totalNumRows = totalNumRows;
            return this;
        }

        @Override
        public GetStatementResultV2Response build() {
            return new GetStatementResultV2Response(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
