/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshiftdata;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.redshiftdata.RedshiftDataClient;
import software.amazon.awssdk.services.redshiftdata.RedshiftDataServiceClientConfiguration;
import software.amazon.awssdk.services.redshiftdata.internal.RedshiftDataServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.redshiftdata.model.ActiveSessionsExceededException;
import software.amazon.awssdk.services.redshiftdata.model.ActiveStatementsExceededException;
import software.amazon.awssdk.services.redshiftdata.model.BatchExecuteStatementException;
import software.amazon.awssdk.services.redshiftdata.model.BatchExecuteStatementRequest;
import software.amazon.awssdk.services.redshiftdata.model.BatchExecuteStatementResponse;
import software.amazon.awssdk.services.redshiftdata.model.CancelStatementRequest;
import software.amazon.awssdk.services.redshiftdata.model.CancelStatementResponse;
import software.amazon.awssdk.services.redshiftdata.model.DatabaseConnectionException;
import software.amazon.awssdk.services.redshiftdata.model.DescribeStatementRequest;
import software.amazon.awssdk.services.redshiftdata.model.DescribeStatementResponse;
import software.amazon.awssdk.services.redshiftdata.model.DescribeTableRequest;
import software.amazon.awssdk.services.redshiftdata.model.DescribeTableResponse;
import software.amazon.awssdk.services.redshiftdata.model.ExecuteStatementException;
import software.amazon.awssdk.services.redshiftdata.model.ExecuteStatementRequest;
import software.amazon.awssdk.services.redshiftdata.model.ExecuteStatementResponse;
import software.amazon.awssdk.services.redshiftdata.model.GetStatementResultRequest;
import software.amazon.awssdk.services.redshiftdata.model.GetStatementResultResponse;
import software.amazon.awssdk.services.redshiftdata.model.GetStatementResultV2Request;
import software.amazon.awssdk.services.redshiftdata.model.GetStatementResultV2Response;
import software.amazon.awssdk.services.redshiftdata.model.InternalServerException;
import software.amazon.awssdk.services.redshiftdata.model.ListDatabasesRequest;
import software.amazon.awssdk.services.redshiftdata.model.ListDatabasesResponse;
import software.amazon.awssdk.services.redshiftdata.model.ListSchemasRequest;
import software.amazon.awssdk.services.redshiftdata.model.ListSchemasResponse;
import software.amazon.awssdk.services.redshiftdata.model.ListStatementsRequest;
import software.amazon.awssdk.services.redshiftdata.model.ListStatementsResponse;
import software.amazon.awssdk.services.redshiftdata.model.ListTablesRequest;
import software.amazon.awssdk.services.redshiftdata.model.ListTablesResponse;
import software.amazon.awssdk.services.redshiftdata.model.QueryTimeoutException;
import software.amazon.awssdk.services.redshiftdata.model.RedshiftDataException;
import software.amazon.awssdk.services.redshiftdata.model.ResourceNotFoundException;
import software.amazon.awssdk.services.redshiftdata.model.ValidationException;
import software.amazon.awssdk.services.redshiftdata.transform.BatchExecuteStatementRequestMarshaller;
import software.amazon.awssdk.services.redshiftdata.transform.CancelStatementRequestMarshaller;
import software.amazon.awssdk.services.redshiftdata.transform.DescribeStatementRequestMarshaller;
import software.amazon.awssdk.services.redshiftdata.transform.DescribeTableRequestMarshaller;
import software.amazon.awssdk.services.redshiftdata.transform.ExecuteStatementRequestMarshaller;
import software.amazon.awssdk.services.redshiftdata.transform.GetStatementResultRequestMarshaller;
import software.amazon.awssdk.services.redshiftdata.transform.GetStatementResultV2RequestMarshaller;
import software.amazon.awssdk.services.redshiftdata.transform.ListDatabasesRequestMarshaller;
import software.amazon.awssdk.services.redshiftdata.transform.ListSchemasRequestMarshaller;
import software.amazon.awssdk.services.redshiftdata.transform.ListStatementsRequestMarshaller;
import software.amazon.awssdk.services.redshiftdata.transform.ListTablesRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultRedshiftDataClient
implements RedshiftDataClient {
    private static final Logger log = Logger.loggerFor(DefaultRedshiftDataClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.AWS_JSON).build();
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultRedshiftDataClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).option((ClientOption)SdkClientOption.API_METADATA, (Object)"Redshift_Data#2.36.x").build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchExecuteStatementResponse batchExecuteStatement(BatchExecuteStatementRequest batchExecuteStatementRequest) throws ValidationException, ActiveSessionsExceededException, ActiveStatementsExceededException, BatchExecuteStatementException, InternalServerException, AwsServiceException, SdkClientException, RedshiftDataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchExecuteStatementResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ActiveStatementsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActiveStatementsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActiveStatementsExceededException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "QueryTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("QueryTimeoutException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueryTimeoutException::builder).build());
                }
                case "DatabaseConnectionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DatabaseConnectionException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(DatabaseConnectionException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ActiveSessionsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActiveSessionsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActiveSessionsExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ExecuteStatementException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecuteStatementException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ExecuteStatementException::builder).build());
                }
                case "BatchExecuteStatementException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchExecuteStatementException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(BatchExecuteStatementException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)batchExecuteStatementRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftDataClient.resolveMetricPublishers(clientConfiguration, batchExecuteStatementRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift Data");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchExecuteStatement");
            BatchExecuteStatementResponse batchExecuteStatementResponse = (BatchExecuteStatementResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchExecuteStatement").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)batchExecuteStatementRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new BatchExecuteStatementRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return batchExecuteStatementResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftDataClient.lambda$batchExecuteStatement$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CancelStatementResponse cancelStatement(CancelStatementRequest cancelStatementRequest) throws ValidationException, ResourceNotFoundException, InternalServerException, DatabaseConnectionException, AwsServiceException, SdkClientException, RedshiftDataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CancelStatementResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ActiveStatementsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActiveStatementsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActiveStatementsExceededException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "QueryTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("QueryTimeoutException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueryTimeoutException::builder).build());
                }
                case "DatabaseConnectionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DatabaseConnectionException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(DatabaseConnectionException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ActiveSessionsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActiveSessionsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActiveSessionsExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ExecuteStatementException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecuteStatementException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ExecuteStatementException::builder).build());
                }
                case "BatchExecuteStatementException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchExecuteStatementException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(BatchExecuteStatementException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)cancelStatementRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftDataClient.resolveMetricPublishers(clientConfiguration, cancelStatementRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift Data");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CancelStatement");
            CancelStatementResponse cancelStatementResponse = (CancelStatementResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CancelStatement").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)cancelStatementRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CancelStatementRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return cancelStatementResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftDataClient.lambda$cancelStatement$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeStatementResponse describeStatement(DescribeStatementRequest describeStatementRequest) throws ValidationException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, RedshiftDataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeStatementResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ActiveStatementsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActiveStatementsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActiveStatementsExceededException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "QueryTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("QueryTimeoutException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueryTimeoutException::builder).build());
                }
                case "DatabaseConnectionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DatabaseConnectionException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(DatabaseConnectionException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ActiveSessionsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActiveSessionsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActiveSessionsExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ExecuteStatementException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecuteStatementException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ExecuteStatementException::builder).build());
                }
                case "BatchExecuteStatementException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchExecuteStatementException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(BatchExecuteStatementException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeStatementRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftDataClient.resolveMetricPublishers(clientConfiguration, describeStatementRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift Data");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeStatement");
            DescribeStatementResponse describeStatementResponse = (DescribeStatementResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeStatement").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeStatementRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeStatementRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeStatementResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftDataClient.lambda$describeStatement$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeTableResponse describeTable(DescribeTableRequest describeTableRequest) throws ValidationException, QueryTimeoutException, InternalServerException, DatabaseConnectionException, AwsServiceException, SdkClientException, RedshiftDataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeTableResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ActiveStatementsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActiveStatementsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActiveStatementsExceededException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "QueryTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("QueryTimeoutException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueryTimeoutException::builder).build());
                }
                case "DatabaseConnectionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DatabaseConnectionException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(DatabaseConnectionException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ActiveSessionsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActiveSessionsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActiveSessionsExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ExecuteStatementException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecuteStatementException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ExecuteStatementException::builder).build());
                }
                case "BatchExecuteStatementException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchExecuteStatementException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(BatchExecuteStatementException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeTableRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftDataClient.resolveMetricPublishers(clientConfiguration, describeTableRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift Data");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeTable");
            DescribeTableResponse describeTableResponse = (DescribeTableResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeTable").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeTableRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeTableRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeTableResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftDataClient.lambda$describeTable$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExecuteStatementResponse executeStatement(ExecuteStatementRequest executeStatementRequest) throws ValidationException, ActiveSessionsExceededException, ExecuteStatementException, ActiveStatementsExceededException, InternalServerException, AwsServiceException, SdkClientException, RedshiftDataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ExecuteStatementResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ActiveStatementsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActiveStatementsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActiveStatementsExceededException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "QueryTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("QueryTimeoutException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueryTimeoutException::builder).build());
                }
                case "DatabaseConnectionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DatabaseConnectionException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(DatabaseConnectionException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ActiveSessionsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActiveSessionsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActiveSessionsExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ExecuteStatementException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecuteStatementException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ExecuteStatementException::builder).build());
                }
                case "BatchExecuteStatementException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchExecuteStatementException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(BatchExecuteStatementException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)executeStatementRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftDataClient.resolveMetricPublishers(clientConfiguration, executeStatementRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift Data");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ExecuteStatement");
            ExecuteStatementResponse executeStatementResponse = (ExecuteStatementResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ExecuteStatement").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)executeStatementRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ExecuteStatementRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return executeStatementResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftDataClient.lambda$executeStatement$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetStatementResultResponse getStatementResult(GetStatementResultRequest getStatementResultRequest) throws ValidationException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, RedshiftDataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetStatementResultResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ActiveStatementsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActiveStatementsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActiveStatementsExceededException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "QueryTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("QueryTimeoutException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueryTimeoutException::builder).build());
                }
                case "DatabaseConnectionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DatabaseConnectionException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(DatabaseConnectionException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ActiveSessionsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActiveSessionsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActiveSessionsExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ExecuteStatementException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecuteStatementException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ExecuteStatementException::builder).build());
                }
                case "BatchExecuteStatementException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchExecuteStatementException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(BatchExecuteStatementException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getStatementResultRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftDataClient.resolveMetricPublishers(clientConfiguration, getStatementResultRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift Data");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetStatementResult");
            GetStatementResultResponse getStatementResultResponse = (GetStatementResultResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetStatementResult").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getStatementResultRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetStatementResultRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getStatementResultResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftDataClient.lambda$getStatementResult$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetStatementResultV2Response getStatementResultV2(GetStatementResultV2Request getStatementResultV2Request) throws ValidationException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, RedshiftDataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetStatementResultV2Response::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ActiveStatementsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActiveStatementsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActiveStatementsExceededException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "QueryTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("QueryTimeoutException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueryTimeoutException::builder).build());
                }
                case "DatabaseConnectionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DatabaseConnectionException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(DatabaseConnectionException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ActiveSessionsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActiveSessionsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActiveSessionsExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ExecuteStatementException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecuteStatementException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ExecuteStatementException::builder).build());
                }
                case "BatchExecuteStatementException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchExecuteStatementException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(BatchExecuteStatementException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getStatementResultV2Request, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftDataClient.resolveMetricPublishers(clientConfiguration, getStatementResultV2Request.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift Data");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetStatementResultV2");
            GetStatementResultV2Response getStatementResultV2Response = (GetStatementResultV2Response)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetStatementResultV2").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getStatementResultV2Request).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetStatementResultV2RequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getStatementResultV2Response;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftDataClient.lambda$getStatementResultV2$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListDatabasesResponse listDatabases(ListDatabasesRequest listDatabasesRequest) throws ValidationException, QueryTimeoutException, InternalServerException, DatabaseConnectionException, AwsServiceException, SdkClientException, RedshiftDataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDatabasesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ActiveStatementsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActiveStatementsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActiveStatementsExceededException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "QueryTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("QueryTimeoutException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueryTimeoutException::builder).build());
                }
                case "DatabaseConnectionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DatabaseConnectionException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(DatabaseConnectionException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ActiveSessionsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActiveSessionsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActiveSessionsExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ExecuteStatementException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecuteStatementException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ExecuteStatementException::builder).build());
                }
                case "BatchExecuteStatementException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchExecuteStatementException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(BatchExecuteStatementException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listDatabasesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftDataClient.resolveMetricPublishers(clientConfiguration, listDatabasesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift Data");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListDatabases");
            ListDatabasesResponse listDatabasesResponse = (ListDatabasesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDatabases").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listDatabasesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListDatabasesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listDatabasesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftDataClient.lambda$listDatabases$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListSchemasResponse listSchemas(ListSchemasRequest listSchemasRequest) throws ValidationException, QueryTimeoutException, InternalServerException, DatabaseConnectionException, AwsServiceException, SdkClientException, RedshiftDataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListSchemasResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ActiveStatementsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActiveStatementsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActiveStatementsExceededException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "QueryTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("QueryTimeoutException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueryTimeoutException::builder).build());
                }
                case "DatabaseConnectionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DatabaseConnectionException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(DatabaseConnectionException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ActiveSessionsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActiveSessionsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActiveSessionsExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ExecuteStatementException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecuteStatementException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ExecuteStatementException::builder).build());
                }
                case "BatchExecuteStatementException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchExecuteStatementException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(BatchExecuteStatementException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listSchemasRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftDataClient.resolveMetricPublishers(clientConfiguration, listSchemasRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift Data");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListSchemas");
            ListSchemasResponse listSchemasResponse = (ListSchemasResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListSchemas").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listSchemasRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListSchemasRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listSchemasResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftDataClient.lambda$listSchemas$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListStatementsResponse listStatements(ListStatementsRequest listStatementsRequest) throws ValidationException, InternalServerException, AwsServiceException, SdkClientException, RedshiftDataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListStatementsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ActiveStatementsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActiveStatementsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActiveStatementsExceededException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "QueryTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("QueryTimeoutException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueryTimeoutException::builder).build());
                }
                case "DatabaseConnectionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DatabaseConnectionException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(DatabaseConnectionException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ActiveSessionsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActiveSessionsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActiveSessionsExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ExecuteStatementException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecuteStatementException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ExecuteStatementException::builder).build());
                }
                case "BatchExecuteStatementException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchExecuteStatementException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(BatchExecuteStatementException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listStatementsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftDataClient.resolveMetricPublishers(clientConfiguration, listStatementsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift Data");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListStatements");
            ListStatementsResponse listStatementsResponse = (ListStatementsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListStatements").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listStatementsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListStatementsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listStatementsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftDataClient.lambda$listStatements$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTablesResponse listTables(ListTablesRequest listTablesRequest) throws ValidationException, QueryTimeoutException, InternalServerException, DatabaseConnectionException, AwsServiceException, SdkClientException, RedshiftDataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTablesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ActiveStatementsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActiveStatementsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActiveStatementsExceededException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "QueryTimeoutException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("QueryTimeoutException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueryTimeoutException::builder).build());
                }
                case "DatabaseConnectionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DatabaseConnectionException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(DatabaseConnectionException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ActiveSessionsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ActiveSessionsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ActiveSessionsExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ExecuteStatementException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ExecuteStatementException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(ExecuteStatementException::builder).build());
                }
                case "BatchExecuteStatementException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("BatchExecuteStatementException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(BatchExecuteStatementException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTablesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultRedshiftDataClient.resolveMetricPublishers(clientConfiguration, listTablesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Redshift Data");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTables");
            ListTablesResponse listTablesResponse = (ListTablesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTables").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listTablesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTablesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTablesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultRedshiftDataClient.lambda$listTables$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    public final String serviceName() {
        return "redshift-data";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        RedshiftDataServiceClientConfigurationBuilder serviceConfigBuilder = new RedshiftDataServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(RedshiftDataException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1");
    }

    @Override
    public final RedshiftDataServiceClientConfiguration serviceClientConfiguration() {
        return new RedshiftDataServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$listTables$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listStatements$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listSchemas$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listDatabases$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getStatementResultV2$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getStatementResult$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$executeStatement$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeTable$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeStatement$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$cancelStatement$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchExecuteStatement$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

