/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshiftserverless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An array of key-value pairs to set for advanced control over Amazon Redshift Serverless.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConfigParameter implements SdkPojo, Serializable, ToCopyableBuilder<ConfigParameter.Builder, ConfigParameter> {
    private static final SdkField<String> PARAMETER_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("parameterKey").getter(getter(ConfigParameter::parameterKey)).setter(setter(Builder::parameterKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameterKey").build()).build();

    private static final SdkField<String> PARAMETER_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("parameterValue").getter(getter(ConfigParameter::parameterValue)).setter(setter(Builder::parameterValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameterValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARAMETER_KEY_FIELD,
            PARAMETER_VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String parameterKey;

    private final String parameterValue;

    private ConfigParameter(BuilderImpl builder) {
        this.parameterKey = builder.parameterKey;
        this.parameterValue = builder.parameterValue;
    }

    /**
     * <p>
     * The key of the parameter. The options are <code>datestyle</code>, <code>enable_user_activity_logging</code>,
     * <code>query_group</code>, <code>search_path</code>, and <code>max_query_execution_time</code>.
     * </p>
     * 
     * @return The key of the parameter. The options are <code>datestyle</code>,
     *         <code>enable_user_activity_logging</code>, <code>query_group</code>, <code>search_path</code>, and
     *         <code>max_query_execution_time</code>.
     */
    public final String parameterKey() {
        return parameterKey;
    }

    /**
     * <p>
     * The value of the parameter to set.
     * </p>
     * 
     * @return The value of the parameter to set.
     */
    public final String parameterValue() {
        return parameterValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(parameterKey());
        hashCode = 31 * hashCode + Objects.hashCode(parameterValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigParameter)) {
            return false;
        }
        ConfigParameter other = (ConfigParameter) obj;
        return Objects.equals(parameterKey(), other.parameterKey()) && Objects.equals(parameterValue(), other.parameterValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConfigParameter").add("ParameterKey", parameterKey()).add("ParameterValue", parameterValue())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "parameterKey":
            return Optional.ofNullable(clazz.cast(parameterKey()));
        case "parameterValue":
            return Optional.ofNullable(clazz.cast(parameterValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConfigParameter, T> g) {
        return obj -> g.apply((ConfigParameter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConfigParameter> {
        /**
         * <p>
         * The key of the parameter. The options are <code>datestyle</code>, <code>enable_user_activity_logging</code>,
         * <code>query_group</code>, <code>search_path</code>, and <code>max_query_execution_time</code>.
         * </p>
         * 
         * @param parameterKey
         *        The key of the parameter. The options are <code>datestyle</code>,
         *        <code>enable_user_activity_logging</code>, <code>query_group</code>, <code>search_path</code>, and
         *        <code>max_query_execution_time</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterKey(String parameterKey);

        /**
         * <p>
         * The value of the parameter to set.
         * </p>
         * 
         * @param parameterValue
         *        The value of the parameter to set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterValue(String parameterValue);
    }

    static final class BuilderImpl implements Builder {
        private String parameterKey;

        private String parameterValue;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigParameter model) {
            parameterKey(model.parameterKey);
            parameterValue(model.parameterValue);
        }

        public final String getParameterKey() {
            return parameterKey;
        }

        public final void setParameterKey(String parameterKey) {
            this.parameterKey = parameterKey;
        }

        @Override
        public final Builder parameterKey(String parameterKey) {
            this.parameterKey = parameterKey;
            return this;
        }

        public final String getParameterValue() {
            return parameterValue;
        }

        public final void setParameterValue(String parameterValue) {
            this.parameterValue = parameterValue;
        }

        @Override
        public final Builder parameterValue(String parameterValue) {
            this.parameterValue = parameterValue;
            return this;
        }

        @Override
        public ConfigParameter build() {
            return new ConfigParameter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
