/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshiftserverless.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateScheduledActionRequest extends RedshiftServerlessRequest implements
        ToCopyableBuilder<CreateScheduledActionRequest.Builder, CreateScheduledActionRequest> {
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("enabled").getter(getter(CreateScheduledActionRequest::enabled)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enabled").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("endTime").getter(getter(CreateScheduledActionRequest::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()).build();

    private static final SdkField<String> NAMESPACE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("namespaceName").getter(getter(CreateScheduledActionRequest::namespaceName))
            .setter(setter(Builder::namespaceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespaceName").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(CreateScheduledActionRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<Schedule> SCHEDULE_FIELD = SdkField.<Schedule> builder(MarshallingType.SDK_POJO)
            .memberName("schedule").getter(getter(CreateScheduledActionRequest::schedule)).setter(setter(Builder::schedule))
            .constructor(Schedule::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schedule").build()).build();

    private static final SdkField<String> SCHEDULED_ACTION_DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("scheduledActionDescription")
            .getter(getter(CreateScheduledActionRequest::scheduledActionDescription))
            .setter(setter(Builder::scheduledActionDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scheduledActionDescription").build())
            .build();

    private static final SdkField<String> SCHEDULED_ACTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("scheduledActionName").getter(getter(CreateScheduledActionRequest::scheduledActionName))
            .setter(setter(Builder::scheduledActionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scheduledActionName").build())
            .build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("startTime").getter(getter(CreateScheduledActionRequest::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()).build();

    private static final SdkField<TargetAction> TARGET_ACTION_FIELD = SdkField.<TargetAction> builder(MarshallingType.SDK_POJO)
            .memberName("targetAction").getter(getter(CreateScheduledActionRequest::targetAction))
            .setter(setter(Builder::targetAction)).constructor(TargetAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetAction").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_FIELD, END_TIME_FIELD,
            NAMESPACE_NAME_FIELD, ROLE_ARN_FIELD, SCHEDULE_FIELD, SCHEDULED_ACTION_DESCRIPTION_FIELD,
            SCHEDULED_ACTION_NAME_FIELD, START_TIME_FIELD, TARGET_ACTION_FIELD));

    private final Boolean enabled;

    private final Instant endTime;

    private final String namespaceName;

    private final String roleArn;

    private final Schedule schedule;

    private final String scheduledActionDescription;

    private final String scheduledActionName;

    private final Instant startTime;

    private final TargetAction targetAction;

    private CreateScheduledActionRequest(BuilderImpl builder) {
        super(builder);
        this.enabled = builder.enabled;
        this.endTime = builder.endTime;
        this.namespaceName = builder.namespaceName;
        this.roleArn = builder.roleArn;
        this.schedule = builder.schedule;
        this.scheduledActionDescription = builder.scheduledActionDescription;
        this.scheduledActionName = builder.scheduledActionName;
        this.startTime = builder.startTime;
        this.targetAction = builder.targetAction;
    }

    /**
     * <p>
     * Indicates whether the schedule is enabled. If false, the scheduled action does not trigger. For more information
     * about <code>state</code> of the scheduled action, see <a
     * href="https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_ScheduledAction.html"
     * >ScheduledAction</a>.
     * </p>
     * 
     * @return Indicates whether the schedule is enabled. If false, the scheduled action does not trigger. For more
     *         information about <code>state</code> of the scheduled action, see <a
     *         href="https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_ScheduledAction.html"
     *         >ScheduledAction</a>.
     */
    public final Boolean enabled() {
        return enabled;
    }

    /**
     * <p>
     * The end time in UTC when the schedule is no longer active. After this time, the scheduled action does not
     * trigger.
     * </p>
     * 
     * @return The end time in UTC when the schedule is no longer active. After this time, the scheduled action does not
     *         trigger.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * The name of the namespace for which to create a scheduled action.
     * </p>
     * 
     * @return The name of the namespace for which to create a scheduled action.
     */
    public final String namespaceName() {
        return namespaceName;
    }

    /**
     * <p>
     * The ARN of the IAM role to assume to run the scheduled action. This IAM role must have permission to run the
     * Amazon Redshift Serverless API operation in the scheduled action. This IAM role must allow the Amazon Redshift
     * scheduler to schedule creating snapshots. (Principal scheduler.redshift.amazonaws.com) to assume permissions on
     * your behalf. For more information about the IAM role to use with the Amazon Redshift scheduler, see <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-identity-based.html">Using
     * Identity-Based Policies for Amazon Redshift</a> in the Amazon Redshift Cluster Management Guide
     * </p>
     * 
     * @return The ARN of the IAM role to assume to run the scheduled action. This IAM role must have permission to run
     *         the Amazon Redshift Serverless API operation in the scheduled action. This IAM role must allow the Amazon
     *         Redshift scheduler to schedule creating snapshots. (Principal scheduler.redshift.amazonaws.com) to assume
     *         permissions on your behalf. For more information about the IAM role to use with the Amazon Redshift
     *         scheduler, see <a
     *         href="https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-identity-based.html"
     *         >Using Identity-Based Policies for Amazon Redshift</a> in the Amazon Redshift Cluster Management Guide
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The schedule for a one-time (at format) or recurring (cron format) scheduled action. Schedule invocations must be
     * separated by at least one hour.
     * </p>
     * <p>
     * Format of at expressions is "<code>at(yyyy-mm-ddThh:mm:ss)</code>". For example, "
     * <code>at(2016-03-04T17:27:00)</code>".
     * </p>
     * <p>
     * Format of cron expressions is "<code>cron(Minutes Hours Day-of-month Month Day-of-week Year)</code>
     * ". For example, "<code>cron(0 10 ? * MON *)</code>
     * ". For more information, see <a href="https://docs.aws.amazon.com
     * /AmazonCloudWatch/latest/events/ScheduledEvents.html#CronExpressions">Cron Expressions</a> in the <i>Amazon
     * CloudWatch Events User Guide</i>.
     * </p>
     * 
     * @return The schedule for a one-time (at format) or recurring (cron format) scheduled action. Schedule invocations
     *         must be separated by at least one hour.</p>
     *         <p>
     *         Format of at expressions is "<code>at(yyyy-mm-ddThh:mm:ss)</code>". For example, "
     *         <code>at(2016-03-04T17:27:00)</code>".
     *         </p>
     *         <p>
     *         Format of cron expressions is "<code>cron(Minutes Hours Day-of-month Month Day-of-week Year)</code>
     *         ". For example, "<code>cron(0 10 ? * MON *)</code>
     *         ". For more information, see <a href="https://docs.aws.amazon
     *         .com/AmazonCloudWatch/latest/events/ScheduledEvents.html#CronExpressions">Cron Expressions</a> in the
     *         <i>Amazon CloudWatch Events User Guide</i>.
     */
    public final Schedule schedule() {
        return schedule;
    }

    /**
     * <p>
     * The description of the scheduled action.
     * </p>
     * 
     * @return The description of the scheduled action.
     */
    public final String scheduledActionDescription() {
        return scheduledActionDescription;
    }

    /**
     * <p>
     * The name of the scheduled action.
     * </p>
     * 
     * @return The name of the scheduled action.
     */
    public final String scheduledActionName() {
        return scheduledActionName;
    }

    /**
     * <p>
     * The start time in UTC when the schedule is active. Before this time, the scheduled action does not trigger.
     * </p>
     * 
     * @return The start time in UTC when the schedule is active. Before this time, the scheduled action does not
     *         trigger.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * Returns the value of the TargetAction property for this object.
     * 
     * @return The value of the TargetAction property for this object.
     */
    public final TargetAction targetAction() {
        return targetAction;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(namespaceName());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(schedule());
        hashCode = 31 * hashCode + Objects.hashCode(scheduledActionDescription());
        hashCode = 31 * hashCode + Objects.hashCode(scheduledActionName());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(targetAction());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateScheduledActionRequest)) {
            return false;
        }
        CreateScheduledActionRequest other = (CreateScheduledActionRequest) obj;
        return Objects.equals(enabled(), other.enabled()) && Objects.equals(endTime(), other.endTime())
                && Objects.equals(namespaceName(), other.namespaceName()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(schedule(), other.schedule())
                && Objects.equals(scheduledActionDescription(), other.scheduledActionDescription())
                && Objects.equals(scheduledActionName(), other.scheduledActionName())
                && Objects.equals(startTime(), other.startTime()) && Objects.equals(targetAction(), other.targetAction());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateScheduledActionRequest").add("Enabled", enabled()).add("EndTime", endTime())
                .add("NamespaceName", namespaceName()).add("RoleArn", roleArn()).add("Schedule", schedule())
                .add("ScheduledActionDescription", scheduledActionDescription())
                .add("ScheduledActionName", scheduledActionName()).add("StartTime", startTime())
                .add("TargetAction", targetAction()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "endTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "namespaceName":
            return Optional.ofNullable(clazz.cast(namespaceName()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "schedule":
            return Optional.ofNullable(clazz.cast(schedule()));
        case "scheduledActionDescription":
            return Optional.ofNullable(clazz.cast(scheduledActionDescription()));
        case "scheduledActionName":
            return Optional.ofNullable(clazz.cast(scheduledActionName()));
        case "startTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "targetAction":
            return Optional.ofNullable(clazz.cast(targetAction()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateScheduledActionRequest, T> g) {
        return obj -> g.apply((CreateScheduledActionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftServerlessRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateScheduledActionRequest> {
        /**
         * <p>
         * Indicates whether the schedule is enabled. If false, the scheduled action does not trigger. For more
         * information about <code>state</code> of the scheduled action, see <a
         * href="https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_ScheduledAction.html"
         * >ScheduledAction</a>.
         * </p>
         * 
         * @param enabled
         *        Indicates whether the schedule is enabled. If false, the scheduled action does not trigger. For more
         *        information about <code>state</code> of the scheduled action, see <a
         *        href="https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_ScheduledAction.html"
         *        >ScheduledAction</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * The end time in UTC when the schedule is no longer active. After this time, the scheduled action does not
         * trigger.
         * </p>
         * 
         * @param endTime
         *        The end time in UTC when the schedule is no longer active. After this time, the scheduled action does
         *        not trigger.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * The name of the namespace for which to create a scheduled action.
         * </p>
         * 
         * @param namespaceName
         *        The name of the namespace for which to create a scheduled action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespaceName(String namespaceName);

        /**
         * <p>
         * The ARN of the IAM role to assume to run the scheduled action. This IAM role must have permission to run the
         * Amazon Redshift Serverless API operation in the scheduled action. This IAM role must allow the Amazon
         * Redshift scheduler to schedule creating snapshots. (Principal scheduler.redshift.amazonaws.com) to assume
         * permissions on your behalf. For more information about the IAM role to use with the Amazon Redshift
         * scheduler, see <a
         * href="https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-identity-based.html">Using
         * Identity-Based Policies for Amazon Redshift</a> in the Amazon Redshift Cluster Management Guide
         * </p>
         * 
         * @param roleArn
         *        The ARN of the IAM role to assume to run the scheduled action. This IAM role must have permission to
         *        run the Amazon Redshift Serverless API operation in the scheduled action. This IAM role must allow the
         *        Amazon Redshift scheduler to schedule creating snapshots. (Principal scheduler.redshift.amazonaws.com)
         *        to assume permissions on your behalf. For more information about the IAM role to use with the Amazon
         *        Redshift scheduler, see <a href=
         *        "https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-identity-based.html"
         *        >Using Identity-Based Policies for Amazon Redshift</a> in the Amazon Redshift Cluster Management Guide
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The schedule for a one-time (at format) or recurring (cron format) scheduled action. Schedule invocations
         * must be separated by at least one hour.
         * </p>
         * <p>
         * Format of at expressions is "<code>at(yyyy-mm-ddThh:mm:ss)</code>". For example, "
         * <code>at(2016-03-04T17:27:00)</code>".
         * </p>
         * <p>
         * Format of cron expressions is "<code>cron(Minutes Hours Day-of-month Month Day-of-week Year)</code>
         * ". For example, "<code>cron(0 10 ? * MON *)</code>
         * ". For more information, see <a href="https://docs.aws.amazon
         * .com/AmazonCloudWatch/latest/events/ScheduledEvents.html#CronExpressions">Cron Expressions</a> in the
         * <i>Amazon CloudWatch Events User Guide</i>.
         * </p>
         * 
         * @param schedule
         *        The schedule for a one-time (at format) or recurring (cron format) scheduled action. Schedule
         *        invocations must be separated by at least one hour.</p>
         *        <p>
         *        Format of at expressions is "<code>at(yyyy-mm-ddThh:mm:ss)</code>". For example, "
         *        <code>at(2016-03-04T17:27:00)</code>".
         *        </p>
         *        <p>
         *        Format of cron expressions is "<code>cron(Minutes Hours Day-of-month Month Day-of-week Year)</code>
         *        ". For example, "<code>cron(0 10 ? * MON *)</code>
         *        ". For more information, see <a href="https://docs.aws
         *        .amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html#CronExpressions">Cron Expressions</a>
         *        in the <i>Amazon CloudWatch Events User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schedule(Schedule schedule);

        /**
         * <p>
         * The schedule for a one-time (at format) or recurring (cron format) scheduled action. Schedule invocations
         * must be separated by at least one hour.
         * </p>
         * <p>
         * Format of at expressions is "<code>at(yyyy-mm-ddThh:mm:ss)</code>". For example, "
         * <code>at(2016-03-04T17:27:00)</code>".
         * </p>
         * <p>
         * Format of cron expressions is "<code>cron(Minutes Hours Day-of-month Month Day-of-week Year)</code>
         * ". For example, "<code>cron(0 10 ? * MON *)</code>
         * ". For more information, see <a href="https://docs.aws.amazon
         * .com/AmazonCloudWatch/latest/events/ScheduledEvents.html#CronExpressions">Cron Expressions</a> in the
         * <i>Amazon CloudWatch Events User Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the {@link Schedule.Builder} avoiding the need to
         * create one manually via {@link Schedule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Schedule.Builder#build()} is called immediately and its result is
         * passed to {@link #schedule(Schedule)}.
         * 
         * @param schedule
         *        a consumer that will call methods on {@link Schedule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #schedule(Schedule)
         */
        default Builder schedule(Consumer<Schedule.Builder> schedule) {
            return schedule(Schedule.builder().applyMutation(schedule).build());
        }

        /**
         * <p>
         * The description of the scheduled action.
         * </p>
         * 
         * @param scheduledActionDescription
         *        The description of the scheduled action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduledActionDescription(String scheduledActionDescription);

        /**
         * <p>
         * The name of the scheduled action.
         * </p>
         * 
         * @param scheduledActionName
         *        The name of the scheduled action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduledActionName(String scheduledActionName);

        /**
         * <p>
         * The start time in UTC when the schedule is active. Before this time, the scheduled action does not trigger.
         * </p>
         * 
         * @param startTime
         *        The start time in UTC when the schedule is active. Before this time, the scheduled action does not
         *        trigger.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * Sets the value of the TargetAction property for this object.
         *
         * @param targetAction
         *        The new value for the TargetAction property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetAction(TargetAction targetAction);

        /**
         * Sets the value of the TargetAction property for this object.
         *
         * This is a convenience method that creates an instance of the {@link TargetAction.Builder} avoiding the need
         * to create one manually via {@link TargetAction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TargetAction.Builder#build()} is called immediately and its
         * result is passed to {@link #targetAction(TargetAction)}.
         * 
         * @param targetAction
         *        a consumer that will call methods on {@link TargetAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetAction(TargetAction)
         */
        default Builder targetAction(Consumer<TargetAction.Builder> targetAction) {
            return targetAction(TargetAction.builder().applyMutation(targetAction).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RedshiftServerlessRequest.BuilderImpl implements Builder {
        private Boolean enabled;

        private Instant endTime;

        private String namespaceName;

        private String roleArn;

        private Schedule schedule;

        private String scheduledActionDescription;

        private String scheduledActionName;

        private Instant startTime;

        private TargetAction targetAction;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateScheduledActionRequest model) {
            super(model);
            enabled(model.enabled);
            endTime(model.endTime);
            namespaceName(model.namespaceName);
            roleArn(model.roleArn);
            schedule(model.schedule);
            scheduledActionDescription(model.scheduledActionDescription);
            scheduledActionName(model.scheduledActionName);
            startTime(model.startTime);
            targetAction(model.targetAction);
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getNamespaceName() {
            return namespaceName;
        }

        public final void setNamespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
        }

        @Override
        public final Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final Schedule.Builder getSchedule() {
            return schedule != null ? schedule.toBuilder() : null;
        }

        public final void setSchedule(Schedule.BuilderImpl schedule) {
            this.schedule = schedule != null ? schedule.build() : null;
        }

        @Override
        public final Builder schedule(Schedule schedule) {
            this.schedule = schedule;
            return this;
        }

        public final String getScheduledActionDescription() {
            return scheduledActionDescription;
        }

        public final void setScheduledActionDescription(String scheduledActionDescription) {
            this.scheduledActionDescription = scheduledActionDescription;
        }

        @Override
        public final Builder scheduledActionDescription(String scheduledActionDescription) {
            this.scheduledActionDescription = scheduledActionDescription;
            return this;
        }

        public final String getScheduledActionName() {
            return scheduledActionName;
        }

        public final void setScheduledActionName(String scheduledActionName) {
            this.scheduledActionName = scheduledActionName;
        }

        @Override
        public final Builder scheduledActionName(String scheduledActionName) {
            this.scheduledActionName = scheduledActionName;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final TargetAction.Builder getTargetAction() {
            return targetAction != null ? targetAction.toBuilder() : null;
        }

        public final void setTargetAction(TargetAction.BuilderImpl targetAction) {
            this.targetAction = targetAction != null ? targetAction.build() : null;
        }

        @Override
        public final Builder targetAction(TargetAction targetAction) {
            this.targetAction = targetAction;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateScheduledActionRequest build() {
            return new CreateScheduledActionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
