/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshiftserverless.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a table restore request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TableRestoreStatus implements SdkPojo, Serializable,
        ToCopyableBuilder<TableRestoreStatus.Builder, TableRestoreStatus> {
    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("message")
            .getter(getter(TableRestoreStatus::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()).build();

    private static final SdkField<String> NAMESPACE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("namespaceName").getter(getter(TableRestoreStatus::namespaceName)).setter(setter(Builder::namespaceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespaceName").build()).build();

    private static final SdkField<String> NEW_TABLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("newTableName").getter(getter(TableRestoreStatus::newTableName)).setter(setter(Builder::newTableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("newTableName").build()).build();

    private static final SdkField<Long> PROGRESS_IN_MEGA_BYTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("progressInMegaBytes").getter(getter(TableRestoreStatus::progressInMegaBytes))
            .setter(setter(Builder::progressInMegaBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("progressInMegaBytes").build())
            .build();

    private static final SdkField<String> RECOVERY_POINT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("recoveryPointId").getter(getter(TableRestoreStatus::recoveryPointId))
            .setter(setter(Builder::recoveryPointId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recoveryPointId").build()).build();

    private static final SdkField<Instant> REQUEST_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("requestTime").getter(getter(TableRestoreStatus::requestTime)).setter(setter(Builder::requestTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestTime").build()).build();

    private static final SdkField<String> SNAPSHOT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("snapshotName").getter(getter(TableRestoreStatus::snapshotName)).setter(setter(Builder::snapshotName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("snapshotName").build()).build();

    private static final SdkField<String> SOURCE_DATABASE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceDatabaseName").getter(getter(TableRestoreStatus::sourceDatabaseName))
            .setter(setter(Builder::sourceDatabaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceDatabaseName").build())
            .build();

    private static final SdkField<String> SOURCE_SCHEMA_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceSchemaName").getter(getter(TableRestoreStatus::sourceSchemaName))
            .setter(setter(Builder::sourceSchemaName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceSchemaName").build()).build();

    private static final SdkField<String> SOURCE_TABLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceTableName").getter(getter(TableRestoreStatus::sourceTableName))
            .setter(setter(Builder::sourceTableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceTableName").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(TableRestoreStatus::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> TABLE_RESTORE_REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("tableRestoreRequestId").getter(getter(TableRestoreStatus::tableRestoreRequestId))
            .setter(setter(Builder::tableRestoreRequestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tableRestoreRequestId").build())
            .build();

    private static final SdkField<String> TARGET_DATABASE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("targetDatabaseName").getter(getter(TableRestoreStatus::targetDatabaseName))
            .setter(setter(Builder::targetDatabaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetDatabaseName").build())
            .build();

    private static final SdkField<String> TARGET_SCHEMA_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("targetSchemaName").getter(getter(TableRestoreStatus::targetSchemaName))
            .setter(setter(Builder::targetSchemaName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetSchemaName").build()).build();

    private static final SdkField<Long> TOTAL_DATA_IN_MEGA_BYTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("totalDataInMegaBytes").getter(getter(TableRestoreStatus::totalDataInMegaBytes))
            .setter(setter(Builder::totalDataInMegaBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalDataInMegaBytes").build())
            .build();

    private static final SdkField<String> WORKGROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workgroupName").getter(getter(TableRestoreStatus::workgroupName)).setter(setter(Builder::workgroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workgroupName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESSAGE_FIELD,
            NAMESPACE_NAME_FIELD, NEW_TABLE_NAME_FIELD, PROGRESS_IN_MEGA_BYTES_FIELD, RECOVERY_POINT_ID_FIELD,
            REQUEST_TIME_FIELD, SNAPSHOT_NAME_FIELD, SOURCE_DATABASE_NAME_FIELD, SOURCE_SCHEMA_NAME_FIELD,
            SOURCE_TABLE_NAME_FIELD, STATUS_FIELD, TABLE_RESTORE_REQUEST_ID_FIELD, TARGET_DATABASE_NAME_FIELD,
            TARGET_SCHEMA_NAME_FIELD, TOTAL_DATA_IN_MEGA_BYTES_FIELD, WORKGROUP_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String message;

    private final String namespaceName;

    private final String newTableName;

    private final Long progressInMegaBytes;

    private final String recoveryPointId;

    private final Instant requestTime;

    private final String snapshotName;

    private final String sourceDatabaseName;

    private final String sourceSchemaName;

    private final String sourceTableName;

    private final String status;

    private final String tableRestoreRequestId;

    private final String targetDatabaseName;

    private final String targetSchemaName;

    private final Long totalDataInMegaBytes;

    private final String workgroupName;

    private TableRestoreStatus(BuilderImpl builder) {
        this.message = builder.message;
        this.namespaceName = builder.namespaceName;
        this.newTableName = builder.newTableName;
        this.progressInMegaBytes = builder.progressInMegaBytes;
        this.recoveryPointId = builder.recoveryPointId;
        this.requestTime = builder.requestTime;
        this.snapshotName = builder.snapshotName;
        this.sourceDatabaseName = builder.sourceDatabaseName;
        this.sourceSchemaName = builder.sourceSchemaName;
        this.sourceTableName = builder.sourceTableName;
        this.status = builder.status;
        this.tableRestoreRequestId = builder.tableRestoreRequestId;
        this.targetDatabaseName = builder.targetDatabaseName;
        this.targetSchemaName = builder.targetSchemaName;
        this.totalDataInMegaBytes = builder.totalDataInMegaBytes;
        this.workgroupName = builder.workgroupName;
    }

    /**
     * <p>
     * A message that explains the returned status. For example, if the status of the operation is <code>FAILED</code>,
     * the message explains why the operation failed.
     * </p>
     * 
     * @return A message that explains the returned status. For example, if the status of the operation is
     *         <code>FAILED</code>, the message explains why the operation failed.
     */
    public final String message() {
        return message;
    }

    /**
     * <p>
     * The namespace of the table being restored from.
     * </p>
     * 
     * @return The namespace of the table being restored from.
     */
    public final String namespaceName() {
        return namespaceName;
    }

    /**
     * <p>
     * The name of the table to create from the restore operation.
     * </p>
     * 
     * @return The name of the table to create from the restore operation.
     */
    public final String newTableName() {
        return newTableName;
    }

    /**
     * <p>
     * The amount of data restored to the new table so far, in megabytes (MB).
     * </p>
     * 
     * @return The amount of data restored to the new table so far, in megabytes (MB).
     */
    public final Long progressInMegaBytes() {
        return progressInMegaBytes;
    }

    /**
     * <p>
     * The ID of the recovery point being restored from.
     * </p>
     * 
     * @return The ID of the recovery point being restored from.
     */
    public final String recoveryPointId() {
        return recoveryPointId;
    }

    /**
     * <p>
     * The time that the table restore request was made, in Universal Coordinated Time (UTC).
     * </p>
     * 
     * @return The time that the table restore request was made, in Universal Coordinated Time (UTC).
     */
    public final Instant requestTime() {
        return requestTime;
    }

    /**
     * <p>
     * The name of the snapshot being restored from.
     * </p>
     * 
     * @return The name of the snapshot being restored from.
     */
    public final String snapshotName() {
        return snapshotName;
    }

    /**
     * <p>
     * The name of the source database being restored from.
     * </p>
     * 
     * @return The name of the source database being restored from.
     */
    public final String sourceDatabaseName() {
        return sourceDatabaseName;
    }

    /**
     * <p>
     * The name of the source schema being restored from.
     * </p>
     * 
     * @return The name of the source schema being restored from.
     */
    public final String sourceSchemaName() {
        return sourceSchemaName;
    }

    /**
     * <p>
     * The name of the source table being restored from.
     * </p>
     * 
     * @return The name of the source table being restored from.
     */
    public final String sourceTableName() {
        return sourceTableName;
    }

    /**
     * <p>
     * A value that describes the current state of the table restore request. Possible values are <code>SUCCEEDED</code>, <code>FAILED</code>, <code>CANCELED</code>, <code>PENDING</code>, and <code>IN_PROGRESS</code>.
     * </p>
     * 
     * @return A value that describes the current state of the table restore request. Possible values are
     *         <code>SUCCEEDED</code>, <code>FAILED</code>, <code>CANCELED</code>, <code>PENDING</code>, and
     *         <code>IN_PROGRESS</code>.
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * The ID of the RestoreTableFromSnapshot request.
     * </p>
     * 
     * @return The ID of the RestoreTableFromSnapshot request.
     */
    public final String tableRestoreRequestId() {
        return tableRestoreRequestId;
    }

    /**
     * <p>
     * The name of the database to restore to.
     * </p>
     * 
     * @return The name of the database to restore to.
     */
    public final String targetDatabaseName() {
        return targetDatabaseName;
    }

    /**
     * <p>
     * The name of the schema to restore to.
     * </p>
     * 
     * @return The name of the schema to restore to.
     */
    public final String targetSchemaName() {
        return targetSchemaName;
    }

    /**
     * <p>
     * The total amount of data to restore to the new table, in megabytes (MB).
     * </p>
     * 
     * @return The total amount of data to restore to the new table, in megabytes (MB).
     */
    public final Long totalDataInMegaBytes() {
        return totalDataInMegaBytes;
    }

    /**
     * <p>
     * The name of the workgroup being restored from.
     * </p>
     * 
     * @return The name of the workgroup being restored from.
     */
    public final String workgroupName() {
        return workgroupName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(namespaceName());
        hashCode = 31 * hashCode + Objects.hashCode(newTableName());
        hashCode = 31 * hashCode + Objects.hashCode(progressInMegaBytes());
        hashCode = 31 * hashCode + Objects.hashCode(recoveryPointId());
        hashCode = 31 * hashCode + Objects.hashCode(requestTime());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotName());
        hashCode = 31 * hashCode + Objects.hashCode(sourceDatabaseName());
        hashCode = 31 * hashCode + Objects.hashCode(sourceSchemaName());
        hashCode = 31 * hashCode + Objects.hashCode(sourceTableName());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(tableRestoreRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(targetDatabaseName());
        hashCode = 31 * hashCode + Objects.hashCode(targetSchemaName());
        hashCode = 31 * hashCode + Objects.hashCode(totalDataInMegaBytes());
        hashCode = 31 * hashCode + Objects.hashCode(workgroupName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TableRestoreStatus)) {
            return false;
        }
        TableRestoreStatus other = (TableRestoreStatus) obj;
        return Objects.equals(message(), other.message()) && Objects.equals(namespaceName(), other.namespaceName())
                && Objects.equals(newTableName(), other.newTableName())
                && Objects.equals(progressInMegaBytes(), other.progressInMegaBytes())
                && Objects.equals(recoveryPointId(), other.recoveryPointId())
                && Objects.equals(requestTime(), other.requestTime()) && Objects.equals(snapshotName(), other.snapshotName())
                && Objects.equals(sourceDatabaseName(), other.sourceDatabaseName())
                && Objects.equals(sourceSchemaName(), other.sourceSchemaName())
                && Objects.equals(sourceTableName(), other.sourceTableName()) && Objects.equals(status(), other.status())
                && Objects.equals(tableRestoreRequestId(), other.tableRestoreRequestId())
                && Objects.equals(targetDatabaseName(), other.targetDatabaseName())
                && Objects.equals(targetSchemaName(), other.targetSchemaName())
                && Objects.equals(totalDataInMegaBytes(), other.totalDataInMegaBytes())
                && Objects.equals(workgroupName(), other.workgroupName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TableRestoreStatus").add("Message", message()).add("NamespaceName", namespaceName())
                .add("NewTableName", newTableName()).add("ProgressInMegaBytes", progressInMegaBytes())
                .add("RecoveryPointId", recoveryPointId()).add("RequestTime", requestTime()).add("SnapshotName", snapshotName())
                .add("SourceDatabaseName", sourceDatabaseName()).add("SourceSchemaName", sourceSchemaName())
                .add("SourceTableName", sourceTableName()).add("Status", status())
                .add("TableRestoreRequestId", tableRestoreRequestId()).add("TargetDatabaseName", targetDatabaseName())
                .add("TargetSchemaName", targetSchemaName()).add("TotalDataInMegaBytes", totalDataInMegaBytes())
                .add("WorkgroupName", workgroupName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "message":
            return Optional.ofNullable(clazz.cast(message()));
        case "namespaceName":
            return Optional.ofNullable(clazz.cast(namespaceName()));
        case "newTableName":
            return Optional.ofNullable(clazz.cast(newTableName()));
        case "progressInMegaBytes":
            return Optional.ofNullable(clazz.cast(progressInMegaBytes()));
        case "recoveryPointId":
            return Optional.ofNullable(clazz.cast(recoveryPointId()));
        case "requestTime":
            return Optional.ofNullable(clazz.cast(requestTime()));
        case "snapshotName":
            return Optional.ofNullable(clazz.cast(snapshotName()));
        case "sourceDatabaseName":
            return Optional.ofNullable(clazz.cast(sourceDatabaseName()));
        case "sourceSchemaName":
            return Optional.ofNullable(clazz.cast(sourceSchemaName()));
        case "sourceTableName":
            return Optional.ofNullable(clazz.cast(sourceTableName()));
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        case "tableRestoreRequestId":
            return Optional.ofNullable(clazz.cast(tableRestoreRequestId()));
        case "targetDatabaseName":
            return Optional.ofNullable(clazz.cast(targetDatabaseName()));
        case "targetSchemaName":
            return Optional.ofNullable(clazz.cast(targetSchemaName()));
        case "totalDataInMegaBytes":
            return Optional.ofNullable(clazz.cast(totalDataInMegaBytes()));
        case "workgroupName":
            return Optional.ofNullable(clazz.cast(workgroupName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TableRestoreStatus, T> g) {
        return obj -> g.apply((TableRestoreStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TableRestoreStatus> {
        /**
         * <p>
         * A message that explains the returned status. For example, if the status of the operation is
         * <code>FAILED</code>, the message explains why the operation failed.
         * </p>
         * 
         * @param message
         *        A message that explains the returned status. For example, if the status of the operation is
         *        <code>FAILED</code>, the message explains why the operation failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * The namespace of the table being restored from.
         * </p>
         * 
         * @param namespaceName
         *        The namespace of the table being restored from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespaceName(String namespaceName);

        /**
         * <p>
         * The name of the table to create from the restore operation.
         * </p>
         * 
         * @param newTableName
         *        The name of the table to create from the restore operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newTableName(String newTableName);

        /**
         * <p>
         * The amount of data restored to the new table so far, in megabytes (MB).
         * </p>
         * 
         * @param progressInMegaBytes
         *        The amount of data restored to the new table so far, in megabytes (MB).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder progressInMegaBytes(Long progressInMegaBytes);

        /**
         * <p>
         * The ID of the recovery point being restored from.
         * </p>
         * 
         * @param recoveryPointId
         *        The ID of the recovery point being restored from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recoveryPointId(String recoveryPointId);

        /**
         * <p>
         * The time that the table restore request was made, in Universal Coordinated Time (UTC).
         * </p>
         * 
         * @param requestTime
         *        The time that the table restore request was made, in Universal Coordinated Time (UTC).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestTime(Instant requestTime);

        /**
         * <p>
         * The name of the snapshot being restored from.
         * </p>
         * 
         * @param snapshotName
         *        The name of the snapshot being restored from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotName(String snapshotName);

        /**
         * <p>
         * The name of the source database being restored from.
         * </p>
         * 
         * @param sourceDatabaseName
         *        The name of the source database being restored from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceDatabaseName(String sourceDatabaseName);

        /**
         * <p>
         * The name of the source schema being restored from.
         * </p>
         * 
         * @param sourceSchemaName
         *        The name of the source schema being restored from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceSchemaName(String sourceSchemaName);

        /**
         * <p>
         * The name of the source table being restored from.
         * </p>
         * 
         * @param sourceTableName
         *        The name of the source table being restored from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceTableName(String sourceTableName);

        /**
         * <p>
         * A value that describes the current state of the table restore request. Possible values are
         * <code>SUCCEEDED</code>, <code>FAILED</code>, <code>CANCELED</code>, <code>PENDING</code>, and
         * <code>IN_PROGRESS</code>.
         * </p>
         * 
         * @param status
         *        A value that describes the current state of the table restore request. Possible values are
         *        <code>SUCCEEDED</code>, <code>FAILED</code>, <code>CANCELED</code>, <code>PENDING</code>, and
         *        <code>IN_PROGRESS</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The ID of the RestoreTableFromSnapshot request.
         * </p>
         * 
         * @param tableRestoreRequestId
         *        The ID of the RestoreTableFromSnapshot request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableRestoreRequestId(String tableRestoreRequestId);

        /**
         * <p>
         * The name of the database to restore to.
         * </p>
         * 
         * @param targetDatabaseName
         *        The name of the database to restore to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetDatabaseName(String targetDatabaseName);

        /**
         * <p>
         * The name of the schema to restore to.
         * </p>
         * 
         * @param targetSchemaName
         *        The name of the schema to restore to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetSchemaName(String targetSchemaName);

        /**
         * <p>
         * The total amount of data to restore to the new table, in megabytes (MB).
         * </p>
         * 
         * @param totalDataInMegaBytes
         *        The total amount of data to restore to the new table, in megabytes (MB).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalDataInMegaBytes(Long totalDataInMegaBytes);

        /**
         * <p>
         * The name of the workgroup being restored from.
         * </p>
         * 
         * @param workgroupName
         *        The name of the workgroup being restored from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workgroupName(String workgroupName);
    }

    static final class BuilderImpl implements Builder {
        private String message;

        private String namespaceName;

        private String newTableName;

        private Long progressInMegaBytes;

        private String recoveryPointId;

        private Instant requestTime;

        private String snapshotName;

        private String sourceDatabaseName;

        private String sourceSchemaName;

        private String sourceTableName;

        private String status;

        private String tableRestoreRequestId;

        private String targetDatabaseName;

        private String targetSchemaName;

        private Long totalDataInMegaBytes;

        private String workgroupName;

        private BuilderImpl() {
        }

        private BuilderImpl(TableRestoreStatus model) {
            message(model.message);
            namespaceName(model.namespaceName);
            newTableName(model.newTableName);
            progressInMegaBytes(model.progressInMegaBytes);
            recoveryPointId(model.recoveryPointId);
            requestTime(model.requestTime);
            snapshotName(model.snapshotName);
            sourceDatabaseName(model.sourceDatabaseName);
            sourceSchemaName(model.sourceSchemaName);
            sourceTableName(model.sourceTableName);
            status(model.status);
            tableRestoreRequestId(model.tableRestoreRequestId);
            targetDatabaseName(model.targetDatabaseName);
            targetSchemaName(model.targetSchemaName);
            totalDataInMegaBytes(model.totalDataInMegaBytes);
            workgroupName(model.workgroupName);
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final String getNamespaceName() {
            return namespaceName;
        }

        public final void setNamespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
        }

        @Override
        public final Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public final String getNewTableName() {
            return newTableName;
        }

        public final void setNewTableName(String newTableName) {
            this.newTableName = newTableName;
        }

        @Override
        public final Builder newTableName(String newTableName) {
            this.newTableName = newTableName;
            return this;
        }

        public final Long getProgressInMegaBytes() {
            return progressInMegaBytes;
        }

        public final void setProgressInMegaBytes(Long progressInMegaBytes) {
            this.progressInMegaBytes = progressInMegaBytes;
        }

        @Override
        public final Builder progressInMegaBytes(Long progressInMegaBytes) {
            this.progressInMegaBytes = progressInMegaBytes;
            return this;
        }

        public final String getRecoveryPointId() {
            return recoveryPointId;
        }

        public final void setRecoveryPointId(String recoveryPointId) {
            this.recoveryPointId = recoveryPointId;
        }

        @Override
        public final Builder recoveryPointId(String recoveryPointId) {
            this.recoveryPointId = recoveryPointId;
            return this;
        }

        public final Instant getRequestTime() {
            return requestTime;
        }

        public final void setRequestTime(Instant requestTime) {
            this.requestTime = requestTime;
        }

        @Override
        public final Builder requestTime(Instant requestTime) {
            this.requestTime = requestTime;
            return this;
        }

        public final String getSnapshotName() {
            return snapshotName;
        }

        public final void setSnapshotName(String snapshotName) {
            this.snapshotName = snapshotName;
        }

        @Override
        public final Builder snapshotName(String snapshotName) {
            this.snapshotName = snapshotName;
            return this;
        }

        public final String getSourceDatabaseName() {
            return sourceDatabaseName;
        }

        public final void setSourceDatabaseName(String sourceDatabaseName) {
            this.sourceDatabaseName = sourceDatabaseName;
        }

        @Override
        public final Builder sourceDatabaseName(String sourceDatabaseName) {
            this.sourceDatabaseName = sourceDatabaseName;
            return this;
        }

        public final String getSourceSchemaName() {
            return sourceSchemaName;
        }

        public final void setSourceSchemaName(String sourceSchemaName) {
            this.sourceSchemaName = sourceSchemaName;
        }

        @Override
        public final Builder sourceSchemaName(String sourceSchemaName) {
            this.sourceSchemaName = sourceSchemaName;
            return this;
        }

        public final String getSourceTableName() {
            return sourceTableName;
        }

        public final void setSourceTableName(String sourceTableName) {
            this.sourceTableName = sourceTableName;
        }

        @Override
        public final Builder sourceTableName(String sourceTableName) {
            this.sourceTableName = sourceTableName;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getTableRestoreRequestId() {
            return tableRestoreRequestId;
        }

        public final void setTableRestoreRequestId(String tableRestoreRequestId) {
            this.tableRestoreRequestId = tableRestoreRequestId;
        }

        @Override
        public final Builder tableRestoreRequestId(String tableRestoreRequestId) {
            this.tableRestoreRequestId = tableRestoreRequestId;
            return this;
        }

        public final String getTargetDatabaseName() {
            return targetDatabaseName;
        }

        public final void setTargetDatabaseName(String targetDatabaseName) {
            this.targetDatabaseName = targetDatabaseName;
        }

        @Override
        public final Builder targetDatabaseName(String targetDatabaseName) {
            this.targetDatabaseName = targetDatabaseName;
            return this;
        }

        public final String getTargetSchemaName() {
            return targetSchemaName;
        }

        public final void setTargetSchemaName(String targetSchemaName) {
            this.targetSchemaName = targetSchemaName;
        }

        @Override
        public final Builder targetSchemaName(String targetSchemaName) {
            this.targetSchemaName = targetSchemaName;
            return this;
        }

        public final Long getTotalDataInMegaBytes() {
            return totalDataInMegaBytes;
        }

        public final void setTotalDataInMegaBytes(Long totalDataInMegaBytes) {
            this.totalDataInMegaBytes = totalDataInMegaBytes;
        }

        @Override
        public final Builder totalDataInMegaBytes(Long totalDataInMegaBytes) {
            this.totalDataInMegaBytes = totalDataInMegaBytes;
            return this;
        }

        public final String getWorkgroupName() {
            return workgroupName;
        }

        public final void setWorkgroupName(String workgroupName) {
            this.workgroupName = workgroupName;
        }

        @Override
        public final Builder workgroupName(String workgroupName) {
            this.workgroupName = workgroupName;
            return this;
        }

        @Override
        public TableRestoreStatus build() {
            return new TableRestoreStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
