/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshiftserverless.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateWorkgroupRequest extends RedshiftServerlessRequest implements
        ToCopyableBuilder<UpdateWorkgroupRequest.Builder, UpdateWorkgroupRequest> {
    private static final SdkField<Integer> BASE_CAPACITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("baseCapacity").getter(getter(UpdateWorkgroupRequest::baseCapacity))
            .setter(setter(Builder::baseCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("baseCapacity").build()).build();

    private static final SdkField<List<ConfigParameter>> CONFIG_PARAMETERS_FIELD = SdkField
            .<List<ConfigParameter>> builder(MarshallingType.LIST)
            .memberName("configParameters")
            .getter(getter(UpdateWorkgroupRequest::configParameters))
            .setter(setter(Builder::configParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configParameters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ConfigParameter> builder(MarshallingType.SDK_POJO)
                                            .constructor(ConfigParameter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> ENHANCED_VPC_ROUTING_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("enhancedVpcRouting").getter(getter(UpdateWorkgroupRequest::enhancedVpcRouting))
            .setter(setter(Builder::enhancedVpcRouting))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enhancedVpcRouting").build())
            .build();

    private static final SdkField<Integer> MAX_CAPACITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxCapacity").getter(getter(UpdateWorkgroupRequest::maxCapacity)).setter(setter(Builder::maxCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxCapacity").build()).build();

    private static final SdkField<Integer> PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("port")
            .getter(getter(UpdateWorkgroupRequest::port)).setter(setter(Builder::port))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("port").build()).build();

    private static final SdkField<Boolean> PUBLICLY_ACCESSIBLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("publiclyAccessible").getter(getter(UpdateWorkgroupRequest::publiclyAccessible))
            .setter(setter(Builder::publiclyAccessible))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publiclyAccessible").build())
            .build();

    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("securityGroupIds")
            .getter(getter(UpdateWorkgroupRequest::securityGroupIds))
            .setter(setter(Builder::securityGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityGroupIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SUBNET_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("subnetIds")
            .getter(getter(UpdateWorkgroupRequest::subnetIds))
            .setter(setter(Builder::subnetIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subnetIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> WORKGROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workgroupName").getter(getter(UpdateWorkgroupRequest::workgroupName))
            .setter(setter(Builder::workgroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workgroupName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BASE_CAPACITY_FIELD,
            CONFIG_PARAMETERS_FIELD, ENHANCED_VPC_ROUTING_FIELD, MAX_CAPACITY_FIELD, PORT_FIELD, PUBLICLY_ACCESSIBLE_FIELD,
            SECURITY_GROUP_IDS_FIELD, SUBNET_IDS_FIELD, WORKGROUP_NAME_FIELD));

    private final Integer baseCapacity;

    private final List<ConfigParameter> configParameters;

    private final Boolean enhancedVpcRouting;

    private final Integer maxCapacity;

    private final Integer port;

    private final Boolean publiclyAccessible;

    private final List<String> securityGroupIds;

    private final List<String> subnetIds;

    private final String workgroupName;

    private UpdateWorkgroupRequest(BuilderImpl builder) {
        super(builder);
        this.baseCapacity = builder.baseCapacity;
        this.configParameters = builder.configParameters;
        this.enhancedVpcRouting = builder.enhancedVpcRouting;
        this.maxCapacity = builder.maxCapacity;
        this.port = builder.port;
        this.publiclyAccessible = builder.publiclyAccessible;
        this.securityGroupIds = builder.securityGroupIds;
        this.subnetIds = builder.subnetIds;
        this.workgroupName = builder.workgroupName;
    }

    /**
     * <p>
     * The new base data warehouse capacity in Redshift Processing Units (RPUs).
     * </p>
     * 
     * @return The new base data warehouse capacity in Redshift Processing Units (RPUs).
     */
    public final Integer baseCapacity() {
        return baseCapacity;
    }

    /**
     * For responses, this returns true if the service returned a value for the ConfigParameters property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasConfigParameters() {
        return configParameters != null && !(configParameters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of parameters to set for advanced control over a database. The options are <code>auto_mv</code>,
     * <code>datestyle</code>, <code>enable_case_sensitive_identifier</code>, <code>enable_user_activity_logging</code>,
     * <code>query_group</code>, <code>search_path</code>, <code>require_ssl</code>, <code>use_fips_ssl</code>, and
     * query monitoring metrics that let you define performance boundaries. For more information about query monitoring
     * rules and available metrics, see <a href=
     * "https://docs.aws.amazon.com/redshift/latest/dg/cm-c-wlm-query-monitoring-rules.html#cm-c-wlm-query-monitoring-metrics-serverless"
     * > Query monitoring metrics for Amazon Redshift Serverless</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConfigParameters} method.
     * </p>
     * 
     * @return An array of parameters to set for advanced control over a database. The options are <code>auto_mv</code>,
     *         <code>datestyle</code>, <code>enable_case_sensitive_identifier</code>,
     *         <code>enable_user_activity_logging</code>, <code>query_group</code>, <code>search_path</code>,
     *         <code>require_ssl</code>, <code>use_fips_ssl</code>, and query monitoring metrics that let you define
     *         performance boundaries. For more information about query monitoring rules and available metrics, see <a
     *         href=
     *         "https://docs.aws.amazon.com/redshift/latest/dg/cm-c-wlm-query-monitoring-rules.html#cm-c-wlm-query-monitoring-metrics-serverless"
     *         > Query monitoring metrics for Amazon Redshift Serverless</a>.
     */
    public final List<ConfigParameter> configParameters() {
        return configParameters;
    }

    /**
     * <p>
     * The value that specifies whether to turn on enhanced virtual private cloud (VPC) routing, which forces Amazon
     * Redshift Serverless to route traffic through your VPC.
     * </p>
     * 
     * @return The value that specifies whether to turn on enhanced virtual private cloud (VPC) routing, which forces
     *         Amazon Redshift Serverless to route traffic through your VPC.
     */
    public final Boolean enhancedVpcRouting() {
        return enhancedVpcRouting;
    }

    /**
     * <p>
     * The maximum data-warehouse capacity Amazon Redshift Serverless uses to serve queries. The max capacity is
     * specified in RPUs.
     * </p>
     * 
     * @return The maximum data-warehouse capacity Amazon Redshift Serverless uses to serve queries. The max capacity is
     *         specified in RPUs.
     */
    public final Integer maxCapacity() {
        return maxCapacity;
    }

    /**
     * <p>
     * The custom port to use when connecting to a workgroup. Valid port ranges are 5431-5455 and 8191-8215. The default
     * is 5439.
     * </p>
     * 
     * @return The custom port to use when connecting to a workgroup. Valid port ranges are 5431-5455 and 8191-8215. The
     *         default is 5439.
     */
    public final Integer port() {
        return port;
    }

    /**
     * <p>
     * A value that specifies whether the workgroup can be accessible from a public network.
     * </p>
     * 
     * @return A value that specifies whether the workgroup can be accessible from a public network.
     */
    public final Boolean publiclyAccessible() {
        return publiclyAccessible;
    }

    /**
     * For responses, this returns true if the service returned a value for the SecurityGroupIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSecurityGroupIds() {
        return securityGroupIds != null && !(securityGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of security group IDs to associate with the workgroup.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSecurityGroupIds} method.
     * </p>
     * 
     * @return An array of security group IDs to associate with the workgroup.
     */
    public final List<String> securityGroupIds() {
        return securityGroupIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the SubnetIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSubnetIds() {
        return subnetIds != null && !(subnetIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of VPC subnet IDs to associate with the workgroup.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubnetIds} method.
     * </p>
     * 
     * @return An array of VPC subnet IDs to associate with the workgroup.
     */
    public final List<String> subnetIds() {
        return subnetIds;
    }

    /**
     * <p>
     * The name of the workgroup to update. You can't update the name of a workgroup once it is created.
     * </p>
     * 
     * @return The name of the workgroup to update. You can't update the name of a workgroup once it is created.
     */
    public final String workgroupName() {
        return workgroupName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(baseCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(hasConfigParameters() ? configParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(enhancedVpcRouting());
        hashCode = 31 * hashCode + Objects.hashCode(maxCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(port());
        hashCode = 31 * hashCode + Objects.hashCode(publiclyAccessible());
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityGroupIds() ? securityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSubnetIds() ? subnetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(workgroupName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateWorkgroupRequest)) {
            return false;
        }
        UpdateWorkgroupRequest other = (UpdateWorkgroupRequest) obj;
        return Objects.equals(baseCapacity(), other.baseCapacity()) && hasConfigParameters() == other.hasConfigParameters()
                && Objects.equals(configParameters(), other.configParameters())
                && Objects.equals(enhancedVpcRouting(), other.enhancedVpcRouting())
                && Objects.equals(maxCapacity(), other.maxCapacity()) && Objects.equals(port(), other.port())
                && Objects.equals(publiclyAccessible(), other.publiclyAccessible())
                && hasSecurityGroupIds() == other.hasSecurityGroupIds()
                && Objects.equals(securityGroupIds(), other.securityGroupIds()) && hasSubnetIds() == other.hasSubnetIds()
                && Objects.equals(subnetIds(), other.subnetIds()) && Objects.equals(workgroupName(), other.workgroupName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateWorkgroupRequest").add("BaseCapacity", baseCapacity())
                .add("ConfigParameters", hasConfigParameters() ? configParameters() : null)
                .add("EnhancedVpcRouting", enhancedVpcRouting()).add("MaxCapacity", maxCapacity()).add("Port", port())
                .add("PubliclyAccessible", publiclyAccessible())
                .add("SecurityGroupIds", hasSecurityGroupIds() ? securityGroupIds() : null)
                .add("SubnetIds", hasSubnetIds() ? subnetIds() : null).add("WorkgroupName", workgroupName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "baseCapacity":
            return Optional.ofNullable(clazz.cast(baseCapacity()));
        case "configParameters":
            return Optional.ofNullable(clazz.cast(configParameters()));
        case "enhancedVpcRouting":
            return Optional.ofNullable(clazz.cast(enhancedVpcRouting()));
        case "maxCapacity":
            return Optional.ofNullable(clazz.cast(maxCapacity()));
        case "port":
            return Optional.ofNullable(clazz.cast(port()));
        case "publiclyAccessible":
            return Optional.ofNullable(clazz.cast(publiclyAccessible()));
        case "securityGroupIds":
            return Optional.ofNullable(clazz.cast(securityGroupIds()));
        case "subnetIds":
            return Optional.ofNullable(clazz.cast(subnetIds()));
        case "workgroupName":
            return Optional.ofNullable(clazz.cast(workgroupName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateWorkgroupRequest, T> g) {
        return obj -> g.apply((UpdateWorkgroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftServerlessRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateWorkgroupRequest> {
        /**
         * <p>
         * The new base data warehouse capacity in Redshift Processing Units (RPUs).
         * </p>
         * 
         * @param baseCapacity
         *        The new base data warehouse capacity in Redshift Processing Units (RPUs).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baseCapacity(Integer baseCapacity);

        /**
         * <p>
         * An array of parameters to set for advanced control over a database. The options are <code>auto_mv</code>,
         * <code>datestyle</code>, <code>enable_case_sensitive_identifier</code>,
         * <code>enable_user_activity_logging</code>, <code>query_group</code>, <code>search_path</code>,
         * <code>require_ssl</code>, <code>use_fips_ssl</code>, and query monitoring metrics that let you define
         * performance boundaries. For more information about query monitoring rules and available metrics, see <a href=
         * "https://docs.aws.amazon.com/redshift/latest/dg/cm-c-wlm-query-monitoring-rules.html#cm-c-wlm-query-monitoring-metrics-serverless"
         * > Query monitoring metrics for Amazon Redshift Serverless</a>.
         * </p>
         * 
         * @param configParameters
         *        An array of parameters to set for advanced control over a database. The options are
         *        <code>auto_mv</code>, <code>datestyle</code>, <code>enable_case_sensitive_identifier</code>,
         *        <code>enable_user_activity_logging</code>, <code>query_group</code>, <code>search_path</code>,
         *        <code>require_ssl</code>, <code>use_fips_ssl</code>, and query monitoring metrics that let you define
         *        performance boundaries. For more information about query monitoring rules and available metrics, see
         *        <a href=
         *        "https://docs.aws.amazon.com/redshift/latest/dg/cm-c-wlm-query-monitoring-rules.html#cm-c-wlm-query-monitoring-metrics-serverless"
         *        > Query monitoring metrics for Amazon Redshift Serverless</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configParameters(Collection<ConfigParameter> configParameters);

        /**
         * <p>
         * An array of parameters to set for advanced control over a database. The options are <code>auto_mv</code>,
         * <code>datestyle</code>, <code>enable_case_sensitive_identifier</code>,
         * <code>enable_user_activity_logging</code>, <code>query_group</code>, <code>search_path</code>,
         * <code>require_ssl</code>, <code>use_fips_ssl</code>, and query monitoring metrics that let you define
         * performance boundaries. For more information about query monitoring rules and available metrics, see <a href=
         * "https://docs.aws.amazon.com/redshift/latest/dg/cm-c-wlm-query-monitoring-rules.html#cm-c-wlm-query-monitoring-metrics-serverless"
         * > Query monitoring metrics for Amazon Redshift Serverless</a>.
         * </p>
         * 
         * @param configParameters
         *        An array of parameters to set for advanced control over a database. The options are
         *        <code>auto_mv</code>, <code>datestyle</code>, <code>enable_case_sensitive_identifier</code>,
         *        <code>enable_user_activity_logging</code>, <code>query_group</code>, <code>search_path</code>,
         *        <code>require_ssl</code>, <code>use_fips_ssl</code>, and query monitoring metrics that let you define
         *        performance boundaries. For more information about query monitoring rules and available metrics, see
         *        <a href=
         *        "https://docs.aws.amazon.com/redshift/latest/dg/cm-c-wlm-query-monitoring-rules.html#cm-c-wlm-query-monitoring-metrics-serverless"
         *        > Query monitoring metrics for Amazon Redshift Serverless</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configParameters(ConfigParameter... configParameters);

        /**
         * <p>
         * An array of parameters to set for advanced control over a database. The options are <code>auto_mv</code>,
         * <code>datestyle</code>, <code>enable_case_sensitive_identifier</code>,
         * <code>enable_user_activity_logging</code>, <code>query_group</code>, <code>search_path</code>,
         * <code>require_ssl</code>, <code>use_fips_ssl</code>, and query monitoring metrics that let you define
         * performance boundaries. For more information about query monitoring rules and available metrics, see <a href=
         * "https://docs.aws.amazon.com/redshift/latest/dg/cm-c-wlm-query-monitoring-rules.html#cm-c-wlm-query-monitoring-metrics-serverless"
         * > Query monitoring metrics for Amazon Redshift Serverless</a>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.redshiftserverless.model.ConfigParameter.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.redshiftserverless.model.ConfigParameter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.redshiftserverless.model.ConfigParameter.Builder#build()} is called
         * immediately and its result is passed to {@link #configParameters(List<ConfigParameter>)}.
         * 
         * @param configParameters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.redshiftserverless.model.ConfigParameter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configParameters(java.util.Collection<ConfigParameter>)
         */
        Builder configParameters(Consumer<ConfigParameter.Builder>... configParameters);

        /**
         * <p>
         * The value that specifies whether to turn on enhanced virtual private cloud (VPC) routing, which forces Amazon
         * Redshift Serverless to route traffic through your VPC.
         * </p>
         * 
         * @param enhancedVpcRouting
         *        The value that specifies whether to turn on enhanced virtual private cloud (VPC) routing, which forces
         *        Amazon Redshift Serverless to route traffic through your VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enhancedVpcRouting(Boolean enhancedVpcRouting);

        /**
         * <p>
         * The maximum data-warehouse capacity Amazon Redshift Serverless uses to serve queries. The max capacity is
         * specified in RPUs.
         * </p>
         * 
         * @param maxCapacity
         *        The maximum data-warehouse capacity Amazon Redshift Serverless uses to serve queries. The max capacity
         *        is specified in RPUs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxCapacity(Integer maxCapacity);

        /**
         * <p>
         * The custom port to use when connecting to a workgroup. Valid port ranges are 5431-5455 and 8191-8215. The
         * default is 5439.
         * </p>
         * 
         * @param port
         *        The custom port to use when connecting to a workgroup. Valid port ranges are 5431-5455 and 8191-8215.
         *        The default is 5439.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder port(Integer port);

        /**
         * <p>
         * A value that specifies whether the workgroup can be accessible from a public network.
         * </p>
         * 
         * @param publiclyAccessible
         *        A value that specifies whether the workgroup can be accessible from a public network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publiclyAccessible(Boolean publiclyAccessible);

        /**
         * <p>
         * An array of security group IDs to associate with the workgroup.
         * </p>
         * 
         * @param securityGroupIds
         *        An array of security group IDs to associate with the workgroup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(Collection<String> securityGroupIds);

        /**
         * <p>
         * An array of security group IDs to associate with the workgroup.
         * </p>
         * 
         * @param securityGroupIds
         *        An array of security group IDs to associate with the workgroup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(String... securityGroupIds);

        /**
         * <p>
         * An array of VPC subnet IDs to associate with the workgroup.
         * </p>
         * 
         * @param subnetIds
         *        An array of VPC subnet IDs to associate with the workgroup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(Collection<String> subnetIds);

        /**
         * <p>
         * An array of VPC subnet IDs to associate with the workgroup.
         * </p>
         * 
         * @param subnetIds
         *        An array of VPC subnet IDs to associate with the workgroup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(String... subnetIds);

        /**
         * <p>
         * The name of the workgroup to update. You can't update the name of a workgroup once it is created.
         * </p>
         * 
         * @param workgroupName
         *        The name of the workgroup to update. You can't update the name of a workgroup once it is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workgroupName(String workgroupName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RedshiftServerlessRequest.BuilderImpl implements Builder {
        private Integer baseCapacity;

        private List<ConfigParameter> configParameters = DefaultSdkAutoConstructList.getInstance();

        private Boolean enhancedVpcRouting;

        private Integer maxCapacity;

        private Integer port;

        private Boolean publiclyAccessible;

        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private List<String> subnetIds = DefaultSdkAutoConstructList.getInstance();

        private String workgroupName;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateWorkgroupRequest model) {
            super(model);
            baseCapacity(model.baseCapacity);
            configParameters(model.configParameters);
            enhancedVpcRouting(model.enhancedVpcRouting);
            maxCapacity(model.maxCapacity);
            port(model.port);
            publiclyAccessible(model.publiclyAccessible);
            securityGroupIds(model.securityGroupIds);
            subnetIds(model.subnetIds);
            workgroupName(model.workgroupName);
        }

        public final Integer getBaseCapacity() {
            return baseCapacity;
        }

        public final void setBaseCapacity(Integer baseCapacity) {
            this.baseCapacity = baseCapacity;
        }

        @Override
        public final Builder baseCapacity(Integer baseCapacity) {
            this.baseCapacity = baseCapacity;
            return this;
        }

        public final List<ConfigParameter.Builder> getConfigParameters() {
            List<ConfigParameter.Builder> result = ConfigParameterListCopier.copyToBuilder(this.configParameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConfigParameters(Collection<ConfigParameter.BuilderImpl> configParameters) {
            this.configParameters = ConfigParameterListCopier.copyFromBuilder(configParameters);
        }

        @Override
        public final Builder configParameters(Collection<ConfigParameter> configParameters) {
            this.configParameters = ConfigParameterListCopier.copy(configParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configParameters(ConfigParameter... configParameters) {
            configParameters(Arrays.asList(configParameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configParameters(Consumer<ConfigParameter.Builder>... configParameters) {
            configParameters(Stream.of(configParameters).map(c -> ConfigParameter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Boolean getEnhancedVpcRouting() {
            return enhancedVpcRouting;
        }

        public final void setEnhancedVpcRouting(Boolean enhancedVpcRouting) {
            this.enhancedVpcRouting = enhancedVpcRouting;
        }

        @Override
        public final Builder enhancedVpcRouting(Boolean enhancedVpcRouting) {
            this.enhancedVpcRouting = enhancedVpcRouting;
            return this;
        }

        public final Integer getMaxCapacity() {
            return maxCapacity;
        }

        public final void setMaxCapacity(Integer maxCapacity) {
            this.maxCapacity = maxCapacity;
        }

        @Override
        public final Builder maxCapacity(Integer maxCapacity) {
            this.maxCapacity = maxCapacity;
            return this;
        }

        public final Integer getPort() {
            return port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final Boolean getPubliclyAccessible() {
            return publiclyAccessible;
        }

        public final void setPubliclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
        }

        @Override
        public final Builder publiclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
            return this;
        }

        public final Collection<String> getSecurityGroupIds() {
            if (securityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return securityGroupIds;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdListCopier.copy(securityGroupIds);
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdListCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String... securityGroupIds) {
            securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final Collection<String> getSubnetIds() {
            if (subnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return subnetIds;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdListCopier.copy(subnetIds);
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdListCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String... subnetIds) {
            subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final String getWorkgroupName() {
            return workgroupName;
        }

        public final void setWorkgroupName(String workgroupName) {
            this.workgroupName = workgroupName;
        }

        @Override
        public final Builder workgroupName(String workgroupName) {
            this.workgroupName = workgroupName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateWorkgroupRequest build() {
            return new UpdateWorkgroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
