/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshiftserverless.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListScheduledActionsResponse extends RedshiftServerlessResponse implements
        ToCopyableBuilder<ListScheduledActionsResponse.Builder, ListScheduledActionsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListScheduledActionsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<ScheduledActionAssociation>> SCHEDULED_ACTIONS_FIELD = SdkField
            .<List<ScheduledActionAssociation>> builder(MarshallingType.LIST)
            .memberName("scheduledActions")
            .getter(getter(ListScheduledActionsResponse::scheduledActions))
            .setter(setter(Builder::scheduledActions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scheduledActions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ScheduledActionAssociation> builder(MarshallingType.SDK_POJO)
                                            .constructor(ScheduledActionAssociation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            SCHEDULED_ACTIONS_FIELD));

    private final String nextToken;

    private final List<ScheduledActionAssociation> scheduledActions;

    private ListScheduledActionsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.scheduledActions = builder.scheduledActions;
    }

    /**
     * <p>
     * If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token
     * for each page. Make the call again using the returned token to retrieve the next page.
     * </p>
     * 
     * @return If nextToken is returned, there are more results available. The value of nextToken is a unique pagination
     *         token for each page. Make the call again using the returned token to retrieve the next page.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ScheduledActions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasScheduledActions() {
        return scheduledActions != null && !(scheduledActions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * All of the returned scheduled action association objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasScheduledActions} method.
     * </p>
     * 
     * @return All of the returned scheduled action association objects.
     */
    public final List<ScheduledActionAssociation> scheduledActions() {
        return scheduledActions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasScheduledActions() ? scheduledActions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListScheduledActionsResponse)) {
            return false;
        }
        ListScheduledActionsResponse other = (ListScheduledActionsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasScheduledActions() == other.hasScheduledActions()
                && Objects.equals(scheduledActions(), other.scheduledActions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListScheduledActionsResponse").add("NextToken", nextToken())
                .add("ScheduledActions", hasScheduledActions() ? scheduledActions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "scheduledActions":
            return Optional.ofNullable(clazz.cast(scheduledActions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListScheduledActionsResponse, T> g) {
        return obj -> g.apply((ListScheduledActionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftServerlessResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListScheduledActionsResponse> {
        /**
         * <p>
         * If nextToken is returned, there are more results available. The value of nextToken is a unique pagination
         * token for each page. Make the call again using the returned token to retrieve the next page.
         * </p>
         * 
         * @param nextToken
         *        If nextToken is returned, there are more results available. The value of nextToken is a unique
         *        pagination token for each page. Make the call again using the returned token to retrieve the next
         *        page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * All of the returned scheduled action association objects.
         * </p>
         * 
         * @param scheduledActions
         *        All of the returned scheduled action association objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduledActions(Collection<ScheduledActionAssociation> scheduledActions);

        /**
         * <p>
         * All of the returned scheduled action association objects.
         * </p>
         * 
         * @param scheduledActions
         *        All of the returned scheduled action association objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduledActions(ScheduledActionAssociation... scheduledActions);

        /**
         * <p>
         * All of the returned scheduled action association objects.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.redshiftserverless.model.ScheduledActionAssociation.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.redshiftserverless.model.ScheduledActionAssociation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.redshiftserverless.model.ScheduledActionAssociation.Builder#build()}
         * is called immediately and its result is passed to {@link #scheduledActions(List<ScheduledActionAssociation>)}.
         * 
         * @param scheduledActions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.redshiftserverless.model.ScheduledActionAssociation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scheduledActions(java.util.Collection<ScheduledActionAssociation>)
         */
        Builder scheduledActions(Consumer<ScheduledActionAssociation.Builder>... scheduledActions);
    }

    static final class BuilderImpl extends RedshiftServerlessResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<ScheduledActionAssociation> scheduledActions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListScheduledActionsResponse model) {
            super(model);
            nextToken(model.nextToken);
            scheduledActions(model.scheduledActions);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ScheduledActionAssociation.Builder> getScheduledActions() {
            List<ScheduledActionAssociation.Builder> result = ScheduledActionsListCopier.copyToBuilder(this.scheduledActions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setScheduledActions(Collection<ScheduledActionAssociation.BuilderImpl> scheduledActions) {
            this.scheduledActions = ScheduledActionsListCopier.copyFromBuilder(scheduledActions);
        }

        @Override
        public final Builder scheduledActions(Collection<ScheduledActionAssociation> scheduledActions) {
            this.scheduledActions = ScheduledActionsListCopier.copy(scheduledActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scheduledActions(ScheduledActionAssociation... scheduledActions) {
            scheduledActions(Arrays.asList(scheduledActions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scheduledActions(Consumer<ScheduledActionAssociation.Builder>... scheduledActions) {
            scheduledActions(Stream.of(scheduledActions).map(c -> ScheduledActionAssociation.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListScheduledActionsResponse build() {
            return new ListScheduledActionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
