/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshiftserverless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a network interface in an Amazon Redshift Serverless managed VPC endpoint.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NetworkInterface implements SdkPojo, Serializable,
        ToCopyableBuilder<NetworkInterface.Builder, NetworkInterface> {
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("availabilityZone").getter(getter(NetworkInterface::availabilityZone))
            .setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZone").build()).build();

    private static final SdkField<String> IPV6_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ipv6Address").getter(getter(NetworkInterface::ipv6Address)).setter(setter(Builder::ipv6Address))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipv6Address").build()).build();

    private static final SdkField<String> NETWORK_INTERFACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("networkInterfaceId").getter(getter(NetworkInterface::networkInterfaceId))
            .setter(setter(Builder::networkInterfaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkInterfaceId").build())
            .build();

    private static final SdkField<String> PRIVATE_IP_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("privateIpAddress").getter(getter(NetworkInterface::privateIpAddress))
            .setter(setter(Builder::privateIpAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("privateIpAddress").build()).build();

    private static final SdkField<String> SUBNET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("subnetId").getter(getter(NetworkInterface::subnetId)).setter(setter(Builder::subnetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subnetId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVAILABILITY_ZONE_FIELD,
            IPV6_ADDRESS_FIELD, NETWORK_INTERFACE_ID_FIELD, PRIVATE_IP_ADDRESS_FIELD, SUBNET_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String availabilityZone;

    private final String ipv6Address;

    private final String networkInterfaceId;

    private final String privateIpAddress;

    private final String subnetId;

    private NetworkInterface(BuilderImpl builder) {
        this.availabilityZone = builder.availabilityZone;
        this.ipv6Address = builder.ipv6Address;
        this.networkInterfaceId = builder.networkInterfaceId;
        this.privateIpAddress = builder.privateIpAddress;
        this.subnetId = builder.subnetId;
    }

    /**
     * <p>
     * The availability Zone.
     * </p>
     * 
     * @return The availability Zone.
     */
    public final String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * The IPv6 address of the network interface within the subnet.
     * </p>
     * 
     * @return The IPv6 address of the network interface within the subnet.
     */
    public final String ipv6Address() {
        return ipv6Address;
    }

    /**
     * <p>
     * The unique identifier of the network interface.
     * </p>
     * 
     * @return The unique identifier of the network interface.
     */
    public final String networkInterfaceId() {
        return networkInterfaceId;
    }

    /**
     * <p>
     * The IPv4 address of the network interface within the subnet.
     * </p>
     * 
     * @return The IPv4 address of the network interface within the subnet.
     */
    public final String privateIpAddress() {
        return privateIpAddress;
    }

    /**
     * <p>
     * The unique identifier of the subnet.
     * </p>
     * 
     * @return The unique identifier of the subnet.
     */
    public final String subnetId() {
        return subnetId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(ipv6Address());
        hashCode = 31 * hashCode + Objects.hashCode(networkInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(privateIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(subnetId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkInterface)) {
            return false;
        }
        NetworkInterface other = (NetworkInterface) obj;
        return Objects.equals(availabilityZone(), other.availabilityZone()) && Objects.equals(ipv6Address(), other.ipv6Address())
                && Objects.equals(networkInterfaceId(), other.networkInterfaceId())
                && Objects.equals(privateIpAddress(), other.privateIpAddress()) && Objects.equals(subnetId(), other.subnetId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NetworkInterface").add("AvailabilityZone", availabilityZone()).add("Ipv6Address", ipv6Address())
                .add("NetworkInterfaceId", networkInterfaceId()).add("PrivateIpAddress", privateIpAddress())
                .add("SubnetId", subnetId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "availabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "ipv6Address":
            return Optional.ofNullable(clazz.cast(ipv6Address()));
        case "networkInterfaceId":
            return Optional.ofNullable(clazz.cast(networkInterfaceId()));
        case "privateIpAddress":
            return Optional.ofNullable(clazz.cast(privateIpAddress()));
        case "subnetId":
            return Optional.ofNullable(clazz.cast(subnetId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NetworkInterface, T> g) {
        return obj -> g.apply((NetworkInterface) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NetworkInterface> {
        /**
         * <p>
         * The availability Zone.
         * </p>
         * 
         * @param availabilityZone
         *        The availability Zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * The IPv6 address of the network interface within the subnet.
         * </p>
         * 
         * @param ipv6Address
         *        The IPv6 address of the network interface within the subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6Address(String ipv6Address);

        /**
         * <p>
         * The unique identifier of the network interface.
         * </p>
         * 
         * @param networkInterfaceId
         *        The unique identifier of the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaceId(String networkInterfaceId);

        /**
         * <p>
         * The IPv4 address of the network interface within the subnet.
         * </p>
         * 
         * @param privateIpAddress
         *        The IPv4 address of the network interface within the subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateIpAddress(String privateIpAddress);

        /**
         * <p>
         * The unique identifier of the subnet.
         * </p>
         * 
         * @param subnetId
         *        The unique identifier of the subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetId(String subnetId);
    }

    static final class BuilderImpl implements Builder {
        private String availabilityZone;

        private String ipv6Address;

        private String networkInterfaceId;

        private String privateIpAddress;

        private String subnetId;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkInterface model) {
            availabilityZone(model.availabilityZone);
            ipv6Address(model.ipv6Address);
            networkInterfaceId(model.networkInterfaceId);
            privateIpAddress(model.privateIpAddress);
            subnetId(model.subnetId);
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final String getIpv6Address() {
            return ipv6Address;
        }

        public final void setIpv6Address(String ipv6Address) {
            this.ipv6Address = ipv6Address;
        }

        @Override
        public final Builder ipv6Address(String ipv6Address) {
            this.ipv6Address = ipv6Address;
            return this;
        }

        public final String getNetworkInterfaceId() {
            return networkInterfaceId;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final String getPrivateIpAddress() {
            return privateIpAddress;
        }

        public final void setPrivateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
        }

        @Override
        public final Builder privateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
            return this;
        }

        public final String getSubnetId() {
            return subnetId;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        @Override
        public NetworkInterface build() {
            return new NetworkInterface(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
