/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshiftserverless.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A collection of database objects and users.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Namespace implements SdkPojo, Serializable, ToCopyableBuilder<Namespace.Builder, Namespace> {
    private static final SdkField<String> ADMIN_PASSWORD_SECRET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("adminPasswordSecretArn").getter(getter(Namespace::adminPasswordSecretArn))
            .setter(setter(Builder::adminPasswordSecretArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("adminPasswordSecretArn").build())
            .build();

    private static final SdkField<String> ADMIN_PASSWORD_SECRET_KMS_KEY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("adminPasswordSecretKmsKeyId")
            .getter(getter(Namespace::adminPasswordSecretKmsKeyId))
            .setter(setter(Builder::adminPasswordSecretKmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("adminPasswordSecretKmsKeyId")
                    .build()).build();

    private static final SdkField<String> ADMIN_USERNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("adminUsername").getter(getter(Namespace::adminUsername)).setter(setter(Builder::adminUsername))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("adminUsername").build()).build();

    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationDate")
            .getter(getter(Namespace::creationDate))
            .setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDate").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> DB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("dbName")
            .getter(getter(Namespace::dbName)).setter(setter(Builder::dbName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dbName").build()).build();

    private static final SdkField<String> DEFAULT_IAM_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("defaultIamRoleArn").getter(getter(Namespace::defaultIamRoleArn))
            .setter(setter(Builder::defaultIamRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultIamRoleArn").build()).build();

    private static final SdkField<List<String>> IAM_ROLES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("iamRoles")
            .getter(getter(Namespace::iamRoles))
            .setter(setter(Builder::iamRoles))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iamRoles").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("kmsKeyId").getter(getter(Namespace::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyId").build()).build();

    private static final SdkField<List<String>> LOG_EXPORTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("logExports")
            .getter(getter(Namespace::logExportsAsStrings))
            .setter(setter(Builder::logExportsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logExports").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NAMESPACE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("namespaceArn").getter(getter(Namespace::namespaceArn)).setter(setter(Builder::namespaceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespaceArn").build()).build();

    private static final SdkField<String> NAMESPACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("namespaceId").getter(getter(Namespace::namespaceId)).setter(setter(Builder::namespaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespaceId").build()).build();

    private static final SdkField<String> NAMESPACE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("namespaceName").getter(getter(Namespace::namespaceName)).setter(setter(Builder::namespaceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespaceName").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(Namespace::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ADMIN_PASSWORD_SECRET_ARN_FIELD, ADMIN_PASSWORD_SECRET_KMS_KEY_ID_FIELD, ADMIN_USERNAME_FIELD, CREATION_DATE_FIELD,
            DB_NAME_FIELD, DEFAULT_IAM_ROLE_ARN_FIELD, IAM_ROLES_FIELD, KMS_KEY_ID_FIELD, LOG_EXPORTS_FIELD, NAMESPACE_ARN_FIELD,
            NAMESPACE_ID_FIELD, NAMESPACE_NAME_FIELD, STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String adminPasswordSecretArn;

    private final String adminPasswordSecretKmsKeyId;

    private final String adminUsername;

    private final Instant creationDate;

    private final String dbName;

    private final String defaultIamRoleArn;

    private final List<String> iamRoles;

    private final String kmsKeyId;

    private final List<String> logExports;

    private final String namespaceArn;

    private final String namespaceId;

    private final String namespaceName;

    private final String status;

    private Namespace(BuilderImpl builder) {
        this.adminPasswordSecretArn = builder.adminPasswordSecretArn;
        this.adminPasswordSecretKmsKeyId = builder.adminPasswordSecretKmsKeyId;
        this.adminUsername = builder.adminUsername;
        this.creationDate = builder.creationDate;
        this.dbName = builder.dbName;
        this.defaultIamRoleArn = builder.defaultIamRoleArn;
        this.iamRoles = builder.iamRoles;
        this.kmsKeyId = builder.kmsKeyId;
        this.logExports = builder.logExports;
        this.namespaceArn = builder.namespaceArn;
        this.namespaceId = builder.namespaceId;
        this.namespaceName = builder.namespaceName;
        this.status = builder.status;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the namespace's admin user credentials secret.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the namespace's admin user credentials secret.
     */
    public final String adminPasswordSecretArn() {
        return adminPasswordSecretArn;
    }

    /**
     * <p>
     * The ID of the Key Management Service (KMS) key used to encrypt and store the namespace's admin credentials
     * secret.
     * </p>
     * 
     * @return The ID of the Key Management Service (KMS) key used to encrypt and store the namespace's admin
     *         credentials secret.
     */
    public final String adminPasswordSecretKmsKeyId() {
        return adminPasswordSecretKmsKeyId;
    }

    /**
     * <p>
     * The username of the administrator for the first database created in the namespace.
     * </p>
     * 
     * @return The username of the administrator for the first database created in the namespace.
     */
    public final String adminUsername() {
        return adminUsername;
    }

    /**
     * <p>
     * The date of when the namespace was created.
     * </p>
     * 
     * @return The date of when the namespace was created.
     */
    public final Instant creationDate() {
        return creationDate;
    }

    /**
     * <p>
     * The name of the first database created in the namespace.
     * </p>
     * 
     * @return The name of the first database created in the namespace.
     */
    public final String dbName() {
        return dbName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role to set as a default in the namespace.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role to set as a default in the namespace.
     */
    public final String defaultIamRoleArn() {
        return defaultIamRoleArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the IamRoles property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasIamRoles() {
        return iamRoles != null && !(iamRoles instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of IAM roles to associate with the namespace.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIamRoles} method.
     * </p>
     * 
     * @return A list of IAM roles to associate with the namespace.
     */
    public final List<String> iamRoles() {
        return iamRoles;
    }

    /**
     * <p>
     * The ID of the Amazon Web Services Key Management Service key used to encrypt your data.
     * </p>
     * 
     * @return The ID of the Amazon Web Services Key Management Service key used to encrypt your data.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * The types of logs the namespace can export. Available export types are User log, Connection log, and User
     * activity log.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLogExports} method.
     * </p>
     * 
     * @return The types of logs the namespace can export. Available export types are User log, Connection log, and User
     *         activity log.
     */
    public final List<LogExport> logExports() {
        return LogExportListCopier.copyStringToEnum(logExports);
    }

    /**
     * For responses, this returns true if the service returned a value for the LogExports property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasLogExports() {
        return logExports != null && !(logExports instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The types of logs the namespace can export. Available export types are User log, Connection log, and User
     * activity log.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLogExports} method.
     * </p>
     * 
     * @return The types of logs the namespace can export. Available export types are User log, Connection log, and User
     *         activity log.
     */
    public final List<String> logExportsAsStrings() {
        return logExports;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) associated with a namespace.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) associated with a namespace.
     */
    public final String namespaceArn() {
        return namespaceArn;
    }

    /**
     * <p>
     * The unique identifier of a namespace.
     * </p>
     * 
     * @return The unique identifier of a namespace.
     */
    public final String namespaceId() {
        return namespaceId;
    }

    /**
     * <p>
     * The name of the namespace. Must be between 3-64 alphanumeric characters in lowercase, and it cannot be a reserved
     * word. A list of reserved words can be found in <a
     * href="https://docs.aws.amazon.com/redshift/latest/dg/r_pg_keywords.html">Reserved Words</a> in the Amazon
     * Redshift Database Developer Guide.
     * </p>
     * 
     * @return The name of the namespace. Must be between 3-64 alphanumeric characters in lowercase, and it cannot be a
     *         reserved word. A list of reserved words can be found in <a
     *         href="https://docs.aws.amazon.com/redshift/latest/dg/r_pg_keywords.html">Reserved Words</a> in the Amazon
     *         Redshift Database Developer Guide.
     */
    public final String namespaceName() {
        return namespaceName;
    }

    /**
     * <p>
     * The status of the namespace.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link NamespaceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the namespace.
     * @see NamespaceStatus
     */
    public final NamespaceStatus status() {
        return NamespaceStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the namespace.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link NamespaceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the namespace.
     * @see NamespaceStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(adminPasswordSecretArn());
        hashCode = 31 * hashCode + Objects.hashCode(adminPasswordSecretKmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(adminUsername());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(dbName());
        hashCode = 31 * hashCode + Objects.hashCode(defaultIamRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasIamRoles() ? iamRoles() : null);
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(hasLogExports() ? logExportsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(namespaceArn());
        hashCode = 31 * hashCode + Objects.hashCode(namespaceId());
        hashCode = 31 * hashCode + Objects.hashCode(namespaceName());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Namespace)) {
            return false;
        }
        Namespace other = (Namespace) obj;
        return Objects.equals(adminPasswordSecretArn(), other.adminPasswordSecretArn())
                && Objects.equals(adminPasswordSecretKmsKeyId(), other.adminPasswordSecretKmsKeyId())
                && Objects.equals(adminUsername(), other.adminUsername()) && Objects.equals(creationDate(), other.creationDate())
                && Objects.equals(dbName(), other.dbName()) && Objects.equals(defaultIamRoleArn(), other.defaultIamRoleArn())
                && hasIamRoles() == other.hasIamRoles() && Objects.equals(iamRoles(), other.iamRoles())
                && Objects.equals(kmsKeyId(), other.kmsKeyId()) && hasLogExports() == other.hasLogExports()
                && Objects.equals(logExportsAsStrings(), other.logExportsAsStrings())
                && Objects.equals(namespaceArn(), other.namespaceArn()) && Objects.equals(namespaceId(), other.namespaceId())
                && Objects.equals(namespaceName(), other.namespaceName())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Namespace").add("AdminPasswordSecretArn", adminPasswordSecretArn())
                .add("AdminPasswordSecretKmsKeyId", adminPasswordSecretKmsKeyId())
                .add("AdminUsername", adminUsername() == null ? null : "*** Sensitive Data Redacted ***")
                .add("CreationDate", creationDate()).add("DbName", dbName()).add("DefaultIamRoleArn", defaultIamRoleArn())
                .add("IamRoles", hasIamRoles() ? iamRoles() : null).add("KmsKeyId", kmsKeyId())
                .add("LogExports", hasLogExports() ? logExportsAsStrings() : null).add("NamespaceArn", namespaceArn())
                .add("NamespaceId", namespaceId()).add("NamespaceName", namespaceName()).add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "adminPasswordSecretArn":
            return Optional.ofNullable(clazz.cast(adminPasswordSecretArn()));
        case "adminPasswordSecretKmsKeyId":
            return Optional.ofNullable(clazz.cast(adminPasswordSecretKmsKeyId()));
        case "adminUsername":
            return Optional.ofNullable(clazz.cast(adminUsername()));
        case "creationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        case "dbName":
            return Optional.ofNullable(clazz.cast(dbName()));
        case "defaultIamRoleArn":
            return Optional.ofNullable(clazz.cast(defaultIamRoleArn()));
        case "iamRoles":
            return Optional.ofNullable(clazz.cast(iamRoles()));
        case "kmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "logExports":
            return Optional.ofNullable(clazz.cast(logExportsAsStrings()));
        case "namespaceArn":
            return Optional.ofNullable(clazz.cast(namespaceArn()));
        case "namespaceId":
            return Optional.ofNullable(clazz.cast(namespaceId()));
        case "namespaceName":
            return Optional.ofNullable(clazz.cast(namespaceName()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Namespace, T> g) {
        return obj -> g.apply((Namespace) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Namespace> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) for the namespace's admin user credentials secret.
         * </p>
         * 
         * @param adminPasswordSecretArn
         *        The Amazon Resource Name (ARN) for the namespace's admin user credentials secret.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adminPasswordSecretArn(String adminPasswordSecretArn);

        /**
         * <p>
         * The ID of the Key Management Service (KMS) key used to encrypt and store the namespace's admin credentials
         * secret.
         * </p>
         * 
         * @param adminPasswordSecretKmsKeyId
         *        The ID of the Key Management Service (KMS) key used to encrypt and store the namespace's admin
         *        credentials secret.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adminPasswordSecretKmsKeyId(String adminPasswordSecretKmsKeyId);

        /**
         * <p>
         * The username of the administrator for the first database created in the namespace.
         * </p>
         * 
         * @param adminUsername
         *        The username of the administrator for the first database created in the namespace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adminUsername(String adminUsername);

        /**
         * <p>
         * The date of when the namespace was created.
         * </p>
         * 
         * @param creationDate
         *        The date of when the namespace was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Instant creationDate);

        /**
         * <p>
         * The name of the first database created in the namespace.
         * </p>
         * 
         * @param dbName
         *        The name of the first database created in the namespace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbName(String dbName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role to set as a default in the namespace.
         * </p>
         * 
         * @param defaultIamRoleArn
         *        The Amazon Resource Name (ARN) of the IAM role to set as a default in the namespace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultIamRoleArn(String defaultIamRoleArn);

        /**
         * <p>
         * A list of IAM roles to associate with the namespace.
         * </p>
         * 
         * @param iamRoles
         *        A list of IAM roles to associate with the namespace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamRoles(Collection<String> iamRoles);

        /**
         * <p>
         * A list of IAM roles to associate with the namespace.
         * </p>
         * 
         * @param iamRoles
         *        A list of IAM roles to associate with the namespace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamRoles(String... iamRoles);

        /**
         * <p>
         * The ID of the Amazon Web Services Key Management Service key used to encrypt your data.
         * </p>
         * 
         * @param kmsKeyId
         *        The ID of the Amazon Web Services Key Management Service key used to encrypt your data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * The types of logs the namespace can export. Available export types are User log, Connection log, and User
         * activity log.
         * </p>
         * 
         * @param logExports
         *        The types of logs the namespace can export. Available export types are User log, Connection log, and
         *        User activity log.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logExportsWithStrings(Collection<String> logExports);

        /**
         * <p>
         * The types of logs the namespace can export. Available export types are User log, Connection log, and User
         * activity log.
         * </p>
         * 
         * @param logExports
         *        The types of logs the namespace can export. Available export types are User log, Connection log, and
         *        User activity log.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logExportsWithStrings(String... logExports);

        /**
         * <p>
         * The types of logs the namespace can export. Available export types are User log, Connection log, and User
         * activity log.
         * </p>
         * 
         * @param logExports
         *        The types of logs the namespace can export. Available export types are User log, Connection log, and
         *        User activity log.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logExports(Collection<LogExport> logExports);

        /**
         * <p>
         * The types of logs the namespace can export. Available export types are User log, Connection log, and User
         * activity log.
         * </p>
         * 
         * @param logExports
         *        The types of logs the namespace can export. Available export types are User log, Connection log, and
         *        User activity log.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logExports(LogExport... logExports);

        /**
         * <p>
         * The Amazon Resource Name (ARN) associated with a namespace.
         * </p>
         * 
         * @param namespaceArn
         *        The Amazon Resource Name (ARN) associated with a namespace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespaceArn(String namespaceArn);

        /**
         * <p>
         * The unique identifier of a namespace.
         * </p>
         * 
         * @param namespaceId
         *        The unique identifier of a namespace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespaceId(String namespaceId);

        /**
         * <p>
         * The name of the namespace. Must be between 3-64 alphanumeric characters in lowercase, and it cannot be a
         * reserved word. A list of reserved words can be found in <a
         * href="https://docs.aws.amazon.com/redshift/latest/dg/r_pg_keywords.html">Reserved Words</a> in the Amazon
         * Redshift Database Developer Guide.
         * </p>
         * 
         * @param namespaceName
         *        The name of the namespace. Must be between 3-64 alphanumeric characters in lowercase, and it cannot be
         *        a reserved word. A list of reserved words can be found in <a
         *        href="https://docs.aws.amazon.com/redshift/latest/dg/r_pg_keywords.html">Reserved Words</a> in the
         *        Amazon Redshift Database Developer Guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespaceName(String namespaceName);

        /**
         * <p>
         * The status of the namespace.
         * </p>
         * 
         * @param status
         *        The status of the namespace.
         * @see NamespaceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NamespaceStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the namespace.
         * </p>
         * 
         * @param status
         *        The status of the namespace.
         * @see NamespaceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NamespaceStatus
         */
        Builder status(NamespaceStatus status);
    }

    static final class BuilderImpl implements Builder {
        private String adminPasswordSecretArn;

        private String adminPasswordSecretKmsKeyId;

        private String adminUsername;

        private Instant creationDate;

        private String dbName;

        private String defaultIamRoleArn;

        private List<String> iamRoles = DefaultSdkAutoConstructList.getInstance();

        private String kmsKeyId;

        private List<String> logExports = DefaultSdkAutoConstructList.getInstance();

        private String namespaceArn;

        private String namespaceId;

        private String namespaceName;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(Namespace model) {
            adminPasswordSecretArn(model.adminPasswordSecretArn);
            adminPasswordSecretKmsKeyId(model.adminPasswordSecretKmsKeyId);
            adminUsername(model.adminUsername);
            creationDate(model.creationDate);
            dbName(model.dbName);
            defaultIamRoleArn(model.defaultIamRoleArn);
            iamRoles(model.iamRoles);
            kmsKeyId(model.kmsKeyId);
            logExportsWithStrings(model.logExports);
            namespaceArn(model.namespaceArn);
            namespaceId(model.namespaceId);
            namespaceName(model.namespaceName);
            status(model.status);
        }

        public final String getAdminPasswordSecretArn() {
            return adminPasswordSecretArn;
        }

        public final void setAdminPasswordSecretArn(String adminPasswordSecretArn) {
            this.adminPasswordSecretArn = adminPasswordSecretArn;
        }

        @Override
        public final Builder adminPasswordSecretArn(String adminPasswordSecretArn) {
            this.adminPasswordSecretArn = adminPasswordSecretArn;
            return this;
        }

        public final String getAdminPasswordSecretKmsKeyId() {
            return adminPasswordSecretKmsKeyId;
        }

        public final void setAdminPasswordSecretKmsKeyId(String adminPasswordSecretKmsKeyId) {
            this.adminPasswordSecretKmsKeyId = adminPasswordSecretKmsKeyId;
        }

        @Override
        public final Builder adminPasswordSecretKmsKeyId(String adminPasswordSecretKmsKeyId) {
            this.adminPasswordSecretKmsKeyId = adminPasswordSecretKmsKeyId;
            return this;
        }

        public final String getAdminUsername() {
            return adminUsername;
        }

        public final void setAdminUsername(String adminUsername) {
            this.adminUsername = adminUsername;
        }

        @Override
        public final Builder adminUsername(String adminUsername) {
            this.adminUsername = adminUsername;
            return this;
        }

        public final Instant getCreationDate() {
            return creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final String getDbName() {
            return dbName;
        }

        public final void setDbName(String dbName) {
            this.dbName = dbName;
        }

        @Override
        public final Builder dbName(String dbName) {
            this.dbName = dbName;
            return this;
        }

        public final String getDefaultIamRoleArn() {
            return defaultIamRoleArn;
        }

        public final void setDefaultIamRoleArn(String defaultIamRoleArn) {
            this.defaultIamRoleArn = defaultIamRoleArn;
        }

        @Override
        public final Builder defaultIamRoleArn(String defaultIamRoleArn) {
            this.defaultIamRoleArn = defaultIamRoleArn;
            return this;
        }

        public final Collection<String> getIamRoles() {
            if (iamRoles instanceof SdkAutoConstructList) {
                return null;
            }
            return iamRoles;
        }

        public final void setIamRoles(Collection<String> iamRoles) {
            this.iamRoles = IamRoleArnListCopier.copy(iamRoles);
        }

        @Override
        public final Builder iamRoles(Collection<String> iamRoles) {
            this.iamRoles = IamRoleArnListCopier.copy(iamRoles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder iamRoles(String... iamRoles) {
            iamRoles(Arrays.asList(iamRoles));
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final Collection<String> getLogExports() {
            if (logExports instanceof SdkAutoConstructList) {
                return null;
            }
            return logExports;
        }

        public final void setLogExports(Collection<String> logExports) {
            this.logExports = LogExportListCopier.copy(logExports);
        }

        @Override
        public final Builder logExportsWithStrings(Collection<String> logExports) {
            this.logExports = LogExportListCopier.copy(logExports);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logExportsWithStrings(String... logExports) {
            logExportsWithStrings(Arrays.asList(logExports));
            return this;
        }

        @Override
        public final Builder logExports(Collection<LogExport> logExports) {
            this.logExports = LogExportListCopier.copyEnumToString(logExports);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logExports(LogExport... logExports) {
            logExports(Arrays.asList(logExports));
            return this;
        }

        public final String getNamespaceArn() {
            return namespaceArn;
        }

        public final void setNamespaceArn(String namespaceArn) {
            this.namespaceArn = namespaceArn;
        }

        @Override
        public final Builder namespaceArn(String namespaceArn) {
            this.namespaceArn = namespaceArn;
            return this;
        }

        public final String getNamespaceId() {
            return namespaceId;
        }

        public final void setNamespaceId(String namespaceId) {
            this.namespaceId = namespaceId;
        }

        @Override
        public final Builder namespaceId(String namespaceId) {
            this.namespaceId = namespaceId;
            return this;
        }

        public final String getNamespaceName() {
            return namespaceName;
        }

        public final void setNamespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
        }

        @Override
        public final Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(NamespaceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public Namespace build() {
            return new Namespace(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
