/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshiftserverless.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The returned scheduled action object.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ScheduledActionResponse implements SdkPojo, Serializable,
        ToCopyableBuilder<ScheduledActionResponse.Builder, ScheduledActionResponse> {
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("endTime").getter(getter(ScheduledActionResponse::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()).build();

    private static final SdkField<String> NAMESPACE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("namespaceName").getter(getter(ScheduledActionResponse::namespaceName))
            .setter(setter(Builder::namespaceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespaceName").build()).build();

    private static final SdkField<List<Instant>> NEXT_INVOCATIONS_FIELD = SdkField
            .<List<Instant>> builder(MarshallingType.LIST)
            .memberName("nextInvocations")
            .getter(getter(ScheduledActionResponse::nextInvocations))
            .setter(setter(Builder::nextInvocations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextInvocations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Instant> builder(MarshallingType.INSTANT)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(ScheduledActionResponse::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<Schedule> SCHEDULE_FIELD = SdkField.<Schedule> builder(MarshallingType.SDK_POJO)
            .memberName("schedule").getter(getter(ScheduledActionResponse::schedule)).setter(setter(Builder::schedule))
            .constructor(Schedule::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schedule").build()).build();

    private static final SdkField<String> SCHEDULED_ACTION_DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("scheduledActionDescription")
            .getter(getter(ScheduledActionResponse::scheduledActionDescription))
            .setter(setter(Builder::scheduledActionDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scheduledActionDescription").build())
            .build();

    private static final SdkField<String> SCHEDULED_ACTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("scheduledActionName").getter(getter(ScheduledActionResponse::scheduledActionName))
            .setter(setter(Builder::scheduledActionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scheduledActionName").build())
            .build();

    private static final SdkField<String> SCHEDULED_ACTION_UUID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("scheduledActionUuid").getter(getter(ScheduledActionResponse::scheduledActionUuid))
            .setter(setter(Builder::scheduledActionUuid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scheduledActionUuid").build())
            .build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("startTime").getter(getter(ScheduledActionResponse::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("state")
            .getter(getter(ScheduledActionResponse::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()).build();

    private static final SdkField<TargetAction> TARGET_ACTION_FIELD = SdkField.<TargetAction> builder(MarshallingType.SDK_POJO)
            .memberName("targetAction").getter(getter(ScheduledActionResponse::targetAction))
            .setter(setter(Builder::targetAction)).constructor(TargetAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetAction").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(END_TIME_FIELD,
            NAMESPACE_NAME_FIELD, NEXT_INVOCATIONS_FIELD, ROLE_ARN_FIELD, SCHEDULE_FIELD, SCHEDULED_ACTION_DESCRIPTION_FIELD,
            SCHEDULED_ACTION_NAME_FIELD, SCHEDULED_ACTION_UUID_FIELD, START_TIME_FIELD, STATE_FIELD, TARGET_ACTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final Instant endTime;

    private final String namespaceName;

    private final List<Instant> nextInvocations;

    private final String roleArn;

    private final Schedule schedule;

    private final String scheduledActionDescription;

    private final String scheduledActionName;

    private final String scheduledActionUuid;

    private final Instant startTime;

    private final String state;

    private final TargetAction targetAction;

    private ScheduledActionResponse(BuilderImpl builder) {
        this.endTime = builder.endTime;
        this.namespaceName = builder.namespaceName;
        this.nextInvocations = builder.nextInvocations;
        this.roleArn = builder.roleArn;
        this.schedule = builder.schedule;
        this.scheduledActionDescription = builder.scheduledActionDescription;
        this.scheduledActionName = builder.scheduledActionName;
        this.scheduledActionUuid = builder.scheduledActionUuid;
        this.startTime = builder.startTime;
        this.state = builder.state;
        this.targetAction = builder.targetAction;
    }

    /**
     * <p>
     * The end time of
     * </p>
     * 
     * @return The end time of
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * The end time in UTC when the schedule is no longer active. After this time, the scheduled action does not
     * trigger.
     * </p>
     * 
     * @return The end time in UTC when the schedule is no longer active. After this time, the scheduled action does not
     *         trigger.
     */
    public final String namespaceName() {
        return namespaceName;
    }

    /**
     * For responses, this returns true if the service returned a value for the NextInvocations property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasNextInvocations() {
        return nextInvocations != null && !(nextInvocations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of timestamps of when the next scheduled actions will trigger.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNextInvocations} method.
     * </p>
     * 
     * @return An array of timestamps of when the next scheduled actions will trigger.
     */
    public final List<Instant> nextInvocations() {
        return nextInvocations;
    }

    /**
     * <p>
     * The ARN of the IAM role to assume to run the scheduled action. This IAM role must have permission to run the
     * Amazon Redshift Serverless API operation in the scheduled action. This IAM role must allow the Amazon Redshift
     * scheduler to schedule creating snapshots. (Principal scheduler.redshift.amazonaws.com) to assume permissions on
     * your behalf. For more information about the IAM role to use with the Amazon Redshift scheduler, see <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-identity-based.html">Using
     * Identity-Based Policies for Amazon Redshift</a> in the Amazon Redshift Management Guide
     * </p>
     * 
     * @return The ARN of the IAM role to assume to run the scheduled action. This IAM role must have permission to run
     *         the Amazon Redshift Serverless API operation in the scheduled action. This IAM role must allow the Amazon
     *         Redshift scheduler to schedule creating snapshots. (Principal scheduler.redshift.amazonaws.com) to assume
     *         permissions on your behalf. For more information about the IAM role to use with the Amazon Redshift
     *         scheduler, see <a
     *         href="https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-identity-based.html"
     *         >Using Identity-Based Policies for Amazon Redshift</a> in the Amazon Redshift Management Guide
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The schedule for a one-time (at timestamp format) or recurring (cron format) scheduled action. Schedule
     * invocations must be separated by at least one hour. Times are in UTC.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Format of at timestamp is <code>yyyy-mm-ddThh:mm:ss</code>. For example, <code>2016-03-04T17:27:00</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Format of cron expression is <code>(Minutes Hours Day-of-month Month Day-of-week Year)</code>. For example,
     * <code>"(0 10 ? * MON *)"</code>. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html#CronExpressions">Cron
     * Expressions</a> in the <i>Amazon CloudWatch Events User Guide</i>.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The schedule for a one-time (at timestamp format) or recurring (cron format) scheduled action. Schedule
     *         invocations must be separated by at least one hour. Times are in UTC.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Format of at timestamp is <code>yyyy-mm-ddThh:mm:ss</code>. For example, <code>2016-03-04T17:27:00</code>
     *         .
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Format of cron expression is <code>(Minutes Hours Day-of-month Month Day-of-week Year)</code>. For
     *         example, <code>"(0 10 ? * MON *)"</code>. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html#CronExpressions"
     *         >Cron Expressions</a> in the <i>Amazon CloudWatch Events User Guide</i>.
     *         </p>
     *         </li>
     */
    public final Schedule schedule() {
        return schedule;
    }

    /**
     * <p>
     * The description of the scheduled action.
     * </p>
     * 
     * @return The description of the scheduled action.
     */
    public final String scheduledActionDescription() {
        return scheduledActionDescription;
    }

    /**
     * <p>
     * The name of the scheduled action.
     * </p>
     * 
     * @return The name of the scheduled action.
     */
    public final String scheduledActionName() {
        return scheduledActionName;
    }

    /**
     * <p>
     * The uuid of the scheduled action.
     * </p>
     * 
     * @return The uuid of the scheduled action.
     */
    public final String scheduledActionUuid() {
        return scheduledActionUuid;
    }

    /**
     * <p>
     * The start time in UTC when the schedule is active. Before this time, the scheduled action does not trigger.
     * </p>
     * 
     * @return The start time in UTC when the schedule is active. Before this time, the scheduled action does not
     *         trigger.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The state of the scheduled action.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link State#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the scheduled action.
     * @see State
     */
    public final State state() {
        return State.fromValue(state);
    }

    /**
     * <p>
     * The state of the scheduled action.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link State#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the scheduled action.
     * @see State
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * Returns the value of the TargetAction property for this object.
     * 
     * @return The value of the TargetAction property for this object.
     */
    public final TargetAction targetAction() {
        return targetAction;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(namespaceName());
        hashCode = 31 * hashCode + Objects.hashCode(hasNextInvocations() ? nextInvocations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(schedule());
        hashCode = 31 * hashCode + Objects.hashCode(scheduledActionDescription());
        hashCode = 31 * hashCode + Objects.hashCode(scheduledActionName());
        hashCode = 31 * hashCode + Objects.hashCode(scheduledActionUuid());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(targetAction());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScheduledActionResponse)) {
            return false;
        }
        ScheduledActionResponse other = (ScheduledActionResponse) obj;
        return Objects.equals(endTime(), other.endTime()) && Objects.equals(namespaceName(), other.namespaceName())
                && hasNextInvocations() == other.hasNextInvocations()
                && Objects.equals(nextInvocations(), other.nextInvocations()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(schedule(), other.schedule())
                && Objects.equals(scheduledActionDescription(), other.scheduledActionDescription())
                && Objects.equals(scheduledActionName(), other.scheduledActionName())
                && Objects.equals(scheduledActionUuid(), other.scheduledActionUuid())
                && Objects.equals(startTime(), other.startTime()) && Objects.equals(stateAsString(), other.stateAsString())
                && Objects.equals(targetAction(), other.targetAction());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ScheduledActionResponse").add("EndTime", endTime()).add("NamespaceName", namespaceName())
                .add("NextInvocations", hasNextInvocations() ? nextInvocations() : null).add("RoleArn", roleArn())
                .add("Schedule", schedule()).add("ScheduledActionDescription", scheduledActionDescription())
                .add("ScheduledActionName", scheduledActionName()).add("ScheduledActionUuid", scheduledActionUuid())
                .add("StartTime", startTime()).add("State", stateAsString()).add("TargetAction", targetAction()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "endTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "namespaceName":
            return Optional.ofNullable(clazz.cast(namespaceName()));
        case "nextInvocations":
            return Optional.ofNullable(clazz.cast(nextInvocations()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "schedule":
            return Optional.ofNullable(clazz.cast(schedule()));
        case "scheduledActionDescription":
            return Optional.ofNullable(clazz.cast(scheduledActionDescription()));
        case "scheduledActionName":
            return Optional.ofNullable(clazz.cast(scheduledActionName()));
        case "scheduledActionUuid":
            return Optional.ofNullable(clazz.cast(scheduledActionUuid()));
        case "startTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "state":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "targetAction":
            return Optional.ofNullable(clazz.cast(targetAction()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ScheduledActionResponse, T> g) {
        return obj -> g.apply((ScheduledActionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ScheduledActionResponse> {
        /**
         * <p>
         * The end time of
         * </p>
         * 
         * @param endTime
         *        The end time of
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * The end time in UTC when the schedule is no longer active. After this time, the scheduled action does not
         * trigger.
         * </p>
         * 
         * @param namespaceName
         *        The end time in UTC when the schedule is no longer active. After this time, the scheduled action does
         *        not trigger.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespaceName(String namespaceName);

        /**
         * <p>
         * An array of timestamps of when the next scheduled actions will trigger.
         * </p>
         * 
         * @param nextInvocations
         *        An array of timestamps of when the next scheduled actions will trigger.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextInvocations(Collection<Instant> nextInvocations);

        /**
         * <p>
         * An array of timestamps of when the next scheduled actions will trigger.
         * </p>
         * 
         * @param nextInvocations
         *        An array of timestamps of when the next scheduled actions will trigger.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextInvocations(Instant... nextInvocations);

        /**
         * <p>
         * The ARN of the IAM role to assume to run the scheduled action. This IAM role must have permission to run the
         * Amazon Redshift Serverless API operation in the scheduled action. This IAM role must allow the Amazon
         * Redshift scheduler to schedule creating snapshots. (Principal scheduler.redshift.amazonaws.com) to assume
         * permissions on your behalf. For more information about the IAM role to use with the Amazon Redshift
         * scheduler, see <a
         * href="https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-identity-based.html">Using
         * Identity-Based Policies for Amazon Redshift</a> in the Amazon Redshift Management Guide
         * </p>
         * 
         * @param roleArn
         *        The ARN of the IAM role to assume to run the scheduled action. This IAM role must have permission to
         *        run the Amazon Redshift Serverless API operation in the scheduled action. This IAM role must allow the
         *        Amazon Redshift scheduler to schedule creating snapshots. (Principal scheduler.redshift.amazonaws.com)
         *        to assume permissions on your behalf. For more information about the IAM role to use with the Amazon
         *        Redshift scheduler, see <a href=
         *        "https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-identity-based.html"
         *        >Using Identity-Based Policies for Amazon Redshift</a> in the Amazon Redshift Management Guide
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The schedule for a one-time (at timestamp format) or recurring (cron format) scheduled action. Schedule
         * invocations must be separated by at least one hour. Times are in UTC.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Format of at timestamp is <code>yyyy-mm-ddThh:mm:ss</code>. For example, <code>2016-03-04T17:27:00</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Format of cron expression is <code>(Minutes Hours Day-of-month Month Day-of-week Year)</code>. For example,
         * <code>"(0 10 ? * MON *)"</code>. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html#CronExpressions">Cron
         * Expressions</a> in the <i>Amazon CloudWatch Events User Guide</i>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param schedule
         *        The schedule for a one-time (at timestamp format) or recurring (cron format) scheduled action.
         *        Schedule invocations must be separated by at least one hour. Times are in UTC.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Format of at timestamp is <code>yyyy-mm-ddThh:mm:ss</code>. For example,
         *        <code>2016-03-04T17:27:00</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Format of cron expression is <code>(Minutes Hours Day-of-month Month Day-of-week Year)</code>. For
         *        example, <code>"(0 10 ? * MON *)"</code>. For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html#CronExpressions"
         *        >Cron Expressions</a> in the <i>Amazon CloudWatch Events User Guide</i>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schedule(Schedule schedule);

        /**
         * <p>
         * The schedule for a one-time (at timestamp format) or recurring (cron format) scheduled action. Schedule
         * invocations must be separated by at least one hour. Times are in UTC.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Format of at timestamp is <code>yyyy-mm-ddThh:mm:ss</code>. For example, <code>2016-03-04T17:27:00</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Format of cron expression is <code>(Minutes Hours Day-of-month Month Day-of-week Year)</code>. For example,
         * <code>"(0 10 ? * MON *)"</code>. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html#CronExpressions">Cron
         * Expressions</a> in the <i>Amazon CloudWatch Events User Guide</i>.
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the {@link Schedule.Builder} avoiding the need to
         * create one manually via {@link Schedule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Schedule.Builder#build()} is called immediately and its result is
         * passed to {@link #schedule(Schedule)}.
         * 
         * @param schedule
         *        a consumer that will call methods on {@link Schedule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #schedule(Schedule)
         */
        default Builder schedule(Consumer<Schedule.Builder> schedule) {
            return schedule(Schedule.builder().applyMutation(schedule).build());
        }

        /**
         * <p>
         * The description of the scheduled action.
         * </p>
         * 
         * @param scheduledActionDescription
         *        The description of the scheduled action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduledActionDescription(String scheduledActionDescription);

        /**
         * <p>
         * The name of the scheduled action.
         * </p>
         * 
         * @param scheduledActionName
         *        The name of the scheduled action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduledActionName(String scheduledActionName);

        /**
         * <p>
         * The uuid of the scheduled action.
         * </p>
         * 
         * @param scheduledActionUuid
         *        The uuid of the scheduled action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduledActionUuid(String scheduledActionUuid);

        /**
         * <p>
         * The start time in UTC when the schedule is active. Before this time, the scheduled action does not trigger.
         * </p>
         * 
         * @param startTime
         *        The start time in UTC when the schedule is active. Before this time, the scheduled action does not
         *        trigger.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The state of the scheduled action.
         * </p>
         * 
         * @param state
         *        The state of the scheduled action.
         * @see State
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see State
         */
        Builder state(String state);

        /**
         * <p>
         * The state of the scheduled action.
         * </p>
         * 
         * @param state
         *        The state of the scheduled action.
         * @see State
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see State
         */
        Builder state(State state);

        /**
         * Sets the value of the TargetAction property for this object.
         *
         * @param targetAction
         *        The new value for the TargetAction property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetAction(TargetAction targetAction);

        /**
         * Sets the value of the TargetAction property for this object.
         *
         * This is a convenience method that creates an instance of the {@link TargetAction.Builder} avoiding the need
         * to create one manually via {@link TargetAction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TargetAction.Builder#build()} is called immediately and its
         * result is passed to {@link #targetAction(TargetAction)}.
         * 
         * @param targetAction
         *        a consumer that will call methods on {@link TargetAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetAction(TargetAction)
         */
        default Builder targetAction(Consumer<TargetAction.Builder> targetAction) {
            return targetAction(TargetAction.builder().applyMutation(targetAction).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Instant endTime;

        private String namespaceName;

        private List<Instant> nextInvocations = DefaultSdkAutoConstructList.getInstance();

        private String roleArn;

        private Schedule schedule;

        private String scheduledActionDescription;

        private String scheduledActionName;

        private String scheduledActionUuid;

        private Instant startTime;

        private String state;

        private TargetAction targetAction;

        private BuilderImpl() {
        }

        private BuilderImpl(ScheduledActionResponse model) {
            endTime(model.endTime);
            namespaceName(model.namespaceName);
            nextInvocations(model.nextInvocations);
            roleArn(model.roleArn);
            schedule(model.schedule);
            scheduledActionDescription(model.scheduledActionDescription);
            scheduledActionName(model.scheduledActionName);
            scheduledActionUuid(model.scheduledActionUuid);
            startTime(model.startTime);
            state(model.state);
            targetAction(model.targetAction);
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getNamespaceName() {
            return namespaceName;
        }

        public final void setNamespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
        }

        @Override
        public final Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public final Collection<Instant> getNextInvocations() {
            if (nextInvocations instanceof SdkAutoConstructList) {
                return null;
            }
            return nextInvocations;
        }

        public final void setNextInvocations(Collection<Instant> nextInvocations) {
            this.nextInvocations = NextInvocationsListCopier.copy(nextInvocations);
        }

        @Override
        public final Builder nextInvocations(Collection<Instant> nextInvocations) {
            this.nextInvocations = NextInvocationsListCopier.copy(nextInvocations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nextInvocations(Instant... nextInvocations) {
            nextInvocations(Arrays.asList(nextInvocations));
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final Schedule.Builder getSchedule() {
            return schedule != null ? schedule.toBuilder() : null;
        }

        public final void setSchedule(Schedule.BuilderImpl schedule) {
            this.schedule = schedule != null ? schedule.build() : null;
        }

        @Override
        public final Builder schedule(Schedule schedule) {
            this.schedule = schedule;
            return this;
        }

        public final String getScheduledActionDescription() {
            return scheduledActionDescription;
        }

        public final void setScheduledActionDescription(String scheduledActionDescription) {
            this.scheduledActionDescription = scheduledActionDescription;
        }

        @Override
        public final Builder scheduledActionDescription(String scheduledActionDescription) {
            this.scheduledActionDescription = scheduledActionDescription;
            return this;
        }

        public final String getScheduledActionName() {
            return scheduledActionName;
        }

        public final void setScheduledActionName(String scheduledActionName) {
            this.scheduledActionName = scheduledActionName;
        }

        @Override
        public final Builder scheduledActionName(String scheduledActionName) {
            this.scheduledActionName = scheduledActionName;
            return this;
        }

        public final String getScheduledActionUuid() {
            return scheduledActionUuid;
        }

        public final void setScheduledActionUuid(String scheduledActionUuid) {
            this.scheduledActionUuid = scheduledActionUuid;
        }

        @Override
        public final Builder scheduledActionUuid(String scheduledActionUuid) {
            this.scheduledActionUuid = scheduledActionUuid;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(State state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final TargetAction.Builder getTargetAction() {
            return targetAction != null ? targetAction.toBuilder() : null;
        }

        public final void setTargetAction(TargetAction.BuilderImpl targetAction) {
            this.targetAction = targetAction != null ? targetAction.build() : null;
        }

        @Override
        public final Builder targetAction(TargetAction targetAction) {
            this.targetAction = targetAction;
            return this;
        }

        @Override
        public ScheduledActionResponse build() {
            return new ScheduledActionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
