/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshiftserverless.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetRecoveryPointResponse extends RedshiftServerlessResponse implements
        ToCopyableBuilder<GetRecoveryPointResponse.Builder, GetRecoveryPointResponse> {
    private static final SdkField<RecoveryPoint> RECOVERY_POINT_FIELD = SdkField
            .<RecoveryPoint> builder(MarshallingType.SDK_POJO).memberName("recoveryPoint")
            .getter(getter(GetRecoveryPointResponse::recoveryPoint)).setter(setter(Builder::recoveryPoint))
            .constructor(RecoveryPoint::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recoveryPoint").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECOVERY_POINT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final RecoveryPoint recoveryPoint;

    private GetRecoveryPointResponse(BuilderImpl builder) {
        super(builder);
        this.recoveryPoint = builder.recoveryPoint;
    }

    /**
     * <p>
     * The returned recovery point object.
     * </p>
     * 
     * @return The returned recovery point object.
     */
    public final RecoveryPoint recoveryPoint() {
        return recoveryPoint;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(recoveryPoint());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRecoveryPointResponse)) {
            return false;
        }
        GetRecoveryPointResponse other = (GetRecoveryPointResponse) obj;
        return Objects.equals(recoveryPoint(), other.recoveryPoint());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetRecoveryPointResponse").add("RecoveryPoint", recoveryPoint()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "recoveryPoint":
            return Optional.ofNullable(clazz.cast(recoveryPoint()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("recoveryPoint", RECOVERY_POINT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetRecoveryPointResponse, T> g) {
        return obj -> g.apply((GetRecoveryPointResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftServerlessResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetRecoveryPointResponse> {
        /**
         * <p>
         * The returned recovery point object.
         * </p>
         * 
         * @param recoveryPoint
         *        The returned recovery point object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recoveryPoint(RecoveryPoint recoveryPoint);

        /**
         * <p>
         * The returned recovery point object.
         * </p>
         * This is a convenience method that creates an instance of the {@link RecoveryPoint.Builder} avoiding the need
         * to create one manually via {@link RecoveryPoint#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RecoveryPoint.Builder#build()} is called immediately and its
         * result is passed to {@link #recoveryPoint(RecoveryPoint)}.
         * 
         * @param recoveryPoint
         *        a consumer that will call methods on {@link RecoveryPoint.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #recoveryPoint(RecoveryPoint)
         */
        default Builder recoveryPoint(Consumer<RecoveryPoint.Builder> recoveryPoint) {
            return recoveryPoint(RecoveryPoint.builder().applyMutation(recoveryPoint).build());
        }
    }

    static final class BuilderImpl extends RedshiftServerlessResponse.BuilderImpl implements Builder {
        private RecoveryPoint recoveryPoint;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRecoveryPointResponse model) {
            super(model);
            recoveryPoint(model.recoveryPoint);
        }

        public final RecoveryPoint.Builder getRecoveryPoint() {
            return recoveryPoint != null ? recoveryPoint.toBuilder() : null;
        }

        public final void setRecoveryPoint(RecoveryPoint.BuilderImpl recoveryPoint) {
            this.recoveryPoint = recoveryPoint != null ? recoveryPoint.build() : null;
        }

        @Override
        public final Builder recoveryPoint(RecoveryPoint recoveryPoint) {
            this.recoveryPoint = recoveryPoint;
            return this;
        }

        @Override
        public GetRecoveryPointResponse build() {
            return new GetRecoveryPointResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
