/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshiftserverless.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A collection of Amazon Redshift compute resources managed by AWS Glue.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ManagedWorkgroupListItem implements SdkPojo, Serializable,
        ToCopyableBuilder<ManagedWorkgroupListItem.Builder, ManagedWorkgroupListItem> {
    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationDate")
            .getter(getter(ManagedWorkgroupListItem::creationDate))
            .setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDate").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> MANAGED_WORKGROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("managedWorkgroupId").getter(getter(ManagedWorkgroupListItem::managedWorkgroupId))
            .setter(setter(Builder::managedWorkgroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("managedWorkgroupId").build())
            .build();

    private static final SdkField<String> MANAGED_WORKGROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("managedWorkgroupName").getter(getter(ManagedWorkgroupListItem::managedWorkgroupName))
            .setter(setter(Builder::managedWorkgroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("managedWorkgroupName").build())
            .build();

    private static final SdkField<String> SOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceArn").getter(getter(ManagedWorkgroupListItem::sourceArn)).setter(setter(Builder::sourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceArn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(ManagedWorkgroupListItem::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATION_DATE_FIELD,
            MANAGED_WORKGROUP_ID_FIELD, MANAGED_WORKGROUP_NAME_FIELD, SOURCE_ARN_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Instant creationDate;

    private final String managedWorkgroupId;

    private final String managedWorkgroupName;

    private final String sourceArn;

    private final String status;

    private ManagedWorkgroupListItem(BuilderImpl builder) {
        this.creationDate = builder.creationDate;
        this.managedWorkgroupId = builder.managedWorkgroupId;
        this.managedWorkgroupName = builder.managedWorkgroupName;
        this.sourceArn = builder.sourceArn;
        this.status = builder.status;
    }

    /**
     * <p>
     * The creation date of the managed workgroup.
     * </p>
     * 
     * @return The creation date of the managed workgroup.
     */
    public final Instant creationDate() {
        return creationDate;
    }

    /**
     * <p>
     * The unique identifier of the managed workgroup.
     * </p>
     * 
     * @return The unique identifier of the managed workgroup.
     */
    public final String managedWorkgroupId() {
        return managedWorkgroupId;
    }

    /**
     * <p>
     * The name of the managed workgroup.
     * </p>
     * 
     * @return The name of the managed workgroup.
     */
    public final String managedWorkgroupName() {
        return managedWorkgroupName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the managed workgroup in the AWS Glue Data Catalog.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the managed workgroup in the AWS Glue Data Catalog.
     */
    public final String sourceArn() {
        return sourceArn;
    }

    /**
     * <p>
     * The status of the managed workgroup.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ManagedWorkgroupStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the managed workgroup.
     * @see ManagedWorkgroupStatus
     */
    public final ManagedWorkgroupStatus status() {
        return ManagedWorkgroupStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the managed workgroup.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ManagedWorkgroupStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the managed workgroup.
     * @see ManagedWorkgroupStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(managedWorkgroupId());
        hashCode = 31 * hashCode + Objects.hashCode(managedWorkgroupName());
        hashCode = 31 * hashCode + Objects.hashCode(sourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ManagedWorkgroupListItem)) {
            return false;
        }
        ManagedWorkgroupListItem other = (ManagedWorkgroupListItem) obj;
        return Objects.equals(creationDate(), other.creationDate())
                && Objects.equals(managedWorkgroupId(), other.managedWorkgroupId())
                && Objects.equals(managedWorkgroupName(), other.managedWorkgroupName())
                && Objects.equals(sourceArn(), other.sourceArn()) && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ManagedWorkgroupListItem").add("CreationDate", creationDate())
                .add("ManagedWorkgroupId", managedWorkgroupId()).add("ManagedWorkgroupName", managedWorkgroupName())
                .add("SourceArn", sourceArn()).add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "creationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        case "managedWorkgroupId":
            return Optional.ofNullable(clazz.cast(managedWorkgroupId()));
        case "managedWorkgroupName":
            return Optional.ofNullable(clazz.cast(managedWorkgroupName()));
        case "sourceArn":
            return Optional.ofNullable(clazz.cast(sourceArn()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("creationDate", CREATION_DATE_FIELD);
        map.put("managedWorkgroupId", MANAGED_WORKGROUP_ID_FIELD);
        map.put("managedWorkgroupName", MANAGED_WORKGROUP_NAME_FIELD);
        map.put("sourceArn", SOURCE_ARN_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ManagedWorkgroupListItem, T> g) {
        return obj -> g.apply((ManagedWorkgroupListItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ManagedWorkgroupListItem> {
        /**
         * <p>
         * The creation date of the managed workgroup.
         * </p>
         * 
         * @param creationDate
         *        The creation date of the managed workgroup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Instant creationDate);

        /**
         * <p>
         * The unique identifier of the managed workgroup.
         * </p>
         * 
         * @param managedWorkgroupId
         *        The unique identifier of the managed workgroup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managedWorkgroupId(String managedWorkgroupId);

        /**
         * <p>
         * The name of the managed workgroup.
         * </p>
         * 
         * @param managedWorkgroupName
         *        The name of the managed workgroup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managedWorkgroupName(String managedWorkgroupName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the managed workgroup in the AWS Glue Data Catalog.
         * </p>
         * 
         * @param sourceArn
         *        The Amazon Resource Name (ARN) for the managed workgroup in the AWS Glue Data Catalog.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceArn(String sourceArn);

        /**
         * <p>
         * The status of the managed workgroup.
         * </p>
         * 
         * @param status
         *        The status of the managed workgroup.
         * @see ManagedWorkgroupStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ManagedWorkgroupStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the managed workgroup.
         * </p>
         * 
         * @param status
         *        The status of the managed workgroup.
         * @see ManagedWorkgroupStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ManagedWorkgroupStatus
         */
        Builder status(ManagedWorkgroupStatus status);
    }

    static final class BuilderImpl implements Builder {
        private Instant creationDate;

        private String managedWorkgroupId;

        private String managedWorkgroupName;

        private String sourceArn;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(ManagedWorkgroupListItem model) {
            creationDate(model.creationDate);
            managedWorkgroupId(model.managedWorkgroupId);
            managedWorkgroupName(model.managedWorkgroupName);
            sourceArn(model.sourceArn);
            status(model.status);
        }

        public final Instant getCreationDate() {
            return creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final String getManagedWorkgroupId() {
            return managedWorkgroupId;
        }

        public final void setManagedWorkgroupId(String managedWorkgroupId) {
            this.managedWorkgroupId = managedWorkgroupId;
        }

        @Override
        public final Builder managedWorkgroupId(String managedWorkgroupId) {
            this.managedWorkgroupId = managedWorkgroupId;
            return this;
        }

        public final String getManagedWorkgroupName() {
            return managedWorkgroupName;
        }

        public final void setManagedWorkgroupName(String managedWorkgroupName) {
            this.managedWorkgroupName = managedWorkgroupName;
        }

        @Override
        public final Builder managedWorkgroupName(String managedWorkgroupName) {
            this.managedWorkgroupName = managedWorkgroupName;
            return this;
        }

        public final String getSourceArn() {
            return sourceArn;
        }

        public final void setSourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
        }

        @Override
        public final Builder sourceArn(String sourceArn) {
            this.sourceArn = sourceArn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ManagedWorkgroupStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public ManagedWorkgroupListItem build() {
            return new ManagedWorkgroupListItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
