/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshiftserverless.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RestoreFromRecoveryPointRequest extends RedshiftServerlessRequest implements
        ToCopyableBuilder<RestoreFromRecoveryPointRequest.Builder, RestoreFromRecoveryPointRequest> {
    private static final SdkField<String> NAMESPACE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("namespaceName").getter(getter(RestoreFromRecoveryPointRequest::namespaceName))
            .setter(setter(Builder::namespaceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespaceName").build()).build();

    private static final SdkField<String> RECOVERY_POINT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("recoveryPointId").getter(getter(RestoreFromRecoveryPointRequest::recoveryPointId))
            .setter(setter(Builder::recoveryPointId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recoveryPointId").build()).build();

    private static final SdkField<String> WORKGROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workgroupName").getter(getter(RestoreFromRecoveryPointRequest::workgroupName))
            .setter(setter(Builder::workgroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workgroupName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAMESPACE_NAME_FIELD,
            RECOVERY_POINT_ID_FIELD, WORKGROUP_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String namespaceName;

    private final String recoveryPointId;

    private final String workgroupName;

    private RestoreFromRecoveryPointRequest(BuilderImpl builder) {
        super(builder);
        this.namespaceName = builder.namespaceName;
        this.recoveryPointId = builder.recoveryPointId;
        this.workgroupName = builder.workgroupName;
    }

    /**
     * <p>
     * The name of the namespace to restore data into.
     * </p>
     * 
     * @return The name of the namespace to restore data into.
     */
    public final String namespaceName() {
        return namespaceName;
    }

    /**
     * <p>
     * The unique identifier of the recovery point to restore from.
     * </p>
     * 
     * @return The unique identifier of the recovery point to restore from.
     */
    public final String recoveryPointId() {
        return recoveryPointId;
    }

    /**
     * <p>
     * The name of the workgroup used to restore data.
     * </p>
     * 
     * @return The name of the workgroup used to restore data.
     */
    public final String workgroupName() {
        return workgroupName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(namespaceName());
        hashCode = 31 * hashCode + Objects.hashCode(recoveryPointId());
        hashCode = 31 * hashCode + Objects.hashCode(workgroupName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RestoreFromRecoveryPointRequest)) {
            return false;
        }
        RestoreFromRecoveryPointRequest other = (RestoreFromRecoveryPointRequest) obj;
        return Objects.equals(namespaceName(), other.namespaceName())
                && Objects.equals(recoveryPointId(), other.recoveryPointId())
                && Objects.equals(workgroupName(), other.workgroupName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RestoreFromRecoveryPointRequest").add("NamespaceName", namespaceName())
                .add("RecoveryPointId", recoveryPointId()).add("WorkgroupName", workgroupName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "namespaceName":
            return Optional.ofNullable(clazz.cast(namespaceName()));
        case "recoveryPointId":
            return Optional.ofNullable(clazz.cast(recoveryPointId()));
        case "workgroupName":
            return Optional.ofNullable(clazz.cast(workgroupName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("namespaceName", NAMESPACE_NAME_FIELD);
        map.put("recoveryPointId", RECOVERY_POINT_ID_FIELD);
        map.put("workgroupName", WORKGROUP_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RestoreFromRecoveryPointRequest, T> g) {
        return obj -> g.apply((RestoreFromRecoveryPointRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftServerlessRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, RestoreFromRecoveryPointRequest> {
        /**
         * <p>
         * The name of the namespace to restore data into.
         * </p>
         * 
         * @param namespaceName
         *        The name of the namespace to restore data into.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespaceName(String namespaceName);

        /**
         * <p>
         * The unique identifier of the recovery point to restore from.
         * </p>
         * 
         * @param recoveryPointId
         *        The unique identifier of the recovery point to restore from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recoveryPointId(String recoveryPointId);

        /**
         * <p>
         * The name of the workgroup used to restore data.
         * </p>
         * 
         * @param workgroupName
         *        The name of the workgroup used to restore data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workgroupName(String workgroupName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RedshiftServerlessRequest.BuilderImpl implements Builder {
        private String namespaceName;

        private String recoveryPointId;

        private String workgroupName;

        private BuilderImpl() {
        }

        private BuilderImpl(RestoreFromRecoveryPointRequest model) {
            super(model);
            namespaceName(model.namespaceName);
            recoveryPointId(model.recoveryPointId);
            workgroupName(model.workgroupName);
        }

        public final String getNamespaceName() {
            return namespaceName;
        }

        public final void setNamespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
        }

        @Override
        public final Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public final String getRecoveryPointId() {
            return recoveryPointId;
        }

        public final void setRecoveryPointId(String recoveryPointId) {
            this.recoveryPointId = recoveryPointId;
        }

        @Override
        public final Builder recoveryPointId(String recoveryPointId) {
            this.recoveryPointId = recoveryPointId;
            return this;
        }

        public final String getWorkgroupName() {
            return workgroupName;
        }

        public final void setWorkgroupName(String workgroupName) {
            this.workgroupName = workgroupName;
        }

        @Override
        public final Builder workgroupName(String workgroupName) {
            this.workgroupName = workgroupName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RestoreFromRecoveryPointRequest build() {
            return new RestoreFromRecoveryPointRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
