/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshiftserverless.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The schedule of when Amazon Redshift Serverless should run the scheduled action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Schedule implements SdkPojo, Serializable, ToCopyableBuilder<Schedule.Builder, Schedule> {
    private static final SdkField<Instant> AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT).memberName("at")
            .getter(getter(Schedule::at)).setter(setter(Builder::at))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("at").build()).build();

    private static final SdkField<String> CRON_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("cron")
            .getter(getter(Schedule::cron)).setter(setter(Builder::cron))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cron").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AT_FIELD, CRON_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Instant at;

    private final String cron;

    private final Type type;

    private Schedule(BuilderImpl builder) {
        this.at = builder.at;
        this.cron = builder.cron;
        this.type = builder.type;
    }

    /**
     * <p>
     * The timestamp of when Amazon Redshift Serverless should run the scheduled action. Timestamp is in UTC. Format of
     * at expression is <code>yyyy-mm-ddThh:mm:ss</code>. For example, <code>2016-03-04T17:27:00</code>.
     * </p>
     * 
     * @return The timestamp of when Amazon Redshift Serverless should run the scheduled action. Timestamp is in UTC.
     *         Format of at expression is <code>yyyy-mm-ddThh:mm:ss</code>. For example,
     *         <code>2016-03-04T17:27:00</code>.
     */
    public final Instant at() {
        return at;
    }

    /**
     * <p>
     * The cron expression to use to schedule a recurring scheduled action. Schedule invocations must be separated by at
     * least one hour. Times are in UTC.
     * </p>
     * <p>
     * Format of cron expressions is <code>(Minutes Hours Day-of-month Month Day-of-week Year)</code>. For example,
     * <code>"(0 10 ? * MON *)"</code>. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html#CronExpressions">Cron
     * Expressions</a> in the <i>Amazon CloudWatch Events User Guide</i>.
     * </p>
     * 
     * @return The cron expression to use to schedule a recurring scheduled action. Schedule invocations must be
     *         separated by at least one hour. Times are in UTC.</p>
     *         <p>
     *         Format of cron expressions is <code>(Minutes Hours Day-of-month Month Day-of-week Year)</code>. For
     *         example, <code>"(0 10 ? * MON *)"</code>. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html#CronExpressions"
     *         >Cron Expressions</a> in the <i>Amazon CloudWatch Events User Guide</i>.
     */
    public final String cron() {
        return cron;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(at());
        hashCode = 31 * hashCode + Objects.hashCode(cron());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Schedule)) {
            return false;
        }
        Schedule other = (Schedule) obj;
        return Objects.equals(at(), other.at()) && Objects.equals(cron(), other.cron());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Schedule").add("At", at()).add("Cron", cron()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "at":
            return Optional.ofNullable(clazz.cast(at()));
        case "cron":
            return Optional.ofNullable(clazz.cast(cron()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #at()} initialized to the given value.
     *
     * <p>
     * The timestamp of when Amazon Redshift Serverless should run the scheduled action. Timestamp is in UTC. Format of
     * at expression is <code>yyyy-mm-ddThh:mm:ss</code>. For example, <code>2016-03-04T17:27:00</code>.
     * </p>
     * 
     * @param at
     *        The timestamp of when Amazon Redshift Serverless should run the scheduled action. Timestamp is in UTC.
     *        Format of at expression is <code>yyyy-mm-ddThh:mm:ss</code>. For example, <code>2016-03-04T17:27:00</code>
     *        .
     */
    public static Schedule fromAt(Instant at) {
        return builder().at(at).build();
    }

    /**
     * Create an instance of this class with {@link #cron()} initialized to the given value.
     *
     * <p>
     * The cron expression to use to schedule a recurring scheduled action. Schedule invocations must be separated by at
     * least one hour. Times are in UTC.
     * </p>
     * <p>
     * Format of cron expressions is <code>(Minutes Hours Day-of-month Month Day-of-week Year)</code>. For example,
     * <code>"(0 10 ? * MON *)"</code>. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html#CronExpressions">Cron
     * Expressions</a> in the <i>Amazon CloudWatch Events User Guide</i>.
     * </p>
     * 
     * @param cron
     *        The cron expression to use to schedule a recurring scheduled action. Schedule invocations must be
     *        separated by at least one hour. Times are in UTC.</p>
     *        <p>
     *        Format of cron expressions is <code>(Minutes Hours Day-of-month Month Day-of-week Year)</code>. For
     *        example, <code>"(0 10 ? * MON *)"</code>. For more information, see <a
     *        href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html#CronExpressions"
     *        >Cron Expressions</a> in the <i>Amazon CloudWatch Events User Guide</i>.
     */
    public static Schedule fromCron(String cron) {
        return builder().cron(cron).build();
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("at", AT_FIELD);
        map.put("cron", CRON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Schedule, T> g) {
        return obj -> g.apply((Schedule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Schedule> {
        /**
         * <p>
         * The timestamp of when Amazon Redshift Serverless should run the scheduled action. Timestamp is in UTC. Format
         * of at expression is <code>yyyy-mm-ddThh:mm:ss</code>. For example, <code>2016-03-04T17:27:00</code>.
         * </p>
         * 
         * @param at
         *        The timestamp of when Amazon Redshift Serverless should run the scheduled action. Timestamp is in UTC.
         *        Format of at expression is <code>yyyy-mm-ddThh:mm:ss</code>. For example,
         *        <code>2016-03-04T17:27:00</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder at(Instant at);

        /**
         * <p>
         * The cron expression to use to schedule a recurring scheduled action. Schedule invocations must be separated
         * by at least one hour. Times are in UTC.
         * </p>
         * <p>
         * Format of cron expressions is <code>(Minutes Hours Day-of-month Month Day-of-week Year)</code>. For example,
         * <code>"(0 10 ? * MON *)"</code>. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html#CronExpressions">Cron
         * Expressions</a> in the <i>Amazon CloudWatch Events User Guide</i>.
         * </p>
         * 
         * @param cron
         *        The cron expression to use to schedule a recurring scheduled action. Schedule invocations must be
         *        separated by at least one hour. Times are in UTC.</p>
         *        <p>
         *        Format of cron expressions is <code>(Minutes Hours Day-of-month Month Day-of-week Year)</code>. For
         *        example, <code>"(0 10 ? * MON *)"</code>. For more information, see <a
         *        href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html#CronExpressions"
         *        >Cron Expressions</a> in the <i>Amazon CloudWatch Events User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cron(String cron);
    }

    static final class BuilderImpl implements Builder {
        private Instant at;

        private String cron;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(Schedule model) {
            at(model.at);
            cron(model.cron);
        }

        public final Instant getAt() {
            return at;
        }

        public final void setAt(Instant at) {
            Object oldValue = this.at;
            this.at = at;
            handleUnionValueChange(Type.AT, oldValue, this.at);
        }

        @Override
        public final Builder at(Instant at) {
            Object oldValue = this.at;
            this.at = at;
            handleUnionValueChange(Type.AT, oldValue, this.at);
            return this;
        }

        public final String getCron() {
            return cron;
        }

        public final void setCron(String cron) {
            Object oldValue = this.cron;
            this.cron = cron;
            handleUnionValueChange(Type.CRON, oldValue, this.cron);
        }

        @Override
        public final Builder cron(String cron) {
            Object oldValue = this.cron;
            this.cron = cron;
            handleUnionValueChange(Type.CRON, oldValue, this.cron);
            return this;
        }

        @Override
        public Schedule build() {
            return new Schedule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see Schedule#type()
     */
    public enum Type {
        AT,

        CRON,

        UNKNOWN_TO_SDK_VERSION
    }
}
