/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshiftserverless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The object that you configure to copy snapshots from one namespace to a namespace in another Amazon Web Services
 * Region.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SnapshotCopyConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<SnapshotCopyConfiguration.Builder, SnapshotCopyConfiguration> {
    private static final SdkField<String> DESTINATION_KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("destinationKmsKeyId").getter(getter(SnapshotCopyConfiguration::destinationKmsKeyId))
            .setter(setter(Builder::destinationKmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationKmsKeyId").build())
            .build();

    private static final SdkField<String> DESTINATION_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("destinationRegion").getter(getter(SnapshotCopyConfiguration::destinationRegion))
            .setter(setter(Builder::destinationRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationRegion").build()).build();

    private static final SdkField<String> NAMESPACE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("namespaceName").getter(getter(SnapshotCopyConfiguration::namespaceName))
            .setter(setter(Builder::namespaceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespaceName").build()).build();

    private static final SdkField<String> SNAPSHOT_COPY_CONFIGURATION_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("snapshotCopyConfigurationArn")
            .getter(getter(SnapshotCopyConfiguration::snapshotCopyConfigurationArn))
            .setter(setter(Builder::snapshotCopyConfigurationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("snapshotCopyConfigurationArn")
                    .build()).build();

    private static final SdkField<String> SNAPSHOT_COPY_CONFIGURATION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("snapshotCopyConfigurationId")
            .getter(getter(SnapshotCopyConfiguration::snapshotCopyConfigurationId))
            .setter(setter(Builder::snapshotCopyConfigurationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("snapshotCopyConfigurationId")
                    .build()).build();

    private static final SdkField<Integer> SNAPSHOT_RETENTION_PERIOD_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("snapshotRetentionPeriod").getter(getter(SnapshotCopyConfiguration::snapshotRetentionPeriod))
            .setter(setter(Builder::snapshotRetentionPeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("snapshotRetentionPeriod").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_KMS_KEY_ID_FIELD,
            DESTINATION_REGION_FIELD, NAMESPACE_NAME_FIELD, SNAPSHOT_COPY_CONFIGURATION_ARN_FIELD,
            SNAPSHOT_COPY_CONFIGURATION_ID_FIELD, SNAPSHOT_RETENTION_PERIOD_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String destinationKmsKeyId;

    private final String destinationRegion;

    private final String namespaceName;

    private final String snapshotCopyConfigurationArn;

    private final String snapshotCopyConfigurationId;

    private final Integer snapshotRetentionPeriod;

    private SnapshotCopyConfiguration(BuilderImpl builder) {
        this.destinationKmsKeyId = builder.destinationKmsKeyId;
        this.destinationRegion = builder.destinationRegion;
        this.namespaceName = builder.namespaceName;
        this.snapshotCopyConfigurationArn = builder.snapshotCopyConfigurationArn;
        this.snapshotCopyConfigurationId = builder.snapshotCopyConfigurationId;
        this.snapshotRetentionPeriod = builder.snapshotRetentionPeriod;
    }

    /**
     * <p>
     * The ID of the KMS key to use to encrypt your snapshots in the destination Amazon Web Services Region.
     * </p>
     * 
     * @return The ID of the KMS key to use to encrypt your snapshots in the destination Amazon Web Services Region.
     */
    public final String destinationKmsKeyId() {
        return destinationKmsKeyId;
    }

    /**
     * <p>
     * The destination Amazon Web Services Region to copy snapshots to.
     * </p>
     * 
     * @return The destination Amazon Web Services Region to copy snapshots to.
     */
    public final String destinationRegion() {
        return destinationRegion;
    }

    /**
     * <p>
     * The name of the namespace to copy snapshots from in the source Amazon Web Services Region.
     * </p>
     * 
     * @return The name of the namespace to copy snapshots from in the source Amazon Web Services Region.
     */
    public final String namespaceName() {
        return namespaceName;
    }

    /**
     * <p>
     * The ARN of the snapshot copy configuration object.
     * </p>
     * 
     * @return The ARN of the snapshot copy configuration object.
     */
    public final String snapshotCopyConfigurationArn() {
        return snapshotCopyConfigurationArn;
    }

    /**
     * <p>
     * The ID of the snapshot copy configuration object.
     * </p>
     * 
     * @return The ID of the snapshot copy configuration object.
     */
    public final String snapshotCopyConfigurationId() {
        return snapshotCopyConfigurationId;
    }

    /**
     * <p>
     * The retention period of snapshots that are copied to the destination Amazon Web Services Region.
     * </p>
     * 
     * @return The retention period of snapshots that are copied to the destination Amazon Web Services Region.
     */
    public final Integer snapshotRetentionPeriod() {
        return snapshotRetentionPeriod;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(destinationKmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(destinationRegion());
        hashCode = 31 * hashCode + Objects.hashCode(namespaceName());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotCopyConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotCopyConfigurationId());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotRetentionPeriod());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SnapshotCopyConfiguration)) {
            return false;
        }
        SnapshotCopyConfiguration other = (SnapshotCopyConfiguration) obj;
        return Objects.equals(destinationKmsKeyId(), other.destinationKmsKeyId())
                && Objects.equals(destinationRegion(), other.destinationRegion())
                && Objects.equals(namespaceName(), other.namespaceName())
                && Objects.equals(snapshotCopyConfigurationArn(), other.snapshotCopyConfigurationArn())
                && Objects.equals(snapshotCopyConfigurationId(), other.snapshotCopyConfigurationId())
                && Objects.equals(snapshotRetentionPeriod(), other.snapshotRetentionPeriod());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SnapshotCopyConfiguration").add("DestinationKmsKeyId", destinationKmsKeyId())
                .add("DestinationRegion", destinationRegion()).add("NamespaceName", namespaceName())
                .add("SnapshotCopyConfigurationArn", snapshotCopyConfigurationArn())
                .add("SnapshotCopyConfigurationId", snapshotCopyConfigurationId())
                .add("SnapshotRetentionPeriod", snapshotRetentionPeriod()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "destinationKmsKeyId":
            return Optional.ofNullable(clazz.cast(destinationKmsKeyId()));
        case "destinationRegion":
            return Optional.ofNullable(clazz.cast(destinationRegion()));
        case "namespaceName":
            return Optional.ofNullable(clazz.cast(namespaceName()));
        case "snapshotCopyConfigurationArn":
            return Optional.ofNullable(clazz.cast(snapshotCopyConfigurationArn()));
        case "snapshotCopyConfigurationId":
            return Optional.ofNullable(clazz.cast(snapshotCopyConfigurationId()));
        case "snapshotRetentionPeriod":
            return Optional.ofNullable(clazz.cast(snapshotRetentionPeriod()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("destinationKmsKeyId", DESTINATION_KMS_KEY_ID_FIELD);
        map.put("destinationRegion", DESTINATION_REGION_FIELD);
        map.put("namespaceName", NAMESPACE_NAME_FIELD);
        map.put("snapshotCopyConfigurationArn", SNAPSHOT_COPY_CONFIGURATION_ARN_FIELD);
        map.put("snapshotCopyConfigurationId", SNAPSHOT_COPY_CONFIGURATION_ID_FIELD);
        map.put("snapshotRetentionPeriod", SNAPSHOT_RETENTION_PERIOD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SnapshotCopyConfiguration, T> g) {
        return obj -> g.apply((SnapshotCopyConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SnapshotCopyConfiguration> {
        /**
         * <p>
         * The ID of the KMS key to use to encrypt your snapshots in the destination Amazon Web Services Region.
         * </p>
         * 
         * @param destinationKmsKeyId
         *        The ID of the KMS key to use to encrypt your snapshots in the destination Amazon Web Services Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationKmsKeyId(String destinationKmsKeyId);

        /**
         * <p>
         * The destination Amazon Web Services Region to copy snapshots to.
         * </p>
         * 
         * @param destinationRegion
         *        The destination Amazon Web Services Region to copy snapshots to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationRegion(String destinationRegion);

        /**
         * <p>
         * The name of the namespace to copy snapshots from in the source Amazon Web Services Region.
         * </p>
         * 
         * @param namespaceName
         *        The name of the namespace to copy snapshots from in the source Amazon Web Services Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespaceName(String namespaceName);

        /**
         * <p>
         * The ARN of the snapshot copy configuration object.
         * </p>
         * 
         * @param snapshotCopyConfigurationArn
         *        The ARN of the snapshot copy configuration object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotCopyConfigurationArn(String snapshotCopyConfigurationArn);

        /**
         * <p>
         * The ID of the snapshot copy configuration object.
         * </p>
         * 
         * @param snapshotCopyConfigurationId
         *        The ID of the snapshot copy configuration object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotCopyConfigurationId(String snapshotCopyConfigurationId);

        /**
         * <p>
         * The retention period of snapshots that are copied to the destination Amazon Web Services Region.
         * </p>
         * 
         * @param snapshotRetentionPeriod
         *        The retention period of snapshots that are copied to the destination Amazon Web Services Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotRetentionPeriod(Integer snapshotRetentionPeriod);
    }

    static final class BuilderImpl implements Builder {
        private String destinationKmsKeyId;

        private String destinationRegion;

        private String namespaceName;

        private String snapshotCopyConfigurationArn;

        private String snapshotCopyConfigurationId;

        private Integer snapshotRetentionPeriod;

        private BuilderImpl() {
        }

        private BuilderImpl(SnapshotCopyConfiguration model) {
            destinationKmsKeyId(model.destinationKmsKeyId);
            destinationRegion(model.destinationRegion);
            namespaceName(model.namespaceName);
            snapshotCopyConfigurationArn(model.snapshotCopyConfigurationArn);
            snapshotCopyConfigurationId(model.snapshotCopyConfigurationId);
            snapshotRetentionPeriod(model.snapshotRetentionPeriod);
        }

        public final String getDestinationKmsKeyId() {
            return destinationKmsKeyId;
        }

        public final void setDestinationKmsKeyId(String destinationKmsKeyId) {
            this.destinationKmsKeyId = destinationKmsKeyId;
        }

        @Override
        public final Builder destinationKmsKeyId(String destinationKmsKeyId) {
            this.destinationKmsKeyId = destinationKmsKeyId;
            return this;
        }

        public final String getDestinationRegion() {
            return destinationRegion;
        }

        public final void setDestinationRegion(String destinationRegion) {
            this.destinationRegion = destinationRegion;
        }

        @Override
        public final Builder destinationRegion(String destinationRegion) {
            this.destinationRegion = destinationRegion;
            return this;
        }

        public final String getNamespaceName() {
            return namespaceName;
        }

        public final void setNamespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
        }

        @Override
        public final Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public final String getSnapshotCopyConfigurationArn() {
            return snapshotCopyConfigurationArn;
        }

        public final void setSnapshotCopyConfigurationArn(String snapshotCopyConfigurationArn) {
            this.snapshotCopyConfigurationArn = snapshotCopyConfigurationArn;
        }

        @Override
        public final Builder snapshotCopyConfigurationArn(String snapshotCopyConfigurationArn) {
            this.snapshotCopyConfigurationArn = snapshotCopyConfigurationArn;
            return this;
        }

        public final String getSnapshotCopyConfigurationId() {
            return snapshotCopyConfigurationId;
        }

        public final void setSnapshotCopyConfigurationId(String snapshotCopyConfigurationId) {
            this.snapshotCopyConfigurationId = snapshotCopyConfigurationId;
        }

        @Override
        public final Builder snapshotCopyConfigurationId(String snapshotCopyConfigurationId) {
            this.snapshotCopyConfigurationId = snapshotCopyConfigurationId;
            return this;
        }

        public final Integer getSnapshotRetentionPeriod() {
            return snapshotRetentionPeriod;
        }

        public final void setSnapshotRetentionPeriod(Integer snapshotRetentionPeriod) {
            this.snapshotRetentionPeriod = snapshotRetentionPeriod;
        }

        @Override
        public final Builder snapshotRetentionPeriod(Integer snapshotRetentionPeriod) {
            this.snapshotRetentionPeriod = snapshotRetentionPeriod;
            return this;
        }

        @Override
        public SnapshotCopyConfiguration build() {
            return new SnapshotCopyConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
