/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshiftserverless.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateSnapshotCopyConfigurationResponse extends RedshiftServerlessResponse implements
        ToCopyableBuilder<UpdateSnapshotCopyConfigurationResponse.Builder, UpdateSnapshotCopyConfigurationResponse> {
    private static final SdkField<SnapshotCopyConfiguration> SNAPSHOT_COPY_CONFIGURATION_FIELD = SdkField
            .<SnapshotCopyConfiguration> builder(MarshallingType.SDK_POJO).memberName("snapshotCopyConfiguration")
            .getter(getter(UpdateSnapshotCopyConfigurationResponse::snapshotCopyConfiguration))
            .setter(setter(Builder::snapshotCopyConfiguration)).constructor(SnapshotCopyConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("snapshotCopyConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(SNAPSHOT_COPY_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final SnapshotCopyConfiguration snapshotCopyConfiguration;

    private UpdateSnapshotCopyConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.snapshotCopyConfiguration = builder.snapshotCopyConfiguration;
    }

    /**
     * <p>
     * The updated snapshot copy configuration object.
     * </p>
     * 
     * @return The updated snapshot copy configuration object.
     */
    public final SnapshotCopyConfiguration snapshotCopyConfiguration() {
        return snapshotCopyConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(snapshotCopyConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSnapshotCopyConfigurationResponse)) {
            return false;
        }
        UpdateSnapshotCopyConfigurationResponse other = (UpdateSnapshotCopyConfigurationResponse) obj;
        return Objects.equals(snapshotCopyConfiguration(), other.snapshotCopyConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateSnapshotCopyConfigurationResponse")
                .add("SnapshotCopyConfiguration", snapshotCopyConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "snapshotCopyConfiguration":
            return Optional.ofNullable(clazz.cast(snapshotCopyConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("snapshotCopyConfiguration", SNAPSHOT_COPY_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateSnapshotCopyConfigurationResponse, T> g) {
        return obj -> g.apply((UpdateSnapshotCopyConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftServerlessResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateSnapshotCopyConfigurationResponse> {
        /**
         * <p>
         * The updated snapshot copy configuration object.
         * </p>
         * 
         * @param snapshotCopyConfiguration
         *        The updated snapshot copy configuration object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotCopyConfiguration(SnapshotCopyConfiguration snapshotCopyConfiguration);

        /**
         * <p>
         * The updated snapshot copy configuration object.
         * </p>
         * This is a convenience method that creates an instance of the {@link SnapshotCopyConfiguration.Builder}
         * avoiding the need to create one manually via {@link SnapshotCopyConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SnapshotCopyConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #snapshotCopyConfiguration(SnapshotCopyConfiguration)}.
         * 
         * @param snapshotCopyConfiguration
         *        a consumer that will call methods on {@link SnapshotCopyConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #snapshotCopyConfiguration(SnapshotCopyConfiguration)
         */
        default Builder snapshotCopyConfiguration(Consumer<SnapshotCopyConfiguration.Builder> snapshotCopyConfiguration) {
            return snapshotCopyConfiguration(SnapshotCopyConfiguration.builder().applyMutation(snapshotCopyConfiguration).build());
        }
    }

    static final class BuilderImpl extends RedshiftServerlessResponse.BuilderImpl implements Builder {
        private SnapshotCopyConfiguration snapshotCopyConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSnapshotCopyConfigurationResponse model) {
            super(model);
            snapshotCopyConfiguration(model.snapshotCopyConfiguration);
        }

        public final SnapshotCopyConfiguration.Builder getSnapshotCopyConfiguration() {
            return snapshotCopyConfiguration != null ? snapshotCopyConfiguration.toBuilder() : null;
        }

        public final void setSnapshotCopyConfiguration(SnapshotCopyConfiguration.BuilderImpl snapshotCopyConfiguration) {
            this.snapshotCopyConfiguration = snapshotCopyConfiguration != null ? snapshotCopyConfiguration.build() : null;
        }

        @Override
        public final Builder snapshotCopyConfiguration(SnapshotCopyConfiguration snapshotCopyConfiguration) {
            this.snapshotCopyConfiguration = snapshotCopyConfiguration;
            return this;
        }

        @Override
        public UpdateSnapshotCopyConfigurationResponse build() {
            return new UpdateSnapshotCopyConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
