/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshiftserverless.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListCustomDomainAssociationsResponse extends RedshiftServerlessResponse implements
        ToCopyableBuilder<ListCustomDomainAssociationsResponse.Builder, ListCustomDomainAssociationsResponse> {
    private static final SdkField<List<Association>> ASSOCIATIONS_FIELD = SdkField
            .<List<Association>> builder(MarshallingType.LIST)
            .memberName("associations")
            .getter(getter(ListCustomDomainAssociationsResponse::associations))
            .setter(setter(Builder::associations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Association> builder(MarshallingType.SDK_POJO)
                                            .constructor(Association::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListCustomDomainAssociationsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATIONS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<Association> associations;

    private final String nextToken;

    private ListCustomDomainAssociationsResponse(BuilderImpl builder) {
        super(builder);
        this.associations = builder.associations;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Associations property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAssociations() {
        return associations != null && !(associations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of Association objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAssociations} method.
     * </p>
     * 
     * @return A list of Association objects.
     */
    public final List<Association> associations() {
        return associations;
    }

    /**
     * <p>
     * When <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is
     * a unique pagination token for each page. Make the call again using the returned token to retrieve the next page.
     * </p>
     * 
     * @return When <code>nextToken</code> is returned, there are more results available. The value of
     *         <code>nextToken</code> is a unique pagination token for each page. Make the call again using the returned
     *         token to retrieve the next page.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAssociations() ? associations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCustomDomainAssociationsResponse)) {
            return false;
        }
        ListCustomDomainAssociationsResponse other = (ListCustomDomainAssociationsResponse) obj;
        return hasAssociations() == other.hasAssociations() && Objects.equals(associations(), other.associations())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListCustomDomainAssociationsResponse")
                .add("Associations", hasAssociations() ? associations() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "associations":
            return Optional.ofNullable(clazz.cast(associations()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("associations", ASSOCIATIONS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListCustomDomainAssociationsResponse, T> g) {
        return obj -> g.apply((ListCustomDomainAssociationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftServerlessResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListCustomDomainAssociationsResponse> {
        /**
         * <p>
         * A list of Association objects.
         * </p>
         * 
         * @param associations
         *        A list of Association objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associations(Collection<Association> associations);

        /**
         * <p>
         * A list of Association objects.
         * </p>
         * 
         * @param associations
         *        A list of Association objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associations(Association... associations);

        /**
         * <p>
         * A list of Association objects.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.redshiftserverless.model.Association.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.redshiftserverless.model.Association#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.redshiftserverless.model.Association.Builder#build()} is called
         * immediately and its result is passed to {@link #associations(List<Association>)}.
         * 
         * @param associations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.redshiftserverless.model.Association.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #associations(java.util.Collection<Association>)
         */
        Builder associations(Consumer<Association.Builder>... associations);

        /**
         * <p>
         * When <code>nextToken</code> is returned, there are more results available. The value of
         * <code>nextToken</code> is a unique pagination token for each page. Make the call again using the returned
         * token to retrieve the next page.
         * </p>
         * 
         * @param nextToken
         *        When <code>nextToken</code> is returned, there are more results available. The value of
         *        <code>nextToken</code> is a unique pagination token for each page. Make the call again using the
         *        returned token to retrieve the next page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends RedshiftServerlessResponse.BuilderImpl implements Builder {
        private List<Association> associations = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCustomDomainAssociationsResponse model) {
            super(model);
            associations(model.associations);
            nextToken(model.nextToken);
        }

        public final List<Association.Builder> getAssociations() {
            List<Association.Builder> result = AssociationListCopier.copyToBuilder(this.associations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssociations(Collection<Association.BuilderImpl> associations) {
            this.associations = AssociationListCopier.copyFromBuilder(associations);
        }

        @Override
        public final Builder associations(Collection<Association> associations) {
            this.associations = AssociationListCopier.copy(associations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associations(Association... associations) {
            associations(Arrays.asList(associations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associations(Consumer<Association.Builder>... associations) {
            associations(Stream.of(associations).map(c -> Association.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListCustomDomainAssociationsResponse build() {
            return new ListCustomDomainAssociationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
