/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshiftserverless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains names of objects associated with a scheduled action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ScheduledActionAssociation implements SdkPojo, Serializable,
        ToCopyableBuilder<ScheduledActionAssociation.Builder, ScheduledActionAssociation> {
    private static final SdkField<String> NAMESPACE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("namespaceName").getter(getter(ScheduledActionAssociation::namespaceName))
            .setter(setter(Builder::namespaceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespaceName").build()).build();

    private static final SdkField<String> SCHEDULED_ACTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("scheduledActionName").getter(getter(ScheduledActionAssociation::scheduledActionName))
            .setter(setter(Builder::scheduledActionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scheduledActionName").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAMESPACE_NAME_FIELD,
            SCHEDULED_ACTION_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String namespaceName;

    private final String scheduledActionName;

    private ScheduledActionAssociation(BuilderImpl builder) {
        this.namespaceName = builder.namespaceName;
        this.scheduledActionName = builder.scheduledActionName;
    }

    /**
     * <p>
     * Name of associated Amazon Redshift Serverless namespace.
     * </p>
     * 
     * @return Name of associated Amazon Redshift Serverless namespace.
     */
    public final String namespaceName() {
        return namespaceName;
    }

    /**
     * <p>
     * Name of associated scheduled action.
     * </p>
     * 
     * @return Name of associated scheduled action.
     */
    public final String scheduledActionName() {
        return scheduledActionName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(namespaceName());
        hashCode = 31 * hashCode + Objects.hashCode(scheduledActionName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScheduledActionAssociation)) {
            return false;
        }
        ScheduledActionAssociation other = (ScheduledActionAssociation) obj;
        return Objects.equals(namespaceName(), other.namespaceName())
                && Objects.equals(scheduledActionName(), other.scheduledActionName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ScheduledActionAssociation").add("NamespaceName", namespaceName())
                .add("ScheduledActionName", scheduledActionName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "namespaceName":
            return Optional.ofNullable(clazz.cast(namespaceName()));
        case "scheduledActionName":
            return Optional.ofNullable(clazz.cast(scheduledActionName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("namespaceName", NAMESPACE_NAME_FIELD);
        map.put("scheduledActionName", SCHEDULED_ACTION_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ScheduledActionAssociation, T> g) {
        return obj -> g.apply((ScheduledActionAssociation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ScheduledActionAssociation> {
        /**
         * <p>
         * Name of associated Amazon Redshift Serverless namespace.
         * </p>
         * 
         * @param namespaceName
         *        Name of associated Amazon Redshift Serverless namespace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespaceName(String namespaceName);

        /**
         * <p>
         * Name of associated scheduled action.
         * </p>
         * 
         * @param scheduledActionName
         *        Name of associated scheduled action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduledActionName(String scheduledActionName);
    }

    static final class BuilderImpl implements Builder {
        private String namespaceName;

        private String scheduledActionName;

        private BuilderImpl() {
        }

        private BuilderImpl(ScheduledActionAssociation model) {
            namespaceName(model.namespaceName);
            scheduledActionName(model.scheduledActionName);
        }

        public final String getNamespaceName() {
            return namespaceName;
        }

        public final void setNamespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
        }

        @Override
        public final Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public final String getScheduledActionName() {
            return scheduledActionName;
        }

        public final void setScheduledActionName(String scheduledActionName) {
            this.scheduledActionName = scheduledActionName;
        }

        @Override
        public final Builder scheduledActionName(String scheduledActionName) {
            this.scheduledActionName = scheduledActionName;
            return this;
        }

        @Override
        public ScheduledActionAssociation build() {
            return new ScheduledActionAssociation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
