/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshiftserverless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The usage limit object.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UsageLimit implements SdkPojo, Serializable, ToCopyableBuilder<UsageLimit.Builder, UsageLimit> {
    private static final SdkField<Long> AMOUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("amount")
            .getter(getter(UsageLimit::amount)).setter(setter(Builder::amount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("amount").build()).build();

    private static final SdkField<String> BREACH_ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("breachAction").getter(getter(UsageLimit::breachActionAsString)).setter(setter(Builder::breachAction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("breachAction").build()).build();

    private static final SdkField<String> PERIOD_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("period")
            .getter(getter(UsageLimit::periodAsString)).setter(setter(Builder::period))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("period").build()).build();

    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceArn").getter(getter(UsageLimit::resourceArn)).setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceArn").build()).build();

    private static final SdkField<String> USAGE_LIMIT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("usageLimitArn").getter(getter(UsageLimit::usageLimitArn)).setter(setter(Builder::usageLimitArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usageLimitArn").build()).build();

    private static final SdkField<String> USAGE_LIMIT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("usageLimitId").getter(getter(UsageLimit::usageLimitId)).setter(setter(Builder::usageLimitId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usageLimitId").build()).build();

    private static final SdkField<String> USAGE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("usageType").getter(getter(UsageLimit::usageTypeAsString)).setter(setter(Builder::usageType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usageType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(AMOUNT_FIELD, BREACH_ACTION_FIELD, PERIOD_FIELD, RESOURCE_ARN_FIELD,
                    USAGE_LIMIT_ARN_FIELD, USAGE_LIMIT_ID_FIELD, USAGE_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Long amount;

    private final String breachAction;

    private final String period;

    private final String resourceArn;

    private final String usageLimitArn;

    private final String usageLimitId;

    private final String usageType;

    private UsageLimit(BuilderImpl builder) {
        this.amount = builder.amount;
        this.breachAction = builder.breachAction;
        this.period = builder.period;
        this.resourceArn = builder.resourceArn;
        this.usageLimitArn = builder.usageLimitArn;
        this.usageLimitId = builder.usageLimitId;
        this.usageType = builder.usageType;
    }

    /**
     * <p>
     * The limit amount. If time-based, this amount is in RPUs consumed per hour. If data-based, this amount is in
     * terabytes (TB). The value must be a positive number.
     * </p>
     * 
     * @return The limit amount. If time-based, this amount is in RPUs consumed per hour. If data-based, this amount is
     *         in terabytes (TB). The value must be a positive number.
     */
    public final Long amount() {
        return amount;
    }

    /**
     * <p>
     * The action that Amazon Redshift Serverless takes when the limit is reached.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #breachAction} will
     * return {@link UsageLimitBreachAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #breachActionAsString}.
     * </p>
     * 
     * @return The action that Amazon Redshift Serverless takes when the limit is reached.
     * @see UsageLimitBreachAction
     */
    public final UsageLimitBreachAction breachAction() {
        return UsageLimitBreachAction.fromValue(breachAction);
    }

    /**
     * <p>
     * The action that Amazon Redshift Serverless takes when the limit is reached.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #breachAction} will
     * return {@link UsageLimitBreachAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #breachActionAsString}.
     * </p>
     * 
     * @return The action that Amazon Redshift Serverless takes when the limit is reached.
     * @see UsageLimitBreachAction
     */
    public final String breachActionAsString() {
        return breachAction;
    }

    /**
     * <p>
     * The time period that the amount applies to. A weekly period begins on Sunday. The default is monthly.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #period} will
     * return {@link UsageLimitPeriod#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #periodAsString}.
     * </p>
     * 
     * @return The time period that the amount applies to. A weekly period begins on Sunday. The default is monthly.
     * @see UsageLimitPeriod
     */
    public final UsageLimitPeriod period() {
        return UsageLimitPeriod.fromValue(period);
    }

    /**
     * <p>
     * The time period that the amount applies to. A weekly period begins on Sunday. The default is monthly.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #period} will
     * return {@link UsageLimitPeriod#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #periodAsString}.
     * </p>
     * 
     * @return The time period that the amount applies to. A weekly period begins on Sunday. The default is monthly.
     * @see UsageLimitPeriod
     */
    public final String periodAsString() {
        return period;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that identifies the Amazon Redshift Serverless resource.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) that identifies the Amazon Redshift Serverless resource.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the resource associated with the usage limit.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the resource associated with the usage limit.
     */
    public final String usageLimitArn() {
        return usageLimitArn;
    }

    /**
     * <p>
     * The identifier of the usage limit.
     * </p>
     * 
     * @return The identifier of the usage limit.
     */
    public final String usageLimitId() {
        return usageLimitId;
    }

    /**
     * <p>
     * The Amazon Redshift Serverless feature to limit.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #usageType} will
     * return {@link UsageLimitUsageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #usageTypeAsString}.
     * </p>
     * 
     * @return The Amazon Redshift Serverless feature to limit.
     * @see UsageLimitUsageType
     */
    public final UsageLimitUsageType usageType() {
        return UsageLimitUsageType.fromValue(usageType);
    }

    /**
     * <p>
     * The Amazon Redshift Serverless feature to limit.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #usageType} will
     * return {@link UsageLimitUsageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #usageTypeAsString}.
     * </p>
     * 
     * @return The Amazon Redshift Serverless feature to limit.
     * @see UsageLimitUsageType
     */
    public final String usageTypeAsString() {
        return usageType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(amount());
        hashCode = 31 * hashCode + Objects.hashCode(breachActionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(periodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(usageLimitArn());
        hashCode = 31 * hashCode + Objects.hashCode(usageLimitId());
        hashCode = 31 * hashCode + Objects.hashCode(usageTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UsageLimit)) {
            return false;
        }
        UsageLimit other = (UsageLimit) obj;
        return Objects.equals(amount(), other.amount()) && Objects.equals(breachActionAsString(), other.breachActionAsString())
                && Objects.equals(periodAsString(), other.periodAsString()) && Objects.equals(resourceArn(), other.resourceArn())
                && Objects.equals(usageLimitArn(), other.usageLimitArn()) && Objects.equals(usageLimitId(), other.usageLimitId())
                && Objects.equals(usageTypeAsString(), other.usageTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UsageLimit").add("Amount", amount()).add("BreachAction", breachActionAsString())
                .add("Period", periodAsString()).add("ResourceArn", resourceArn()).add("UsageLimitArn", usageLimitArn())
                .add("UsageLimitId", usageLimitId()).add("UsageType", usageTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "amount":
            return Optional.ofNullable(clazz.cast(amount()));
        case "breachAction":
            return Optional.ofNullable(clazz.cast(breachActionAsString()));
        case "period":
            return Optional.ofNullable(clazz.cast(periodAsString()));
        case "resourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "usageLimitArn":
            return Optional.ofNullable(clazz.cast(usageLimitArn()));
        case "usageLimitId":
            return Optional.ofNullable(clazz.cast(usageLimitId()));
        case "usageType":
            return Optional.ofNullable(clazz.cast(usageTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("amount", AMOUNT_FIELD);
        map.put("breachAction", BREACH_ACTION_FIELD);
        map.put("period", PERIOD_FIELD);
        map.put("resourceArn", RESOURCE_ARN_FIELD);
        map.put("usageLimitArn", USAGE_LIMIT_ARN_FIELD);
        map.put("usageLimitId", USAGE_LIMIT_ID_FIELD);
        map.put("usageType", USAGE_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UsageLimit, T> g) {
        return obj -> g.apply((UsageLimit) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UsageLimit> {
        /**
         * <p>
         * The limit amount. If time-based, this amount is in RPUs consumed per hour. If data-based, this amount is in
         * terabytes (TB). The value must be a positive number.
         * </p>
         * 
         * @param amount
         *        The limit amount. If time-based, this amount is in RPUs consumed per hour. If data-based, this amount
         *        is in terabytes (TB). The value must be a positive number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amount(Long amount);

        /**
         * <p>
         * The action that Amazon Redshift Serverless takes when the limit is reached.
         * </p>
         * 
         * @param breachAction
         *        The action that Amazon Redshift Serverless takes when the limit is reached.
         * @see UsageLimitBreachAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UsageLimitBreachAction
         */
        Builder breachAction(String breachAction);

        /**
         * <p>
         * The action that Amazon Redshift Serverless takes when the limit is reached.
         * </p>
         * 
         * @param breachAction
         *        The action that Amazon Redshift Serverless takes when the limit is reached.
         * @see UsageLimitBreachAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UsageLimitBreachAction
         */
        Builder breachAction(UsageLimitBreachAction breachAction);

        /**
         * <p>
         * The time period that the amount applies to. A weekly period begins on Sunday. The default is monthly.
         * </p>
         * 
         * @param period
         *        The time period that the amount applies to. A weekly period begins on Sunday. The default is monthly.
         * @see UsageLimitPeriod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UsageLimitPeriod
         */
        Builder period(String period);

        /**
         * <p>
         * The time period that the amount applies to. A weekly period begins on Sunday. The default is monthly.
         * </p>
         * 
         * @param period
         *        The time period that the amount applies to. A weekly period begins on Sunday. The default is monthly.
         * @see UsageLimitPeriod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UsageLimitPeriod
         */
        Builder period(UsageLimitPeriod period);

        /**
         * <p>
         * The Amazon Resource Name (ARN) that identifies the Amazon Redshift Serverless resource.
         * </p>
         * 
         * @param resourceArn
         *        The Amazon Resource Name (ARN) that identifies the Amazon Redshift Serverless resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the resource associated with the usage limit.
         * </p>
         * 
         * @param usageLimitArn
         *        The Amazon Resource Name (ARN) of the resource associated with the usage limit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usageLimitArn(String usageLimitArn);

        /**
         * <p>
         * The identifier of the usage limit.
         * </p>
         * 
         * @param usageLimitId
         *        The identifier of the usage limit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usageLimitId(String usageLimitId);

        /**
         * <p>
         * The Amazon Redshift Serverless feature to limit.
         * </p>
         * 
         * @param usageType
         *        The Amazon Redshift Serverless feature to limit.
         * @see UsageLimitUsageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UsageLimitUsageType
         */
        Builder usageType(String usageType);

        /**
         * <p>
         * The Amazon Redshift Serverless feature to limit.
         * </p>
         * 
         * @param usageType
         *        The Amazon Redshift Serverless feature to limit.
         * @see UsageLimitUsageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UsageLimitUsageType
         */
        Builder usageType(UsageLimitUsageType usageType);
    }

    static final class BuilderImpl implements Builder {
        private Long amount;

        private String breachAction;

        private String period;

        private String resourceArn;

        private String usageLimitArn;

        private String usageLimitId;

        private String usageType;

        private BuilderImpl() {
        }

        private BuilderImpl(UsageLimit model) {
            amount(model.amount);
            breachAction(model.breachAction);
            period(model.period);
            resourceArn(model.resourceArn);
            usageLimitArn(model.usageLimitArn);
            usageLimitId(model.usageLimitId);
            usageType(model.usageType);
        }

        public final Long getAmount() {
            return amount;
        }

        public final void setAmount(Long amount) {
            this.amount = amount;
        }

        @Override
        public final Builder amount(Long amount) {
            this.amount = amount;
            return this;
        }

        public final String getBreachAction() {
            return breachAction;
        }

        public final void setBreachAction(String breachAction) {
            this.breachAction = breachAction;
        }

        @Override
        public final Builder breachAction(String breachAction) {
            this.breachAction = breachAction;
            return this;
        }

        @Override
        public final Builder breachAction(UsageLimitBreachAction breachAction) {
            this.breachAction(breachAction == null ? null : breachAction.toString());
            return this;
        }

        public final String getPeriod() {
            return period;
        }

        public final void setPeriod(String period) {
            this.period = period;
        }

        @Override
        public final Builder period(String period) {
            this.period = period;
            return this;
        }

        @Override
        public final Builder period(UsageLimitPeriod period) {
            this.period(period == null ? null : period.toString());
            return this;
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final String getUsageLimitArn() {
            return usageLimitArn;
        }

        public final void setUsageLimitArn(String usageLimitArn) {
            this.usageLimitArn = usageLimitArn;
        }

        @Override
        public final Builder usageLimitArn(String usageLimitArn) {
            this.usageLimitArn = usageLimitArn;
            return this;
        }

        public final String getUsageLimitId() {
            return usageLimitId;
        }

        public final void setUsageLimitId(String usageLimitId) {
            this.usageLimitId = usageLimitId;
        }

        @Override
        public final Builder usageLimitId(String usageLimitId) {
            this.usageLimitId = usageLimitId;
            return this;
        }

        public final String getUsageType() {
            return usageType;
        }

        public final void setUsageType(String usageType) {
            this.usageType = usageType;
        }

        @Override
        public final Builder usageType(String usageType) {
            this.usageType = usageType;
            return this;
        }

        @Override
        public final Builder usageType(UsageLimitUsageType usageType) {
            this.usageType(usageType == null ? null : usageType.toString());
            return this;
        }

        @Override
        public UsageLimit build() {
            return new UsageLimit(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
