/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshiftserverless.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.redshiftserverless.model.RedshiftServerlessRequest;
import software.amazon.awssdk.services.redshiftserverless.model.SubnetIdListCopier;
import software.amazon.awssdk.services.redshiftserverless.model.VpcSecurityGroupIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateEndpointAccessRequest
extends RedshiftServerlessRequest
implements ToCopyableBuilder<Builder, CreateEndpointAccessRequest> {
    private static final SdkField<String> ENDPOINT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("endpointName").getter(CreateEndpointAccessRequest.getter(CreateEndpointAccessRequest::endpointName)).setter(CreateEndpointAccessRequest.setter(Builder::endpointName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpointName").build()}).build();
    private static final SdkField<String> OWNER_ACCOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ownerAccount").getter(CreateEndpointAccessRequest.getter(CreateEndpointAccessRequest::ownerAccount)).setter(CreateEndpointAccessRequest.setter(Builder::ownerAccount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ownerAccount").build()}).build();
    private static final SdkField<List<String>> SUBNET_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("subnetIds").getter(CreateEndpointAccessRequest.getter(CreateEndpointAccessRequest::subnetIds)).setter(CreateEndpointAccessRequest.setter(Builder::subnetIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subnetIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> VPC_SECURITY_GROUP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("vpcSecurityGroupIds").getter(CreateEndpointAccessRequest.getter(CreateEndpointAccessRequest::vpcSecurityGroupIds)).setter(CreateEndpointAccessRequest.setter(Builder::vpcSecurityGroupIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcSecurityGroupIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> WORKGROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workgroupName").getter(CreateEndpointAccessRequest.getter(CreateEndpointAccessRequest::workgroupName)).setter(CreateEndpointAccessRequest.setter(Builder::workgroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workgroupName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_NAME_FIELD, OWNER_ACCOUNT_FIELD, SUBNET_IDS_FIELD, VPC_SECURITY_GROUP_IDS_FIELD, WORKGROUP_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateEndpointAccessRequest.memberNameToFieldInitializer();
    private final String endpointName;
    private final String ownerAccount;
    private final List<String> subnetIds;
    private final List<String> vpcSecurityGroupIds;
    private final String workgroupName;

    private CreateEndpointAccessRequest(BuilderImpl builder) {
        super(builder);
        this.endpointName = builder.endpointName;
        this.ownerAccount = builder.ownerAccount;
        this.subnetIds = builder.subnetIds;
        this.vpcSecurityGroupIds = builder.vpcSecurityGroupIds;
        this.workgroupName = builder.workgroupName;
    }

    public final String endpointName() {
        return this.endpointName;
    }

    public final String ownerAccount() {
        return this.ownerAccount;
    }

    public final boolean hasSubnetIds() {
        return this.subnetIds != null && !(this.subnetIds instanceof SdkAutoConstructList);
    }

    public final List<String> subnetIds() {
        return this.subnetIds;
    }

    public final boolean hasVpcSecurityGroupIds() {
        return this.vpcSecurityGroupIds != null && !(this.vpcSecurityGroupIds instanceof SdkAutoConstructList);
    }

    public final List<String> vpcSecurityGroupIds() {
        return this.vpcSecurityGroupIds;
    }

    public final String workgroupName() {
        return this.workgroupName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointName());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerAccount());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubnetIds() ? this.subnetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVpcSecurityGroupIds() ? this.vpcSecurityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.workgroupName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateEndpointAccessRequest)) {
            return false;
        }
        CreateEndpointAccessRequest other = (CreateEndpointAccessRequest)((Object)obj);
        return Objects.equals(this.endpointName(), other.endpointName()) && Objects.equals(this.ownerAccount(), other.ownerAccount()) && this.hasSubnetIds() == other.hasSubnetIds() && Objects.equals(this.subnetIds(), other.subnetIds()) && this.hasVpcSecurityGroupIds() == other.hasVpcSecurityGroupIds() && Objects.equals(this.vpcSecurityGroupIds(), other.vpcSecurityGroupIds()) && Objects.equals(this.workgroupName(), other.workgroupName());
    }

    public final String toString() {
        return ToString.builder((String)"CreateEndpointAccessRequest").add("EndpointName", (Object)this.endpointName()).add("OwnerAccount", (Object)this.ownerAccount()).add("SubnetIds", this.hasSubnetIds() ? this.subnetIds() : null).add("VpcSecurityGroupIds", this.hasVpcSecurityGroupIds() ? this.vpcSecurityGroupIds() : null).add("WorkgroupName", (Object)this.workgroupName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "endpointName": {
                return Optional.ofNullable(clazz.cast(this.endpointName()));
            }
            case "ownerAccount": {
                return Optional.ofNullable(clazz.cast(this.ownerAccount()));
            }
            case "subnetIds": {
                return Optional.ofNullable(clazz.cast(this.subnetIds()));
            }
            case "vpcSecurityGroupIds": {
                return Optional.ofNullable(clazz.cast(this.vpcSecurityGroupIds()));
            }
            case "workgroupName": {
                return Optional.ofNullable(clazz.cast(this.workgroupName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("endpointName", ENDPOINT_NAME_FIELD);
        map.put("ownerAccount", OWNER_ACCOUNT_FIELD);
        map.put("subnetIds", SUBNET_IDS_FIELD);
        map.put("vpcSecurityGroupIds", VPC_SECURITY_GROUP_IDS_FIELD);
        map.put("workgroupName", WORKGROUP_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateEndpointAccessRequest, T> g) {
        return obj -> g.apply((CreateEndpointAccessRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RedshiftServerlessRequest.BuilderImpl
    implements Builder {
        private String endpointName;
        private String ownerAccount;
        private List<String> subnetIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> vpcSecurityGroupIds = DefaultSdkAutoConstructList.getInstance();
        private String workgroupName;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateEndpointAccessRequest model) {
            super(model);
            this.endpointName(model.endpointName);
            this.ownerAccount(model.ownerAccount);
            this.subnetIds(model.subnetIds);
            this.vpcSecurityGroupIds(model.vpcSecurityGroupIds);
            this.workgroupName(model.workgroupName);
        }

        public final String getEndpointName() {
            return this.endpointName;
        }

        public final void setEndpointName(String endpointName) {
            this.endpointName = endpointName;
        }

        @Override
        public final Builder endpointName(String endpointName) {
            this.endpointName = endpointName;
            return this;
        }

        public final String getOwnerAccount() {
            return this.ownerAccount;
        }

        public final void setOwnerAccount(String ownerAccount) {
            this.ownerAccount = ownerAccount;
        }

        @Override
        public final Builder ownerAccount(String ownerAccount) {
            this.ownerAccount = ownerAccount;
            return this;
        }

        public final Collection<String> getSubnetIds() {
            if (this.subnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.subnetIds;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdListCopier.copy(subnetIds);
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdListCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String ... subnetIds) {
            this.subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final Collection<String> getVpcSecurityGroupIds() {
            if (this.vpcSecurityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.vpcSecurityGroupIds;
        }

        public final void setVpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = VpcSecurityGroupIdListCopier.copy(vpcSecurityGroupIds);
        }

        @Override
        public final Builder vpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = VpcSecurityGroupIdListCopier.copy(vpcSecurityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroupIds(String ... vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds(Arrays.asList(vpcSecurityGroupIds));
            return this;
        }

        public final String getWorkgroupName() {
            return this.workgroupName;
        }

        public final void setWorkgroupName(String workgroupName) {
            this.workgroupName = workgroupName;
        }

        @Override
        public final Builder workgroupName(String workgroupName) {
            this.workgroupName = workgroupName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateEndpointAccessRequest build() {
            return new CreateEndpointAccessRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends RedshiftServerlessRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateEndpointAccessRequest> {
        public Builder endpointName(String var1);

        public Builder ownerAccount(String var1);

        public Builder subnetIds(Collection<String> var1);

        public Builder subnetIds(String ... var1);

        public Builder vpcSecurityGroupIds(Collection<String> var1);

        public Builder vpcSecurityGroupIds(String ... var1);

        public Builder workgroupName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

