/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshiftserverless.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.redshiftserverless.model.Namespace;
import software.amazon.awssdk.services.redshiftserverless.model.RedshiftServerlessResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RestoreFromRecoveryPointResponse
extends RedshiftServerlessResponse
implements ToCopyableBuilder<Builder, RestoreFromRecoveryPointResponse> {
    private static final SdkField<Namespace> NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("namespace").getter(RestoreFromRecoveryPointResponse.getter(RestoreFromRecoveryPointResponse::namespace)).setter(RestoreFromRecoveryPointResponse.setter(Builder::namespace)).constructor(Namespace::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespace").build()}).build();
    private static final SdkField<String> RECOVERY_POINT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("recoveryPointId").getter(RestoreFromRecoveryPointResponse.getter(RestoreFromRecoveryPointResponse::recoveryPointId)).setter(RestoreFromRecoveryPointResponse.setter(Builder::recoveryPointId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recoveryPointId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAMESPACE_FIELD, RECOVERY_POINT_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RestoreFromRecoveryPointResponse.memberNameToFieldInitializer();
    private final Namespace namespace;
    private final String recoveryPointId;

    private RestoreFromRecoveryPointResponse(BuilderImpl builder) {
        super(builder);
        this.namespace = builder.namespace;
        this.recoveryPointId = builder.recoveryPointId;
    }

    public final Namespace namespace() {
        return this.namespace;
    }

    public final String recoveryPointId() {
        return this.recoveryPointId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.namespace());
        hashCode = 31 * hashCode + Objects.hashCode(this.recoveryPointId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RestoreFromRecoveryPointResponse)) {
            return false;
        }
        RestoreFromRecoveryPointResponse other = (RestoreFromRecoveryPointResponse)((Object)obj);
        return Objects.equals(this.namespace(), other.namespace()) && Objects.equals(this.recoveryPointId(), other.recoveryPointId());
    }

    public final String toString() {
        return ToString.builder((String)"RestoreFromRecoveryPointResponse").add("Namespace", (Object)this.namespace()).add("RecoveryPointId", (Object)this.recoveryPointId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "namespace": {
                return Optional.ofNullable(clazz.cast(this.namespace()));
            }
            case "recoveryPointId": {
                return Optional.ofNullable(clazz.cast(this.recoveryPointId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("namespace", NAMESPACE_FIELD);
        map.put("recoveryPointId", RECOVERY_POINT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RestoreFromRecoveryPointResponse, T> g) {
        return obj -> g.apply((RestoreFromRecoveryPointResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RedshiftServerlessResponse.BuilderImpl
    implements Builder {
        private Namespace namespace;
        private String recoveryPointId;

        private BuilderImpl() {
        }

        private BuilderImpl(RestoreFromRecoveryPointResponse model) {
            super(model);
            this.namespace(model.namespace);
            this.recoveryPointId(model.recoveryPointId);
        }

        public final Namespace.Builder getNamespace() {
            return this.namespace != null ? this.namespace.toBuilder() : null;
        }

        public final void setNamespace(Namespace.BuilderImpl namespace) {
            this.namespace = namespace != null ? namespace.build() : null;
        }

        @Override
        public final Builder namespace(Namespace namespace) {
            this.namespace = namespace;
            return this;
        }

        public final String getRecoveryPointId() {
            return this.recoveryPointId;
        }

        public final void setRecoveryPointId(String recoveryPointId) {
            this.recoveryPointId = recoveryPointId;
        }

        @Override
        public final Builder recoveryPointId(String recoveryPointId) {
            this.recoveryPointId = recoveryPointId;
            return this;
        }

        @Override
        public RestoreFromRecoveryPointResponse build() {
            return new RestoreFromRecoveryPointResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends RedshiftServerlessResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RestoreFromRecoveryPointResponse> {
        public Builder namespace(Namespace var1);

        default public Builder namespace(Consumer<Namespace.Builder> namespace) {
            return this.namespace((Namespace)((Namespace.Builder)Namespace.builder().applyMutation(namespace)).build());
        }

        public Builder recoveryPointId(String var1);
    }
}

