/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshiftserverless.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.redshiftserverless.model.RedshiftServerlessRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteNamespaceRequest
extends RedshiftServerlessRequest
implements ToCopyableBuilder<Builder, DeleteNamespaceRequest> {
    private static final SdkField<String> FINAL_SNAPSHOT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("finalSnapshotName").getter(DeleteNamespaceRequest.getter(DeleteNamespaceRequest::finalSnapshotName)).setter(DeleteNamespaceRequest.setter(Builder::finalSnapshotName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("finalSnapshotName").build()}).build();
    private static final SdkField<Integer> FINAL_SNAPSHOT_RETENTION_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("finalSnapshotRetentionPeriod").getter(DeleteNamespaceRequest.getter(DeleteNamespaceRequest::finalSnapshotRetentionPeriod)).setter(DeleteNamespaceRequest.setter(Builder::finalSnapshotRetentionPeriod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("finalSnapshotRetentionPeriod").build()}).build();
    private static final SdkField<String> NAMESPACE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("namespaceName").getter(DeleteNamespaceRequest.getter(DeleteNamespaceRequest::namespaceName)).setter(DeleteNamespaceRequest.setter(Builder::namespaceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespaceName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FINAL_SNAPSHOT_NAME_FIELD, FINAL_SNAPSHOT_RETENTION_PERIOD_FIELD, NAMESPACE_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeleteNamespaceRequest.memberNameToFieldInitializer();
    private final String finalSnapshotName;
    private final Integer finalSnapshotRetentionPeriod;
    private final String namespaceName;

    private DeleteNamespaceRequest(BuilderImpl builder) {
        super(builder);
        this.finalSnapshotName = builder.finalSnapshotName;
        this.finalSnapshotRetentionPeriod = builder.finalSnapshotRetentionPeriod;
        this.namespaceName = builder.namespaceName;
    }

    public final String finalSnapshotName() {
        return this.finalSnapshotName;
    }

    public final Integer finalSnapshotRetentionPeriod() {
        return this.finalSnapshotRetentionPeriod;
    }

    public final String namespaceName() {
        return this.namespaceName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.finalSnapshotName());
        hashCode = 31 * hashCode + Objects.hashCode(this.finalSnapshotRetentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.namespaceName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteNamespaceRequest)) {
            return false;
        }
        DeleteNamespaceRequest other = (DeleteNamespaceRequest)((Object)obj);
        return Objects.equals(this.finalSnapshotName(), other.finalSnapshotName()) && Objects.equals(this.finalSnapshotRetentionPeriod(), other.finalSnapshotRetentionPeriod()) && Objects.equals(this.namespaceName(), other.namespaceName());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteNamespaceRequest").add("FinalSnapshotName", (Object)this.finalSnapshotName()).add("FinalSnapshotRetentionPeriod", (Object)this.finalSnapshotRetentionPeriod()).add("NamespaceName", (Object)this.namespaceName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "finalSnapshotName": {
                return Optional.ofNullable(clazz.cast(this.finalSnapshotName()));
            }
            case "finalSnapshotRetentionPeriod": {
                return Optional.ofNullable(clazz.cast(this.finalSnapshotRetentionPeriod()));
            }
            case "namespaceName": {
                return Optional.ofNullable(clazz.cast(this.namespaceName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("finalSnapshotName", FINAL_SNAPSHOT_NAME_FIELD);
        map.put("finalSnapshotRetentionPeriod", FINAL_SNAPSHOT_RETENTION_PERIOD_FIELD);
        map.put("namespaceName", NAMESPACE_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteNamespaceRequest, T> g) {
        return obj -> g.apply((DeleteNamespaceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RedshiftServerlessRequest.BuilderImpl
    implements Builder {
        private String finalSnapshotName;
        private Integer finalSnapshotRetentionPeriod;
        private String namespaceName;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteNamespaceRequest model) {
            super(model);
            this.finalSnapshotName(model.finalSnapshotName);
            this.finalSnapshotRetentionPeriod(model.finalSnapshotRetentionPeriod);
            this.namespaceName(model.namespaceName);
        }

        public final String getFinalSnapshotName() {
            return this.finalSnapshotName;
        }

        public final void setFinalSnapshotName(String finalSnapshotName) {
            this.finalSnapshotName = finalSnapshotName;
        }

        @Override
        public final Builder finalSnapshotName(String finalSnapshotName) {
            this.finalSnapshotName = finalSnapshotName;
            return this;
        }

        public final Integer getFinalSnapshotRetentionPeriod() {
            return this.finalSnapshotRetentionPeriod;
        }

        public final void setFinalSnapshotRetentionPeriod(Integer finalSnapshotRetentionPeriod) {
            this.finalSnapshotRetentionPeriod = finalSnapshotRetentionPeriod;
        }

        @Override
        public final Builder finalSnapshotRetentionPeriod(Integer finalSnapshotRetentionPeriod) {
            this.finalSnapshotRetentionPeriod = finalSnapshotRetentionPeriod;
            return this;
        }

        public final String getNamespaceName() {
            return this.namespaceName;
        }

        public final void setNamespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
        }

        @Override
        public final Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteNamespaceRequest build() {
            return new DeleteNamespaceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends RedshiftServerlessRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteNamespaceRequest> {
        public Builder finalSnapshotName(String var1);

        public Builder finalSnapshotRetentionPeriod(Integer var1);

        public Builder namespaceName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

