/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshiftserverless.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteWorkgroupResponse extends RedshiftServerlessResponse implements
        ToCopyableBuilder<DeleteWorkgroupResponse.Builder, DeleteWorkgroupResponse> {
    private static final SdkField<Workgroup> WORKGROUP_FIELD = SdkField.<Workgroup> builder(MarshallingType.SDK_POJO)
            .memberName("workgroup").getter(getter(DeleteWorkgroupResponse::workgroup)).setter(setter(Builder::workgroup))
            .constructor(Workgroup::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workgroup").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKGROUP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Workgroup workgroup;

    private DeleteWorkgroupResponse(BuilderImpl builder) {
        super(builder);
        this.workgroup = builder.workgroup;
    }

    /**
     * <p>
     * The deleted workgroup object.
     * </p>
     * 
     * @return The deleted workgroup object.
     */
    public final Workgroup workgroup() {
        return workgroup;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(workgroup());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteWorkgroupResponse)) {
            return false;
        }
        DeleteWorkgroupResponse other = (DeleteWorkgroupResponse) obj;
        return Objects.equals(workgroup(), other.workgroup());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteWorkgroupResponse").add("Workgroup", workgroup()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "workgroup":
            return Optional.ofNullable(clazz.cast(workgroup()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("workgroup", WORKGROUP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteWorkgroupResponse, T> g) {
        return obj -> g.apply((DeleteWorkgroupResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends RedshiftServerlessResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteWorkgroupResponse> {
        /**
         * <p>
         * The deleted workgroup object.
         * </p>
         * 
         * @param workgroup
         *        The deleted workgroup object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workgroup(Workgroup workgroup);

        /**
         * <p>
         * The deleted workgroup object.
         * </p>
         * This is a convenience method that creates an instance of the {@link Workgroup.Builder} avoiding the need to
         * create one manually via {@link Workgroup#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Workgroup.Builder#build()} is called immediately and its result
         * is passed to {@link #workgroup(Workgroup)}.
         * 
         * @param workgroup
         *        a consumer that will call methods on {@link Workgroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #workgroup(Workgroup)
         */
        default Builder workgroup(Consumer<Workgroup.Builder> workgroup) {
            return workgroup(Workgroup.builder().applyMutation(workgroup).build());
        }
    }

    static final class BuilderImpl extends RedshiftServerlessResponse.BuilderImpl implements Builder {
        private Workgroup workgroup;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteWorkgroupResponse model) {
            super(model);
            workgroup(model.workgroup);
        }

        public final Workgroup.Builder getWorkgroup() {
            return workgroup != null ? workgroup.toBuilder() : null;
        }

        public final void setWorkgroup(Workgroup.BuilderImpl workgroup) {
            this.workgroup = workgroup != null ? workgroup.build() : null;
        }

        @Override
        public final Builder workgroup(Workgroup workgroup) {
            this.workgroup = workgroup;
            return this;
        }

        @Override
        public DeleteWorkgroupResponse build() {
            return new DeleteWorkgroupResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
