/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshiftserverless.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents an Amazon Redshift Serverless reservation, which gives you the option to commit to a specified number of
 * Redshift Processing Units (RPUs) for a year at a discount from Serverless on-demand (OD) rates.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Reservation implements SdkPojo, Serializable, ToCopyableBuilder<Reservation.Builder, Reservation> {
    private static final SdkField<Integer> CAPACITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("capacity").getter(getter(Reservation::capacity)).setter(setter(Builder::capacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capacity").build()).build();

    private static final SdkField<Instant> END_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("endDate")
            .getter(getter(Reservation::endDate))
            .setter(setter(Builder::endDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endDate").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<ReservationOffering> OFFERING_FIELD = SdkField
            .<ReservationOffering> builder(MarshallingType.SDK_POJO).memberName("offering").getter(getter(Reservation::offering))
            .setter(setter(Builder::offering)).constructor(ReservationOffering::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("offering").build()).build();

    private static final SdkField<String> RESERVATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("reservationArn").getter(getter(Reservation::reservationArn)).setter(setter(Builder::reservationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reservationArn").build()).build();

    private static final SdkField<String> RESERVATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("reservationId").getter(getter(Reservation::reservationId)).setter(setter(Builder::reservationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reservationId").build()).build();

    private static final SdkField<Instant> START_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("startDate")
            .getter(getter(Reservation::startDate))
            .setter(setter(Builder::startDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startDate").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(Reservation::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPACITY_FIELD,
            END_DATE_FIELD, OFFERING_FIELD, RESERVATION_ARN_FIELD, RESERVATION_ID_FIELD, START_DATE_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer capacity;

    private final Instant endDate;

    private final ReservationOffering offering;

    private final String reservationArn;

    private final String reservationId;

    private final Instant startDate;

    private final String status;

    private Reservation(BuilderImpl builder) {
        this.capacity = builder.capacity;
        this.endDate = builder.endDate;
        this.offering = builder.offering;
        this.reservationArn = builder.reservationArn;
        this.reservationId = builder.reservationId;
        this.startDate = builder.startDate;
        this.status = builder.status;
    }

    /**
     * <p>
     * The number of Redshift Processing Units (RPUs) to reserve.
     * </p>
     * 
     * @return The number of Redshift Processing Units (RPUs) to reserve.
     */
    public final Integer capacity() {
        return capacity;
    }

    /**
     * <p>
     * The end date for the serverless reservation. This date is one year after the start date that you specify.
     * </p>
     * 
     * @return The end date for the serverless reservation. This date is one year after the start date that you specify.
     */
    public final Instant endDate() {
        return endDate;
    }

    /**
     * <p>
     * The type of offering for the reservation. The offering class determines the payment schedule for the reservation.
     * </p>
     * 
     * @return The type of offering for the reservation. The offering class determines the payment schedule for the
     *         reservation.
     */
    public final ReservationOffering offering() {
        return offering;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) that uniquely identifies the serverless reservation.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) that uniquely identifies the serverless reservation.
     */
    public final String reservationArn() {
        return reservationArn;
    }

    /**
     * <p>
     * The identifier that uniquely identifies the serverless reservation.
     * </p>
     * 
     * @return The identifier that uniquely identifies the serverless reservation.
     */
    public final String reservationId() {
        return reservationId;
    }

    /**
     * <p>
     * The start date for the serverless reservation. This is the date you specified for the reservation to start when
     * you created the reservation.
     * </p>
     * 
     * @return The start date for the serverless reservation. This is the date you specified for the reservation to
     *         start when you created the reservation.
     */
    public final Instant startDate() {
        return startDate;
    }

    /**
     * <p>
     * The status of the reservation. Possible values include the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>payment-pending</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>active</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>payment-failed</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>retired</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The status of the reservation. Possible values include the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>payment-pending</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>active</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>payment-failed</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>retired</code>
     *         </p>
     *         </li>
     */
    public final String status() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(capacity());
        hashCode = 31 * hashCode + Objects.hashCode(endDate());
        hashCode = 31 * hashCode + Objects.hashCode(offering());
        hashCode = 31 * hashCode + Objects.hashCode(reservationArn());
        hashCode = 31 * hashCode + Objects.hashCode(reservationId());
        hashCode = 31 * hashCode + Objects.hashCode(startDate());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Reservation)) {
            return false;
        }
        Reservation other = (Reservation) obj;
        return Objects.equals(capacity(), other.capacity()) && Objects.equals(endDate(), other.endDate())
                && Objects.equals(offering(), other.offering()) && Objects.equals(reservationArn(), other.reservationArn())
                && Objects.equals(reservationId(), other.reservationId()) && Objects.equals(startDate(), other.startDate())
                && Objects.equals(status(), other.status());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Reservation").add("Capacity", capacity()).add("EndDate", endDate()).add("Offering", offering())
                .add("ReservationArn", reservationArn()).add("ReservationId", reservationId()).add("StartDate", startDate())
                .add("Status", status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "capacity":
            return Optional.ofNullable(clazz.cast(capacity()));
        case "endDate":
            return Optional.ofNullable(clazz.cast(endDate()));
        case "offering":
            return Optional.ofNullable(clazz.cast(offering()));
        case "reservationArn":
            return Optional.ofNullable(clazz.cast(reservationArn()));
        case "reservationId":
            return Optional.ofNullable(clazz.cast(reservationId()));
        case "startDate":
            return Optional.ofNullable(clazz.cast(startDate()));
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("capacity", CAPACITY_FIELD);
        map.put("endDate", END_DATE_FIELD);
        map.put("offering", OFFERING_FIELD);
        map.put("reservationArn", RESERVATION_ARN_FIELD);
        map.put("reservationId", RESERVATION_ID_FIELD);
        map.put("startDate", START_DATE_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Reservation, T> g) {
        return obj -> g.apply((Reservation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Reservation> {
        /**
         * <p>
         * The number of Redshift Processing Units (RPUs) to reserve.
         * </p>
         * 
         * @param capacity
         *        The number of Redshift Processing Units (RPUs) to reserve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacity(Integer capacity);

        /**
         * <p>
         * The end date for the serverless reservation. This date is one year after the start date that you specify.
         * </p>
         * 
         * @param endDate
         *        The end date for the serverless reservation. This date is one year after the start date that you
         *        specify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endDate(Instant endDate);

        /**
         * <p>
         * The type of offering for the reservation. The offering class determines the payment schedule for the
         * reservation.
         * </p>
         * 
         * @param offering
         *        The type of offering for the reservation. The offering class determines the payment schedule for the
         *        reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder offering(ReservationOffering offering);

        /**
         * <p>
         * The type of offering for the reservation. The offering class determines the payment schedule for the
         * reservation.
         * </p>
         * This is a convenience method that creates an instance of the {@link ReservationOffering.Builder} avoiding the
         * need to create one manually via {@link ReservationOffering#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ReservationOffering.Builder#build()} is called immediately and
         * its result is passed to {@link #offering(ReservationOffering)}.
         * 
         * @param offering
         *        a consumer that will call methods on {@link ReservationOffering.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #offering(ReservationOffering)
         */
        default Builder offering(Consumer<ReservationOffering.Builder> offering) {
            return offering(ReservationOffering.builder().applyMutation(offering).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) that uniquely identifies the serverless reservation.
         * </p>
         * 
         * @param reservationArn
         *        The Amazon Resource Name (ARN) that uniquely identifies the serverless reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservationArn(String reservationArn);

        /**
         * <p>
         * The identifier that uniquely identifies the serverless reservation.
         * </p>
         * 
         * @param reservationId
         *        The identifier that uniquely identifies the serverless reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservationId(String reservationId);

        /**
         * <p>
         * The start date for the serverless reservation. This is the date you specified for the reservation to start
         * when you created the reservation.
         * </p>
         * 
         * @param startDate
         *        The start date for the serverless reservation. This is the date you specified for the reservation to
         *        start when you created the reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startDate(Instant startDate);

        /**
         * <p>
         * The status of the reservation. Possible values include the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>payment-pending</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>active</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>payment-failed</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>retired</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the reservation. Possible values include the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>payment-pending</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>active</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>payment-failed</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>retired</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);
    }

    static final class BuilderImpl implements Builder {
        private Integer capacity;

        private Instant endDate;

        private ReservationOffering offering;

        private String reservationArn;

        private String reservationId;

        private Instant startDate;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(Reservation model) {
            capacity(model.capacity);
            endDate(model.endDate);
            offering(model.offering);
            reservationArn(model.reservationArn);
            reservationId(model.reservationId);
            startDate(model.startDate);
            status(model.status);
        }

        public final Integer getCapacity() {
            return capacity;
        }

        public final void setCapacity(Integer capacity) {
            this.capacity = capacity;
        }

        @Override
        public final Builder capacity(Integer capacity) {
            this.capacity = capacity;
            return this;
        }

        public final Instant getEndDate() {
            return endDate;
        }

        public final void setEndDate(Instant endDate) {
            this.endDate = endDate;
        }

        @Override
        public final Builder endDate(Instant endDate) {
            this.endDate = endDate;
            return this;
        }

        public final ReservationOffering.Builder getOffering() {
            return offering != null ? offering.toBuilder() : null;
        }

        public final void setOffering(ReservationOffering.BuilderImpl offering) {
            this.offering = offering != null ? offering.build() : null;
        }

        @Override
        public final Builder offering(ReservationOffering offering) {
            this.offering = offering;
            return this;
        }

        public final String getReservationArn() {
            return reservationArn;
        }

        public final void setReservationArn(String reservationArn) {
            this.reservationArn = reservationArn;
        }

        @Override
        public final Builder reservationArn(String reservationArn) {
            this.reservationArn = reservationArn;
            return this;
        }

        public final String getReservationId() {
            return reservationId;
        }

        public final void setReservationId(String reservationId) {
            this.reservationId = reservationId;
        }

        @Override
        public final Builder reservationId(String reservationId) {
            this.reservationId = reservationId;
            return this;
        }

        public final Instant getStartDate() {
            return startDate;
        }

        public final void setStartDate(Instant startDate) {
            this.startDate = startDate;
        }

        @Override
        public final Builder startDate(Instant startDate) {
            this.startDate = startDate;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public Reservation build() {
            return new Reservation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
