/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshiftserverless.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListUsageLimitsResponse extends RedshiftServerlessResponse implements
        ToCopyableBuilder<ListUsageLimitsResponse.Builder, ListUsageLimitsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListUsageLimitsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<UsageLimit>> USAGE_LIMITS_FIELD = SdkField
            .<List<UsageLimit>> builder(MarshallingType.LIST)
            .memberName("usageLimits")
            .getter(getter(ListUsageLimitsResponse::usageLimits))
            .setter(setter(Builder::usageLimits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usageLimits").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UsageLimit> builder(MarshallingType.SDK_POJO)
                                            .constructor(UsageLimit::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            USAGE_LIMITS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final List<UsageLimit> usageLimits;

    private ListUsageLimitsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.usageLimits = builder.usageLimits;
    }

    /**
     * <p>
     * When <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is
     * a unique pagination token for each page. Make the call again using the returned token to retrieve the next page.
     * </p>
     * 
     * @return When <code>nextToken</code> is returned, there are more results available. The value of
     *         <code>nextToken</code> is a unique pagination token for each page. Make the call again using the returned
     *         token to retrieve the next page.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the UsageLimits property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasUsageLimits() {
        return usageLimits != null && !(usageLimits instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of returned usage limit objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUsageLimits} method.
     * </p>
     * 
     * @return An array of returned usage limit objects.
     */
    public final List<UsageLimit> usageLimits() {
        return usageLimits;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasUsageLimits() ? usageLimits() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListUsageLimitsResponse)) {
            return false;
        }
        ListUsageLimitsResponse other = (ListUsageLimitsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasUsageLimits() == other.hasUsageLimits()
                && Objects.equals(usageLimits(), other.usageLimits());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListUsageLimitsResponse").add("NextToken", nextToken())
                .add("UsageLimits", hasUsageLimits() ? usageLimits() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "usageLimits":
            return Optional.ofNullable(clazz.cast(usageLimits()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("usageLimits", USAGE_LIMITS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListUsageLimitsResponse, T> g) {
        return obj -> g.apply((ListUsageLimitsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends RedshiftServerlessResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListUsageLimitsResponse> {
        /**
         * <p>
         * When <code>nextToken</code> is returned, there are more results available. The value of
         * <code>nextToken</code> is a unique pagination token for each page. Make the call again using the returned
         * token to retrieve the next page.
         * </p>
         * 
         * @param nextToken
         *        When <code>nextToken</code> is returned, there are more results available. The value of
         *        <code>nextToken</code> is a unique pagination token for each page. Make the call again using the
         *        returned token to retrieve the next page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * An array of returned usage limit objects.
         * </p>
         * 
         * @param usageLimits
         *        An array of returned usage limit objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usageLimits(Collection<UsageLimit> usageLimits);

        /**
         * <p>
         * An array of returned usage limit objects.
         * </p>
         * 
         * @param usageLimits
         *        An array of returned usage limit objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usageLimits(UsageLimit... usageLimits);

        /**
         * <p>
         * An array of returned usage limit objects.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.redshiftserverless.model.UsageLimit.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.redshiftserverless.model.UsageLimit#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.redshiftserverless.model.UsageLimit.Builder#build()} is called
         * immediately and its result is passed to {@link #usageLimits(List<UsageLimit>)}.
         * 
         * @param usageLimits
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.redshiftserverless.model.UsageLimit.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #usageLimits(java.util.Collection<UsageLimit>)
         */
        Builder usageLimits(Consumer<UsageLimit.Builder>... usageLimits);
    }

    static final class BuilderImpl extends RedshiftServerlessResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<UsageLimit> usageLimits = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListUsageLimitsResponse model) {
            super(model);
            nextToken(model.nextToken);
            usageLimits(model.usageLimits);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<UsageLimit.Builder> getUsageLimits() {
            List<UsageLimit.Builder> result = UsageLimitsCopier.copyToBuilder(this.usageLimits);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUsageLimits(Collection<UsageLimit.BuilderImpl> usageLimits) {
            this.usageLimits = UsageLimitsCopier.copyFromBuilder(usageLimits);
        }

        @Override
        public final Builder usageLimits(Collection<UsageLimit> usageLimits) {
            this.usageLimits = UsageLimitsCopier.copy(usageLimits);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder usageLimits(UsageLimit... usageLimits) {
            usageLimits(Arrays.asList(usageLimits));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder usageLimits(Consumer<UsageLimit.Builder>... usageLimits) {
            usageLimits(Stream.of(usageLimits).map(c -> UsageLimit.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListUsageLimitsResponse build() {
            return new ListUsageLimitsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
