/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshiftserverless.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A snapshot object that contains databases.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Snapshot implements SdkPojo, Serializable, ToCopyableBuilder<Snapshot.Builder, Snapshot> {
    private static final SdkField<List<String>> ACCOUNTS_WITH_PROVISIONED_RESTORE_ACCESS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("accountsWithProvisionedRestoreAccess")
            .getter(getter(Snapshot::accountsWithProvisionedRestoreAccess))
            .setter(setter(Builder::accountsWithProvisionedRestoreAccess))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("accountsWithProvisionedRestoreAccess").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> ACCOUNTS_WITH_RESTORE_ACCESS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("accountsWithRestoreAccess")
            .getter(getter(Snapshot::accountsWithRestoreAccess))
            .setter(setter(Builder::accountsWithRestoreAccess))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountsWithRestoreAccess").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Double> ACTUAL_INCREMENTAL_BACKUP_SIZE_IN_MEGA_BYTES_FIELD = SdkField
            .<Double> builder(MarshallingType.DOUBLE)
            .memberName("actualIncrementalBackupSizeInMegaBytes")
            .getter(getter(Snapshot::actualIncrementalBackupSizeInMegaBytes))
            .setter(setter(Builder::actualIncrementalBackupSizeInMegaBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("actualIncrementalBackupSizeInMegaBytes").build()).build();

    private static final SdkField<String> ADMIN_PASSWORD_SECRET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("adminPasswordSecretArn").getter(getter(Snapshot::adminPasswordSecretArn))
            .setter(setter(Builder::adminPasswordSecretArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("adminPasswordSecretArn").build())
            .build();

    private static final SdkField<String> ADMIN_PASSWORD_SECRET_KMS_KEY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("adminPasswordSecretKmsKeyId")
            .getter(getter(Snapshot::adminPasswordSecretKmsKeyId))
            .setter(setter(Builder::adminPasswordSecretKmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("adminPasswordSecretKmsKeyId")
                    .build()).build();

    private static final SdkField<String> ADMIN_USERNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("adminUsername").getter(getter(Snapshot::adminUsername)).setter(setter(Builder::adminUsername))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("adminUsername").build()).build();

    private static final SdkField<Double> BACKUP_PROGRESS_IN_MEGA_BYTES_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("backupProgressInMegaBytes").getter(getter(Snapshot::backupProgressInMegaBytes))
            .setter(setter(Builder::backupProgressInMegaBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("backupProgressInMegaBytes").build())
            .build();

    private static final SdkField<Double> CURRENT_BACKUP_RATE_IN_MEGA_BYTES_PER_SECOND_FIELD = SdkField
            .<Double> builder(MarshallingType.DOUBLE)
            .memberName("currentBackupRateInMegaBytesPerSecond")
            .getter(getter(Snapshot::currentBackupRateInMegaBytesPerSecond))
            .setter(setter(Builder::currentBackupRateInMegaBytesPerSecond))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("currentBackupRateInMegaBytesPerSecond").build()).build();

    private static final SdkField<Long> ELAPSED_TIME_IN_SECONDS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("elapsedTimeInSeconds").getter(getter(Snapshot::elapsedTimeInSeconds))
            .setter(setter(Builder::elapsedTimeInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("elapsedTimeInSeconds").build())
            .build();

    private static final SdkField<Long> ESTIMATED_SECONDS_TO_COMPLETION_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("estimatedSecondsToCompletion")
            .getter(getter(Snapshot::estimatedSecondsToCompletion))
            .setter(setter(Builder::estimatedSecondsToCompletion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("estimatedSecondsToCompletion")
                    .build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("kmsKeyId").getter(getter(Snapshot::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyId").build()).build();

    private static final SdkField<String> NAMESPACE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("namespaceArn").getter(getter(Snapshot::namespaceArn)).setter(setter(Builder::namespaceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespaceArn").build()).build();

    private static final SdkField<String> NAMESPACE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("namespaceName").getter(getter(Snapshot::namespaceName)).setter(setter(Builder::namespaceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespaceName").build()).build();

    private static final SdkField<String> OWNER_ACCOUNT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ownerAccount").getter(getter(Snapshot::ownerAccount)).setter(setter(Builder::ownerAccount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ownerAccount").build()).build();

    private static final SdkField<String> SNAPSHOT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("snapshotArn").getter(getter(Snapshot::snapshotArn)).setter(setter(Builder::snapshotArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("snapshotArn").build()).build();

    private static final SdkField<Instant> SNAPSHOT_CREATE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("snapshotCreateTime")
            .getter(getter(Snapshot::snapshotCreateTime))
            .setter(setter(Builder::snapshotCreateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("snapshotCreateTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> SNAPSHOT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("snapshotName").getter(getter(Snapshot::snapshotName)).setter(setter(Builder::snapshotName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("snapshotName").build()).build();

    private static final SdkField<Integer> SNAPSHOT_REMAINING_DAYS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("snapshotRemainingDays").getter(getter(Snapshot::snapshotRemainingDays))
            .setter(setter(Builder::snapshotRemainingDays))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("snapshotRemainingDays").build())
            .build();

    private static final SdkField<Integer> SNAPSHOT_RETENTION_PERIOD_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("snapshotRetentionPeriod").getter(getter(Snapshot::snapshotRetentionPeriod))
            .setter(setter(Builder::snapshotRetentionPeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("snapshotRetentionPeriod").build())
            .build();

    private static final SdkField<Instant> SNAPSHOT_RETENTION_START_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("snapshotRetentionStartTime")
            .getter(getter(Snapshot::snapshotRetentionStartTime))
            .setter(setter(Builder::snapshotRetentionStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("snapshotRetentionStartTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(Snapshot::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Double> TOTAL_BACKUP_SIZE_IN_MEGA_BYTES_FIELD = SdkField
            .<Double> builder(MarshallingType.DOUBLE)
            .memberName("totalBackupSizeInMegaBytes")
            .getter(getter(Snapshot::totalBackupSizeInMegaBytes))
            .setter(setter(Builder::totalBackupSizeInMegaBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalBackupSizeInMegaBytes").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ACCOUNTS_WITH_PROVISIONED_RESTORE_ACCESS_FIELD, ACCOUNTS_WITH_RESTORE_ACCESS_FIELD,
            ACTUAL_INCREMENTAL_BACKUP_SIZE_IN_MEGA_BYTES_FIELD, ADMIN_PASSWORD_SECRET_ARN_FIELD,
            ADMIN_PASSWORD_SECRET_KMS_KEY_ID_FIELD, ADMIN_USERNAME_FIELD, BACKUP_PROGRESS_IN_MEGA_BYTES_FIELD,
            CURRENT_BACKUP_RATE_IN_MEGA_BYTES_PER_SECOND_FIELD, ELAPSED_TIME_IN_SECONDS_FIELD,
            ESTIMATED_SECONDS_TO_COMPLETION_FIELD, KMS_KEY_ID_FIELD, NAMESPACE_ARN_FIELD, NAMESPACE_NAME_FIELD,
            OWNER_ACCOUNT_FIELD, SNAPSHOT_ARN_FIELD, SNAPSHOT_CREATE_TIME_FIELD, SNAPSHOT_NAME_FIELD,
            SNAPSHOT_REMAINING_DAYS_FIELD, SNAPSHOT_RETENTION_PERIOD_FIELD, SNAPSHOT_RETENTION_START_TIME_FIELD, STATUS_FIELD,
            TOTAL_BACKUP_SIZE_IN_MEGA_BYTES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> accountsWithProvisionedRestoreAccess;

    private final List<String> accountsWithRestoreAccess;

    private final Double actualIncrementalBackupSizeInMegaBytes;

    private final String adminPasswordSecretArn;

    private final String adminPasswordSecretKmsKeyId;

    private final String adminUsername;

    private final Double backupProgressInMegaBytes;

    private final Double currentBackupRateInMegaBytesPerSecond;

    private final Long elapsedTimeInSeconds;

    private final Long estimatedSecondsToCompletion;

    private final String kmsKeyId;

    private final String namespaceArn;

    private final String namespaceName;

    private final String ownerAccount;

    private final String snapshotArn;

    private final Instant snapshotCreateTime;

    private final String snapshotName;

    private final Integer snapshotRemainingDays;

    private final Integer snapshotRetentionPeriod;

    private final Instant snapshotRetentionStartTime;

    private final String status;

    private final Double totalBackupSizeInMegaBytes;

    private Snapshot(BuilderImpl builder) {
        this.accountsWithProvisionedRestoreAccess = builder.accountsWithProvisionedRestoreAccess;
        this.accountsWithRestoreAccess = builder.accountsWithRestoreAccess;
        this.actualIncrementalBackupSizeInMegaBytes = builder.actualIncrementalBackupSizeInMegaBytes;
        this.adminPasswordSecretArn = builder.adminPasswordSecretArn;
        this.adminPasswordSecretKmsKeyId = builder.adminPasswordSecretKmsKeyId;
        this.adminUsername = builder.adminUsername;
        this.backupProgressInMegaBytes = builder.backupProgressInMegaBytes;
        this.currentBackupRateInMegaBytesPerSecond = builder.currentBackupRateInMegaBytesPerSecond;
        this.elapsedTimeInSeconds = builder.elapsedTimeInSeconds;
        this.estimatedSecondsToCompletion = builder.estimatedSecondsToCompletion;
        this.kmsKeyId = builder.kmsKeyId;
        this.namespaceArn = builder.namespaceArn;
        this.namespaceName = builder.namespaceName;
        this.ownerAccount = builder.ownerAccount;
        this.snapshotArn = builder.snapshotArn;
        this.snapshotCreateTime = builder.snapshotCreateTime;
        this.snapshotName = builder.snapshotName;
        this.snapshotRemainingDays = builder.snapshotRemainingDays;
        this.snapshotRetentionPeriod = builder.snapshotRetentionPeriod;
        this.snapshotRetentionStartTime = builder.snapshotRetentionStartTime;
        this.status = builder.status;
        this.totalBackupSizeInMegaBytes = builder.totalBackupSizeInMegaBytes;
    }

    /**
     * For responses, this returns true if the service returned a value for the AccountsWithProvisionedRestoreAccess
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasAccountsWithProvisionedRestoreAccess() {
        return accountsWithProvisionedRestoreAccess != null
                && !(accountsWithProvisionedRestoreAccess instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * All of the Amazon Web Services accounts that have access to restore a snapshot to a provisioned cluster.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAccountsWithProvisionedRestoreAccess}
     * method.
     * </p>
     * 
     * @return All of the Amazon Web Services accounts that have access to restore a snapshot to a provisioned cluster.
     */
    public final List<String> accountsWithProvisionedRestoreAccess() {
        return accountsWithProvisionedRestoreAccess;
    }

    /**
     * For responses, this returns true if the service returned a value for the AccountsWithRestoreAccess property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAccountsWithRestoreAccess() {
        return accountsWithRestoreAccess != null && !(accountsWithRestoreAccess instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * All of the Amazon Web Services accounts that have access to restore a snapshot to a namespace.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAccountsWithRestoreAccess} method.
     * </p>
     * 
     * @return All of the Amazon Web Services accounts that have access to restore a snapshot to a namespace.
     */
    public final List<String> accountsWithRestoreAccess() {
        return accountsWithRestoreAccess;
    }

    /**
     * <p>
     * The size of the incremental backup in megabytes.
     * </p>
     * 
     * @return The size of the incremental backup in megabytes.
     */
    public final Double actualIncrementalBackupSizeInMegaBytes() {
        return actualIncrementalBackupSizeInMegaBytes;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the namespace's admin user credentials secret.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the namespace's admin user credentials secret.
     */
    public final String adminPasswordSecretArn() {
        return adminPasswordSecretArn;
    }

    /**
     * <p>
     * The ID of the Key Management Service (KMS) key used to encrypt and store the namespace's admin credentials
     * secret.
     * </p>
     * 
     * @return The ID of the Key Management Service (KMS) key used to encrypt and store the namespace's admin
     *         credentials secret.
     */
    public final String adminPasswordSecretKmsKeyId() {
        return adminPasswordSecretKmsKeyId;
    }

    /**
     * <p>
     * The username of the database within a snapshot.
     * </p>
     * 
     * @return The username of the database within a snapshot.
     */
    public final String adminUsername() {
        return adminUsername;
    }

    /**
     * <p>
     * The size in megabytes of the data that has been backed up to a snapshot.
     * </p>
     * 
     * @return The size in megabytes of the data that has been backed up to a snapshot.
     */
    public final Double backupProgressInMegaBytes() {
        return backupProgressInMegaBytes;
    }

    /**
     * <p>
     * The rate at which data is backed up into a snapshot in megabytes per second.
     * </p>
     * 
     * @return The rate at which data is backed up into a snapshot in megabytes per second.
     */
    public final Double currentBackupRateInMegaBytesPerSecond() {
        return currentBackupRateInMegaBytesPerSecond;
    }

    /**
     * <p>
     * The amount of time it took to back up data into a snapshot.
     * </p>
     * 
     * @return The amount of time it took to back up data into a snapshot.
     */
    public final Long elapsedTimeInSeconds() {
        return elapsedTimeInSeconds;
    }

    /**
     * <p>
     * The estimated amount of seconds until the snapshot completes backup.
     * </p>
     * 
     * @return The estimated amount of seconds until the snapshot completes backup.
     */
    public final Long estimatedSecondsToCompletion() {
        return estimatedSecondsToCompletion;
    }

    /**
     * <p>
     * The unique identifier of the KMS key used to encrypt the snapshot.
     * </p>
     * 
     * @return The unique identifier of the KMS key used to encrypt the snapshot.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the namespace the snapshot was created from.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the namespace the snapshot was created from.
     */
    public final String namespaceArn() {
        return namespaceArn;
    }

    /**
     * <p>
     * The name of the namepsace.
     * </p>
     * 
     * @return The name of the namepsace.
     */
    public final String namespaceName() {
        return namespaceName;
    }

    /**
     * <p>
     * The owner Amazon Web Services; account of the snapshot.
     * </p>
     * 
     * @return The owner Amazon Web Services; account of the snapshot.
     */
    public final String ownerAccount() {
        return ownerAccount;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the snapshot.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the snapshot.
     */
    public final String snapshotArn() {
        return snapshotArn;
    }

    /**
     * <p>
     * The timestamp of when the snapshot was created.
     * </p>
     * 
     * @return The timestamp of when the snapshot was created.
     */
    public final Instant snapshotCreateTime() {
        return snapshotCreateTime;
    }

    /**
     * <p>
     * The name of the snapshot.
     * </p>
     * 
     * @return The name of the snapshot.
     */
    public final String snapshotName() {
        return snapshotName;
    }

    /**
     * <p>
     * The amount of days until the snapshot is deleted.
     * </p>
     * 
     * @return The amount of days until the snapshot is deleted.
     */
    public final Integer snapshotRemainingDays() {
        return snapshotRemainingDays;
    }

    /**
     * <p>
     * The period of time, in days, of how long the snapshot is retained.
     * </p>
     * 
     * @return The period of time, in days, of how long the snapshot is retained.
     */
    public final Integer snapshotRetentionPeriod() {
        return snapshotRetentionPeriod;
    }

    /**
     * <p>
     * The timestamp of when data within the snapshot started getting retained.
     * </p>
     * 
     * @return The timestamp of when data within the snapshot started getting retained.
     */
    public final Instant snapshotRetentionStartTime() {
        return snapshotRetentionStartTime;
    }

    /**
     * <p>
     * The status of the snapshot.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SnapshotStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the snapshot.
     * @see SnapshotStatus
     */
    public final SnapshotStatus status() {
        return SnapshotStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the snapshot.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SnapshotStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the snapshot.
     * @see SnapshotStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The total size, in megabytes, of how big the snapshot is.
     * </p>
     * 
     * @return The total size, in megabytes, of how big the snapshot is.
     */
    public final Double totalBackupSizeInMegaBytes() {
        return totalBackupSizeInMegaBytes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode
                + Objects.hashCode(hasAccountsWithProvisionedRestoreAccess() ? accountsWithProvisionedRestoreAccess() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAccountsWithRestoreAccess() ? accountsWithRestoreAccess() : null);
        hashCode = 31 * hashCode + Objects.hashCode(actualIncrementalBackupSizeInMegaBytes());
        hashCode = 31 * hashCode + Objects.hashCode(adminPasswordSecretArn());
        hashCode = 31 * hashCode + Objects.hashCode(adminPasswordSecretKmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(adminUsername());
        hashCode = 31 * hashCode + Objects.hashCode(backupProgressInMegaBytes());
        hashCode = 31 * hashCode + Objects.hashCode(currentBackupRateInMegaBytesPerSecond());
        hashCode = 31 * hashCode + Objects.hashCode(elapsedTimeInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(estimatedSecondsToCompletion());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(namespaceArn());
        hashCode = 31 * hashCode + Objects.hashCode(namespaceName());
        hashCode = 31 * hashCode + Objects.hashCode(ownerAccount());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotArn());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotCreateTime());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotName());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotRemainingDays());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotRetentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotRetentionStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(totalBackupSizeInMegaBytes());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Snapshot)) {
            return false;
        }
        Snapshot other = (Snapshot) obj;
        return hasAccountsWithProvisionedRestoreAccess() == other.hasAccountsWithProvisionedRestoreAccess()
                && Objects.equals(accountsWithProvisionedRestoreAccess(), other.accountsWithProvisionedRestoreAccess())
                && hasAccountsWithRestoreAccess() == other.hasAccountsWithRestoreAccess()
                && Objects.equals(accountsWithRestoreAccess(), other.accountsWithRestoreAccess())
                && Objects.equals(actualIncrementalBackupSizeInMegaBytes(), other.actualIncrementalBackupSizeInMegaBytes())
                && Objects.equals(adminPasswordSecretArn(), other.adminPasswordSecretArn())
                && Objects.equals(adminPasswordSecretKmsKeyId(), other.adminPasswordSecretKmsKeyId())
                && Objects.equals(adminUsername(), other.adminUsername())
                && Objects.equals(backupProgressInMegaBytes(), other.backupProgressInMegaBytes())
                && Objects.equals(currentBackupRateInMegaBytesPerSecond(), other.currentBackupRateInMegaBytesPerSecond())
                && Objects.equals(elapsedTimeInSeconds(), other.elapsedTimeInSeconds())
                && Objects.equals(estimatedSecondsToCompletion(), other.estimatedSecondsToCompletion())
                && Objects.equals(kmsKeyId(), other.kmsKeyId()) && Objects.equals(namespaceArn(), other.namespaceArn())
                && Objects.equals(namespaceName(), other.namespaceName()) && Objects.equals(ownerAccount(), other.ownerAccount())
                && Objects.equals(snapshotArn(), other.snapshotArn())
                && Objects.equals(snapshotCreateTime(), other.snapshotCreateTime())
                && Objects.equals(snapshotName(), other.snapshotName())
                && Objects.equals(snapshotRemainingDays(), other.snapshotRemainingDays())
                && Objects.equals(snapshotRetentionPeriod(), other.snapshotRetentionPeriod())
                && Objects.equals(snapshotRetentionStartTime(), other.snapshotRetentionStartTime())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(totalBackupSizeInMegaBytes(), other.totalBackupSizeInMegaBytes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("Snapshot")
                .add("AccountsWithProvisionedRestoreAccess",
                        hasAccountsWithProvisionedRestoreAccess() ? accountsWithProvisionedRestoreAccess() : null)
                .add("AccountsWithRestoreAccess", hasAccountsWithRestoreAccess() ? accountsWithRestoreAccess() : null)
                .add("ActualIncrementalBackupSizeInMegaBytes", actualIncrementalBackupSizeInMegaBytes())
                .add("AdminPasswordSecretArn", adminPasswordSecretArn())
                .add("AdminPasswordSecretKmsKeyId", adminPasswordSecretKmsKeyId()).add("AdminUsername", adminUsername())
                .add("BackupProgressInMegaBytes", backupProgressInMegaBytes())
                .add("CurrentBackupRateInMegaBytesPerSecond", currentBackupRateInMegaBytesPerSecond())
                .add("ElapsedTimeInSeconds", elapsedTimeInSeconds())
                .add("EstimatedSecondsToCompletion", estimatedSecondsToCompletion()).add("KmsKeyId", kmsKeyId())
                .add("NamespaceArn", namespaceArn()).add("NamespaceName", namespaceName()).add("OwnerAccount", ownerAccount())
                .add("SnapshotArn", snapshotArn()).add("SnapshotCreateTime", snapshotCreateTime())
                .add("SnapshotName", snapshotName()).add("SnapshotRemainingDays", snapshotRemainingDays())
                .add("SnapshotRetentionPeriod", snapshotRetentionPeriod())
                .add("SnapshotRetentionStartTime", snapshotRetentionStartTime()).add("Status", statusAsString())
                .add("TotalBackupSizeInMegaBytes", totalBackupSizeInMegaBytes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accountsWithProvisionedRestoreAccess":
            return Optional.ofNullable(clazz.cast(accountsWithProvisionedRestoreAccess()));
        case "accountsWithRestoreAccess":
            return Optional.ofNullable(clazz.cast(accountsWithRestoreAccess()));
        case "actualIncrementalBackupSizeInMegaBytes":
            return Optional.ofNullable(clazz.cast(actualIncrementalBackupSizeInMegaBytes()));
        case "adminPasswordSecretArn":
            return Optional.ofNullable(clazz.cast(adminPasswordSecretArn()));
        case "adminPasswordSecretKmsKeyId":
            return Optional.ofNullable(clazz.cast(adminPasswordSecretKmsKeyId()));
        case "adminUsername":
            return Optional.ofNullable(clazz.cast(adminUsername()));
        case "backupProgressInMegaBytes":
            return Optional.ofNullable(clazz.cast(backupProgressInMegaBytes()));
        case "currentBackupRateInMegaBytesPerSecond":
            return Optional.ofNullable(clazz.cast(currentBackupRateInMegaBytesPerSecond()));
        case "elapsedTimeInSeconds":
            return Optional.ofNullable(clazz.cast(elapsedTimeInSeconds()));
        case "estimatedSecondsToCompletion":
            return Optional.ofNullable(clazz.cast(estimatedSecondsToCompletion()));
        case "kmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "namespaceArn":
            return Optional.ofNullable(clazz.cast(namespaceArn()));
        case "namespaceName":
            return Optional.ofNullable(clazz.cast(namespaceName()));
        case "ownerAccount":
            return Optional.ofNullable(clazz.cast(ownerAccount()));
        case "snapshotArn":
            return Optional.ofNullable(clazz.cast(snapshotArn()));
        case "snapshotCreateTime":
            return Optional.ofNullable(clazz.cast(snapshotCreateTime()));
        case "snapshotName":
            return Optional.ofNullable(clazz.cast(snapshotName()));
        case "snapshotRemainingDays":
            return Optional.ofNullable(clazz.cast(snapshotRemainingDays()));
        case "snapshotRetentionPeriod":
            return Optional.ofNullable(clazz.cast(snapshotRetentionPeriod()));
        case "snapshotRetentionStartTime":
            return Optional.ofNullable(clazz.cast(snapshotRetentionStartTime()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "totalBackupSizeInMegaBytes":
            return Optional.ofNullable(clazz.cast(totalBackupSizeInMegaBytes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("accountsWithProvisionedRestoreAccess", ACCOUNTS_WITH_PROVISIONED_RESTORE_ACCESS_FIELD);
        map.put("accountsWithRestoreAccess", ACCOUNTS_WITH_RESTORE_ACCESS_FIELD);
        map.put("actualIncrementalBackupSizeInMegaBytes", ACTUAL_INCREMENTAL_BACKUP_SIZE_IN_MEGA_BYTES_FIELD);
        map.put("adminPasswordSecretArn", ADMIN_PASSWORD_SECRET_ARN_FIELD);
        map.put("adminPasswordSecretKmsKeyId", ADMIN_PASSWORD_SECRET_KMS_KEY_ID_FIELD);
        map.put("adminUsername", ADMIN_USERNAME_FIELD);
        map.put("backupProgressInMegaBytes", BACKUP_PROGRESS_IN_MEGA_BYTES_FIELD);
        map.put("currentBackupRateInMegaBytesPerSecond", CURRENT_BACKUP_RATE_IN_MEGA_BYTES_PER_SECOND_FIELD);
        map.put("elapsedTimeInSeconds", ELAPSED_TIME_IN_SECONDS_FIELD);
        map.put("estimatedSecondsToCompletion", ESTIMATED_SECONDS_TO_COMPLETION_FIELD);
        map.put("kmsKeyId", KMS_KEY_ID_FIELD);
        map.put("namespaceArn", NAMESPACE_ARN_FIELD);
        map.put("namespaceName", NAMESPACE_NAME_FIELD);
        map.put("ownerAccount", OWNER_ACCOUNT_FIELD);
        map.put("snapshotArn", SNAPSHOT_ARN_FIELD);
        map.put("snapshotCreateTime", SNAPSHOT_CREATE_TIME_FIELD);
        map.put("snapshotName", SNAPSHOT_NAME_FIELD);
        map.put("snapshotRemainingDays", SNAPSHOT_REMAINING_DAYS_FIELD);
        map.put("snapshotRetentionPeriod", SNAPSHOT_RETENTION_PERIOD_FIELD);
        map.put("snapshotRetentionStartTime", SNAPSHOT_RETENTION_START_TIME_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("totalBackupSizeInMegaBytes", TOTAL_BACKUP_SIZE_IN_MEGA_BYTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Snapshot, T> g) {
        return obj -> g.apply((Snapshot) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Snapshot> {
        /**
         * <p>
         * All of the Amazon Web Services accounts that have access to restore a snapshot to a provisioned cluster.
         * </p>
         * 
         * @param accountsWithProvisionedRestoreAccess
         *        All of the Amazon Web Services accounts that have access to restore a snapshot to a provisioned
         *        cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountsWithProvisionedRestoreAccess(Collection<String> accountsWithProvisionedRestoreAccess);

        /**
         * <p>
         * All of the Amazon Web Services accounts that have access to restore a snapshot to a provisioned cluster.
         * </p>
         * 
         * @param accountsWithProvisionedRestoreAccess
         *        All of the Amazon Web Services accounts that have access to restore a snapshot to a provisioned
         *        cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountsWithProvisionedRestoreAccess(String... accountsWithProvisionedRestoreAccess);

        /**
         * <p>
         * All of the Amazon Web Services accounts that have access to restore a snapshot to a namespace.
         * </p>
         * 
         * @param accountsWithRestoreAccess
         *        All of the Amazon Web Services accounts that have access to restore a snapshot to a namespace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountsWithRestoreAccess(Collection<String> accountsWithRestoreAccess);

        /**
         * <p>
         * All of the Amazon Web Services accounts that have access to restore a snapshot to a namespace.
         * </p>
         * 
         * @param accountsWithRestoreAccess
         *        All of the Amazon Web Services accounts that have access to restore a snapshot to a namespace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountsWithRestoreAccess(String... accountsWithRestoreAccess);

        /**
         * <p>
         * The size of the incremental backup in megabytes.
         * </p>
         * 
         * @param actualIncrementalBackupSizeInMegaBytes
         *        The size of the incremental backup in megabytes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actualIncrementalBackupSizeInMegaBytes(Double actualIncrementalBackupSizeInMegaBytes);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the namespace's admin user credentials secret.
         * </p>
         * 
         * @param adminPasswordSecretArn
         *        The Amazon Resource Name (ARN) for the namespace's admin user credentials secret.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adminPasswordSecretArn(String adminPasswordSecretArn);

        /**
         * <p>
         * The ID of the Key Management Service (KMS) key used to encrypt and store the namespace's admin credentials
         * secret.
         * </p>
         * 
         * @param adminPasswordSecretKmsKeyId
         *        The ID of the Key Management Service (KMS) key used to encrypt and store the namespace's admin
         *        credentials secret.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adminPasswordSecretKmsKeyId(String adminPasswordSecretKmsKeyId);

        /**
         * <p>
         * The username of the database within a snapshot.
         * </p>
         * 
         * @param adminUsername
         *        The username of the database within a snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adminUsername(String adminUsername);

        /**
         * <p>
         * The size in megabytes of the data that has been backed up to a snapshot.
         * </p>
         * 
         * @param backupProgressInMegaBytes
         *        The size in megabytes of the data that has been backed up to a snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupProgressInMegaBytes(Double backupProgressInMegaBytes);

        /**
         * <p>
         * The rate at which data is backed up into a snapshot in megabytes per second.
         * </p>
         * 
         * @param currentBackupRateInMegaBytesPerSecond
         *        The rate at which data is backed up into a snapshot in megabytes per second.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentBackupRateInMegaBytesPerSecond(Double currentBackupRateInMegaBytesPerSecond);

        /**
         * <p>
         * The amount of time it took to back up data into a snapshot.
         * </p>
         * 
         * @param elapsedTimeInSeconds
         *        The amount of time it took to back up data into a snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elapsedTimeInSeconds(Long elapsedTimeInSeconds);

        /**
         * <p>
         * The estimated amount of seconds until the snapshot completes backup.
         * </p>
         * 
         * @param estimatedSecondsToCompletion
         *        The estimated amount of seconds until the snapshot completes backup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimatedSecondsToCompletion(Long estimatedSecondsToCompletion);

        /**
         * <p>
         * The unique identifier of the KMS key used to encrypt the snapshot.
         * </p>
         * 
         * @param kmsKeyId
         *        The unique identifier of the KMS key used to encrypt the snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the namespace the snapshot was created from.
         * </p>
         * 
         * @param namespaceArn
         *        The Amazon Resource Name (ARN) of the namespace the snapshot was created from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespaceArn(String namespaceArn);

        /**
         * <p>
         * The name of the namepsace.
         * </p>
         * 
         * @param namespaceName
         *        The name of the namepsace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespaceName(String namespaceName);

        /**
         * <p>
         * The owner Amazon Web Services; account of the snapshot.
         * </p>
         * 
         * @param ownerAccount
         *        The owner Amazon Web Services; account of the snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerAccount(String ownerAccount);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the snapshot.
         * </p>
         * 
         * @param snapshotArn
         *        The Amazon Resource Name (ARN) of the snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotArn(String snapshotArn);

        /**
         * <p>
         * The timestamp of when the snapshot was created.
         * </p>
         * 
         * @param snapshotCreateTime
         *        The timestamp of when the snapshot was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotCreateTime(Instant snapshotCreateTime);

        /**
         * <p>
         * The name of the snapshot.
         * </p>
         * 
         * @param snapshotName
         *        The name of the snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotName(String snapshotName);

        /**
         * <p>
         * The amount of days until the snapshot is deleted.
         * </p>
         * 
         * @param snapshotRemainingDays
         *        The amount of days until the snapshot is deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotRemainingDays(Integer snapshotRemainingDays);

        /**
         * <p>
         * The period of time, in days, of how long the snapshot is retained.
         * </p>
         * 
         * @param snapshotRetentionPeriod
         *        The period of time, in days, of how long the snapshot is retained.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotRetentionPeriod(Integer snapshotRetentionPeriod);

        /**
         * <p>
         * The timestamp of when data within the snapshot started getting retained.
         * </p>
         * 
         * @param snapshotRetentionStartTime
         *        The timestamp of when data within the snapshot started getting retained.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotRetentionStartTime(Instant snapshotRetentionStartTime);

        /**
         * <p>
         * The status of the snapshot.
         * </p>
         * 
         * @param status
         *        The status of the snapshot.
         * @see SnapshotStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SnapshotStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the snapshot.
         * </p>
         * 
         * @param status
         *        The status of the snapshot.
         * @see SnapshotStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SnapshotStatus
         */
        Builder status(SnapshotStatus status);

        /**
         * <p>
         * The total size, in megabytes, of how big the snapshot is.
         * </p>
         * 
         * @param totalBackupSizeInMegaBytes
         *        The total size, in megabytes, of how big the snapshot is.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalBackupSizeInMegaBytes(Double totalBackupSizeInMegaBytes);
    }

    static final class BuilderImpl implements Builder {
        private List<String> accountsWithProvisionedRestoreAccess = DefaultSdkAutoConstructList.getInstance();

        private List<String> accountsWithRestoreAccess = DefaultSdkAutoConstructList.getInstance();

        private Double actualIncrementalBackupSizeInMegaBytes;

        private String adminPasswordSecretArn;

        private String adminPasswordSecretKmsKeyId;

        private String adminUsername;

        private Double backupProgressInMegaBytes;

        private Double currentBackupRateInMegaBytesPerSecond;

        private Long elapsedTimeInSeconds;

        private Long estimatedSecondsToCompletion;

        private String kmsKeyId;

        private String namespaceArn;

        private String namespaceName;

        private String ownerAccount;

        private String snapshotArn;

        private Instant snapshotCreateTime;

        private String snapshotName;

        private Integer snapshotRemainingDays;

        private Integer snapshotRetentionPeriod;

        private Instant snapshotRetentionStartTime;

        private String status;

        private Double totalBackupSizeInMegaBytes;

        private BuilderImpl() {
        }

        private BuilderImpl(Snapshot model) {
            accountsWithProvisionedRestoreAccess(model.accountsWithProvisionedRestoreAccess);
            accountsWithRestoreAccess(model.accountsWithRestoreAccess);
            actualIncrementalBackupSizeInMegaBytes(model.actualIncrementalBackupSizeInMegaBytes);
            adminPasswordSecretArn(model.adminPasswordSecretArn);
            adminPasswordSecretKmsKeyId(model.adminPasswordSecretKmsKeyId);
            adminUsername(model.adminUsername);
            backupProgressInMegaBytes(model.backupProgressInMegaBytes);
            currentBackupRateInMegaBytesPerSecond(model.currentBackupRateInMegaBytesPerSecond);
            elapsedTimeInSeconds(model.elapsedTimeInSeconds);
            estimatedSecondsToCompletion(model.estimatedSecondsToCompletion);
            kmsKeyId(model.kmsKeyId);
            namespaceArn(model.namespaceArn);
            namespaceName(model.namespaceName);
            ownerAccount(model.ownerAccount);
            snapshotArn(model.snapshotArn);
            snapshotCreateTime(model.snapshotCreateTime);
            snapshotName(model.snapshotName);
            snapshotRemainingDays(model.snapshotRemainingDays);
            snapshotRetentionPeriod(model.snapshotRetentionPeriod);
            snapshotRetentionStartTime(model.snapshotRetentionStartTime);
            status(model.status);
            totalBackupSizeInMegaBytes(model.totalBackupSizeInMegaBytes);
        }

        public final Collection<String> getAccountsWithProvisionedRestoreAccess() {
            if (accountsWithProvisionedRestoreAccess instanceof SdkAutoConstructList) {
                return null;
            }
            return accountsWithProvisionedRestoreAccess;
        }

        public final void setAccountsWithProvisionedRestoreAccess(Collection<String> accountsWithProvisionedRestoreAccess) {
            this.accountsWithProvisionedRestoreAccess = AccountIdListCopier.copy(accountsWithProvisionedRestoreAccess);
        }

        @Override
        public final Builder accountsWithProvisionedRestoreAccess(Collection<String> accountsWithProvisionedRestoreAccess) {
            this.accountsWithProvisionedRestoreAccess = AccountIdListCopier.copy(accountsWithProvisionedRestoreAccess);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountsWithProvisionedRestoreAccess(String... accountsWithProvisionedRestoreAccess) {
            accountsWithProvisionedRestoreAccess(Arrays.asList(accountsWithProvisionedRestoreAccess));
            return this;
        }

        public final Collection<String> getAccountsWithRestoreAccess() {
            if (accountsWithRestoreAccess instanceof SdkAutoConstructList) {
                return null;
            }
            return accountsWithRestoreAccess;
        }

        public final void setAccountsWithRestoreAccess(Collection<String> accountsWithRestoreAccess) {
            this.accountsWithRestoreAccess = AccountIdListCopier.copy(accountsWithRestoreAccess);
        }

        @Override
        public final Builder accountsWithRestoreAccess(Collection<String> accountsWithRestoreAccess) {
            this.accountsWithRestoreAccess = AccountIdListCopier.copy(accountsWithRestoreAccess);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountsWithRestoreAccess(String... accountsWithRestoreAccess) {
            accountsWithRestoreAccess(Arrays.asList(accountsWithRestoreAccess));
            return this;
        }

        public final Double getActualIncrementalBackupSizeInMegaBytes() {
            return actualIncrementalBackupSizeInMegaBytes;
        }

        public final void setActualIncrementalBackupSizeInMegaBytes(Double actualIncrementalBackupSizeInMegaBytes) {
            this.actualIncrementalBackupSizeInMegaBytes = actualIncrementalBackupSizeInMegaBytes;
        }

        @Override
        public final Builder actualIncrementalBackupSizeInMegaBytes(Double actualIncrementalBackupSizeInMegaBytes) {
            this.actualIncrementalBackupSizeInMegaBytes = actualIncrementalBackupSizeInMegaBytes;
            return this;
        }

        public final String getAdminPasswordSecretArn() {
            return adminPasswordSecretArn;
        }

        public final void setAdminPasswordSecretArn(String adminPasswordSecretArn) {
            this.adminPasswordSecretArn = adminPasswordSecretArn;
        }

        @Override
        public final Builder adminPasswordSecretArn(String adminPasswordSecretArn) {
            this.adminPasswordSecretArn = adminPasswordSecretArn;
            return this;
        }

        public final String getAdminPasswordSecretKmsKeyId() {
            return adminPasswordSecretKmsKeyId;
        }

        public final void setAdminPasswordSecretKmsKeyId(String adminPasswordSecretKmsKeyId) {
            this.adminPasswordSecretKmsKeyId = adminPasswordSecretKmsKeyId;
        }

        @Override
        public final Builder adminPasswordSecretKmsKeyId(String adminPasswordSecretKmsKeyId) {
            this.adminPasswordSecretKmsKeyId = adminPasswordSecretKmsKeyId;
            return this;
        }

        public final String getAdminUsername() {
            return adminUsername;
        }

        public final void setAdminUsername(String adminUsername) {
            this.adminUsername = adminUsername;
        }

        @Override
        public final Builder adminUsername(String adminUsername) {
            this.adminUsername = adminUsername;
            return this;
        }

        public final Double getBackupProgressInMegaBytes() {
            return backupProgressInMegaBytes;
        }

        public final void setBackupProgressInMegaBytes(Double backupProgressInMegaBytes) {
            this.backupProgressInMegaBytes = backupProgressInMegaBytes;
        }

        @Override
        public final Builder backupProgressInMegaBytes(Double backupProgressInMegaBytes) {
            this.backupProgressInMegaBytes = backupProgressInMegaBytes;
            return this;
        }

        public final Double getCurrentBackupRateInMegaBytesPerSecond() {
            return currentBackupRateInMegaBytesPerSecond;
        }

        public final void setCurrentBackupRateInMegaBytesPerSecond(Double currentBackupRateInMegaBytesPerSecond) {
            this.currentBackupRateInMegaBytesPerSecond = currentBackupRateInMegaBytesPerSecond;
        }

        @Override
        public final Builder currentBackupRateInMegaBytesPerSecond(Double currentBackupRateInMegaBytesPerSecond) {
            this.currentBackupRateInMegaBytesPerSecond = currentBackupRateInMegaBytesPerSecond;
            return this;
        }

        public final Long getElapsedTimeInSeconds() {
            return elapsedTimeInSeconds;
        }

        public final void setElapsedTimeInSeconds(Long elapsedTimeInSeconds) {
            this.elapsedTimeInSeconds = elapsedTimeInSeconds;
        }

        @Override
        public final Builder elapsedTimeInSeconds(Long elapsedTimeInSeconds) {
            this.elapsedTimeInSeconds = elapsedTimeInSeconds;
            return this;
        }

        public final Long getEstimatedSecondsToCompletion() {
            return estimatedSecondsToCompletion;
        }

        public final void setEstimatedSecondsToCompletion(Long estimatedSecondsToCompletion) {
            this.estimatedSecondsToCompletion = estimatedSecondsToCompletion;
        }

        @Override
        public final Builder estimatedSecondsToCompletion(Long estimatedSecondsToCompletion) {
            this.estimatedSecondsToCompletion = estimatedSecondsToCompletion;
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getNamespaceArn() {
            return namespaceArn;
        }

        public final void setNamespaceArn(String namespaceArn) {
            this.namespaceArn = namespaceArn;
        }

        @Override
        public final Builder namespaceArn(String namespaceArn) {
            this.namespaceArn = namespaceArn;
            return this;
        }

        public final String getNamespaceName() {
            return namespaceName;
        }

        public final void setNamespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
        }

        @Override
        public final Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public final String getOwnerAccount() {
            return ownerAccount;
        }

        public final void setOwnerAccount(String ownerAccount) {
            this.ownerAccount = ownerAccount;
        }

        @Override
        public final Builder ownerAccount(String ownerAccount) {
            this.ownerAccount = ownerAccount;
            return this;
        }

        public final String getSnapshotArn() {
            return snapshotArn;
        }

        public final void setSnapshotArn(String snapshotArn) {
            this.snapshotArn = snapshotArn;
        }

        @Override
        public final Builder snapshotArn(String snapshotArn) {
            this.snapshotArn = snapshotArn;
            return this;
        }

        public final Instant getSnapshotCreateTime() {
            return snapshotCreateTime;
        }

        public final void setSnapshotCreateTime(Instant snapshotCreateTime) {
            this.snapshotCreateTime = snapshotCreateTime;
        }

        @Override
        public final Builder snapshotCreateTime(Instant snapshotCreateTime) {
            this.snapshotCreateTime = snapshotCreateTime;
            return this;
        }

        public final String getSnapshotName() {
            return snapshotName;
        }

        public final void setSnapshotName(String snapshotName) {
            this.snapshotName = snapshotName;
        }

        @Override
        public final Builder snapshotName(String snapshotName) {
            this.snapshotName = snapshotName;
            return this;
        }

        public final Integer getSnapshotRemainingDays() {
            return snapshotRemainingDays;
        }

        public final void setSnapshotRemainingDays(Integer snapshotRemainingDays) {
            this.snapshotRemainingDays = snapshotRemainingDays;
        }

        @Override
        public final Builder snapshotRemainingDays(Integer snapshotRemainingDays) {
            this.snapshotRemainingDays = snapshotRemainingDays;
            return this;
        }

        public final Integer getSnapshotRetentionPeriod() {
            return snapshotRetentionPeriod;
        }

        public final void setSnapshotRetentionPeriod(Integer snapshotRetentionPeriod) {
            this.snapshotRetentionPeriod = snapshotRetentionPeriod;
        }

        @Override
        public final Builder snapshotRetentionPeriod(Integer snapshotRetentionPeriod) {
            this.snapshotRetentionPeriod = snapshotRetentionPeriod;
            return this;
        }

        public final Instant getSnapshotRetentionStartTime() {
            return snapshotRetentionStartTime;
        }

        public final void setSnapshotRetentionStartTime(Instant snapshotRetentionStartTime) {
            this.snapshotRetentionStartTime = snapshotRetentionStartTime;
        }

        @Override
        public final Builder snapshotRetentionStartTime(Instant snapshotRetentionStartTime) {
            this.snapshotRetentionStartTime = snapshotRetentionStartTime;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SnapshotStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Double getTotalBackupSizeInMegaBytes() {
            return totalBackupSizeInMegaBytes;
        }

        public final void setTotalBackupSizeInMegaBytes(Double totalBackupSizeInMegaBytes) {
            this.totalBackupSizeInMegaBytes = totalBackupSizeInMegaBytes;
        }

        @Override
        public final Builder totalBackupSizeInMegaBytes(Double totalBackupSizeInMegaBytes) {
            this.totalBackupSizeInMegaBytes = totalBackupSizeInMegaBytes;
            return this;
        }

        @Override
        public Snapshot build() {
            return new Snapshot(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
