/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.regions.servicemetadata;

import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.utils.ImmutableMap;

@SdkPublicApi
public final class NeptuneServiceMetadata
implements ServiceMetadata {
    private static final String ENDPOINT_PREFIX = "neptune";
    private static final Map<String, String> PARTITION_OVERRIDDEN_ENDPOINTS = ImmutableMap.builder().build();
    private static final Map<String, String> REGION_OVERRIDDEN_ENDPOINTS = ImmutableMap.builder().put((Object)"ap-northeast-1", (Object)"rds.ap-northeast-1.amazonaws.com").put((Object)"ap-northeast-2", (Object)"rds.ap-northeast-2.amazonaws.com").put((Object)"ap-south-1", (Object)"rds.ap-south-1.amazonaws.com").put((Object)"ap-southeast-1", (Object)"rds.ap-southeast-1.amazonaws.com").put((Object)"ap-southeast-2", (Object)"rds.ap-southeast-2.amazonaws.com").put((Object)"ca-central-1", (Object)"rds.ca-central-1.amazonaws.com").put((Object)"eu-central-1", (Object)"rds.eu-central-1.amazonaws.com").put((Object)"eu-north-1", (Object)"rds.eu-north-1.amazonaws.com").put((Object)"eu-west-1", (Object)"rds.eu-west-1.amazonaws.com").put((Object)"eu-west-2", (Object)"rds.eu-west-2.amazonaws.com").put((Object)"me-south-1", (Object)"rds.me-south-1.amazonaws.com").put((Object)"us-east-1", (Object)"rds.us-east-1.amazonaws.com").put((Object)"us-east-2", (Object)"rds.us-east-2.amazonaws.com").put((Object)"us-west-2", (Object)"rds.us-west-2.amazonaws.com").put((Object)"cn-northwest-1", (Object)"rds.cn-northwest-1.amazonaws.com.cn").put((Object)"us-gov-east-1", (Object)"rds.us-gov-east-1.amazonaws.com").put((Object)"us-gov-west-1", (Object)"rds.us-gov-west-1.amazonaws.com").build();
    private static final List<Region> REGIONS = Collections.unmodifiableList(Arrays.asList(Region.of("ap-northeast-1"), Region.of("ap-northeast-2"), Region.of("ap-south-1"), Region.of("ap-southeast-1"), Region.of("ap-southeast-2"), Region.of("ca-central-1"), Region.of("eu-central-1"), Region.of("eu-north-1"), Region.of("eu-west-1"), Region.of("eu-west-2"), Region.of("me-south-1"), Region.of("us-east-1"), Region.of("us-east-2"), Region.of("us-west-2"), Region.of("cn-northwest-1"), Region.of("us-gov-east-1"), Region.of("us-gov-west-1")));
    private static final Map<String, String> SIGNING_REGION_OVERRIDES = ImmutableMap.builder().put((Object)"ap-northeast-1", (Object)"ap-northeast-1").put((Object)"ap-northeast-2", (Object)"ap-northeast-2").put((Object)"ap-south-1", (Object)"ap-south-1").put((Object)"ap-southeast-1", (Object)"ap-southeast-1").put((Object)"ap-southeast-2", (Object)"ap-southeast-2").put((Object)"ca-central-1", (Object)"ca-central-1").put((Object)"eu-central-1", (Object)"eu-central-1").put((Object)"eu-north-1", (Object)"eu-north-1").put((Object)"eu-west-1", (Object)"eu-west-1").put((Object)"eu-west-2", (Object)"eu-west-2").put((Object)"me-south-1", (Object)"me-south-1").put((Object)"us-east-1", (Object)"us-east-1").put((Object)"us-east-2", (Object)"us-east-2").put((Object)"us-west-2", (Object)"us-west-2").put((Object)"cn-northwest-1", (Object)"cn-northwest-1").put((Object)"us-gov-east-1", (Object)"us-gov-east-1").put((Object)"us-gov-west-1", (Object)"us-gov-west-1").build();

    @Override
    public List<Region> regions() {
        return REGIONS;
    }

    @Override
    public URI endpointFor(Region region) {
        return URI.create(REGION_OVERRIDDEN_ENDPOINTS.containsKey(region.id()) ? REGION_OVERRIDDEN_ENDPOINTS.get(region.id()) : this.computeEndpoint(ENDPOINT_PREFIX, PARTITION_OVERRIDDEN_ENDPOINTS, region));
    }

    @Override
    public Region signingRegion(Region region) {
        return Region.of(SIGNING_REGION_OVERRIDES.getOrDefault(region.id(), region.id()));
    }
}

