/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.regions.servicemetadata;

import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.regions.ServicePartitionMetadata;
import software.amazon.awssdk.regions.internal.DefaultServicePartitionMetadata;
import software.amazon.awssdk.utils.ImmutableMap;

@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
public final class ElasticfilesystemServiceMetadata implements ServiceMetadata {
    private static final String ENDPOINT_PREFIX = "elasticfilesystem";

    private static final Map<String, String> PARTITION_OVERRIDDEN_ENDPOINTS = ImmutableMap.<String, String> builder().build();

    private static final Map<String, String> REGION_OVERRIDDEN_ENDPOINTS = ImmutableMap.<String, String> builder()
            .put("fips-ap-east-1", "elasticfilesystem-fips.ap-east-1.amazonaws.com")
            .put("fips-ap-northeast-1", "elasticfilesystem-fips.ap-northeast-1.amazonaws.com")
            .put("fips-ap-northeast-2", "elasticfilesystem-fips.ap-northeast-2.amazonaws.com")
            .put("fips-ap-south-1", "elasticfilesystem-fips.ap-south-1.amazonaws.com")
            .put("fips-ap-southeast-1", "elasticfilesystem-fips.ap-southeast-1.amazonaws.com")
            .put("fips-ap-southeast-2", "elasticfilesystem-fips.ap-southeast-2.amazonaws.com")
            .put("fips-ca-central-1", "elasticfilesystem-fips.ca-central-1.amazonaws.com")
            .put("fips-eu-central-1", "elasticfilesystem-fips.eu-central-1.amazonaws.com")
            .put("fips-eu-north-1", "elasticfilesystem-fips.eu-north-1.amazonaws.com")
            .put("fips-eu-west-1", "elasticfilesystem-fips.eu-west-1.amazonaws.com")
            .put("fips-eu-west-2", "elasticfilesystem-fips.eu-west-2.amazonaws.com")
            .put("fips-eu-west-3", "elasticfilesystem-fips.eu-west-3.amazonaws.com")
            .put("fips-me-south-1", "elasticfilesystem-fips.me-south-1.amazonaws.com")
            .put("fips-sa-east-1", "elasticfilesystem-fips.sa-east-1.amazonaws.com")
            .put("fips-us-east-1", "elasticfilesystem-fips.us-east-1.amazonaws.com")
            .put("fips-us-east-2", "elasticfilesystem-fips.us-east-2.amazonaws.com")
            .put("fips-us-west-1", "elasticfilesystem-fips.us-west-1.amazonaws.com")
            .put("fips-us-west-2", "elasticfilesystem-fips.us-west-2.amazonaws.com")
            .put("fips-cn-north-1", "elasticfilesystem-fips.cn-north-1.amazonaws.com.cn")
            .put("fips-cn-northwest-1", "elasticfilesystem-fips.cn-northwest-1.amazonaws.com.cn")
            .put("fips-us-gov-east-1", "elasticfilesystem-fips.us-gov-east-1.amazonaws.com")
            .put("fips-us-gov-west-1", "elasticfilesystem-fips.us-gov-west-1.amazonaws.com").build();

    private static final List<Region> REGIONS = Collections.unmodifiableList(Arrays.asList(Region.of("ap-east-1"),
            Region.of("ap-northeast-1"), Region.of("ap-northeast-2"), Region.of("ap-south-1"), Region.of("ap-southeast-1"),
            Region.of("ap-southeast-2"), Region.of("ca-central-1"), Region.of("eu-central-1"), Region.of("eu-north-1"),
            Region.of("eu-west-1"), Region.of("eu-west-2"), Region.of("eu-west-3"), Region.of("fips-ap-east-1"),
            Region.of("fips-ap-northeast-1"), Region.of("fips-ap-northeast-2"), Region.of("fips-ap-south-1"),
            Region.of("fips-ap-southeast-1"), Region.of("fips-ap-southeast-2"), Region.of("fips-ca-central-1"),
            Region.of("fips-eu-central-1"), Region.of("fips-eu-north-1"), Region.of("fips-eu-west-1"),
            Region.of("fips-eu-west-2"), Region.of("fips-eu-west-3"), Region.of("fips-me-south-1"), Region.of("fips-sa-east-1"),
            Region.of("fips-us-east-1"), Region.of("fips-us-east-2"), Region.of("fips-us-west-1"), Region.of("fips-us-west-2"),
            Region.of("me-south-1"), Region.of("sa-east-1"), Region.of("us-east-1"), Region.of("us-east-2"),
            Region.of("us-west-1"), Region.of("us-west-2"), Region.of("cn-north-1"), Region.of("cn-northwest-1"),
            Region.of("fips-cn-north-1"), Region.of("fips-cn-northwest-1"), Region.of("fips-us-gov-east-1"),
            Region.of("fips-us-gov-west-1"), Region.of("us-gov-east-1"), Region.of("us-gov-west-1")));

    private static final Map<String, String> SIGNING_REGION_OVERRIDES = ImmutableMap.<String, String> builder()
            .put("fips-ap-east-1", "ap-east-1").put("fips-ap-northeast-1", "ap-northeast-1")
            .put("fips-ap-northeast-2", "ap-northeast-2").put("fips-ap-south-1", "ap-south-1")
            .put("fips-ap-southeast-1", "ap-southeast-1").put("fips-ap-southeast-2", "ap-southeast-2")
            .put("fips-ca-central-1", "ca-central-1").put("fips-eu-central-1", "eu-central-1")
            .put("fips-eu-north-1", "eu-north-1").put("fips-eu-west-1", "eu-west-1").put("fips-eu-west-2", "eu-west-2")
            .put("fips-eu-west-3", "eu-west-3").put("fips-me-south-1", "me-south-1").put("fips-sa-east-1", "sa-east-1")
            .put("fips-us-east-1", "us-east-1").put("fips-us-east-2", "us-east-2").put("fips-us-west-1", "us-west-1")
            .put("fips-us-west-2", "us-west-2").put("fips-cn-north-1", "cn-north-1").put("fips-cn-northwest-1", "cn-northwest-1")
            .put("fips-us-gov-east-1", "us-gov-east-1").put("fips-us-gov-west-1", "us-gov-west-1").build();

    private static final List<ServicePartitionMetadata> PARTITIONS = Collections.unmodifiableList(Arrays.asList(
            new DefaultServicePartitionMetadata("aws", null), new DefaultServicePartitionMetadata("aws-cn", null),
            new DefaultServicePartitionMetadata("aws-us-gov", null)));

    @Override
    public List<Region> regions() {
        return REGIONS;
    }

    @Override
    public URI endpointFor(Region region) {
        return URI.create(REGION_OVERRIDDEN_ENDPOINTS.containsKey(region.id()) ? REGION_OVERRIDDEN_ENDPOINTS.get(region.id())
                : computeEndpoint(ENDPOINT_PREFIX, PARTITION_OVERRIDDEN_ENDPOINTS, region));
    }

    @Override
    public Region signingRegion(Region region) {
        return Region.of(SIGNING_REGION_OVERRIDES.getOrDefault(region.id(), region.id()));
    }

    @Override
    public List<ServicePartitionMetadata> servicePartitions() {
        return PARTITIONS;
    }
}
