/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.regions.servicemetadata;

import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.regions.EndpointTag;
import software.amazon.awssdk.regions.PartitionEndpointKey;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.regions.ServiceEndpointKey;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.regions.ServicePartitionMetadata;
import software.amazon.awssdk.regions.internal.DefaultServicePartitionMetadata;
import software.amazon.awssdk.regions.internal.util.ServiceMetadataUtils;
import software.amazon.awssdk.utils.ImmutableMap;
import software.amazon.awssdk.utils.Pair;

@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
public final class InternetmonitorServiceMetadata implements ServiceMetadata {
    private static final String ENDPOINT_PREFIX = "internetmonitor";

    private static final List<Region> REGIONS = Collections.unmodifiableList(Arrays.asList(Region.of("ap-northeast-3"),
            Region.of("ap-south-2"), Region.of("ap-southeast-3"), Region.of("ap-southeast-4"), Region.of("eu-central-2"),
            Region.of("eu-south-2"), Region.of("me-central-1"), Region.of("cn-north-1"), Region.of("cn-northwest-1"),
            Region.of("us-gov-east-1"), Region.of("us-gov-west-1")));

    private static final List<ServicePartitionMetadata> PARTITIONS = Collections.unmodifiableList(Arrays.asList(
            new DefaultServicePartitionMetadata("aws", null), new DefaultServicePartitionMetadata("aws-cn", null),
            new DefaultServicePartitionMetadata("aws-us-gov", null)));

    private static final Map<ServiceEndpointKey, String> SIGNING_REGIONS_BY_REGION = ImmutableMap
            .<ServiceEndpointKey, String> builder().build();

    private static final Map<Pair<String, PartitionEndpointKey>, String> SIGNING_REGIONS_BY_PARTITION = ImmutableMap
            .<Pair<String, PartitionEndpointKey>, String> builder().build();

    private static final Map<ServiceEndpointKey, String> DNS_SUFFIXES_BY_REGION = ImmutableMap
            .<ServiceEndpointKey, String> builder().build();

    private static final Map<Pair<String, PartitionEndpointKey>, String> DNS_SUFFIXES_BY_PARTITION = ImmutableMap
            .<Pair<String, PartitionEndpointKey>, String> builder()
            .put(Pair.of("aws", PartitionEndpointKey.builder().tags(EndpointTag.of("fips")).build()), "api.aws")
            .put(Pair.of("aws-cn", PartitionEndpointKey.builder().tags(EndpointTag.of("fips")).build()),
                    "api.amazonwebservices.com.cn")
            .put(Pair.of("aws-us-gov", PartitionEndpointKey.builder().tags(EndpointTag.of("fips")).build()), "api.aws").build();

    private static final Map<ServiceEndpointKey, String> HOSTNAMES_BY_REGION = ImmutableMap
            .<ServiceEndpointKey, String> builder()
            .put(ServiceEndpointKey.builder().region(Region.of("ap-northeast-3")).build(),
                    "internetmonitor.ap-northeast-3.api.aws")
            .put(ServiceEndpointKey.builder().region(Region.of("ap-south-2")).build(), "internetmonitor.ap-south-2.api.aws")
            .put(ServiceEndpointKey.builder().region(Region.of("ap-southeast-3")).build(),
                    "internetmonitor.ap-southeast-3.api.aws")
            .put(ServiceEndpointKey.builder().region(Region.of("ap-southeast-4")).build(),
                    "internetmonitor.ap-southeast-4.api.aws")
            .put(ServiceEndpointKey.builder().region(Region.of("eu-central-2")).build(), "internetmonitor.eu-central-2.api.aws")
            .put(ServiceEndpointKey.builder().region(Region.of("eu-south-2")).build(), "internetmonitor.eu-south-2.api.aws")
            .put(ServiceEndpointKey.builder().region(Region.of("me-central-1")).build(), "internetmonitor.me-central-1.api.aws")
            .put(ServiceEndpointKey.builder().region(Region.of("cn-north-1")).build(),
                    "internetmonitor.cn-north-1.api.amazonwebservices.com.cn")
            .put(ServiceEndpointKey.builder().region(Region.of("cn-northwest-1")).build(),
                    "internetmonitor.cn-northwest-1.api.amazonwebservices.com.cn")
            .put(ServiceEndpointKey.builder().region(Region.of("us-gov-east-1")).build(), "internetmonitor.us-gov-east-1.api.aws")
            .put(ServiceEndpointKey.builder().region(Region.of("us-gov-west-1")).build(), "internetmonitor.us-gov-west-1.api.aws")
            .build();

    private static final Map<Pair<String, PartitionEndpointKey>, String> HOSTNAMES_BY_PARTITION = ImmutableMap
            .<Pair<String, PartitionEndpointKey>, String> builder()
            .put(Pair.of("aws", PartitionEndpointKey.builder().tags(EndpointTag.of("fips")).build()),
                    "{service}-fips.{region}.{dnsSuffix}")
            .put(Pair.of("aws-cn", PartitionEndpointKey.builder().tags(EndpointTag.of("fips")).build()),
                    "{service}-fips.{region}.{dnsSuffix}")
            .put(Pair.of("aws-us-gov", PartitionEndpointKey.builder().tags(EndpointTag.of("fips")).build()),
                    "{service}-fips.{region}.{dnsSuffix}").build();

    @Override
    public List<Region> regions() {
        return REGIONS;
    }

    @Override
    public List<ServicePartitionMetadata> servicePartitions() {
        return PARTITIONS;
    }

    @Override
    public URI endpointFor(ServiceEndpointKey key) {
        return ServiceMetadataUtils.endpointFor(ServiceMetadataUtils.hostname(key, HOSTNAMES_BY_REGION, HOSTNAMES_BY_PARTITION),
                ENDPOINT_PREFIX, key.region().id(),
                ServiceMetadataUtils.dnsSuffix(key, DNS_SUFFIXES_BY_REGION, DNS_SUFFIXES_BY_PARTITION));
    }

    @Override
    public Region signingRegion(ServiceEndpointKey key) {
        return ServiceMetadataUtils.signingRegion(key, SIGNING_REGIONS_BY_REGION, SIGNING_REGIONS_BY_PARTITION);
    }
}
