/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class CompareFacesResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<CompareFacesResponse.Builder, CompareFacesResponse> {
    private final ComparedSourceImageFace sourceImageFace;

    private final List<CompareFacesMatch> faceMatches;

    private final List<ComparedFace> unmatchedFaces;

    private final String sourceImageOrientationCorrection;

    private final String targetImageOrientationCorrection;

    private CompareFacesResponse(BuilderImpl builder) {
        this.sourceImageFace = builder.sourceImageFace;
        this.faceMatches = builder.faceMatches;
        this.unmatchedFaces = builder.unmatchedFaces;
        this.sourceImageOrientationCorrection = builder.sourceImageOrientationCorrection;
        this.targetImageOrientationCorrection = builder.targetImageOrientationCorrection;
    }

    /**
     * <p>
     * The face in the source image that was used for comparison.
     * </p>
     * 
     * @return The face in the source image that was used for comparison.
     */
    public ComparedSourceImageFace sourceImageFace() {
        return sourceImageFace;
    }

    /**
     * <p>
     * An array of faces in the target image that match the source image face. Each <code>CompareFacesMatch</code>
     * object provides the bounding box, the confidence level that the bounding box contains a face, and the similarity
     * score for the face in the bounding box and the face in the source image.
     * </p>
     * 
     * @return An array of faces in the target image that match the source image face. Each
     *         <code>CompareFacesMatch</code> object provides the bounding box, the confidence level that the bounding
     *         box contains a face, and the similarity score for the face in the bounding box and the face in the source
     *         image.
     */
    public List<CompareFacesMatch> faceMatches() {
        return faceMatches;
    }

    /**
     * <p>
     * An array of faces in the target image that did not match the source image face.
     * </p>
     * 
     * @return An array of faces in the target image that did not match the source image face.
     */
    public List<ComparedFace> unmatchedFaces() {
        return unmatchedFaces;
    }

    /**
     * <p>
     * The orientation of the source image (counterclockwise direction). If your application displays the source image,
     * you can use this value to correct image orientation. The bounding box coordinates returned in
     * <code>SourceImageFace</code> represent the location of the face before the image orientation is corrected.
     * </p>
     * <note>
     * <p>
     * If the source image is in .jpeg format, it might contain exchangeable image (Exif) metadata that includes the
     * image's orientation. If the Exif metadata for the source image populates the orientation field, the value of
     * <code>OrientationCorrection</code> is null and the <code>SourceImageFace</code> bounding box coordinates
     * represent the location of the face after Exif metadata is used to correct the orientation. Images in .png format
     * don't contain Exif metadata.
     * </p>
     * </note>
     * 
     * @return The orientation of the source image (counterclockwise direction). If your application displays the source
     *         image, you can use this value to correct image orientation. The bounding box coordinates returned in
     *         <code>SourceImageFace</code> represent the location of the face before the image orientation is
     *         corrected. </p> <note>
     *         <p>
     *         If the source image is in .jpeg format, it might contain exchangeable image (Exif) metadata that includes
     *         the image's orientation. If the Exif metadata for the source image populates the orientation field, the
     *         value of <code>OrientationCorrection</code> is null and the <code>SourceImageFace</code> bounding box
     *         coordinates represent the location of the face after Exif metadata is used to correct the orientation.
     *         Images in .png format don't contain Exif metadata.
     *         </p>
     * @see OrientationCorrection
     */
    public String sourceImageOrientationCorrection() {
        return sourceImageOrientationCorrection;
    }

    /**
     * <p>
     * The orientation of the target image (in counterclockwise direction). If your application displays the target
     * image, you can use this value to correct the orientation of the image. The bounding box coordinates returned in
     * <code>FaceMatches</code> and <code>UnmatchedFaces</code> represent face locations before the image orientation is
     * corrected.
     * </p>
     * <note>
     * <p>
     * If the target image is in .jpg format, it might contain Exif metadata that includes the orientation of the image.
     * If the Exif metadata for the target image populates the orientation field, the value of
     * <code>OrientationCorrection</code> is null and the bounding box coordinates in <code>FaceMatches</code> and
     * <code>UnmatchedFaces</code> represent the location of the face after Exif metadata is used to correct the
     * orientation. Images in .png format don't contain Exif metadata.
     * </p>
     * </note>
     * 
     * @return The orientation of the target image (in counterclockwise direction). If your application displays the
     *         target image, you can use this value to correct the orientation of the image. The bounding box
     *         coordinates returned in <code>FaceMatches</code> and <code>UnmatchedFaces</code> represent face locations
     *         before the image orientation is corrected. </p> <note>
     *         <p>
     *         If the target image is in .jpg format, it might contain Exif metadata that includes the orientation of
     *         the image. If the Exif metadata for the target image populates the orientation field, the value of
     *         <code>OrientationCorrection</code> is null and the bounding box coordinates in <code>FaceMatches</code>
     *         and <code>UnmatchedFaces</code> represent the location of the face after Exif metadata is used to correct
     *         the orientation. Images in .png format don't contain Exif metadata.
     *         </p>
     * @see OrientationCorrection
     */
    public String targetImageOrientationCorrection() {
        return targetImageOrientationCorrection;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((sourceImageFace() == null) ? 0 : sourceImageFace().hashCode());
        hashCode = 31 * hashCode + ((faceMatches() == null) ? 0 : faceMatches().hashCode());
        hashCode = 31 * hashCode + ((unmatchedFaces() == null) ? 0 : unmatchedFaces().hashCode());
        hashCode = 31 * hashCode
                + ((sourceImageOrientationCorrection() == null) ? 0 : sourceImageOrientationCorrection().hashCode());
        hashCode = 31 * hashCode
                + ((targetImageOrientationCorrection() == null) ? 0 : targetImageOrientationCorrection().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CompareFacesResponse)) {
            return false;
        }
        CompareFacesResponse other = (CompareFacesResponse) obj;
        if (other.sourceImageFace() == null ^ this.sourceImageFace() == null) {
            return false;
        }
        if (other.sourceImageFace() != null && !other.sourceImageFace().equals(this.sourceImageFace())) {
            return false;
        }
        if (other.faceMatches() == null ^ this.faceMatches() == null) {
            return false;
        }
        if (other.faceMatches() != null && !other.faceMatches().equals(this.faceMatches())) {
            return false;
        }
        if (other.unmatchedFaces() == null ^ this.unmatchedFaces() == null) {
            return false;
        }
        if (other.unmatchedFaces() != null && !other.unmatchedFaces().equals(this.unmatchedFaces())) {
            return false;
        }
        if (other.sourceImageOrientationCorrection() == null ^ this.sourceImageOrientationCorrection() == null) {
            return false;
        }
        if (other.sourceImageOrientationCorrection() != null
                && !other.sourceImageOrientationCorrection().equals(this.sourceImageOrientationCorrection())) {
            return false;
        }
        if (other.targetImageOrientationCorrection() == null ^ this.targetImageOrientationCorrection() == null) {
            return false;
        }
        if (other.targetImageOrientationCorrection() != null
                && !other.targetImageOrientationCorrection().equals(this.targetImageOrientationCorrection())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (sourceImageFace() != null) {
            sb.append("SourceImageFace: ").append(sourceImageFace()).append(",");
        }
        if (faceMatches() != null) {
            sb.append("FaceMatches: ").append(faceMatches()).append(",");
        }
        if (unmatchedFaces() != null) {
            sb.append("UnmatchedFaces: ").append(unmatchedFaces()).append(",");
        }
        if (sourceImageOrientationCorrection() != null) {
            sb.append("SourceImageOrientationCorrection: ").append(sourceImageOrientationCorrection()).append(",");
        }
        if (targetImageOrientationCorrection() != null) {
            sb.append("TargetImageOrientationCorrection: ").append(targetImageOrientationCorrection()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, CompareFacesResponse> {
        /**
         * <p>
         * The face in the source image that was used for comparison.
         * </p>
         * 
         * @param sourceImageFace
         *        The face in the source image that was used for comparison.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceImageFace(ComparedSourceImageFace sourceImageFace);

        /**
         * <p>
         * An array of faces in the target image that match the source image face. Each <code>CompareFacesMatch</code>
         * object provides the bounding box, the confidence level that the bounding box contains a face, and the
         * similarity score for the face in the bounding box and the face in the source image.
         * </p>
         * 
         * @param faceMatches
         *        An array of faces in the target image that match the source image face. Each
         *        <code>CompareFacesMatch</code> object provides the bounding box, the confidence level that the
         *        bounding box contains a face, and the similarity score for the face in the bounding box and the face
         *        in the source image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder faceMatches(Collection<CompareFacesMatch> faceMatches);

        /**
         * <p>
         * An array of faces in the target image that match the source image face. Each <code>CompareFacesMatch</code>
         * object provides the bounding box, the confidence level that the bounding box contains a face, and the
         * similarity score for the face in the bounding box and the face in the source image.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setFaceMatches(java.util.Collection)} or {@link #withFaceMatches(java.util.Collection)} if you want
         * to override the existing values.
         * </p>
         * 
         * @param faceMatches
         *        An array of faces in the target image that match the source image face. Each
         *        <code>CompareFacesMatch</code> object provides the bounding box, the confidence level that the
         *        bounding box contains a face, and the similarity score for the face in the bounding box and the face
         *        in the source image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder faceMatches(CompareFacesMatch... faceMatches);

        /**
         * <p>
         * An array of faces in the target image that did not match the source image face.
         * </p>
         * 
         * @param unmatchedFaces
         *        An array of faces in the target image that did not match the source image face.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unmatchedFaces(Collection<ComparedFace> unmatchedFaces);

        /**
         * <p>
         * An array of faces in the target image that did not match the source image face.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setUnmatchedFaces(java.util.Collection)} or {@link #withUnmatchedFaces(java.util.Collection)} if you
         * want to override the existing values.
         * </p>
         * 
         * @param unmatchedFaces
         *        An array of faces in the target image that did not match the source image face.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unmatchedFaces(ComparedFace... unmatchedFaces);

        /**
         * <p>
         * The orientation of the source image (counterclockwise direction). If your application displays the source
         * image, you can use this value to correct image orientation. The bounding box coordinates returned in
         * <code>SourceImageFace</code> represent the location of the face before the image orientation is corrected.
         * </p>
         * <note>
         * <p>
         * If the source image is in .jpeg format, it might contain exchangeable image (Exif) metadata that includes the
         * image's orientation. If the Exif metadata for the source image populates the orientation field, the value of
         * <code>OrientationCorrection</code> is null and the <code>SourceImageFace</code> bounding box coordinates
         * represent the location of the face after Exif metadata is used to correct the orientation. Images in .png
         * format don't contain Exif metadata.
         * </p>
         * </note>
         * 
         * @param sourceImageOrientationCorrection
         *        The orientation of the source image (counterclockwise direction). If your application displays the
         *        source image, you can use this value to correct image orientation. The bounding box coordinates
         *        returned in <code>SourceImageFace</code> represent the location of the face before the image
         *        orientation is corrected. </p> <note>
         *        <p>
         *        If the source image is in .jpeg format, it might contain exchangeable image (Exif) metadata that
         *        includes the image's orientation. If the Exif metadata for the source image populates the orientation
         *        field, the value of <code>OrientationCorrection</code> is null and the <code>SourceImageFace</code>
         *        bounding box coordinates represent the location of the face after Exif metadata is used to correct the
         *        orientation. Images in .png format don't contain Exif metadata.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OrientationCorrection
         */
        Builder sourceImageOrientationCorrection(String sourceImageOrientationCorrection);

        /**
         * <p>
         * The orientation of the source image (counterclockwise direction). If your application displays the source
         * image, you can use this value to correct image orientation. The bounding box coordinates returned in
         * <code>SourceImageFace</code> represent the location of the face before the image orientation is corrected.
         * </p>
         * <note>
         * <p>
         * If the source image is in .jpeg format, it might contain exchangeable image (Exif) metadata that includes the
         * image's orientation. If the Exif metadata for the source image populates the orientation field, the value of
         * <code>OrientationCorrection</code> is null and the <code>SourceImageFace</code> bounding box coordinates
         * represent the location of the face after Exif metadata is used to correct the orientation. Images in .png
         * format don't contain Exif metadata.
         * </p>
         * </note>
         * 
         * @param sourceImageOrientationCorrection
         *        The orientation of the source image (counterclockwise direction). If your application displays the
         *        source image, you can use this value to correct image orientation. The bounding box coordinates
         *        returned in <code>SourceImageFace</code> represent the location of the face before the image
         *        orientation is corrected. </p> <note>
         *        <p>
         *        If the source image is in .jpeg format, it might contain exchangeable image (Exif) metadata that
         *        includes the image's orientation. If the Exif metadata for the source image populates the orientation
         *        field, the value of <code>OrientationCorrection</code> is null and the <code>SourceImageFace</code>
         *        bounding box coordinates represent the location of the face after Exif metadata is used to correct the
         *        orientation. Images in .png format don't contain Exif metadata.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OrientationCorrection
         */
        Builder sourceImageOrientationCorrection(OrientationCorrection sourceImageOrientationCorrection);

        /**
         * <p>
         * The orientation of the target image (in counterclockwise direction). If your application displays the target
         * image, you can use this value to correct the orientation of the image. The bounding box coordinates returned
         * in <code>FaceMatches</code> and <code>UnmatchedFaces</code> represent face locations before the image
         * orientation is corrected.
         * </p>
         * <note>
         * <p>
         * If the target image is in .jpg format, it might contain Exif metadata that includes the orientation of the
         * image. If the Exif metadata for the target image populates the orientation field, the value of
         * <code>OrientationCorrection</code> is null and the bounding box coordinates in <code>FaceMatches</code> and
         * <code>UnmatchedFaces</code> represent the location of the face after Exif metadata is used to correct the
         * orientation. Images in .png format don't contain Exif metadata.
         * </p>
         * </note>
         * 
         * @param targetImageOrientationCorrection
         *        The orientation of the target image (in counterclockwise direction). If your application displays the
         *        target image, you can use this value to correct the orientation of the image. The bounding box
         *        coordinates returned in <code>FaceMatches</code> and <code>UnmatchedFaces</code> represent face
         *        locations before the image orientation is corrected. </p> <note>
         *        <p>
         *        If the target image is in .jpg format, it might contain Exif metadata that includes the orientation of
         *        the image. If the Exif metadata for the target image populates the orientation field, the value of
         *        <code>OrientationCorrection</code> is null and the bounding box coordinates in
         *        <code>FaceMatches</code> and <code>UnmatchedFaces</code> represent the location of the face after Exif
         *        metadata is used to correct the orientation. Images in .png format don't contain Exif metadata.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OrientationCorrection
         */
        Builder targetImageOrientationCorrection(String targetImageOrientationCorrection);

        /**
         * <p>
         * The orientation of the target image (in counterclockwise direction). If your application displays the target
         * image, you can use this value to correct the orientation of the image. The bounding box coordinates returned
         * in <code>FaceMatches</code> and <code>UnmatchedFaces</code> represent face locations before the image
         * orientation is corrected.
         * </p>
         * <note>
         * <p>
         * If the target image is in .jpg format, it might contain Exif metadata that includes the orientation of the
         * image. If the Exif metadata for the target image populates the orientation field, the value of
         * <code>OrientationCorrection</code> is null and the bounding box coordinates in <code>FaceMatches</code> and
         * <code>UnmatchedFaces</code> represent the location of the face after Exif metadata is used to correct the
         * orientation. Images in .png format don't contain Exif metadata.
         * </p>
         * </note>
         * 
         * @param targetImageOrientationCorrection
         *        The orientation of the target image (in counterclockwise direction). If your application displays the
         *        target image, you can use this value to correct the orientation of the image. The bounding box
         *        coordinates returned in <code>FaceMatches</code> and <code>UnmatchedFaces</code> represent face
         *        locations before the image orientation is corrected. </p> <note>
         *        <p>
         *        If the target image is in .jpg format, it might contain Exif metadata that includes the orientation of
         *        the image. If the Exif metadata for the target image populates the orientation field, the value of
         *        <code>OrientationCorrection</code> is null and the bounding box coordinates in
         *        <code>FaceMatches</code> and <code>UnmatchedFaces</code> represent the location of the face after Exif
         *        metadata is used to correct the orientation. Images in .png format don't contain Exif metadata.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OrientationCorrection
         */
        Builder targetImageOrientationCorrection(OrientationCorrection targetImageOrientationCorrection);
    }

    private static final class BuilderImpl implements Builder {
        private ComparedSourceImageFace sourceImageFace;

        private List<CompareFacesMatch> faceMatches;

        private List<ComparedFace> unmatchedFaces;

        private String sourceImageOrientationCorrection;

        private String targetImageOrientationCorrection;

        private BuilderImpl() {
        }

        private BuilderImpl(CompareFacesResponse model) {
            setSourceImageFace(model.sourceImageFace);
            setFaceMatches(model.faceMatches);
            setUnmatchedFaces(model.unmatchedFaces);
            setSourceImageOrientationCorrection(model.sourceImageOrientationCorrection);
            setTargetImageOrientationCorrection(model.targetImageOrientationCorrection);
        }

        public final ComparedSourceImageFace getSourceImageFace() {
            return sourceImageFace;
        }

        @Override
        public final Builder sourceImageFace(ComparedSourceImageFace sourceImageFace) {
            this.sourceImageFace = sourceImageFace;
            return this;
        }

        public final void setSourceImageFace(ComparedSourceImageFace sourceImageFace) {
            this.sourceImageFace = sourceImageFace;
        }

        public final Collection<CompareFacesMatch> getFaceMatches() {
            return faceMatches;
        }

        @Override
        public final Builder faceMatches(Collection<CompareFacesMatch> faceMatches) {
            this.faceMatches = CompareFacesMatchListCopier.copy(faceMatches);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder faceMatches(CompareFacesMatch... faceMatches) {
            if (this.faceMatches == null) {
                this.faceMatches = new ArrayList<>(faceMatches.length);
            }
            for (CompareFacesMatch e : faceMatches) {
                this.faceMatches.add(e);
            }
            return this;
        }

        public final void setFaceMatches(Collection<CompareFacesMatch> faceMatches) {
            this.faceMatches = CompareFacesMatchListCopier.copy(faceMatches);
        }

        @SafeVarargs
        public final void setFaceMatches(CompareFacesMatch... faceMatches) {
            if (this.faceMatches == null) {
                this.faceMatches = new ArrayList<>(faceMatches.length);
            }
            for (CompareFacesMatch e : faceMatches) {
                this.faceMatches.add(e);
            }
        }

        public final Collection<ComparedFace> getUnmatchedFaces() {
            return unmatchedFaces;
        }

        @Override
        public final Builder unmatchedFaces(Collection<ComparedFace> unmatchedFaces) {
            this.unmatchedFaces = CompareFacesUnmatchListCopier.copy(unmatchedFaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unmatchedFaces(ComparedFace... unmatchedFaces) {
            if (this.unmatchedFaces == null) {
                this.unmatchedFaces = new ArrayList<>(unmatchedFaces.length);
            }
            for (ComparedFace e : unmatchedFaces) {
                this.unmatchedFaces.add(e);
            }
            return this;
        }

        public final void setUnmatchedFaces(Collection<ComparedFace> unmatchedFaces) {
            this.unmatchedFaces = CompareFacesUnmatchListCopier.copy(unmatchedFaces);
        }

        @SafeVarargs
        public final void setUnmatchedFaces(ComparedFace... unmatchedFaces) {
            if (this.unmatchedFaces == null) {
                this.unmatchedFaces = new ArrayList<>(unmatchedFaces.length);
            }
            for (ComparedFace e : unmatchedFaces) {
                this.unmatchedFaces.add(e);
            }
        }

        public final String getSourceImageOrientationCorrection() {
            return sourceImageOrientationCorrection;
        }

        @Override
        public final Builder sourceImageOrientationCorrection(String sourceImageOrientationCorrection) {
            this.sourceImageOrientationCorrection = sourceImageOrientationCorrection;
            return this;
        }

        @Override
        public final Builder sourceImageOrientationCorrection(OrientationCorrection sourceImageOrientationCorrection) {
            this.sourceImageOrientationCorrection(sourceImageOrientationCorrection.toString());
            return this;
        }

        public final void setSourceImageOrientationCorrection(String sourceImageOrientationCorrection) {
            this.sourceImageOrientationCorrection = sourceImageOrientationCorrection;
        }

        public final void setSourceImageOrientationCorrection(OrientationCorrection sourceImageOrientationCorrection) {
            this.sourceImageOrientationCorrection(sourceImageOrientationCorrection.toString());
        }

        public final String getTargetImageOrientationCorrection() {
            return targetImageOrientationCorrection;
        }

        @Override
        public final Builder targetImageOrientationCorrection(String targetImageOrientationCorrection) {
            this.targetImageOrientationCorrection = targetImageOrientationCorrection;
            return this;
        }

        @Override
        public final Builder targetImageOrientationCorrection(OrientationCorrection targetImageOrientationCorrection) {
            this.targetImageOrientationCorrection(targetImageOrientationCorrection.toString());
            return this;
        }

        public final void setTargetImageOrientationCorrection(String targetImageOrientationCorrection) {
            this.targetImageOrientationCorrection = targetImageOrientationCorrection;
        }

        public final void setTargetImageOrientationCorrection(OrientationCorrection targetImageOrientationCorrection) {
            this.targetImageOrientationCorrection(targetImageOrientationCorrection.toString());
        }

        @Override
        public CompareFacesResponse build() {
            return new CompareFacesResponse(this);
        }
    }
}
