/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.rekognition.transform.EmotionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The emotions detected on the face, and the confidence level in the determination. For example, HAPPY, SAD, and ANGRY.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Emotion implements StructuredPojo, ToCopyableBuilder<Emotion.Builder, Emotion> {
    private final String type;

    private final Float confidence;

    private Emotion(BuilderImpl builder) {
        this.type = builder.type;
        this.confidence = builder.confidence;
    }

    /**
     * <p>
     * Type of emotion detected.
     * </p>
     * 
     * @return Type of emotion detected.
     * @see EmotionName
     */
    public String type() {
        return type;
    }

    /**
     * <p>
     * Level of confidence in the determination.
     * </p>
     * 
     * @return Level of confidence in the determination.
     */
    public Float confidence() {
        return confidence;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((type() == null) ? 0 : type().hashCode());
        hashCode = 31 * hashCode + ((confidence() == null) ? 0 : confidence().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Emotion)) {
            return false;
        }
        Emotion other = (Emotion) obj;
        if (other.type() == null ^ this.type() == null) {
            return false;
        }
        if (other.type() != null && !other.type().equals(this.type())) {
            return false;
        }
        if (other.confidence() == null ^ this.confidence() == null) {
            return false;
        }
        if (other.confidence() != null && !other.confidence().equals(this.confidence())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (type() != null) {
            sb.append("Type: ").append(type()).append(",");
        }
        if (confidence() != null) {
            sb.append("Confidence: ").append(confidence()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EmotionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, Emotion> {
        /**
         * <p>
         * Type of emotion detected.
         * </p>
         * 
         * @param type
         *        Type of emotion detected.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EmotionName
         */
        Builder type(String type);

        /**
         * <p>
         * Type of emotion detected.
         * </p>
         * 
         * @param type
         *        Type of emotion detected.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EmotionName
         */
        Builder type(EmotionName type);

        /**
         * <p>
         * Level of confidence in the determination.
         * </p>
         * 
         * @param confidence
         *        Level of confidence in the determination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder confidence(Float confidence);
    }

    private static final class BuilderImpl implements Builder {
        private String type;

        private Float confidence;

        private BuilderImpl() {
        }

        private BuilderImpl(Emotion model) {
            setType(model.type);
            setConfidence(model.confidence);
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(EmotionName type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final void setType(EmotionName type) {
            this.type(type.toString());
        }

        public final Float getConfidence() {
            return confidence;
        }

        @Override
        public final Builder confidence(Float confidence) {
            this.confidence = confidence;
            return this;
        }

        public final void setConfidence(Float confidence) {
            this.confidence = confidence;
        }

        @Override
        public Emotion build() {
            return new Emotion(this);
        }
    }
}
