/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class IndexFacesRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<IndexFacesRequest.Builder, IndexFacesRequest> {
    private final String collectionId;

    private final Image image;

    private final String externalImageId;

    private final List<String> detectionAttributes;

    private IndexFacesRequest(BuilderImpl builder) {
        this.collectionId = builder.collectionId;
        this.image = builder.image;
        this.externalImageId = builder.externalImageId;
        this.detectionAttributes = builder.detectionAttributes;
    }

    /**
     * <p>
     * The ID of an existing collection to which you want to add the faces that are detected in the input images.
     * </p>
     * 
     * @return The ID of an existing collection to which you want to add the faces that are detected in the input
     *         images.
     */
    public String collectionId() {
        return collectionId;
    }

    /**
     * <p>
     * The input image as bytes or an S3 object.
     * </p>
     * 
     * @return The input image as bytes or an S3 object.
     */
    public Image image() {
        return image;
    }

    /**
     * <p>
     * ID you want to assign to all the faces detected in the image.
     * </p>
     * 
     * @return ID you want to assign to all the faces detected in the image.
     */
    public String externalImageId() {
        return externalImageId;
    }

    /**
     * <p>
     * An array of facial attributes that you want to be returned. This can be the default list of attributes or all
     * attributes. If you don't specify a value for <code>Attributes</code> or if you specify <code>["DEFAULT"]</code>,
     * the API returns the following subset of facial attributes: <code>BoundingBox</code>, <code>Confidence</code>,
     * <code>Pose</code>, <code>Quality</code> and <code>Landmarks</code>. If you provide <code>["ALL"]</code>, all
     * facial attributes are returned but the operation will take longer to complete.
     * </p>
     * <p>
     * If you provide both, <code>["ALL", "DEFAULT"]</code>, the service uses a logical AND operator to determine which
     * attributes to return (in this case, all attributes).
     * </p>
     * 
     * @return An array of facial attributes that you want to be returned. This can be the default list of attributes or
     *         all attributes. If you don't specify a value for <code>Attributes</code> or if you specify
     *         <code>["DEFAULT"]</code>, the API returns the following subset of facial attributes:
     *         <code>BoundingBox</code>, <code>Confidence</code>, <code>Pose</code>, <code>Quality</code> and
     *         <code>Landmarks</code>. If you provide <code>["ALL"]</code>, all facial attributes are returned but the
     *         operation will take longer to complete.</p>
     *         <p>
     *         If you provide both, <code>["ALL", "DEFAULT"]</code>, the service uses a logical AND operator to
     *         determine which attributes to return (in this case, all attributes).
     * @see Attribute
     */
    public List<String> detectionAttributes() {
        return detectionAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((collectionId() == null) ? 0 : collectionId().hashCode());
        hashCode = 31 * hashCode + ((image() == null) ? 0 : image().hashCode());
        hashCode = 31 * hashCode + ((externalImageId() == null) ? 0 : externalImageId().hashCode());
        hashCode = 31 * hashCode + ((detectionAttributes() == null) ? 0 : detectionAttributes().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IndexFacesRequest)) {
            return false;
        }
        IndexFacesRequest other = (IndexFacesRequest) obj;
        if (other.collectionId() == null ^ this.collectionId() == null) {
            return false;
        }
        if (other.collectionId() != null && !other.collectionId().equals(this.collectionId())) {
            return false;
        }
        if (other.image() == null ^ this.image() == null) {
            return false;
        }
        if (other.image() != null && !other.image().equals(this.image())) {
            return false;
        }
        if (other.externalImageId() == null ^ this.externalImageId() == null) {
            return false;
        }
        if (other.externalImageId() != null && !other.externalImageId().equals(this.externalImageId())) {
            return false;
        }
        if (other.detectionAttributes() == null ^ this.detectionAttributes() == null) {
            return false;
        }
        if (other.detectionAttributes() != null && !other.detectionAttributes().equals(this.detectionAttributes())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (collectionId() != null) {
            sb.append("CollectionId: ").append(collectionId()).append(",");
        }
        if (image() != null) {
            sb.append("Image: ").append(image()).append(",");
        }
        if (externalImageId() != null) {
            sb.append("ExternalImageId: ").append(externalImageId()).append(",");
        }
        if (detectionAttributes() != null) {
            sb.append("DetectionAttributes: ").append(detectionAttributes()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, IndexFacesRequest> {
        /**
         * <p>
         * The ID of an existing collection to which you want to add the faces that are detected in the input images.
         * </p>
         * 
         * @param collectionId
         *        The ID of an existing collection to which you want to add the faces that are detected in the input
         *        images.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collectionId(String collectionId);

        /**
         * <p>
         * The input image as bytes or an S3 object.
         * </p>
         * 
         * @param image
         *        The input image as bytes or an S3 object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder image(Image image);

        /**
         * <p>
         * ID you want to assign to all the faces detected in the image.
         * </p>
         * 
         * @param externalImageId
         *        ID you want to assign to all the faces detected in the image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalImageId(String externalImageId);

        /**
         * <p>
         * An array of facial attributes that you want to be returned. This can be the default list of attributes or all
         * attributes. If you don't specify a value for <code>Attributes</code> or if you specify
         * <code>["DEFAULT"]</code>, the API returns the following subset of facial attributes: <code>BoundingBox</code>, <code>Confidence</code>, <code>Pose</code>, <code>Quality</code> and <code>Landmarks</code>. If you provide
         * <code>["ALL"]</code>, all facial attributes are returned but the operation will take longer to complete.
         * </p>
         * <p>
         * If you provide both, <code>["ALL", "DEFAULT"]</code>, the service uses a logical AND operator to determine
         * which attributes to return (in this case, all attributes).
         * </p>
         * 
         * @param detectionAttributes
         *        An array of facial attributes that you want to be returned. This can be the default list of attributes
         *        or all attributes. If you don't specify a value for <code>Attributes</code> or if you specify
         *        <code>["DEFAULT"]</code>, the API returns the following subset of facial attributes:
         *        <code>BoundingBox</code>, <code>Confidence</code>, <code>Pose</code>, <code>Quality</code> and
         *        <code>Landmarks</code>. If you provide <code>["ALL"]</code>, all facial attributes are returned but
         *        the operation will take longer to complete.</p>
         *        <p>
         *        If you provide both, <code>["ALL", "DEFAULT"]</code>, the service uses a logical AND operator to
         *        determine which attributes to return (in this case, all attributes).
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Attribute
         */
        Builder detectionAttributes(Collection<String> detectionAttributes);

        /**
         * <p>
         * An array of facial attributes that you want to be returned. This can be the default list of attributes or all
         * attributes. If you don't specify a value for <code>Attributes</code> or if you specify
         * <code>["DEFAULT"]</code>, the API returns the following subset of facial attributes: <code>BoundingBox</code>, <code>Confidence</code>, <code>Pose</code>, <code>Quality</code> and <code>Landmarks</code>. If you provide
         * <code>["ALL"]</code>, all facial attributes are returned but the operation will take longer to complete.
         * </p>
         * <p>
         * If you provide both, <code>["ALL", "DEFAULT"]</code>, the service uses a logical AND operator to determine
         * which attributes to return (in this case, all attributes).
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setDetectionAttributes(java.util.Collection)} or
         * {@link #withDetectionAttributes(java.util.Collection)} if you want to override the existing values.
         * </p>
         * 
         * @param detectionAttributes
         *        An array of facial attributes that you want to be returned. This can be the default list of attributes
         *        or all attributes. If you don't specify a value for <code>Attributes</code> or if you specify
         *        <code>["DEFAULT"]</code>, the API returns the following subset of facial attributes:
         *        <code>BoundingBox</code>, <code>Confidence</code>, <code>Pose</code>, <code>Quality</code> and
         *        <code>Landmarks</code>. If you provide <code>["ALL"]</code>, all facial attributes are returned but
         *        the operation will take longer to complete.</p>
         *        <p>
         *        If you provide both, <code>["ALL", "DEFAULT"]</code>, the service uses a logical AND operator to
         *        determine which attributes to return (in this case, all attributes).
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Attribute
         */
        Builder detectionAttributes(String... detectionAttributes);

        /**
         * <p>
         * An array of facial attributes that you want to be returned. This can be the default list of attributes or all
         * attributes. If you don't specify a value for <code>Attributes</code> or if you specify
         * <code>["DEFAULT"]</code>, the API returns the following subset of facial attributes: <code>BoundingBox</code>, <code>Confidence</code>, <code>Pose</code>, <code>Quality</code> and <code>Landmarks</code>. If you provide
         * <code>["ALL"]</code>, all facial attributes are returned but the operation will take longer to complete.
         * </p>
         * <p>
         * If you provide both, <code>["ALL", "DEFAULT"]</code>, the service uses a logical AND operator to determine
         * which attributes to return (in this case, all attributes).
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setDetectionAttributes(java.util.Collection)} or
         * {@link #withDetectionAttributes(java.util.Collection)} if you want to override the existing values.
         * </p>
         * 
         * @param detectionAttributes
         *        An array of facial attributes that you want to be returned. This can be the default list of attributes
         *        or all attributes. If you don't specify a value for <code>Attributes</code> or if you specify
         *        <code>["DEFAULT"]</code>, the API returns the following subset of facial attributes:
         *        <code>BoundingBox</code>, <code>Confidence</code>, <code>Pose</code>, <code>Quality</code> and
         *        <code>Landmarks</code>. If you provide <code>["ALL"]</code>, all facial attributes are returned but
         *        the operation will take longer to complete.</p>
         *        <p>
         *        If you provide both, <code>["ALL", "DEFAULT"]</code>, the service uses a logical AND operator to
         *        determine which attributes to return (in this case, all attributes).
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Attribute
         */
        Builder detectionAttributes(Attribute... detectionAttributes);
    }

    private static final class BuilderImpl implements Builder {
        private String collectionId;

        private Image image;

        private String externalImageId;

        private List<String> detectionAttributes;

        private BuilderImpl() {
        }

        private BuilderImpl(IndexFacesRequest model) {
            setCollectionId(model.collectionId);
            setImage(model.image);
            setExternalImageId(model.externalImageId);
            setDetectionAttributes(model.detectionAttributes);
        }

        public final String getCollectionId() {
            return collectionId;
        }

        @Override
        public final Builder collectionId(String collectionId) {
            this.collectionId = collectionId;
            return this;
        }

        public final void setCollectionId(String collectionId) {
            this.collectionId = collectionId;
        }

        public final Image getImage() {
            return image;
        }

        @Override
        public final Builder image(Image image) {
            this.image = image;
            return this;
        }

        public final void setImage(Image image) {
            this.image = image;
        }

        public final String getExternalImageId() {
            return externalImageId;
        }

        @Override
        public final Builder externalImageId(String externalImageId) {
            this.externalImageId = externalImageId;
            return this;
        }

        public final void setExternalImageId(String externalImageId) {
            this.externalImageId = externalImageId;
        }

        public final Collection<String> getDetectionAttributes() {
            return detectionAttributes;
        }

        @Override
        public final Builder detectionAttributes(Collection<String> detectionAttributes) {
            this.detectionAttributes = AttributesCopier.copy(detectionAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder detectionAttributes(String... detectionAttributes) {
            if (this.detectionAttributes == null) {
                this.detectionAttributes = new ArrayList<>(detectionAttributes.length);
            }
            for (String e : detectionAttributes) {
                this.detectionAttributes.add(e);
            }
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder detectionAttributes(Attribute... detectionAttributes) {
            if (this.detectionAttributes == null) {
                this.detectionAttributes = new ArrayList<String>(detectionAttributes.length);
            }
            for (Attribute ele : detectionAttributes) {
                this.detectionAttributes.add(ele.toString());
            }
            return this;
        }

        public final void setDetectionAttributes(Collection<String> detectionAttributes) {
            this.detectionAttributes = AttributesCopier.copy(detectionAttributes);
        }

        @SafeVarargs
        public final void setDetectionAttributes(String... detectionAttributes) {
            if (this.detectionAttributes == null) {
                this.detectionAttributes = new ArrayList<>(detectionAttributes.length);
            }
            for (String e : detectionAttributes) {
                this.detectionAttributes.add(e);
            }
        }

        @SafeVarargs
        public final void setDetectionAttributes(Attribute... detectionAttributes) {
            if (this.detectionAttributes == null) {
                this.detectionAttributes = new ArrayList<String>(detectionAttributes.length);
            }
            for (Attribute ele : detectionAttributes) {
                this.detectionAttributes.add(ele.toString());
            }
        }

        @Override
        public IndexFacesRequest build() {
            return new IndexFacesRequest(this);
        }
    }
}
