/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class IndexFacesResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<IndexFacesResponse.Builder, IndexFacesResponse> {
    private final List<FaceRecord> faceRecords;

    private final String orientationCorrection;

    private IndexFacesResponse(BuilderImpl builder) {
        this.faceRecords = builder.faceRecords;
        this.orientationCorrection = builder.orientationCorrection;
    }

    /**
     * <p>
     * An array of faces detected and added to the collection. For more information, see <a>howitworks-index-faces</a>.
     * </p>
     * 
     * @return An array of faces detected and added to the collection. For more information, see
     *         <a>howitworks-index-faces</a>.
     */
    public List<FaceRecord> faceRecords() {
        return faceRecords;
    }

    /**
     * <p>
     * The orientation of the input image (counterclockwise direction). If your application displays the image, you can
     * use this value to correct image orientation. The bounding box coordinates returned in <code>FaceRecords</code>
     * represent face locations before the image orientation is corrected.
     * </p>
     * <note>
     * <p>
     * If the input image is in jpeg format, it might contain exchangeable image (Exif) metadata. If so, and the Exif
     * metadata populates the orientation field, the value of <code>OrientationCorrection</code> is null and the
     * bounding box coordinates in <code>FaceRecords</code> represent face locations after Exif metadata is used to
     * correct the image orientation. Images in .png format don't contain Exif metadata.
     * </p>
     * </note>
     * 
     * @return The orientation of the input image (counterclockwise direction). If your application displays the image,
     *         you can use this value to correct image orientation. The bounding box coordinates returned in
     *         <code>FaceRecords</code> represent face locations before the image orientation is corrected. </p> <note>
     *         <p>
     *         If the input image is in jpeg format, it might contain exchangeable image (Exif) metadata. If so, and the
     *         Exif metadata populates the orientation field, the value of <code>OrientationCorrection</code> is null
     *         and the bounding box coordinates in <code>FaceRecords</code> represent face locations after Exif metadata
     *         is used to correct the image orientation. Images in .png format don't contain Exif metadata.
     *         </p>
     * @see OrientationCorrection
     */
    public String orientationCorrection() {
        return orientationCorrection;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((faceRecords() == null) ? 0 : faceRecords().hashCode());
        hashCode = 31 * hashCode + ((orientationCorrection() == null) ? 0 : orientationCorrection().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IndexFacesResponse)) {
            return false;
        }
        IndexFacesResponse other = (IndexFacesResponse) obj;
        if (other.faceRecords() == null ^ this.faceRecords() == null) {
            return false;
        }
        if (other.faceRecords() != null && !other.faceRecords().equals(this.faceRecords())) {
            return false;
        }
        if (other.orientationCorrection() == null ^ this.orientationCorrection() == null) {
            return false;
        }
        if (other.orientationCorrection() != null && !other.orientationCorrection().equals(this.orientationCorrection())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (faceRecords() != null) {
            sb.append("FaceRecords: ").append(faceRecords()).append(",");
        }
        if (orientationCorrection() != null) {
            sb.append("OrientationCorrection: ").append(orientationCorrection()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, IndexFacesResponse> {
        /**
         * <p>
         * An array of faces detected and added to the collection. For more information, see
         * <a>howitworks-index-faces</a>.
         * </p>
         * 
         * @param faceRecords
         *        An array of faces detected and added to the collection. For more information, see
         *        <a>howitworks-index-faces</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder faceRecords(Collection<FaceRecord> faceRecords);

        /**
         * <p>
         * An array of faces detected and added to the collection. For more information, see
         * <a>howitworks-index-faces</a>.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setFaceRecords(java.util.Collection)} or {@link #withFaceRecords(java.util.Collection)} if you want
         * to override the existing values.
         * </p>
         * 
         * @param faceRecords
         *        An array of faces detected and added to the collection. For more information, see
         *        <a>howitworks-index-faces</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder faceRecords(FaceRecord... faceRecords);

        /**
         * <p>
         * The orientation of the input image (counterclockwise direction). If your application displays the image, you
         * can use this value to correct image orientation. The bounding box coordinates returned in
         * <code>FaceRecords</code> represent face locations before the image orientation is corrected.
         * </p>
         * <note>
         * <p>
         * If the input image is in jpeg format, it might contain exchangeable image (Exif) metadata. If so, and the
         * Exif metadata populates the orientation field, the value of <code>OrientationCorrection</code> is null and
         * the bounding box coordinates in <code>FaceRecords</code> represent face locations after Exif metadata is used
         * to correct the image orientation. Images in .png format don't contain Exif metadata.
         * </p>
         * </note>
         * 
         * @param orientationCorrection
         *        The orientation of the input image (counterclockwise direction). If your application displays the
         *        image, you can use this value to correct image orientation. The bounding box coordinates returned in
         *        <code>FaceRecords</code> represent face locations before the image orientation is corrected. </p>
         *        <note>
         *        <p>
         *        If the input image is in jpeg format, it might contain exchangeable image (Exif) metadata. If so, and
         *        the Exif metadata populates the orientation field, the value of <code>OrientationCorrection</code> is
         *        null and the bounding box coordinates in <code>FaceRecords</code> represent face locations after Exif
         *        metadata is used to correct the image orientation. Images in .png format don't contain Exif metadata.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OrientationCorrection
         */
        Builder orientationCorrection(String orientationCorrection);

        /**
         * <p>
         * The orientation of the input image (counterclockwise direction). If your application displays the image, you
         * can use this value to correct image orientation. The bounding box coordinates returned in
         * <code>FaceRecords</code> represent face locations before the image orientation is corrected.
         * </p>
         * <note>
         * <p>
         * If the input image is in jpeg format, it might contain exchangeable image (Exif) metadata. If so, and the
         * Exif metadata populates the orientation field, the value of <code>OrientationCorrection</code> is null and
         * the bounding box coordinates in <code>FaceRecords</code> represent face locations after Exif metadata is used
         * to correct the image orientation. Images in .png format don't contain Exif metadata.
         * </p>
         * </note>
         * 
         * @param orientationCorrection
         *        The orientation of the input image (counterclockwise direction). If your application displays the
         *        image, you can use this value to correct image orientation. The bounding box coordinates returned in
         *        <code>FaceRecords</code> represent face locations before the image orientation is corrected. </p>
         *        <note>
         *        <p>
         *        If the input image is in jpeg format, it might contain exchangeable image (Exif) metadata. If so, and
         *        the Exif metadata populates the orientation field, the value of <code>OrientationCorrection</code> is
         *        null and the bounding box coordinates in <code>FaceRecords</code> represent face locations after Exif
         *        metadata is used to correct the image orientation. Images in .png format don't contain Exif metadata.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OrientationCorrection
         */
        Builder orientationCorrection(OrientationCorrection orientationCorrection);
    }

    private static final class BuilderImpl implements Builder {
        private List<FaceRecord> faceRecords;

        private String orientationCorrection;

        private BuilderImpl() {
        }

        private BuilderImpl(IndexFacesResponse model) {
            setFaceRecords(model.faceRecords);
            setOrientationCorrection(model.orientationCorrection);
        }

        public final Collection<FaceRecord> getFaceRecords() {
            return faceRecords;
        }

        @Override
        public final Builder faceRecords(Collection<FaceRecord> faceRecords) {
            this.faceRecords = FaceRecordListCopier.copy(faceRecords);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder faceRecords(FaceRecord... faceRecords) {
            if (this.faceRecords == null) {
                this.faceRecords = new ArrayList<>(faceRecords.length);
            }
            for (FaceRecord e : faceRecords) {
                this.faceRecords.add(e);
            }
            return this;
        }

        public final void setFaceRecords(Collection<FaceRecord> faceRecords) {
            this.faceRecords = FaceRecordListCopier.copy(faceRecords);
        }

        @SafeVarargs
        public final void setFaceRecords(FaceRecord... faceRecords) {
            if (this.faceRecords == null) {
                this.faceRecords = new ArrayList<>(faceRecords.length);
            }
            for (FaceRecord e : faceRecords) {
                this.faceRecords.add(e);
            }
        }

        public final String getOrientationCorrection() {
            return orientationCorrection;
        }

        @Override
        public final Builder orientationCorrection(String orientationCorrection) {
            this.orientationCorrection = orientationCorrection;
            return this;
        }

        @Override
        public final Builder orientationCorrection(OrientationCorrection orientationCorrection) {
            this.orientationCorrection(orientationCorrection.toString());
            return this;
        }

        public final void setOrientationCorrection(String orientationCorrection) {
            this.orientationCorrection = orientationCorrection;
        }

        public final void setOrientationCorrection(OrientationCorrection orientationCorrection) {
            this.orientationCorrection(orientationCorrection.toString());
        }

        @Override
        public IndexFacesResponse build() {
            return new IndexFacesResponse(this);
        }
    }
}
