/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.rekognition.transform.LandmarkMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Indicates the location of the landmark on the face.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Landmark implements StructuredPojo, ToCopyableBuilder<Landmark.Builder, Landmark> {
    private final String type;

    private final Float x;

    private final Float y;

    private Landmark(BuilderImpl builder) {
        this.type = builder.type;
        this.x = builder.x;
        this.y = builder.y;
    }

    /**
     * <p>
     * Type of the landmark.
     * </p>
     * 
     * @return Type of the landmark.
     * @see LandmarkType
     */
    public String type() {
        return type;
    }

    /**
     * <p>
     * x-coordinate from the top left of the landmark expressed as the ration of the width of the image. For example, if
     * the images is 700x200 and the x-coordinate of the landmark is at 350 pixels, this value is 0.5.
     * </p>
     * 
     * @return x-coordinate from the top left of the landmark expressed as the ration of the width of the image. For
     *         example, if the images is 700x200 and the x-coordinate of the landmark is at 350 pixels, this value is
     *         0.5.
     */
    public Float x() {
        return x;
    }

    /**
     * <p>
     * y-coordinate from the top left of the landmark expressed as the ration of the height of the image. For example,
     * if the images is 700x200 and the y-coordinate of the landmark is at 100 pixels, this value is 0.5.
     * </p>
     * 
     * @return y-coordinate from the top left of the landmark expressed as the ration of the height of the image. For
     *         example, if the images is 700x200 and the y-coordinate of the landmark is at 100 pixels, this value is
     *         0.5.
     */
    public Float y() {
        return y;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((type() == null) ? 0 : type().hashCode());
        hashCode = 31 * hashCode + ((x() == null) ? 0 : x().hashCode());
        hashCode = 31 * hashCode + ((y() == null) ? 0 : y().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Landmark)) {
            return false;
        }
        Landmark other = (Landmark) obj;
        if (other.type() == null ^ this.type() == null) {
            return false;
        }
        if (other.type() != null && !other.type().equals(this.type())) {
            return false;
        }
        if (other.x() == null ^ this.x() == null) {
            return false;
        }
        if (other.x() != null && !other.x().equals(this.x())) {
            return false;
        }
        if (other.y() == null ^ this.y() == null) {
            return false;
        }
        if (other.y() != null && !other.y().equals(this.y())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (type() != null) {
            sb.append("Type: ").append(type()).append(",");
        }
        if (x() != null) {
            sb.append("X: ").append(x()).append(",");
        }
        if (y() != null) {
            sb.append("Y: ").append(y()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LandmarkMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, Landmark> {
        /**
         * <p>
         * Type of the landmark.
         * </p>
         * 
         * @param type
         *        Type of the landmark.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LandmarkType
         */
        Builder type(String type);

        /**
         * <p>
         * Type of the landmark.
         * </p>
         * 
         * @param type
         *        Type of the landmark.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LandmarkType
         */
        Builder type(LandmarkType type);

        /**
         * <p>
         * x-coordinate from the top left of the landmark expressed as the ration of the width of the image. For
         * example, if the images is 700x200 and the x-coordinate of the landmark is at 350 pixels, this value is 0.5.
         * </p>
         * 
         * @param x
         *        x-coordinate from the top left of the landmark expressed as the ration of the width of the image. For
         *        example, if the images is 700x200 and the x-coordinate of the landmark is at 350 pixels, this value is
         *        0.5.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder x(Float x);

        /**
         * <p>
         * y-coordinate from the top left of the landmark expressed as the ration of the height of the image. For
         * example, if the images is 700x200 and the y-coordinate of the landmark is at 100 pixels, this value is 0.5.
         * </p>
         * 
         * @param y
         *        y-coordinate from the top left of the landmark expressed as the ration of the height of the image. For
         *        example, if the images is 700x200 and the y-coordinate of the landmark is at 100 pixels, this value is
         *        0.5.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder y(Float y);
    }

    private static final class BuilderImpl implements Builder {
        private String type;

        private Float x;

        private Float y;

        private BuilderImpl() {
        }

        private BuilderImpl(Landmark model) {
            setType(model.type);
            setX(model.x);
            setY(model.y);
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(LandmarkType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final void setType(LandmarkType type) {
            this.type(type.toString());
        }

        public final Float getX() {
            return x;
        }

        @Override
        public final Builder x(Float x) {
            this.x = x;
            return this;
        }

        public final void setX(Float x) {
            this.x = x;
        }

        public final Float getY() {
            return y;
        }

        @Override
        public final Builder y(Float y) {
            this.y = y;
            return this;
        }

        public final void setY(Float y) {
            this.y = y;
        }

        @Override
        public Landmark build() {
            return new Landmark(this);
        }
    }
}
