/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class ListFacesResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<ListFacesResponse.Builder, ListFacesResponse> {
    private final List<Face> faces;

    private final String nextToken;

    private ListFacesResponse(BuilderImpl builder) {
        this.faces = builder.faces;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * An array of <code>Face</code> objects.
     * </p>
     * 
     * @return An array of <code>Face</code> objects.
     */
    public List<Face> faces() {
        return faces;
    }

    /**
     * <p>
     * If the response is truncated, Amazon Rekognition returns this token that you can use in the subsequent request to
     * retrieve the next set of faces.
     * </p>
     * 
     * @return If the response is truncated, Amazon Rekognition returns this token that you can use in the subsequent
     *         request to retrieve the next set of faces.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((faces() == null) ? 0 : faces().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFacesResponse)) {
            return false;
        }
        ListFacesResponse other = (ListFacesResponse) obj;
        if (other.faces() == null ^ this.faces() == null) {
            return false;
        }
        if (other.faces() != null && !other.faces().equals(this.faces())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (faces() != null) {
            sb.append("Faces: ").append(faces()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ListFacesResponse> {
        /**
         * <p>
         * An array of <code>Face</code> objects.
         * </p>
         * 
         * @param faces
         *        An array of <code>Face</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder faces(Collection<Face> faces);

        /**
         * <p>
         * An array of <code>Face</code> objects.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setFaces(java.util.Collection)} or {@link #withFaces(java.util.Collection)} if you want to override
         * the existing values.
         * </p>
         * 
         * @param faces
         *        An array of <code>Face</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder faces(Face... faces);

        /**
         * <p>
         * If the response is truncated, Amazon Rekognition returns this token that you can use in the subsequent
         * request to retrieve the next set of faces.
         * </p>
         * 
         * @param nextToken
         *        If the response is truncated, Amazon Rekognition returns this token that you can use in the subsequent
         *        request to retrieve the next set of faces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    private static final class BuilderImpl implements Builder {
        private List<Face> faces;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFacesResponse model) {
            setFaces(model.faces);
            setNextToken(model.nextToken);
        }

        public final Collection<Face> getFaces() {
            return faces;
        }

        @Override
        public final Builder faces(Collection<Face> faces) {
            this.faces = FaceListCopier.copy(faces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder faces(Face... faces) {
            if (this.faces == null) {
                this.faces = new ArrayList<>(faces.length);
            }
            for (Face e : faces) {
                this.faces.add(e);
            }
            return this;
        }

        public final void setFaces(Collection<Face> faces) {
            this.faces = FaceListCopier.copy(faces);
        }

        @SafeVarargs
        public final void setFaces(Face... faces) {
            if (this.faces == null) {
                this.faces = new ArrayList<>(faces.length);
            }
            for (Face e : faces) {
                this.faces.add(e);
            }
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListFacesResponse build() {
            return new ListFacesResponse(this);
        }
    }
}
