/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class SearchFacesResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<SearchFacesResponse.Builder, SearchFacesResponse> {
    private final String searchedFaceId;

    private final List<FaceMatch> faceMatches;

    private SearchFacesResponse(BuilderImpl builder) {
        this.searchedFaceId = builder.searchedFaceId;
        this.faceMatches = builder.faceMatches;
    }

    /**
     * <p>
     * ID of the face that was searched for matches in a collection.
     * </p>
     * 
     * @return ID of the face that was searched for matches in a collection.
     */
    public String searchedFaceId() {
        return searchedFaceId;
    }

    /**
     * <p>
     * An array of faces that matched the input face, along with the confidence in the match.
     * </p>
     * 
     * @return An array of faces that matched the input face, along with the confidence in the match.
     */
    public List<FaceMatch> faceMatches() {
        return faceMatches;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((searchedFaceId() == null) ? 0 : searchedFaceId().hashCode());
        hashCode = 31 * hashCode + ((faceMatches() == null) ? 0 : faceMatches().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchFacesResponse)) {
            return false;
        }
        SearchFacesResponse other = (SearchFacesResponse) obj;
        if (other.searchedFaceId() == null ^ this.searchedFaceId() == null) {
            return false;
        }
        if (other.searchedFaceId() != null && !other.searchedFaceId().equals(this.searchedFaceId())) {
            return false;
        }
        if (other.faceMatches() == null ^ this.faceMatches() == null) {
            return false;
        }
        if (other.faceMatches() != null && !other.faceMatches().equals(this.faceMatches())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (searchedFaceId() != null) {
            sb.append("SearchedFaceId: ").append(searchedFaceId()).append(",");
        }
        if (faceMatches() != null) {
            sb.append("FaceMatches: ").append(faceMatches()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, SearchFacesResponse> {
        /**
         * <p>
         * ID of the face that was searched for matches in a collection.
         * </p>
         * 
         * @param searchedFaceId
         *        ID of the face that was searched for matches in a collection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder searchedFaceId(String searchedFaceId);

        /**
         * <p>
         * An array of faces that matched the input face, along with the confidence in the match.
         * </p>
         * 
         * @param faceMatches
         *        An array of faces that matched the input face, along with the confidence in the match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder faceMatches(Collection<FaceMatch> faceMatches);

        /**
         * <p>
         * An array of faces that matched the input face, along with the confidence in the match.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setFaceMatches(java.util.Collection)} or {@link #withFaceMatches(java.util.Collection)} if you want
         * to override the existing values.
         * </p>
         * 
         * @param faceMatches
         *        An array of faces that matched the input face, along with the confidence in the match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder faceMatches(FaceMatch... faceMatches);
    }

    private static final class BuilderImpl implements Builder {
        private String searchedFaceId;

        private List<FaceMatch> faceMatches;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchFacesResponse model) {
            setSearchedFaceId(model.searchedFaceId);
            setFaceMatches(model.faceMatches);
        }

        public final String getSearchedFaceId() {
            return searchedFaceId;
        }

        @Override
        public final Builder searchedFaceId(String searchedFaceId) {
            this.searchedFaceId = searchedFaceId;
            return this;
        }

        public final void setSearchedFaceId(String searchedFaceId) {
            this.searchedFaceId = searchedFaceId;
        }

        public final Collection<FaceMatch> getFaceMatches() {
            return faceMatches;
        }

        @Override
        public final Builder faceMatches(Collection<FaceMatch> faceMatches) {
            this.faceMatches = FaceMatchListCopier.copy(faceMatches);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder faceMatches(FaceMatch... faceMatches) {
            if (this.faceMatches == null) {
                this.faceMatches = new ArrayList<>(faceMatches.length);
            }
            for (FaceMatch e : faceMatches) {
                this.faceMatches.add(e);
            }
            return this;
        }

        public final void setFaceMatches(Collection<FaceMatch> faceMatches) {
            this.faceMatches = FaceMatchListCopier.copy(faceMatches);
        }

        @SafeVarargs
        public final void setFaceMatches(FaceMatch... faceMatches) {
            if (this.faceMatches == null) {
                this.faceMatches = new ArrayList<>(faceMatches.length);
            }
            for (FaceMatch e : faceMatches) {
                this.faceMatches.add(e);
            }
        }

        @Override
        public SearchFacesResponse build() {
            return new SearchFacesResponse(this);
        }
    }
}
