/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rekognition.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.rekognition.model.*;
import software.amazon.awssdk.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * CompareFacesResponse JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class CompareFacesResponseUnmarshaller implements Unmarshaller<CompareFacesResponse, JsonUnmarshallerContext> {

    public CompareFacesResponse unmarshall(JsonUnmarshallerContext context) throws Exception {
        CompareFacesResponse.Builder compareFacesResponseBuilder = CompareFacesResponse.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return compareFacesResponseBuilder.build();
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("SourceImageFace", targetDepth)) {
                    context.nextToken();
                    compareFacesResponseBuilder.sourceImageFace(ComparedSourceImageFaceUnmarshaller.getInstance().unmarshall(
                            context));
                }
                if (context.testExpression("FaceMatches", targetDepth)) {
                    context.nextToken();
                    compareFacesResponseBuilder.faceMatches(new ListUnmarshaller<CompareFacesMatch>(CompareFacesMatchUnmarshaller
                            .getInstance()).unmarshall(context));
                }
                if (context.testExpression("UnmatchedFaces", targetDepth)) {
                    context.nextToken();
                    compareFacesResponseBuilder.unmatchedFaces(new ListUnmarshaller<ComparedFace>(ComparedFaceUnmarshaller
                            .getInstance()).unmarshall(context));
                }
                if (context.testExpression("SourceImageOrientationCorrection", targetDepth)) {
                    context.nextToken();
                    compareFacesResponseBuilder.sourceImageOrientationCorrection(context.getUnmarshaller(String.class)
                            .unmarshall(context));
                }
                if (context.testExpression("TargetImageOrientationCorrection", targetDepth)) {
                    context.nextToken();
                    compareFacesResponseBuilder.targetImageOrientationCorrection(context.getUnmarshaller(String.class)
                            .unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return compareFacesResponseBuilder.build();
    }

    private static CompareFacesResponseUnmarshaller INSTANCE;

    public static CompareFacesResponseUnmarshaller getInstance() {
        if (INSTANCE == null)
            INSTANCE = new CompareFacesResponseUnmarshaller();
        return INSTANCE;
    }
}